;-*-SCHEME-*-

;;;
;;; StoK: Scheme to KL1 translator
;;;   Copyright (C) 1997 Yoshihiro Oyama
;;;     <oyama@is.s.u-tokyo.ac.jp>
;;;       December 19, 1997
;;;

;;
;; utilities
;;

(module tool)

(define (string-upcase str)
  (list->string (map (lambda (x) (char-upcase x)) (string->list str))))

;;;
;;;
;;;
(define *unique-name-counter* 0)
(define (unique-name prefix)
  (if (symbol? prefix)
      (begin
	(set! *unique-name-counter* (+ 1 (global-ref *unique-name-counter*)))
	(string->symbol
	 (string-append
	  (symbol->string prefix)
	  (integer->string (global-ref *unique-name-counter*)))))
      (error 'unique-name "Argument is not a symbol" prefix)))

(define (unique-names prefix len)
  (if (= len 0)
      '()
      (cons
       (unique-name prefix)
       (unique-names prefix (- len 1)))))

(define (uniq lis)
  (if (null? lis)
      '()
      (let ((x  (car lis))
	    (xs (cdr lis)))
	(if (member x xs)
	    (uniq xs)
	    (cons x (uniq xs))))))

(define (flat listoflist)
  (if (null? listoflist)
      '()
      (append (car listoflist)
	      (flat (cdr listoflist)))))

(define (path-eliminate-extension filename)
  (let ((exploded (string->list filename)))
    (let loop ((exploded-reversed (reverse exploded)))
      (if (null? exploded-reversed)
	  (error 'path-eliminate-extension "no period (extension) in filename" filename)
	  (if (char=? (car exploded-reversed) #\.)
	      (list->string (reverse (cdr exploded-reversed)))
	      (loop (cdr exploded-reversed)))))))

(define (path-attach-extension kernel-filename extension)
  (string-append kernel-filename (string-append "." extension)))

(define (path-get-extension filename)
  (let loop ((exploded (string->list filename)))
    (if (null? exploded)
	(error 'path-get-extension "no period (extension) in filename" filename)
	(if (char=? (car exploded) #\.)
	    (list->string (cdr exploded))
	    (loop (cdr exploded))))))

