;-*-SCHEME-*-

;;;
;;; StoK: Scheme to KL1 translator
;;;   Copyright (C) 1997 Yoshihiro Oyama
;;;     <oyama@is.s.u-tokyo.ac.jp>
;;;       December 19, 1997
;;;

;;
;; primitive table
;;

(module table)


(define (table-convert-op-from-scheme-to-kl1 op)
  (cond
   ((equal? op '%global-init)       "global_file_init")
   ((equal? op '%global-table-set!) "global_table_set")
   ((equal? op '%global-file-set) "global_file_set")
   ((equal? op '%global-file-ref) "global_file_ref")
   ((equal? op '%and) "and")
   ((equal? op '%or) "or")
   ((equal? op '%not) "not")
   ((equal? op '%boolean?) "booleanp")
   ((equal? op '%equal?)        "equalp")
   ((equal? op '%pair?) "pairp")
   ((equal? op '%cons) "cons")
   ((equal? op '%car) "car")
   ((equal? op '%cdr) "cdr")
   ((equal? op '%cadr) "cadr")
   ((equal? op '%caddr) "caddr")
   ((equal? op '%null?) "nullp")
   ((equal? op '%length) "length")
   ((equal? op '%append) "append")
   ((equal? op '%list-ref) "list_ref")
   ((equal? op '%member) "member")
   ((equal? op '%symbol?) "symbolp")
   ((equal? op '%string->symbol) "string_to_symbol")
   ((equal? op '%symbol->string) "symbol_to_string")
   ((equal? op '%number?) "numberp")
   ((equal? op '%integer?) "integerp")
   ((equal? op '%=) "num_eq")
   ((equal? op '%<) "lt")
   ((equal? op '%>) "gt")
   ((equal? op '%<=) "le")
   ((equal? op '%>=) "ge")
   ((equal? op '%+) "add")
   ((equal? op '%*) "mul")
   ((equal? op '%-) "sub")
   ((equal? op '%quotient) "quotient")
   ((equal? op '%remainder) "remainder")
   ((equal? op '%char?) "charp")
   ((equal? op '%char=?) "char_eq")
   ((equal? op '%char<?) "char_lt")
   ((equal? op '%char>?) "char_gt")
   ((equal? op '%char<=?) "char_le")
   ((equal? op '%char>=?) "char_ge")
   ((equal? op '%char->integer) "char_to_integer")
   ((equal? op '%integer->char) "integer_to_char")
   ((equal? op '%string?) "stringp")
   ((equal? op '%make-string) "make_string")
   ((equal? op '%string-length) "string_length")
   ((equal? op '%string-ref) "string_ref")
   ((equal? op '%string-set) "string_set")
   ((equal? op '%string-append) "string_append")
   ((equal? op '%procedure?) "procedurep")
   ((equal? op '%current-input-port) "current_input_port")
   ((equal? op '%current-output-port) "current_output_port")
   ((equal? op '%open-input-file) "open_input_file")
   ((equal? op '%open-output-file) "open_output_file")
   ((equal? op '%close-input-port) "close_input_port")
   ((equal? op '%close-output-port) "close_output_port")
   ; stok-read
   ((equal? op '%stok-read-char) "stok_read_char")
   ((equal? op '%eof-object?) "eof_objectp")
   ((equal? op '%stok-newline) "stok_newline")
   ((equal? op '%stok-write-char) "stok_write_char")
   ((equal? op '%stok-display-string-with-quote)    "stok_display_string_with_quote")
   ((equal? op '%stok-display-string-without-quote) "stok_display_string_without_quote")
   ((equal? op '%error) "scm_error")
   ((equal? op '%exit) "scm_exit")
   ; hidden prim
   ((equal? op '%isqrt) "isqrt")
   (else (error 'table-convert-op-from-scheme-to-kl1 "Unknown Primitive" op))))

;;; Hmm...
;;; This table is constructed each time this function is called...
;;; What an efficient compiler...
(define (table-primitive-ops)
  (list
   '%quote
   '%and '%or
   '%global-file-set '%global-file-ref
   '%not '%boolean?
   '%equal?
   '%pair? '%cons '%car '%cdr '%cadr '%caddr '%null?
   '%length '%append '%list-ref '%member
   '%symbol? '%string->symbol '%symbol->string
   '%number? '%integer?
   '%= '%> '%< '%>= '%<= 
   '%+ '%* '%-  '%quotient '%remainder
   '%char? '%char=? '%char<? '%char>? '%char<=? '%char>=? 
   '%char->integer '%integer->char 
   '%string? '%make-string '%string-length
   '%string-ref '%string-set '%string-append
   '%procedure?
   '%current-input-port '%current-output-port
   '%open-input-file '%open-output-file
   '%close-input-port '%close-output-port
   '%stok-read-char '%eof-object? '%stok-newline '%stok-write-char 
   '%stok-display-string-with-quote '%stok-display-string-without-quote
   '%error '%exit
   ;;; hidden command
   '%isqrt
   ))

