;-*-SCHEME-*-

;;;
;;; StoK: Scheme to KL1 translator
;;;   Copyright (C) 1997 Yoshihiro Oyama
;;;     <oyama@is.s.u-tokyo.ac.jp>
;;;       December 19, 1997
;;;

;;
;; We must initialize global functions and register them in
;; global function table before running the user program.
;; This module generates a code which handles
;; the initialization.
;;

(module modinit)


(define *predicates-requiring-initialization* '())

(define (modinit-reset-export-functions!)
  (set! *predicates-requiring-initialization* '()))

(define (modinit-add-export-function! predicate-label)
  (set! *predicates-requiring-initialization*
	(cons predicate-label (global-ref *predicates-requiring-initialization*))))

(define (modinit-generate-initialization-predicate port)
  (let ((in-environment-top-arg  'inenv-top)
	(out-environment-top-arg 'outenv-top))
    (let* ((newport1 (stok-display-string-without-quote
		      (modinit-generate-from-module-symbol-to-init-pred-string
		       (gencode-get-this-module-name))
		      port))
	   (newport2 (gencode-print-predicate-args
		      newport1
		      (list out-environment-top-arg in-environment-top-arg)))
	   (newport3 (gencode-print-tombow newport2)))
      (let loop ((init-predicates
		  (reverse (global-ref *predicates-requiring-initialization*)))
		 (in-environment-arg  in-environment-top-arg)
		 (out-environment-arg (unique-name 'outenv))
		 (newport4 newport3))
	(if (= (length init-predicates) 1)
	    ;;; the last predicate
	    (let* ((newport5
		    (modinit-generate-init-predicate-call
		     newport4
		     (car init-predicates)
		     in-environment-arg
		     out-environment-top-arg))
		   (newport6 (gencode-print-period newport5))
		   (newport7 (stok-newline newport6)))
	      newport7)
	    ;;; not the last predicate
	    (let* ((newport5
		    (modinit-generate-init-predicate-call
		     newport4
		     (car init-predicates)
		     in-environment-arg
		     out-environment-arg))
		   (newport6 (stok-display-string-without-quote ", " newport5))
		   (newport7
		    (loop
		     (cdr init-predicates)
		     out-environment-arg
		     (unique-name 'outenv)
		     newport6)))
	      newport7))))))
		   

(define (modinit-generate-init-predicate-call port init-predicate-label inenv outenv)
  (let ((newport-a
	 (cond
	  ((label-predicate-label? init-predicate-label)
	   (let* ((newport1 (stok-display-string-without-quote "init_" port))
		  (newport2 (stok-display-string-without-quote
			     (symbol->string-with-escape
			      (label-get-predicate-label init-predicate-label))
			     newport1)))
	     newport2))
	  ((label-module-label? init-predicate-label)
	   (let ((module-label-sym (label-get-module-label init-predicate-label)))
	     (let* ((newport1 (stok-display-string-without-quote
			       (symbol->string-with-escape module-label-sym) port))
		    (newport2 (stok-display-string-without-quote ":" newport1))
		    (newport3 (stok-display-string-without-quote
			       (modinit-generate-from-module-symbol-to-init-pred-string module-label-sym)
			       newport2)))
	       newport3)))
	  (else
	   (error
	    'modinit-generate-init-predicate-call
	    "Unknown label type"
	    init-predicate-label)))))
    (let ((newport-b (gencode-print-predicate-args newport-a (list outenv inenv))))
      newport-b)))

(define (modinit-generate-from-module-symbol-to-init-pred-string module-sym)
  (string-append "init_module_" (symbol->string-with-escape module-sym)))

