;-*-SCHEME-*-

;;;
;;; StoK: Scheme to KL1 translator
;;;   Copyright (C) 1997 Yoshihiro Oyama
;;;     <oyama@is.s.u-tokyo.ac.jp>
;;;       December 19, 1997
;;;

;;
;; predicate label processings
;;

(module label)


(define (label-make-module-label module-name arglen)
  (list 'module-label module-name arglen))
(define (label-get-module-label init-module-predicate-structure)
  (list-ref init-module-predicate-structure 1))
(define (label-module-label? x)
  (and (pair? x) (equal? (car x) 'module-label)))

(define (label-make-predicate-label predicate-name arglen)
  (list 'label predicate-name arglen))
(define (label-get-predicate-label label-structure)
  (list-ref label-structure 1))
(define (label-get-predicate-arglen label-structure)
  (list-ref label-structure 2))
(define (label-predicate-label? x)
  (and (pair? x) (equal? (car x) 'label)))

(define (label-make-predicate-init-label predicate-name arglen)
  (list 'label-for-init predicate-name arglen))
(define (label-get-predicate-init-label label-structure)
  (list-ref label-structure 1))
(define (label-get-predicate-init-arglen label-structure)
  (list-ref label-structure 2))
(define (label-predicate-init-label? x)
  (and (pair? x) (equal? (car x) 'label-for-init)))

(define (label-make-predicate-label-ref predicate-name arglen)
  (list 'label-ref predicate-name arglen))
(define (label-get-predicate-label-ref label-ref-structure)
  (list-ref label-ref-structure 1))
(define (label-get-predicate-arglen-ref label-ref-structure)
  (list-ref label-ref-structure 2))
(define (label-predicate-label-ref? x)
  (and (pair? x) (equal? (car x) 'label-ref)))
	  
(define (label-make-predicate-init-label-ref predicate-name arglen)
  (list 'label-for-init-ref predicate-name arglen))
(define (label-get-predicate-init-label-ref label-ref-structure)
  (list-ref label-ref-structure 1))
(define (label-get-predicate-init-arglen-ref label-ref-structure)
  (list-ref label-ref-structure 2))
(define (label-predicate-init-label-ref? x)
  (and (pair? x) (equal? (car x) 'label-for-init-ref)))
	  
(define (label-make-global x)
  (list 'global x))
(define (label-get-global lis)
  (list-ref lis 1))
(define (label-global? x)
  (and (pair? x) (equal? (car x) 'global)))
  
(define (label-make-quote x)
  (list '%quote x))
(define (label-get-quoted-object x)
  (list-ref x 1))
(define (label-quote? x)
  (and (pair? x) (equal? (car x) '%quote)))

(define (label-get-environment-name) 'env)

