;-*-SCHEME-*-

;;;
;;; StoK: Scheme to KL1 translator
;;;   Copyright (C) 1997 Yoshihiro Oyama
;;;     <oyama@is.s.u-tokyo.ac.jp>
;;;       December 19, 1997
;;;

;;
;; Closure conversion
;;

(module klokon)


(define (klokon freevars-ed-predicate)
  (klokon-top-predicate freevars-ed-predicate))

(define *global-variables-in-this-predicate* '())

(define (klokon-top-predicate freevars-ed-predicate)
  (let ((freevars  (klofree-detach-freevars  freevars-ed-predicate))
	(predicate (klofree-detach-predicate freevars-ed-predicate)))
    (set! *global-variables-in-this-predicate* freevars)
    (let ((keyword        (list-ref predicate 0))
	  (predicate-name (list-ref predicate 1))
	  (predicate-args (list-ref predicate 2))
	  (guard          (list-ref predicate 3))
	  (predicate-body (list-ref predicate 4)))
      (let ((predicate-label-for-init
	     (label-make-predicate-init-label predicate-name 1))
	    (predicate-label-for-init-ref
	     (label-make-predicate-init-label-ref predicate-name 1))
	    (predicate-arg-for-init (unique-name 'rep))
	    (top-predicate-closure-record (unique-name 'clo))
	    (new-predicate-args
	     (cons
	      predicate-name
	      (append
	       predicate-args
	       (list (label-get-environment-name)))))
	    (converted-predicate-body (klokon-parallel predicate-body))
	    (in-environment-arg  'inenvstream)
	    (out-environment-arg 'outenvstream))
	(let ((new-predicate-args-len (length new-predicate-args)))
	  (let ((predicate-label
		 (label-make-predicate-label
		  predicate-name new-predicate-args-len))
		(predicate-label-ref
		 (label-make-predicate-label-ref
		  predicate-name new-predicate-args-len)))
	    (let ((final-result-body
		   (cond
		    ((equal? keyword 'top-predicate)
		     (list
		      (list
		       'fix
		       (list
			(list
			 'local-predicate
			 predicate-label-for-init
			 (list out-environment-arg in-environment-arg)
			 #t ; guard
			 (list
			  (list
			   'primitive
			   'make-record
			   (list
			    (label-make-predicate-label-ref predicate-name new-predicate-args-len))
			   top-predicate-closure-record)
			  (list
			   'primitive
			   '%global-table-set!
			   (list
			    (symbol->string predicate-name)
			    top-predicate-closure-record
			    in-environment-arg)
			   out-environment-arg))))
		       converted-predicate-body)))
		  ((equal? keyword 'global-variable)
		   (list
		    (list
		     'fix
		     (list
		      (list
		       'local-predicate
		       predicate-label-for-init
		       (list out-environment-arg in-environment-arg)
		       #t ; guard
		       (list
			(list
			 'direct-apply
			 predicate-label
			 (list "dummy" (car predicate-args) in-environment-arg))
			(list
			 'primitive
			 '%global-init
			 (list
			  (symbol->string-with-escape predicate-name)
			  (car predicate-args)
			  in-environment-arg)
			 out-environment-arg))))
		     converted-predicate-body)))
		  (else converted-predicate-body))))
	      (list
	       keyword
	       predicate-label
	       new-predicate-args
	       guard
	       final-result-body))))))))

(define (klokon-main expr)
  (let ((op (car expr)))
    (cond
     ((equal? op 'primitive) (klokon-primitive expr))
     ((equal? op 'assign)    (klokon-assign expr))
     ((equal? op 'apply)     (klokon-apply expr))
     ((equal? op 'fix)       (klokon-fix expr))
     (else
      (error 'klokon-main "unknown operator" expr)))))

(define (klokon-primitive expr) expr)

(define (klokon-parallel expr-list)
  (if (null? expr-list)
      '()
      (cons
       (klokon-main (car expr-list))
       (klokon-parallel (cdr expr-list)))))

(define (klokon-assign expr)
  (let ((keyword (list-ref expr 0))
	(source  (list-ref expr 1))
	(dest    (list-ref expr 2)))
    (if (member source (global-ref *global-variables-in-this-predicate*))
	(list keyword (label-make-global source) dest)
	(list keyword source                      dest))))
    
(define (klokon-apply expr)
  (let ((keyword (list-ref expr 0))
	(closure (list-ref expr 1))
	(args    (list-ref expr 2)))
    (list keyword closure (append args (list (label-get-environment-name))))))

(define (klokon-fix expr)
  (let ((keyword (list-ref expr 0))
	(binds   (list-ref expr 1))
	(body    (list-ref expr 2)))
    (if (not (= (length binds) 1))
	(error 'klokon-fix "Multiple bind in fix is not supported" expr)
	(let ((freevars-ed-local-predicate (list-ref binds 0)))
	  (let ((freevars-in-local-predicate
		 (klofree-detach-freevars freevars-ed-local-predicate))
		(local-predicate
		 (klofree-detach-predicate freevars-ed-local-predicate)))
	    (let ((local-predicate-keyword (list-ref local-predicate 0))
		  (local-predicate-name    (list-ref local-predicate 1))
		  (local-predicate-args    (list-ref local-predicate 2)))
	       ;;; +1 is for an argument for a closure
	       ;;; +1 is for an argument for an environment
	      (let ((local-predicate-args-len
		     (if (equal? local-predicate-keyword 'either-predicate)
			 (+ (length local-predicate-args) 3)
			 (+ (length local-predicate-args) 2)))
		    (closure-name local-predicate-name))
		(let ((new-local-predicate-name
		       (label-make-predicate-label
			local-predicate-name local-predicate-args-len))
		      (new-local-predicate-name-ref
		       (label-make-predicate-label-ref
			local-predicate-name local-predicate-args-len)))
		  (let ((converted-local-predicate
			 (klokon-local-predicate
			  local-predicate
			  new-local-predicate-name
			  closure-name
			  freevars-in-local-predicate))
			(converted-fix-body
			 (klokon-fix-body
			  body
			  new-local-predicate-name-ref
			  closure-name
			  freevars-in-local-predicate)))
		    (list
		     'fix
		     (list converted-local-predicate)
		     converted-fix-body))))))))))

(define (klokon-local-predicate local-predicate new-local-predicate-name closure-name freevars-in-local-predicate)
  (let ((keyword (car local-predicate)))
    (cond
     ((equal? keyword 'local-predicate)
      (klokon-local-normal-predicate
       local-predicate new-local-predicate-name closure-name freevars-in-local-predicate))
     ((equal? keyword 'either-predicate)
      (klokon-local-either-predicate
       local-predicate new-local-predicate-name closure-name freevars-in-local-predicate))
     (else
      (error 'klokon-local-predicate "Unknown predicate type" local-predicate)))))

(define (klokon-local-normal-predicate local-predicate new-local-predicate-name closure-name freevars-in-local-predicate)
  (let (
	(keyword        (list-ref local-predicate 0))
	(predicate-name (list-ref local-predicate 1))
	(predicate-args (list-ref local-predicate 2))
	(guard          (list-ref local-predicate 3))
	(body           (list-ref local-predicate 4)))
    (let ((record-extraction-expression
	   (list 'primitive
		 'record-ref
		 closure-name
		 (cons 's2k-any freevars-in-local-predicate))))
      (list
       keyword
       new-local-predicate-name
       (cons closure-name (append predicate-args (list (label-get-environment-name))))
       guard
       (cons
	record-extraction-expression
	(klokon-parallel body))))))

(define (klokon-local-either-predicate local-predicate new-local-predicate-name closure-name freevars-in-local-predicate)
  (let (
	(keyword        (list-ref local-predicate 0))
	(predicate-name (list-ref local-predicate 1))
	(predicate-args (list-ref local-predicate 2))
	(guard          (list-ref local-predicate 3))
	(body1          (list-ref local-predicate 4))
	(body2          (list-ref local-predicate 5)))
    (let ((record-extraction-expression
	   (list 'primitive
		 'record-ref
		 closure-name
		 (cons 's2k-any freevars-in-local-predicate))))
      (list
       keyword
       new-local-predicate-name
       (cons closure-name (append predicate-args (list (label-get-environment-name))))
       guard
       (cons
	record-extraction-expression
	(klokon-parallel body1))
       (cons
	record-extraction-expression
	(klokon-parallel body2))))))

;;;
;;; create a record containing freevars-in-local-predicate
;;;
(define (klokon-fix-body fix-body new-local-predicate-name closure-name freevars-in-local-predicate)
  (let* ((record-content
	  (cons new-local-predicate-name
		freevars-in-local-predicate))
	 (record-creation-expression
	  (list 'primitive 'make-record record-content closure-name)))
    (cons record-creation-expression (klokon-parallel fix-body))))

