;-*-SCHEME-*-

;;;
;;; StoK: Scheme to KL1 translator
;;;   Copyright (C) 1997 Yoshihiro Oyama
;;;     <oyama@is.s.u-tokyo.ac.jp>
;;;       December 19, 1997
;;;

;;
;; Escape characters which must not used in KL1
;; 

;;
;; escape algorithm
;;  -
;;     -> "__"
;;  other characters listed below
;;     -> "_charactercode_"
;;
;; for example, '&' is escaped to "_38_"
;;

(module escape)

(define (escape-char c)
  (cond
   ((char=? c #\-) "__")
   ((member
     c
     ;  (string->list "+.*/<=>!?:$%_&~^")
     (list #\+ #\. #\* #\/ #\< #\= #\> #\! #\? #\: #\$ #\% #\_ #\& #\~ #\^))
    (string-append
     "_"
     (integer->string (char->integer c))
     "_"))
   (else (list->string (list c)))))

(define (symbol->string-with-escape sym)
  (let* ((str (symbol->string sym))
	 (strlen (string-length str)))
    (let loop ((index 0)
	       (result ""))
      (if (>= index strlen)
	  result
	  (loop
	   (+ index 1)
	   (string-append result (escape-char (string-ref str index))))))))

