;-*-SCHEME-*-

;;;
;;; StoK: Scheme to KL1 translator
;;;   Copyright (C) 1997 Yoshihiro Oyama
;;;     <oyama@is.s.u-tokyo.ac.jp>
;;;       December 19, 1997
;;;

;
; Quick Sort
;

(module scheme-main)
(module-import-end)

(define (qsort lis)
  (if (null? lis)
      '()
      (let ((pivot (car lis))
	    (rest  (cdr lis)))
	(qsort-main pivot '() '() rest))))

(define (qsort-main pivot left right source)
  (if (null? source)
      (let ((sorted-left  (qsort left))
	    (sorted-right (qsort right))) 
	(append sorted-left (cons pivot sorted-right)))
      (let ((x (car source)))
	(if (< x pivot)
	    (qsort-main pivot (cons x left) right (cdr source))
	    (qsort-main pivot left (cons x right) (cdr source))))))

(define (read-random-list port1)
  (let loop ((reversed-result '())
	     (port port1))
    (let ((obj-and-newport (stok-read port)))
      (let ((obj     (stok-read-get-obj  obj-and-newport))
	    (newport (stok-read-get-port obj-and-newport)))
       (if (eof-object? obj)
	   (cons (reverse reversed-result) newport)
	   (loop (cons obj reversed-result) newport))))))

(define (scheme-main argc argv)
  (if (not (= argc 1))
      (error 'scheme-main "Usage: a.out datafilename" argv)
      (let* ((datafilename (list-ref argv 0))
	     (port (open-input-file datafilename))
	     (random-list-and-newport (read-random-list port))
	     (random-list (car  random-list-and-newport))
	     (newport     (cdr random-list-and-newport)))
	(close-input-port newport)
	(qsort random-list))))

