;-*-SCHEME-*-

;;;
;;; StoK: Scheme to KL1 translator
;;;   Copyright (C) 1997 Yoshihiro Oyama
;;;     <oyama@is.s.u-tokyo.ac.jp>
;;;       December 19, 1997
;;;

;
; Prime
;

(module scheme-main)
(module-import-end)

(define (primep i primes)
  (cond ((null? primes) #t)
	((= 0 (remainder i (car primes))) #f)
	(else (primep i (cdr primes)))))

(define (find-primes-in primes from until)
  (cond ((>= from until) '())
	((primep from primes)
	 (cons from (find-primes-in primes (+ from 1) until)))
	(else
	 (find-primes-in primes (+ from 1) until))))

(define (sqrt-int N) (isqrt N))

(define (prime-until max-seed seed n)
  (if (< n max-seed)
      seed
      (let* ((m (sqrt-int n))
	     (small-primes (prime-until max-seed seed m)))
	(append small-primes (find-primes-in small-primes m n)))))

(define (make-init-prime)
  (list 2 3 5 7 11 13))

(define (prime n)
  (prime-until 14 (make-init-prime) n))

(define (append left right)
  (if (null? left)
      right
      (cons (car left) (append (cdr left) right))))

(define (loopprime n iter prevans)
  (if (= iter 0)
      prevans
      (let ((ans (prime n)))
	(loopprime n (- iter 1) ans))))

(define (scheme-main argc argv)
  (if (not (= argc 2))
      (error 'scheme-main "Usage: a.out maxnum iter" argv)
      (let ((n    (string->integer (list-ref argv 0)))
	    (iter (string->integer (list-ref argv 1))))
	(loopprime n iter #f))))

