% (C)1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information.)

%%  mg2kl1.pl: Ground-MGTP/kl1 Translator

%%  MGTP/KL1 SYNTAX
%%  ===============
%%  
%%  MGTP_Program ::= { MGTP_Clause }+
%%  MGTP_Clause  ::= Negative_Clause
%%                |  Bipolar_Horn_Clause  | Bipolar_NonHorn_Clause
%%                |  Positive_Horn_Clause | Positive_NonHorn_Clause
%%
%%  Negative_Clause         ::= Antecedent        `-->' `false'           `.'
%%                           |  `false'           `:-'  Pure_Conjunction  `.'
%%  Bipolar_Horn_Clause     ::= Antecedent        `-->' Pure_Conjunction  `.'
%%                           |  MGTP_Atom         `:-'  Pure_Conjunction  `.'
%%  Bipolar_NonHorn_Clause  ::= Antecedent        `-->' Consequent        `.'
%%                           |  Pure_Disjunction  `:-'  Pure_Conjunction  `.'
%%  Positive_Horn_Clause    ::= `true'            `-->' Pure_Conjunction  `.'
%%                           |  MGTP_Atom         `:-'  `true'            `.'
%%  Positive_NonHorn_Clause ::= `true'            `-->' Consequent        `.'
%%                           |  Pure_Disjunction  `:-'  `true'            `.'
%%  
%%  Antecedent              ::= Pure_Conjunction [ `,' `{' Aux_Literals `}' ]
%%
%%  Consequent              ::= Pure_Disjunction
%%
%%  Pure_Conjunction        ::= MGTP_Atom { `,' MGTP_Atom }*
%%  Pure_Disjunction        ::= MGTP_Atom { `;' MGTP_Atom }*
%%
%%  MGTP_Atom               ::= /* represented with a usual KL1/Prolog term */
%%  
%%  Aux_Literals            ::= KL1_Guard { `,' KL1_Guard }* 

:- op(1090,xfx, (=>)).
:- op(800, xfy, (:)).
:- op(700, xfx, (\=)).
:- op(700, xfx, (:=)).
:- op(700, xfx, (<=)).
:- op(700, xfx, (<<=)).
:- op(700, xfx, ($:=)).
:- op(700, xfx, ($=:=)).
:- op(700, xfx, ($=\=)).
:- op(700, xfx, ($<)).
:- op(700, xfx, ($>)).
:- op(700, xfx, ($=<)).
:- op(700, xfx, ($>=)).
:- op(700, xfx, ($<=)).
:- op(700, xfx, ($$:=)).
:- op(700, xfx, ($$=:=)).
:- op(700, xfx, ($$=\=)).
:- op(700, xfx, ($$<)).
:- op(700, xfx, ($$>)).
:- op(700, xfx, ($$=<)).
:- op(700, xfx, ($$>=)).
:- op(700, xfx, ($$<=)).
:- op(700, xfx, (&<)).
:- op(700, xfx, (&>)).
:- op(700, xfx, (&=<)).
:- op(700, xfx, (&>=)).
:- op(700, xfx, (&<=)).
:- op(700, xfy, (@)).
:- op(500, yfx, (xor)).
:- op(300, xfy, (**)).
:- op(200, fx,  (&)).
:- op(150, xf,  (++)).
:- op(150, xf,  (--)).
:- op(100, fx, (#)).
:- op(100, xfx,(#)).
:- op(90, xfx, (::)).

save :-
        save(mg2kl1), unix(argv(Argv)), do(Argv).

do(Argv) :-
	init,
        ( Argv=[F|Opt] -> set_option(Opt), do1(F) ;
          true ),
        halt.

init :-
	abolish(switch,2),
	asserta(switch(cjm,merc)),
	asserta(switch(sort,no)),
	asserta(switch(dclause,no)).

set_option([naive|Os]) :-	switch(cjm,_,naive), set_option(Os).
set_option([premerc|Os]) :-	switch(cjm,_,premerc), set_option(Os).
set_option([merc|Os]) :-	switch(cjm,_,merc), set_option(Os).
set_option([rams|Os]) :-	switch(cjm,_,rams), set_option(Os).
set_option([newrams|Os]) :-	switch(cjm,_,newrams), set_option(Os).
set_option([sort|Os]) :-	switch(sort,_,yes), set_option(Os).
set_option([dclause|Os]) :-	switch(dclause,_,yes), set_option(Os).
set_option([]).

switch(Name,Old,New) :-
	retract(switch(Name,Old)),
	asserta(switch(Name,New)).

%inputFile(Name,InF) :-
%	name(Name,[D,O,M|_]), name(DOM,[D,O,M]),
%	nameConcat(['../tptp/Problems/',DOM,'/',Name,'.mg'],InF) ;
%	nameConcat(['Problems/test/',Name,'.mg'],InF).
%
%outputFile(Name,OutF) :-
%	switch(cjm,Cjm),
%	nameConcat(['klic/',Name,'_',Cjm,'.kl1'],OutF).

inputFile(Name,InF) :-
	nameConcat([Name,'.mg'],InF).

outputFile(Name,OutF) :-
	switch(cjm,Cjm),
	nameConcat([Name,'_',Cjm,'.kl1'],OutF).

nameConcat(NameList,NewName) :- nameConcat1(NameList,S), name(NewName,S).
nameConcat1([H|L],S) :- name(H,SH), append(SH,SL,S), nameConcat1(L,SL).
nameConcat1([],[]).

append([H|X],Y,[H|Z]) :- append(X,Y,Z).
append([],Y,Y).

do1(Name) :-
        nofileerrors, inputFile(Name,InF), see(InF), fileerrors,
        readCls(InF,Pcls,Tcls,Gcls),!,
	switch(cjm,Cjm),
	( ( Cjm=naive ; Cjm=premerc ) ->
		ante2list(Tcls,Tcls1),
		ante2list(Gcls,Gcls1),
	        outputFile(Name,OutF), tell(OutF),
	        outputHead(OutF,Pcls,Tcls1,Gcls1),
	        outputCls(Tcls1),
	        outputCls(Gcls1),
	        outputCls(Pcls),
		nl,write('otherwise.'),nl,
		write('c(_,_,_,R):-true|R=fail.'),nl,
	        outputFoot(OutF),
	        told ;
	  Cjm=merc ->
	        multi_entries(Tcls,Tcls1,[]),
	        multi_entries(Gcls,Gcls0,[]),
	        remove_taut(Gcls0,Gcls1),
	        outputFile(Name,OutF), tell(OutF),
	        outputHead(OutF,Pcls,Tcls1,Gcls1),
	        outputCls(Tcls1),
	        outputCls(Gcls1),
	        outputCls(Pcls),
		nl,write('otherwise.'),nl,
		write('c(_,_,_,R):-true|R=fail.'),nl,
	        outputFoot(OutF),
	        told ;
	  ( Cjm=rams ; Cjm=newrams ) ->
		ante2list(Tcls,Tcls1),
		ante2list(Gcls,Gcls1),
	        outputFile(Name,OutF), tell(OutF),
	        outputHead(OutF,Pcls,Tcls,Gcls),
	        outputCls(Tcls1),
	        outputCls(Gcls1),
	        outputCls(Pcls),
		nl,write('otherwise.'),nl,
		write('c(_,_,_,R):-true|R=fail.'),nl,
		( switch(dclause,yes) ->
		    output_dclause(Tcls1),
		    output_dclause(Gcls1),
		    output_dclause(Pcls),
		    nl,write('otherwise.'),nl,
		    write('d(_,_,_,R):-true|R=fail.'),nl;
		  true ),
	        outputFoot(OutF),
	        told ).

outputHead(OutF,Pcls,Tcls,Gcls) :-
	switch(cjm,Cjm),
        nl,write('%%  '),write(OutF), write('  Ground-MGTP/'),write(Cjm),
	write('-kl1 User-clauses'),nl,
	cids(Tcls,TS,[],Cjm),
	cids(Gcls,GS,M,Cjm),
	cids(Pcls,M,[],Cjm),
	nl,write(':- module problem.'),nl,
	nl,write('negCls(Cn):-true|Cn='),nl,
	tab(4),write(TS),period,nl,
	nl,write('genCls(Cg):-true|Cg='),nl,
	tab(4),write(GS),period,nl.

cids([mg_cl(Cid,(_-->_))|Cls],[Cid|H],T,naive) :- !,
	cids(Cls,H,T,naive).
cids([mg_cl(Cid,(_-->_))|Cls],[Cid|H],T,premerc) :- !,
	cids(Cls,H,T,naive).
cids([mg_cl(Cid,(1:true-->_))|Cls],[Cid|H],T,merc) :- !,
	cids(Cls,H,T,merc).
cids([mg_cl(Cid,(fire(1:_,_,[],_)-->_))|Cls],[Cid|H],T,merc) :- !,
	cids(Cls,H,T,merc).
cids([mg_cl(Cid,(fire(LN:_,_,_,_)-->_))|Cls],[CidN|H],T,merc) :- !,
%	nameConcat([Cid,'_',LN],CidN),
	litnameConcat(LN,LNS),nameConcat([Cid,'_',LNS],CidN),
	cids(Cls,H,T,merc).
cids([mg_cl(Cid,(ANT-->_))|Cls],[Cid:LIS|H],T,rams) :- !,
	initLIS(ANT,[_|LIS],[]),
	cids(Cls,H,T,rams).
cids([mg_cl(Cid,(ANT-->_))|Cls],[X|H],T,newrams) :- !,
	( switch(dclause,yes) -> no_of_lits(ANT,0,LL), X=(Cid=LL:[]) ;
	  X=(Cid:[]) ),
	cids(Cls,H,T,newrams).
cids([],T,T,_).

initLIS((A,B),H,T) :- !, initLIS(A,H,M), initLIS(B,M,T).
initLIS(_,[[]|T],T).

no_of_lits((A,B),Ni,No) :- !, no_of_lits(A,Ni,Nm), no_of_lits(B,Nm,No).
no_of_lits(_,Ni,No) :- No is Ni+1.

outputFoot(OutF) :-
        nl,write('%%  '),write(OutF),write('  EOF'),nl.

%%%

readCls(InF,Pcls,Tcls,Gcls) :-
        scan([InF],0,Pos_cls,Neg_cls,Gen_cls),
        numbering(Pos_cls,Pcls),
        numbering(Neg_cls,Tcls),
        numbering(Gen_cls,Gcls).

numbering([mg_cl(CN,(A-->C))|Rest],
          [mg_cl(CN,(NewA-->NewC))|NewRest]) :-
        numbering1(A,ante,NewA,0,N),
        numbering1(C,cnsq,NewC,N,_),
        numbering(Rest,NewRest).
numbering([],[]).

numbering1((A,B),AC,(NewA,NewB),Ni,No) :- !,
        numbering1(A,AC,NewA,Ni,N1),
        numbering1(B,AC,NewB,N1,No).
numbering1((A;B),AC,(NewA;NewB),Ni,No) :- !,
        numbering1(A,AC,NewA,Ni,N1),
        numbering1(B,AC,NewB,N1,No).
numbering1({G},ante,{G},No,No) :- !.
numbering1(Lit,cnsq,No:Lit,Ni,No) :- !, No is Ni+1.
numbering1(Lit,ante,No:Lit,Ni,No) :- !, No is Ni+1.

scan(InF,CN,Pcls,Ncls,Gcls) :-
        read(Cls),!,
        scan1(InF,CN,Cls,Pcls,Ncls,Gcls).
scan(_,_,_,_,_,_,_) :-
        display('!! Illeagal input !!'),nl, told,!, fail.

scan1(InF,CN,problemType(R,F,H),Pcls,Ncls,Gcls) :- !,
	assert(problemType(R,F,H)),
	scan(InF,CN,Pcls,Ncls,Gcls).

scan1(InF,CN,InT,
        [mg_cl(Cid,(true-->CNS))|Pcls],Ncls,Gcls) :-
	( InT=(true-->CNS) ; InT=(CNS:-true) ),!,
        CN1 is CN+1,
	nameConcat(['c',CN1],Cid),
        scan(InF,CN1,Pcls,Ncls,Gcls).
scan1(InF,CN,InT,Pcls,
	[mg_cl(Cid,(ANT-->false))|Ncls],Gcls) :-
	( InT=(ANT-->false) ; InT=(false:-ANT) ),!,
        CN1 is CN+1,
	nameConcat(['c',CN1],Cid),
        scan(InF,CN1,Pcls,Ncls,Gcls).
scan1(InF,CN,InT,Pcls,Ncls,
	[mg_cl(Cid,(ANT-->CNS))|Gcls]) :-
	( InT=(ANT-->CNS) ; InT=(CNS:-ANT) ),!,
        CN1 is CN+1,
	nameConcat(['c',CN1],Cid),
        scan(InF,CN1,Pcls,Ncls,Gcls).

scan1(InF,CN,(:- see(File)),Pcls,Ncls,Gcls) :- !,
        see(File),
        scan([File|InF],CN,Pcls,Ncls,Gcls).
scan1([_,File|InF],CN,end_of_file,Pcls,Ncls,Gcls) :- !,
        seen, see(File),
        scan([File|InF],CN,Pcls,Ncls,Gcls).
scan1([_],_,end_of_file,[],[],[]) :- !, seen.

%%%

ante2list([mg_cl(CN,(ANT-->CNS))|Cls],
	  [mg_cl(CN,(ANT1-->CNS))|Cls1]) :-
	( ANT=(_,_) ->
		conj2list(ANT,AL,[]),
		vars_in(CNS,[],Cvars),
		ante2list1(AL,[],Cvars,ANT1) ;
	  ANT1=[ANT+[]-_] ),
	ante2list(Cls,Cls1).
ante2list([],[]).

ante2list1([{G}],_,_,[{G}]) :- !.
ante2list1([A|B],Ivars,Cvars,[A+Ivars-Ovars|ANT1]) :-
	vars_in(A,[],Avars),
	unionVars(Avars,Ivars,Lvars),
	vars_in(B,[],Bvars),
	unionVars(Bvars,Cvars,Rvars),
	intersectionVars(Lvars,Rvars,Ovars),
	ante2list1(B,Ovars,Cvars,ANT1).
ante2list1([],_,_,[]).

%%%

vars_in(V,Vi,Vo) :- var(V),!, add_v(V,Vi,Vo).
vars_in({P},Vi,Vo) :- !, vars_in(P,Vi,Vo).
vars_in({},Vi,Vi) :- !.
vars_in([A|B],Vi,Vo) :- vars_in(A,Vi,Vm), vars_in(B,Vm,Vo).
vars_in([],Vi,Vi).
vars_in(Atom,Vi,Vi) :- atom(Atom),!.
vars_in(Int,Vi,Vi) :- integer(Int),!.
vars_in(Term,Vi,Vo) :- functor(Term,_,Arity),
        vars_in_args(1,Arity,Term,Vi,Vo).

vars_in_args(Jth,Last,Term,Vi,Vo) :-
        Jth<Last,
        arg(Jth,Term,Arg),
        vars_in(Arg,Vi,Vm),
        J1th is Jth+1,
        vars_in_args(J1th,Last,Term,Vm,Vo).
vars_in_args(Last,Last,Term,Vi,Vo) :-
        arg(Last,Term,Arg),
        vars_in(Arg,Vi,Vo).

add_v(V,[V1|Vi],[V1|Vi]) :- V==V1,!.
add_v(V,[V1|Vi],[V1|Vo]) :- add_v(V,Vi,Vo).
add_v(V,[],[V]).

multi_entries([mg_cl(CN,(A-->C))|Cls],Hd,Tl) :-
        conj2list(A,AL,[]),
        findall(Entry,entry(CN,[],AL,A,C,Entry),Entries),
        multi_entries1(Entries,Hd,Tl1),
        multi_entries(Cls,Tl1,Tl).
multi_entries([],Tl,Tl).

multi_entries1([X|Rest],[X|Hd],Tl) :- multi_entries1(Rest,Hd,Tl).
multi_entries1([],Tl,Tl).

entry(CN,Lits,[LN:Lit|Rest],A0,CSQ,Entry) :-
%        factoring(LN,Lit,Rest,Lits,(A0,CSQ),
        factoring([LN],Lit,Rest,Lits,(A0,CSQ),
                  LN1,Lit1,Rest1,Lits1,(A1,CSQ1)),
%        nameConcat(['f',LN1],NewLN),
	NewLN=LN1,
        rev_append(Lits1,Rest1,OL),
        continuation(Lit1,OL,CSQ1,NewLit-Out1,NewOL),
        Entry= mg_cl(CN,(fire(NewLN:NewLit,Out1,NewOL,A1)-->CSQ1)).
entry(CN,Lits,[LN:Lit|Rest],A0,CSQ,Entry) :-
        rev_append(Lits,Rest,OL),
        continuation(Lit,OL,CSQ,NewLit-Out1,NewOL),
%        Entry= mg_cl(CN,(fire(LN:NewLit,Out1,NewOL,A0)-->CSQ)).
        Entry= mg_cl(CN,(fire([LN]:NewLit,Out1,NewOL,A0)-->CSQ)).
entry(CN,Lits,[LN:Lit|Rest],A0,CSQ,Entry) :-
        entry(CN,[LN:Lit|Lits],Rest,A0,CSQ,Entry).

factoring(LN,Lit,Rest,Lits,PP,LN1,Lit1,Rest1,Lits1,PP1) :-
        factoring1(LN,Lit,Rest,Lits,PP,LN2,Lit2,Rest2,Lits2,PP2),
        ( factoring(LN2,Lit2,Rest2,Lits2,PP2,LN1,Lit1,Rest1,Lits1,PP1) ;
          LN1=LN2, Lit1=Lit2, Rest1=Rest2, Lits1=Lits2, PP1=PP2 ).

factoring1(LN,Lit,[LN2:Lit2|Rest],Lits,PP,LN1,FLit,FRest,FLits,FPP) :-
        copy_term((Lit,Lit2,Rest,Lits,PP),(FLit,FLit2,FRest,FLits,FPP)),
        unify_once(FLit,FLit2),
%        nameConcat([LN,'f',LN2],LN1).
        append(LN,[LN2],LN1).
factoring1(LN,Lit,[LN2:Lit2|Rest],Lits,PP,LN1,Lit1,Rest1,Lits1,PP1) :-
        factoring1(LN,Lit,Rest,[LN2:Lit2|Lits],PP,LN1,Lit1,Rest1,Lits1,PP1).

unify_once(X,Y) :- unify(X,Y),!.

rev_append([X|L1],L2,L3) :- rev_append(L1,[X|L2],L3).
rev_append([],L2,L2).

continuation(Lit,OL,CSQ,Lit-(1:Ovars),OL1) :-
        vars_in(Lit,[],Lvars),
        vars_in(OL,[],OLvars),
        vars_in(CSQ,[],Qvars),
	unionVars(OLvars,Qvars,OLQvars),
	intersectionVars(Lvars,OLQvars,Ovars),
        continuation1(1,Ovars,Qvars,OL,OL1),!.

continuation1(_,_,_,[{G}],[{G}]) :- !.
continuation1(VN,Ivars,Qvars,[LN:Lit|OL],
	      [LN:Lit+(VN:Ivars)-(VN1:Ovars)|OL1]) :-
	VN1 is VN+1,
	vars_in(Lit,[],Lvars),
        vars_in(OL,[],OLvars),
	unionVars(OLvars,Qvars,OLQvars),
	unionVars(Ivars,Lvars,ILvars),
	intersectionVars(ILvars,OLQvars,Ovars),!,
	continuation1(VN1,Ovars,Qvars,OL,OL1).
continuation1(_,_,_,[],[]).

member_var(V,[VV|_]) :- V==VV,!.
member_var(V,[_|VV]) :- member_var(V,VV).

subset_vars([V|VV1],VV2) :- member_var(V,VV2),!,
        subset_vars(VV1,VV2).
subset_vars([],_).

unionVars(VV1,[],VV1) :- !.
unionVars([],VV2,VV2) :- !.
unionVars([V|VV1],VV2,UVV) :- member_var(V,VV2),!,
        unionVars(VV1,VV2,UVV).
unionVars([V|VV1],VV2,[V|UVV]) :- unionVars(VV1,VV2,UVV).

intersectionVars(_,[],[]) :- !.
intersectionVars([],_,[]) :- !.
intersectionVars([V|VV1],VV2,[V|UVV]) :- member_var(V,VV2),!,
         intersectionVars(VV1,VV2,UVV).
intersectionVars([_|VV1],VV2,UVV) :- intersectionVars(VV1,VV2,UVV).

vars_count(V,Vi,Vo) :- var(V),!, add_vc(V,Vi,Vo).
vars_count({{P}},Vi,Vo) :- !, vars_count(P,Vi,Vo).
vars_count([A|B],Vi,Vo) :- vars_count(A,Vi,Vm), vars_count(B,Vm,Vo).
vars_count([],Vi,Vi).
vars_count(Atom,Vi,Vi) :- atom(Atom),!.
vars_count(Int,Vi,Vi) :- integer(Int),!.
vars_count(Term,Vi,Vo) :- functor(Term,_,Arity),
        vars_count_args(1,Arity,Term,Vi,Vo).

vars_count_args(Jth,Last,Term,Vi,Vo) :-
        arg(Jth,Term,Arg),
        ( Jth < Last ->
	        J1th is Jth+1,
	        vars_count(Arg,Vi,Vm),
	        vars_count_args(J1th,Last,Term,Vm,Vo) ;
	  Jth= Last ->
	        vars_count(Arg,Vi,Vo) ).

add_vc(V,[V1=C|Vi],[V1=C1|Vi]) :- V==V1,!, C1 is C+1.
add_vc(V,[V1|Vi],[V1|Vo]) :- add_vc(V,Vi,Vo).
add_vc(V,[],[V=1]).

get_vc(V,[V1=C|_],C) :- V==V1,!.
get_vc(V,[_|Vi],C) :- get_vc(V,Vi,C).

dup_vars([_=1|Vars],DupVars) :- !, dup_vars(Vars,DupVars).
dup_vars([V=_|Vars],[V|DupVars]) :- !, dup_vars(Vars,DupVars).
dup_vars([],[]).

%%%

unify(X,Y) :-
        var(X) ->
                (var(Y) ->
                        X = Y;
                %true ->
                        functor(Y,_,N),
                        (N = 0 -> true;
                        N = 1 ->
                                arg(1,Y,Y1),
                                not_occurs_in(X,Y1);
                        %true ->
                                not_occurs_in_args(X,Y,N)),
                        X = Y);
        var(Y) ->
                functor(X,_,N),
                (N = 0 ->
                        true;
                N = 1 ->
                        arg(1,X,X1),
                        not_occurs_in(Y,X1);
                %true ->
                        not_occurs_in_args(Y,X,N)),
                X = Y;
        %true ->
                functor(X,F,N),
                functor(Y,F,N),
                (N = 0 ->
                        true;
                N = 1 ->
                        arg(1,X,X1),
                        arg(1,Y,Y1),
                        unify(X1,Y1);
                %true ->
                        unify_args(X,Y,N)).

unify_args(X,Y,N) :-
        N = 1 ->
                arg(1,X,X1),
                arg(1,Y,Y1),
                unify(X1,Y1);
        %true ->
                arg(N,X,Xn),
                arg(N,Y,Yn),
                unify(Xn,Yn),
                N1 is N - 1,
                unify_args(X,Y,N1).

%%%

not_occurs_in(Var,Term) :-
        Var == Term ->
                fail;
        var(Term) ->
                true;
        %true ->
                functor(Term,_,N),
                (N = 0 ->
                        true;
                N = 1 ->
                        arg(1,Term,Arg1),
                        not_occurs_in(Var,Arg1);
                %true ->
                        not_occurs_in_args(Var,Term,N)).

not_occurs_in_args(Var,Term,N) :-
        N = 1 ->
                arg(1,Term,Arg1),
                not_occurs_in(Var,Arg1);
        %true ->
                arg(N,Term,Argn),
                not_occurs_in(Var,Argn),
                N1 is N - 1,
                not_occurs_in_args(Var,Term,N1).

%%%

remove_taut([Cls|Cls1],Cls2) :- 
        \+(\+((numbervars(Cls,0,_),
               Cls=mg_cl(_,(fire(_:Atom,_,_,_)-->_:Atom))))),!,
        remove_taut(Cls1,Cls2).
remove_taut([Cls|Cls1],[Cls|Cls2]) :- !,
        remove_taut(Cls1,Cls2).
remove_taut([],[]).

%%%

output_dclause([C1|Cls]) :-
	output_dclause1(C1),
	output_dclause(Cls).
output_dclause([]).

output_dclause1(mg_cl(CN,((1:true)-->_))) :-
    ( switch(sort,yes) ->
        nl,write(d(CN,1,'_':true,'R')) ;
      nl,write(d(CN,1,true,'R')) ),
    if,write(true),commit,write('R'=succ),period,nl.
output_dclause1(mg_cl(CN,([(1:Lit)+_-_,{G}]-->CSQ))) :- !,
    \+(\+(( numbervars((Lit,G,CSQ),0,_),
            ( switch(sort,yes) ->
	        nl,write(d(CN,1,'_':Lit,'R')) ;
	      nl,write(d(CN,1,Lit,'R')) ),
	    if,write(G),commit,
	    write('R'=succ),period,nl ))).
output_dclause1(mg_cl(CN,([(1:Lit)+_-_|ANT]-->CSQ))) :-
    \+(\+(( numbervars((Lit,ANT,CSQ),0,_),
            ( switch(sort,yes) ->
	        nl,write(d(CN,1,'_':Lit,'R')) ;
	      nl,write(d(CN,1,Lit,'R')) ),
	    if,write(true),commit,
	    outputAnte_dclause(CN,['N'],1,ANT) ))).

outputAnte_dclause(_,_,_,[]):-
	write('R'=succ),period,nl.
outputAnte_dclause(CN,_,_,[(LN1:Lit)+_-_,{G}]) :- !,
	write('R'=succ),period,nl,
	( switch(sort,yes) ->
	    write(d(CN,LN1,'_':Lit,'R')) ;
	  write(d(CN,LN1,Lit,'R')) ),
	if,write(G),commit,
	write('R'=succ),period,nl.
outputAnte_dclause(CN,Info,NN,[(LN1:Lit)+_-_|ANT]) :- !,
	write('R'=succ),period,nl,
	nameConcat(['N',NN],N1), NN1 is NN+1,
	( switch(sort,yes) ->
	    write(d(CN,LN1,'_':Lit,'R')) ;
	  write(d(CN,LN1,Lit,'R')) ),
	if,write(true),commit,
	append(Info,[N1],Info1),
    outputAnte_dclause(CN,Info1,NN1,ANT).

%%%

outputCls([C1|Cls]) :-
	switch(cjm,Cjm),
	( Cjm=naive ->	output_naive(C1) ;
	  Cjm=premerc -> output_premerc(C1) ;
	  Cjm=merc -> output_merc(C1) ;
	  ( Cjm=rams ; Cjm=newrams ) -> output_naive(C1) ),
	outputCls(Cls).
outputCls([]).

output_naive(mg_cl(CN,((1:true)-->CSQ))) :-
    ( switch(sort,yes) ->
        nl,write(c(CN,'N':true,[],'R')) ;
      nl,write(c(CN,true,[],'R')) ),
    if,write(true),commit,
    outputCnsq_naive(CN,['N'],CSQ),period,nl.
output_naive(mg_cl(CN,([(1:Lit)+Ivars-_,{G}]-->CSQ))) :-
    \+(\+(( numbervars((Lit,G,CSQ),0,_),
            ( switch(sort,yes) ->
	        nl,write(c(CN,'N':Lit,Ivars,'R')) ;
	      nl,write(c(CN,Lit,Ivars,'R')) ),
	    if,write(G),commit,
	    ( CSQ=(_:false) -> write('R'=false),period,nl ;
	      outputCnsq_naive(CN,['N'],CSQ),period,nl ) ))).
output_naive(mg_cl(CN,([(1:Lit)+Ivars-_|ANT]-->CSQ))) :-
    \+(\+(( numbervars((Lit,ANT,CSQ),0,_),
            ( switch(sort,yes) ->
	        nl,write(c(CN,'N':Lit,Ivars,'R')) ;
	      nl,write(c(CN,Lit,Ivars,'R')) ),
	    if,write(true),commit,
	    outputAnte_naive(CN,['N'],1,ANT,CSQ) ))).

outputAnte_naive(_,_,_,[],_:false) :- !,
	write('R'=false),period,nl.
outputAnte_naive(CN,Info,_,[],CSQ) :- !,
	outputCnsq_naive(CN,Info,CSQ),period,nl.
outputAnte_naive(CN,Info,NN,[(_:Lit)+Ivars-_,{G}],CSQ) :- !,
        ( switch(sort,yes) ->
            write('R'=((NN:Info):Ivars)),period,nl ;
          write('R'=(NN:Ivars)),period,nl ),
	nameConcat(['N',NN],N1),
        ( switch(sort,yes) ->
            nl,write(c(CN,N1:Lit,((NN:Info):Ivars),'R')) ;
          nl,write(c(CN,Lit,(NN:Ivars),'R')) ),
        if,write(G),commit,
	append(Info,[N1],Info1),
	( CSQ=(_:false) -> write('R'=false),period,nl ;
	  outputCnsq_naive(CN,Info1,CSQ),period,nl ).
outputAnte_naive(CN,Info,NN,[(_:Lit)+Ivars-_|ANT],CSQ) :- !,
        ( switch(sort,yes) ->
            write('R'=((NN:Info):Ivars)),period,nl ;
          write('R'=(NN:Ivars)),period,nl ),
	nameConcat(['N',NN],N1), NN1 is NN+1,
        ( switch(sort,yes) ->
            nl,write(c(CN,N1:Lit,((NN:Info):Ivars),'R')) ;
          nl,write(c(CN,Lit,(NN:Ivars),'R')) ),
        if,write(true),commit,
	append(Info,[N1],Info1),
    outputAnte_naive(CN,Info1,NN1,ANT,CSQ).

outputCnsq_naive(CN,Ainfo,(A;B)) :-
	( switch(sort,no) -> write('R=( ') ;
	  cnumber(CN,N),
	  write('R=('), write([N|Ainfo]), write('=( ') ),
	outputDisj((A;B),CN,Ainfo),
	( switch(sort,no) -> write(' )') ;
	  write(' ))') ).
outputCnsq_naive(CN,Ainfo,(A,B)) :-
	( switch(sort,no) -> write('R=( ') ;
	  cnumber(CN,N),
	  write('R=('), write([N|Ainfo]), write('=( ') ),
	outputConj((A,B),CN,Ainfo),
	( switch(sort,no) -> write(' )') ;
	  write(' ))') ).
outputCnsq_naive(CN,Ainfo,_:U1) :-
	( switch(sort,no) -> write('R'=U1) ;
	  cnumber(CN,N),
          write('R'=([N|Ainfo]=U1)) ).

cnumber(CN,N) :- name(CN,[_|NS]),name(N,NS).

outputDisj((A;B),CN,Ainfo) :- !,
	outputDisj(A,CN,Ainfo),semicolon,
        outputDisj(B,CN,Ainfo).
outputDisj(_:U1,_,_) :- write(U1).

outputConj((A,B),CN,Ainfo) :- !,
	outputConj(A,CN,Ainfo),comma,
        outputConj(B,CN,Ainfo).
outputConj(_:U1,_,_) :- write(U1).

conj2list((A,B),Hd,Tl) :- !, conj2list(A,Hd,Md), conj2list(B,Md,Tl).
conj2list(A,[A|Tl],Tl).

disj2list((A;B),Hd,Tl) :- !, disj2list(A,Hd,Md), disj2list(B,Md,Tl).
disj2list(A,[AL|Tl],Tl) :- conj2list(A,AL,[]).

%%%

output_premerc(mg_cl(CN,((1:true)-->CSQ))) :-
    ( switch(sort,yes) ->
        nl,write(c(CN,'N':true,[],'R')) ;
      nl,write(c(CN,true,[],'R')) ),
    if,write(true),commit,
    outputCnsq_naive(CN,['N'],CSQ),period,nl.
output_premerc(mg_cl(CN,([(1:Lit)+Ivars-_,{G}]-->CSQ))) :-
    \+(\+(( numbervars((Lit,G,CSQ),0,_),
            ( switch(sort,yes) ->
	        nl,write(c(CN,'N':Lit,Ivars,'R')) ;
	      nl,write(c(CN,Lit,Ivars,'R')) ),
	    if,write(G),commit,
	    ( CSQ=(_:false) -> write('R'=false),period,nl ;
	      outputCnsq_naive(CN,['N'],CSQ),period,nl ) ))).
output_premerc(mg_cl(CN,([(1:Lit)+Ivars-_|ANT]-->CSQ))) :-
    \+(\+(( numbervars((Lit,ANT,CSQ),0,_),
            ( switch(sort,yes) ->
	        nl,write(c(CN,'N':Lit,Ivars,'R')) ;
	      nl,write(c(CN,Lit,Ivars,'R')) ),
	    if,write(true),commit,
	    outputAnte_premerc(CN,['N'],1,ANT,CSQ) ))).

outputAnte_premerc(_,_,_,[],_:false) :- !,
	write('R'=false),period,nl.
outputAnte_premerc(CN,Info,_,[],CSQ) :- !,
	outputCnsq_naive(CN,Info,CSQ),period,nl.
outputAnte_premerc(CN,Info,NN,[(_:Lit)+Ivars-_],CSQ) :- !,
	nameConcat(['N',NN],N1), NN1 is NN+1,
        ( switch(sort,yes) ->
            write('R'=([]:Ivars)),period,nl,
	    nl,write(c(CN,N1:Lit,([]:Ivars),'R')) ;
          write('R'=([]:Ivars)),period,nl,
	  nl,write(c(CN,Lit,([]:Ivars),'R')) ),
	if,write(true),commit,
	append(Info,[N1],Info1),
    outputAnte_premerc(CN,Info1,NN1,[],CSQ).
outputAnte_premerc(CN,Info,NN,[(_:Lit)+Ivars-_,{G}],CSQ) :- !,
	nameConcat(['N',NN],N1),
        ( switch(sort,yes) ->
	    write('R'=(NN:Ivars)),period,nl,
            nl,write(c(CN,N1:Lit,(NN:Ivars),'R')) ;
	  write('R'=(NN:Ivars)),period,nl,
          nl,write(c(CN,Lit,(NN:Ivars),'R')) ),
        if,write(G),commit,
	append(Info,[N1],Info1),
        ( CSQ=(_:false) -> write('R'=false),period,nl ;
	  outputCnsq_naive(CN,Info1,CSQ),period,nl ).
outputAnte_premerc(CN,Info,NN,[(_:Lit)+Ivars-_|ANT],CSQ) :- !,
	nameConcat(['N',NN],N1), NN1 is NN+1,
        ( switch(sort,yes) ->
	    write('R'=(NN:Ivars)),period,nl,
            nl,write(c(CN,N1:Lit,(NN:Ivars),'R')) ;
	  write('R'=(NN:Ivars)),period,nl,
          nl,write(c(CN,Lit,(NN:Ivars),'R')) ),
        if,write(true),commit,
	append(Info,[N1],Info1),
    outputAnte_premerc(CN,Info1,NN1,ANT,CSQ).

%%%

output_merc(mg_cl(CN,(1:true-->CSQ))) :-
    \+(\+(( numbervars(CSQ,0,_),
            ( switch(sort,yes) ->
	        nl,write(c(CN,'N':true,[],'R')) ;
	      nl,write(c(CN,true,[],'R')) ),
	    if,write(true),commit,
            outputCnsq_naive(CN,['N'],CSQ),period,nl))).
output_merc(mg_cl(CN,(fire(LN:Lit,_,[{G}],_)-->CSQ))) :- !,
    litnameConcat(LN,LNS), nameConcat([CN,'_',LNS],Pname),
    \+(\+(( numbervars((Lit,G,CSQ),0,_),
            ( switch(sort,yes) ->
   	        nl,write(c(Pname,'N':Lit,[],'R')) ;
              nl,write(c(Pname,Lit,[],'R')) ),
	    if,write(G),commit,
            outputCnsq_naive(CN,['N'],CSQ),period,nl))).
output_merc(mg_cl(CN,(fire(LN:Lit,_,OL,ANT)-->CSQ))) :-
%    nameConcat([CN,'_',LN],Pname),
    litnameConcat(LN,LNS), nameConcat([CN,'_',LNS],Pname),
    \+(\+(( numbervars((ANT,CSQ),0,_),
            ( switch(sort,yes) ->
	        nl,write(c(Pname,'N':Lit,[],'R')) ;
	      nl,write(c(Pname,Lit,[],'R')) ),
	    if,write(true),commit,
            makeInfo('N',LN,Info),
	    outputAnte_merc(CN,LN,Pname,Info,1,OL,CSQ) ))).

makeInfo(X,[N|Ns],[N:X|XNs]) :- makeInfo(X,Ns,XNs).
makeInfo(_,[],[]).

outputAnte_merc(CN,_,Pname,Info,_,[LN1:Lit+Ivars-_,{G}],CSQ) :- !,
	nameConcat(['N',LN1],N1),
        ( switch(sort,yes) ->
	    Ivars=(_:IIvars),
            write('R'=(Info:IIvars)),period,
            nl,write(c(Pname,N1:Lit,Info:IIvars,'R')) ;
          write('R'=Ivars),period,
          nl,write(c(Pname,Lit,Ivars,'R')) ),
	if,write(G),commit,
	insertInfo(LN1:N1,Info,Info1),
	( CSQ=(_:false) -> write('R'=false),period,nl ;
	  fixInfo(Info1,Finfo),
	  outputCnsq_naive(CN,Finfo,CSQ),period,nl ).
outputAnte_merc(CN,LN,Pname,Info,NN,[LN1:Lit+Ivars-_|OL],CSQ) :- !,
	nameConcat(['N',LN1],N1), NN1 is NN+1,
        ( switch(sort,yes) ->
	    Ivars=(_:IIvars),
            write('R'=(Info:IIvars)),period,
            nl,write(c(Pname,N1:Lit,Info:IIvars,'R')) ;
          write('R'=Ivars),period,
          nl,write(c(Pname,Lit,Ivars,'R')) ),
	if,write(true),commit,
	insertInfo(LN1:N1,Info,Info1),
    outputAnte_merc(CN,LN,Pname,Info1,NN1,OL,CSQ).
outputAnte_merc(_,_,_,_,_,[],_:false) :- !,
	write('R'=false),period,nl.
outputAnte_merc(CN,_,_,Info,_,[],CSQ) :- !,
	fixInfo(Info,Finfo),
	outputCnsq_naive(CN,Finfo,CSQ),period,nl.

fixInfo([_:N|Is],[N|Ns]) :- fixInfo(Is,Ns).
fixInfo([],[]).

insertInfo(N:X,[M:Y|Info],[N:X,M:Y|Info]) :- N<M,!.
insertInfo(N:X,[M:Y|Info],[M:Y|Info1]) :- insertInfo(N:X,Info,Info1).
insertInfo(N:X,[],[N:X]).

space :- write(' ').
comma :- write(',').
period :- write('.').
if :- write(':-').
semicolon :- write(';').
commit :- write('|').

litnameConcat(NameList,NewName) :- litnameConcat1(NameList,S), name(NewName,S).
litnameConcat1([H],S) :- name(H,S).
litnameConcat1([H|L],S) :- name(H,SH), name('_',[XS]), append(SH,[XS|SL],S),
			   litnameConcat1(L,SL).

%%  mg2kl1.pl  EOF
