/* huiTestTrace.c
 *	module to test trace message handling in Helios User-interface
 *		created by k3sato on November 28th in 1994.
 *
 *	modification history:	
 *
 * $Id: huiTestTrace.c,v 1.1 1994/12/01 10:15:01 k3sato Exp $
 */

#include <stdio.h>

#include "helios.h"
#include "huiMessage.h"
#include "huiMemory.h"

/* defined in huiMAccess.c
 */
extern HuiBoolean huiReceiveMsgFromMonitor();
extern HuiBoolean huiSetupTraceSpeedFromMsg();

/* defined in huiDebugInfo.c
 */
extern HuiBoolean huiSendDbgInfo2Monitor();

FILE *huiTestFileOpen();
char *huiTestDreceive();
void huiTestFileClose();


static HuiText	dbgInfoBuf;

/*
 *
 */
HuiBoolean huiTestHandleDbgInfoFromAgent(hAccessInfo, fileName)
    HHuiAccessInfo	hAccessInfo;
    char		*fileName;
{
    FILE		*fd;
    char		*dbgInfo;
    HuiText		msgBuf;
    HuiErrorMsgType	eMsgType;

    if ((fd = huiTestFileOpen(fileName)) == NULL) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    while ((dbgInfo = huiTestDreceive(fd)) != NULL) {

	if (hAccessInfo->monitor.state == HuiOn) {
	    while (hAccessInfo->monitor.traceSpeed == 0) {
		if (huiReceiveMsgFromMonitor(hAccessInfo, msgBuf) == HuiFalse) {
		    huiPutsErrorMsg(HuiEMsg_ReceiveMsgFromMonitorError);
		    /*	clear buffer between UI and Monitor
		     */
		    break;
		}
		if (huiSetupTraceSpeedFromMsg(hAccessInfo, msgBuf) == HuiFalse) {
		    /*	clear buffer between UI and Monitor
		     */
		}
	    }

	    if (huiSendDbgInfo2Monitor(hAccessInfo, dbgInfo) == HuiFalse) {
		huiPutsErrorMsg(HuiEMsg_SendDbgInfo2MonitorError);
	    }
	} else {
	    huiPrintf("<< test: msg trace info >>\n%s\n", dbgInfo);
	}
    }

    huiTestFileClose(fd);

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *
 */
FILE *huiTestFileOpen(fileName)
    char	*fileName;
{
     FILE *fd;

     fd = fopen(fileName, "r");

     return fd;
}

/*
 *
 */
char *huiTestDreceive(fd)
    FILE		*fd;
{
    int			strLength;
    HuiText		tempBuf;
    HuiErrorMsgType	eMsgType;

    dbgInfoBuf[0] = '\0';
    strLength = 0;

    for (;;) {
	tempBuf[0] = '\0';

	fgets(tempBuf, HuiTextBufLen_Lim, fd);

	if (tempBuf[0] == '\0') {
	    if (strLength > 0)
	      break;

	    eMsgType = NULL;
	    goto Error_Rtn;
	}
	  
	if (tempBuf[0] == '\n') {
	    if (strLength == 0)
	      continue;
	    else
	      break;
	}

	if (tempBuf[0] == '#')
	  continue;

	strLength += strlen(tempBuf);
	if (strLength > HuiTextBufLen_Lim) {
	    eMsgType = HuiEMsg_TextLenLimitOver;
	    goto Error_Rtn;
	}

	strcat(dbgInfoBuf, tempBuf);
    }

    return dbgInfoBuf;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return NULL;
}

/*
 *
 */
void huiTestFileClose(fd)
    FILE	*fd;
{
    fclose(fd);
}
