/* huiTLevel.c;
 *	Helios User Interface;
 *		Top Level command process module
 *			created on June 9th, 1994.
 *
 *	modification history:	
 *	(1) add huiTlGui()
 *		on September 1st in '94.
 *	(2) add huiTlParaAgent()
 *		on November 11th in '94.
 *
 * $Id: huiTLevel.c,v 2.0 1995/03/02 09:24:49 k3sato Exp $
 */
#include <stdio.h>

#include <helios/SMessage.h>
#include <helios/hDaemonLib.h>
#include <helios/comm.h>
#include "helios.h"
#include "huiTLevel.h"
#include "huiAgentInfo.h"
#include "huiMessage.h"
#include "huiCommon.h"
#include "huiKeyWord.h"
#include "huiMemory.h"
#include <sys/socket.h>

/* defined in eSAConv.c of env/adm
 */
extern int eSAConvStoA();
extern SMessage eSAConvAtoS();

/* defined in huiDAccess.c
 */
extern HuiBoolean huiStartAppGui();

/* defined in huiAAccess.c
 */
extern HuiBoolean huiSetup2MsgManageInfo();
extern HuiBoolean huiSend2NewParaAgent();
extern HuiBoolean huiSendAgentTraceSwitch();

/* defined in huiCmdAnalysis.c
 */
extern HuiCmdList *tlCmdList;

/* defined in huiCommon.c
 */
extern int huiGetFuncDecl();

static HuiBoolean huiTlConnectSetup();
static HuiBoolean huiTlMTraceSetup();
static HuiBoolean huiTlATraceSetup();

static HuiBoolean huiTlHelpSetup();
static HuiBoolean huiTlGuiSetup();
static HuiBoolean huiTlParaAgentSetup();
static HuiBoolean huiTlShowFuncSetup();

/*
 *	send message to nQueen agent
 */
HuiBoolean huiTlSend(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HHuiMsgManageInfo	msgManageInfo;
    SMessage		message;
    char		*aMsg;
    int			aMsgLen;
    HuiErrorMsgType	eMsgType;
    int			ret;

    if (huiCmdEndCheck(NULL) == HuiFalse) {
	eMsgType = HuiEMsg_NotCmdTerminated;
	huiShowCmdUsage(hAccessInfo->currCmd);
	goto Error_Rtn;
    }

    msgManageInfo = hAccessInfo->msgManageInfo;

    /* S Message Object $B$r:n@.(B
     */
    message = CSMInit();

    /* Type $B$r(BASK$B$K$7$^$9!#(B
     */
    CSMTypeAsk(message);

    /* message id $B$r%;%C%H$7$^$9!#(Bmid = "0_1" etc,.
     */
    CSMPutMidStr(message, "0_1");

    /* From $B$r%;%C%H$7$^$9!#(BUSER $B$O(B "0"
     */
    CSMPutFromAidStr(message, "0");

    /* $B5!G=L>$r%;%C%H$7$^$9!#(B
     */
    CSMPutToAFStr(message, "queen_problem");

    /*$B=hM}L>$r%;%C%H$7$^$9!#(B
     */
    CSMPutToManagementStr(message, "first");

    /*TID$B$O;H$o$J$$!#(B
     */
    CSMPutTidStr(message,"");

    /* Method $B$r%;%C%H!#(B
     */    
    CSMPutMethodStr(message, "solve_queen_problem");

    /* $B%G!<%?(B $B$r%;%C%H$7$^$9!#(B
     */
    CSMPutDataStr(message, "(4)");	/* 8queen $B$N>l9g$O!"(B"(8)" */

    ret = eSAConvStoA("0", "0.1", "normal", "0", "", message, &aMsg, &aMsgLen);
    if (ret < 0) {
	eMsgType = (ret == -1)
	  ? HuiEMsg_EnvInternalError : HuiEMsg_MallocError;
	goto Error_Rtn;
    }

    if (send_a_message("0.1", aMsg, aMsgLen) < 0) {
	eMsgType = HuiEMsg_SendAMessageError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *	receive a  message to nQueen agent
 */
HuiBoolean huiTlReceive(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    int			rpc_id;
    HuiRecvBuf		aMsg;
    int			aMsgLen;
    SMessage		sMsg;
    HuiMsgManageInfo	*currInfo;
    HuiErrorMsgType	eMsgType;
    int			ret;

    if (huiCmdEndCheck(NULL) == HuiFalse) {
	eMsgType = HuiEMsg_NotCmdTerminated;
	huiShowCmdUsage(hAccessInfo->currCmd);
	goto Error_Rtn;
    }

    for (ret = 0; ret == 0;) {
	memset(aMsg, 0, HuiReceiveBufLen_Lim);
	aMsgLen = HuiReceiveBufLen_Lim;

	ret = receive_a_message(&rpc_id, &aMsg, &aMsgLen);
	if (ret < 0) {
	    eMsgType = huiCnvErrno2EMsgType(ret);
	    goto Error_Rtn;
	}

	if ((sMsg = (SMessage)eSAConvAtoS(aMsg)) == NULL) {
	    eMsgType = HuiEMsg_MallocError;
	    goto Error_Rtn;
	}

	if (huiSetup2MsgManageInfo(hAccessInfo, sMsg) == HuiFalse) {
	    eMsgType = HuiEMsg_HuiSetup2MsgManageInfoError;
	    goto Error_Rtn;
	}
    }
    
    /*  $B0z?t$N(B msgID $B$H0lCW$7$?%a%C%;!<%8$,$"$l$P!"(B
     *  $B$=$N%a%C%;!<%8$rI=<($9$k!#(B
     *  msgID $B$,(B NULL $B$J$i!"(BHuiMsgStatus_Replied $B$N(B
     *  $B%a%C%;!<%8$r$9$Y$F=PNO$7$F!"(BHuiMsgStatus_Shown $B$r%;%C%H$9$k!#(B
     */
    
    huiPrintf("msgID\t msgStatus\t ReplyMsg\n");
    huiPrintf("-----------------------------------------------------\n");
    
    for (currInfo = hAccessInfo->msgManageInfo
	 ; currInfo != NULL
	 ; currInfo = currInfo->next) {
	if (currInfo->status == HuiMsgStatus_Replied) {
	    huiPrintf("%s\t %s\t %s\n",
		      currInfo->msgID,
		      currInfo->msgStatus,
		      currInfo->replyMsg);
	}
    }
    
    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* ===================================================
 *	$B%H%C%W!&%l%Y%k$N%3%^%s%I!&%X%k%W>pJs$NI=<((B
 * =================================================== */
HuiBoolean huiTlHelp(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiWord		cmdName;
    HuiErrorMsgType	eMsgType;

    if (huiTlHelpSetup(hAccessInfo, cmdName) == HuiFalse) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    huiShowHelp(hAccessInfo, cmdName);

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * command name $B$N3MF@$H!"%3%^%s%I9T=*N;H=Dj(B
 */
static HuiBoolean huiTlHelpSetup(hAccessInfo, cmdName)
    HHuiAccessInfo	hAccessInfo;
    char		*cmdName;
{
    HuiWordType		wtype;
    HuiErrorMsgType	eMsgType;

    wtype = huiGetWord(cmdName);
    if (wtype == HuiWT_String || wtype == HuiWT_OneChar) {
	if (huiCmdEndCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotCmdTerminated;
	    goto Error_Rtn;
	}
    } else {
	if (huiCmdEndCheck(*cmdName) == HuiFalse) {
	    eMsgType = HuiEMsg_NotCmdTerminated;
	    goto Error_Rtn;
	}
	*cmdName = '\0';
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    huiShowCmdUsage(hAccessInfo->currCmd);
    return HuiFalse;
}

/* =======================================
 *   Create instance of Parametric agents
 * ======================================= */
HuiBoolean huiTlParaAgent(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiText		instanceList;
    HuiErrorMsgType	eMsgType;

    if (huiTlParaAgentSetup(hAccessInfo, instanceList) == HuiFalse) {
	eMsgType = HuiEMsg_TlParaAgentSetupError;
	goto Error_Rtn;
    }

    /* send a message HdMsg_GetParaAgent to Daemon
    if (huiGetParaAgent(hAccessInfo, parentInfo) == HuiFalse) {
	eMsgType = HuiEMsg_CreateParaAgentError;
	goto Error_Rtn;
    }
     */

    /* send a message to a new parametric agent
     */
    if (huiSend2NewParaAgent(hAccessInfo, instanceList) == HuiFalse) {
	eMsgType = HuiEMsg_Send2NewParaAgentError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *   Parametric agent name $B5Z$S!"(B
 *   Parametric instance agent name $B5Z$S!"$=$N0z?t(B
 *   $B$N3MF@$H!"%3%^%s%I9T=*N;H=Dj(B
 *
 *  para_agent <template agnet name> \
 *		<instance agent name>( [ <argument list> ] ) \
 *		[{ <instance agent name>(<argument list>) }].
 *
 *	<argument list> := <argument> [{ , <argument> }]
 *	     <argument> := <alpha-numeric> | "<string>"
 */
static HuiBoolean huiTlParaAgentSetup(hAccessInfo, instanceList)
    HHuiAccessInfo	hAccessInfo;
    char		*instanceList;
{
    int			n;
    HuiWordType		wtype;
    HuiWord		wordBuf;
    HuiSwitchState	usageFlag = HuiOn;
    HuiErrorMsgType	eMsgType;

    wtype = huiGetWord(wordBuf);
    if (wtype != HuiWT_String && wtype != HuiWT_OneChar) {
	eMsgType = HuiEMsg_NotAgentName;
	goto Error_Rtn;
    }

    if ((hAccessInfo->connectedAgent
	 = huiSearchParaAgentInfo(hAccessInfo->allAgentInfo, wordBuf))
	== NULL) {
	eMsgType = HuiEMsg_NotDefinedAgentName;
	goto Error_Rtn_NoUsage;
    }

    for (;;) {
	if ((n = huiGetFuncDecl(instanceList)) == 0) {
	    if (*instanceList != HuiChar_Period) {
		eMsgType = HuiEMsg_NotCmdTerminated;
		goto Error_Rtn;
	    }
	    break;
	}
	instanceList += n;
	*instanceList++ = HuiChar_Space;
    }

    *--instanceList = '\0';

    return HuiTrue;

 Error_Rtn_NoUsage:
    usageFlag = HuiOff;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    if (usageFlag == HuiOn) {
	huiShowCmdUsage(hAccessInfo->currCmd);
    }
    return HuiFalse;
}

/* ======================================================
 *	$B;XDj$5$l$?%(!<%8%'%s%H$X$N@\B3(B
 *
 *	$B%Q%i%a%H%j%C%/!&%(!<%8%'%s%H$X$N@\B3$K:]$7$F$O!"(B
 *	$B%$%s%9%?%s%9!&%(!<%8%'%s%H$,$"$l$P@\B3$7!"(B
 *	$BL5$1$l$P@8@.$7$F$+$i(B connect $B$9$k$h$&%a%C%;!<%8$r(B
 *	$B=PNO$9$k(B
 * ====================================================== */
HuiBoolean huiTlConnect(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
#ifdef _DEBUG_HELIOS_UI
    HAgentInfo		paraAgent;

    int			sock;
    struct sockaddr_in	*sockAddr;
#endif

    HuiErrorMsgType	eMsgType;

    /*
    if (((paraAgent = hAccessInfo->connectedAgent) != NULL) &&
	paraAgent->type != HdAT_Parametric) {
	eMsgType = HuiEMsg_ParaAgentNotNormal;
	goto Error_Rtn;
    }
    */

    if (huiTlConnectSetup(hAccessInfo) == HuiFalse) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    if ((hAccessInfo->sockAddr = get_agent(hAccessInfo->agentId)) == NULL) {
	eMsgType = HuiEMsg_GetAgentError;
	goto Error_Rtn;
    }

#ifdef _DEBUG_HELIOS_UI

    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	eMsgType = HuiEMsg_Socket2AgentFailed;
	goto Error_Rtn;
    }

    sockAddr = hAccessInfo->sockAddr;

    if (connect(sock, sockAddr, sizeof(*sockAddr)) == ERROR_FLAG) {
	eMsgType = HuiEMsg_CouldNotConnect;
	goto Error_Rtn;
    }

    hAccessInfo->sock = sock;

#endif /* _DEBUG_HELIOS_UI */

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * agent name $B$N3MF@$H!"%3%^%s%I9T=*N;H=Dj(B
 */
static HuiBoolean huiTlConnectSetup(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HAgentInfo		hAgentInfo;
    HuiWordType		wtype;
    HuiWord		wordBuf;
    HuiSwitchState	usageFlag = HuiOn;
    HuiErrorMsgType	eMsgType;

    wtype = huiGetWord(wordBuf);
    if (wtype == HuiWT_String || wtype == HuiWT_OneChar) {
	if (huiCmdEndCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotCmdTerminated;
	    goto Error_Rtn;
	}
    } else {
	eMsgType = HuiEMsg_NotAgentName;
	goto Error_Rtn;
    }

    HuiFreeString(&(hAccessInfo->agentName));
    HuiFreeString(&(hAccessInfo->agentId));

    if ((hAccessInfo->agentName = HuiMallocString(wordBuf)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocStringError;
	goto Error_Rtn_NoUsage;
    }

    if ((hAgentInfo = huiSearchAgentInfo(hAccessInfo->allAgentInfo, wordBuf))
	== NULL) {
	eMsgType = HuiEMsg_NotDefinedAgentName;
	goto Error_Rtn_NoUsage;
    }

    hAccessInfo->connectedAgent = hAgentInfo;

    if ((hAccessInfo->agentId = HuiMallocString(hAgentInfo->agentId)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocStringError;
	goto Error_Rtn_NoUsage;
    }

    return HuiTrue;

 Error_Rtn_NoUsage:
    usageFlag = HuiOff;
    HuiFreeString(&(hAccessInfo->agentName));
    HuiFreeString(&(hAccessInfo->agentId));

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    if (usageFlag == HuiOn) {
	huiShowCmdUsage(hAccessInfo->currCmd);
    }
    return HuiFalse;
}

/* ===========================================
 *	$B%H%C%W!&%l%Y%k$+$i$N(B
 *	$B%X%j%*%9!&%f!<%6%$%s%?%U%'!<%9$N=*N;(B
 * =========================================== */
HuiBoolean huiTlBye(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiErrorMsgType	eMsgType;

    if (huiCmdEndCheck(NULL) == HuiFalse) {
	eMsgType = HuiEMsg_NotCmdTerminated;
	huiShowCmdUsage(hAccessInfo);
	goto Error_Rtn;
    }

    if (huiQuitMonitor(hAccessInfo) == HuiFalse) {
	eMsgType = HuiEMsg_QuitMonitorError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* ===================================================
 * $B%a%C%;!<%8!&%H%l!<%9!&%U%i%0$N@_Dj!?2r=|(B
 * =================================================== */
HuiBoolean huiTlMTrace(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiErrorMsgType	eMsgType;

    if (huiTlMTraceSetup(hAccessInfo) == HuiFalse) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * ON/OFF $B%U%i%0$N3MF@$H!"%3%^%s%I9T=*N;H=Dj(B
 */
static HuiBoolean huiTlMTraceSetup(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiKeyWordType 	kwType;
    HuiErrorMsgType	eMsgType;


    kwType = huiGetKeyWord(HuiOnOffKeyWordList);

    switch (kwType) {
    case HuiKW_On:
    case HuiKW_Off:
	if (huiCmdEndCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotCmdTerminated;
	    goto Error_Rtn;
	}

	hAccessInfo->traceInfo.allMsgTrace = (HuiKW_On) ? HuiOn : HuiOff;
	break;
    case HuiKW_NotUsed:
	eMsgType = HuiEMsg_NotOnOffSwitch;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    huiShowCmdUsage(hAccessInfo->currCmd);
    return HuiFalse;
}

/* ======================================
 *	$B%(!<%8%'%s%H!&%H%l!<%9(B
 * ====================================== */
HuiBoolean huiTlATrace(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiWord		wordBuf;
    HuiSwitchState	switchState;
    HHuiTraceSwitch	traceSwitch;
    HuiErrorMsgType	eMsgType;

    if (huiTlATraceSetup(hAccessInfo, wordBuf, &switchState) == HuiFalse) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    /* check agent trace switch for the agent name
     */
    if ((traceSwitch = huiSetupATraceSwitch(hAccessInfo, wordBuf, switchState))
	== NULL) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    /* send control message to the agent
     */
    if (huiSendAgentTraceSwitch(hAccessInfo, traceSwitch) == HuiFalse) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * agent name$B!"5Z$S(B ON/OFF $B%U%i%0$N3MF@$H!"(B
 * $B%3%^%s%I9T=*N;H=Dj(B
 */
static HuiBoolean huiTlATraceSetup(hAccessInfo, agentName, switchState)
    HHuiAccessInfo	hAccessInfo;
    char		*agentName;
    HuiSwitchState	*switchState;
{
    HuiWordType		wtype;
    HuiKeyWordType 	kwType;
    HuiErrorMsgType	eMsgType;

    wtype = huiGetWord(agentName);
    if (wtype != HuiWT_String && wtype != HuiWT_OneChar) {
	eMsgType = HuiEMsg_NotAgentName;
	goto Error_Rtn;
    }

    if (huiCommaCheck(NULL) == HuiFalse) {
	eMsgType = HuiEMsg_NotExistComma;
	goto Error_Rtn;
    }

    kwType = huiGetKeyWord(HuiOnOffKeyWordList);

    switch (kwType) {
    case HuiKW_On:
    case HuiKW_Off:
	if (huiCmdEndCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotCmdTerminated;
	    goto Error_Rtn;
	}

	*switchState = (kwType == HuiKW_On) ? HuiOn : HuiOff;
	break;
    case HuiKW_NotUsed:
	eMsgType = HuiEMsg_NotOnOffSwitch;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    huiShowCmdUsage(hAccessInfo->currCmd);
    return HuiFalse;
}

/* =======================================
 *   $B;XDj$5$l$?%(!<%8%'%s%H$N(B GUI $B$N5/F0(B
 * ======================================= */
HuiBoolean huiTlGui(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiErrorMsgType	eMsgType;

    if (huiTlGuiSetup(hAccessInfo) == HuiFalse) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    if (huiStartAppGui(hAccessInfo->agentName) == HuiFalse) {
	eMsgType = HuiEMsg_StartAppGuiError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * agent name $B$N3MF@$H!"%3%^%s%I9T=*N;H=Dj(B
 */
static HuiBoolean huiTlGuiSetup(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiWordType		wtype;
    HuiWord		wordBuf;
    HuiSwitchState	usageFlag = HuiOn;
    HuiErrorMsgType	eMsgType;

    wtype = huiGetWord(wordBuf);
    if (wtype == HuiWT_String || wtype == HuiWT_OneChar) {
	if (huiCmdEndCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotCmdTerminated;
	    goto Error_Rtn;
	}
    } else {
	eMsgType = HuiEMsg_NotAgentName;
	goto Error_Rtn;
    }

    HuiFreeString(&(hAccessInfo->agentName));

    if ((hAccessInfo->agentName = HuiMallocString(wordBuf)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocStringError;
	goto Error_Rtn_NoUsage;
    }

    return HuiTrue;

 Error_Rtn_NoUsage:
    usageFlag = HuiOff;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    if (usageFlag == HuiOn) {
	huiShowCmdUsage(hAccessInfo->currCmd);
    }
    return HuiFalse;
}

static char *HeaderOfShowAllAgents = "\n  Agent ID\t Agent Name\n";

/* ======================================
 *  Show all names of agent viewed from user
 * ====================================== */
HuiBoolean huiTlShowAllAgents(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HAgentInfo		info;
    HuiErrorMsgType	eMsgType;

    if (huiCmdEndCheck(NULL) == HuiFalse) {
	eMsgType = HuiEMsg_NotCmdTerminated;
	huiShowCmdUsage(hAccessInfo);
	goto Error_Rtn;
    }

    huiPrintf(HeaderOfShowAllAgents);
    huiPutsLine(40, HuiChar_EqualCode);

    for (info = hAccessInfo->allAgentInfo; info != NULL; info = info->next) {
	huiPrintf(" %-18.18s\t%s\n", info->agentId, info->agentName);
    }

    huiPutsLine(40, HuiChar_NULL);

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* ======================================
 *
 * ====================================== */
/*
HuiBoolean huiTlShowActiveAgents(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{

    return HuiTrue;

 Error_Rtn:
    return HuiFalse;
}
*/

/* ===========================================
 *  Show function name of agent given by user
 * =========================================== */
HuiBoolean huiTlShowFunctions(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HAgentInfo		agentInfo;
    HuiErrorMsgType	eMsgType;

    if (huiTlShowFuncSetup(hAccessInfo, &agentInfo) == HuiFalse) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    huiPutsFuncDir(agentInfo->funcDir);

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * agent name $B$N3MF@$H!"%3%^%s%I9T=*N;H=Dj(B
 */
static HuiBoolean huiTlShowFuncSetup(hAccessInfo, agentInfoP)
    HHuiAccessInfo	hAccessInfo;
    HAgentInfo		*agentInfoP;
{
    HuiWord		wordBuf;
    HuiWordType		wtype;
    HuiSwitchState	usageFlag = HuiOn;
    HuiErrorMsgType	eMsgType;

    wtype = huiGetWord(wordBuf);
    if (wtype == HuiWT_String || wtype == HuiWT_OneChar) {
	if (huiCmdEndCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotCmdTerminated;
	    goto Error_Rtn;
	}
    } else {
	eMsgType = HuiEMsg_NotAgentName;
	goto Error_Rtn;
    }

    if ((*agentInfoP = huiSearchAgentInfo(hAccessInfo->allAgentInfo, wordBuf))
	== NULL) {
	eMsgType = HuiEMsg_NotDefinedAgentName;
	goto Error_Rtn_NoUsage;
    }

    return HuiTrue;

 Error_Rtn_NoUsage:
    usageFlag = HuiOff;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    if (usageFlag == HuiOn) {
	huiShowCmdUsage(hAccessInfo->currCmd);
    }
    return HuiFalse;
}

/* ======================================
 *  Show method of agent given by user
 * ====================================== */
HuiBoolean huiTlShowMethods(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HAgentInfo		agentInfo;
    HuiErrorMsgType	eMsgType;

    if (huiTlShowFuncSetup(hAccessInfo, &agentInfo) == HuiFalse) {
	eMsgType = NULL;
	goto Error_Rtn;
    }

    huiPutsMethodDir(agentInfo->methodDir);

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* ======================================
 *
 * ====================================== */
/*
HuiBoolean huiTlShowStructure(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{

    return HuiTrue;

 Error_Rtn:
    return HuiFalse;
}
*/

/* ======================================
 *
 * ====================================== */
/*
HuiBoolean huiTlShowLocation(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{

    return HuiTrue;

 Error_Rtn:
    return HuiFalse;
}
*/

/* ======================================
 *
 * ====================================== */
/*
HuiBoolean huiTlShowStatus(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{

    return HuiTrue;

 Error_Rtn:
    return HuiFalse;
}
*/
