/* huiMsgManage.c;
 *	Message Manage module for Helios User Interface;
 *		created on June 9th, 1994.
 *
 *	modification history:	
 *	(1) add huiGetReplyHmsg()
 *		on October 28th in '94.
 *
 * $Id: huiMsgManage.c,v 1.11 1995/03/02 09:25:11 k3sato Exp $
 */

#include <stdio.h>

#include <helios/SMessage.h>
#include "helios.h"
#include "huiMessage.h"
#include "huiCommon.h"
#include "huiKeyWord.h"
#include "huiMemory.h"

/* defined in huiAAccess.c
 */
extern HuiBoolean huiMsgReceiveFromAgent();

HuiBoolean huiGetToField();
HuiBoolean huiGetMsgField();
HuiMsgManageInfo *huiSearchMsgInfoForMsgId();
void huiPutsMsgManageInfo();

/* ================================================================
 * Get Helios send message from command line 
 *
 *  syntax:
 *	<Helios send message> ::= [ to = <To> ,] msg = <message>
 *
 *	<To> ::= <function name>
 *	       | { <function name>, <process name> } |
 *	       | <function name> : <method name>     |
 *
 *	<message> ::= <method name>(<argument>-list(,))
 * ================================================================ */
HuiBoolean huiGetHMessage(hAccessInfo, hMsgManageInfo)
    HHuiAccessInfo	hAccessInfo;
    HHuiMsgManageInfo	*hMsgManageInfo;
{
    HuiMsgManageInfo	msgManageInfo;
    HuiWord		msgID;
    HuiKeyWordType	kwType;
    HuiErrorMsgType	eMsgType;


    memset(&msgManageInfo, 0, sizeof(HuiMsgManageInfo));

    kwType = huiGetKeyWord(HuiSendKeyWordList);
    if (kwType == HuiKW_To) {

	kwType = huiGetKeyWord(HuiSendKeyWordList);
	if (kwType != HuiKW_Equal) {
	    eMsgType = HuiEMsg_NotKeyWordEqual;
	    goto Error_Rtn;
	}

	if (huiGetToField(&msgManageInfo) != HuiTrue) {
	    eMsgType = HuiEMsg_ErrorInToField;
	    goto Error_Rtn;
	}

	kwType = huiGetKeyWord(HuiSendKeyWordList);
    }

    if (kwType != HuiKW_Msg) {
	eMsgType = HuiEMsg_NotExistMsgKeyWord;
	goto Error_Rtn;
    }

    kwType = huiGetKeyWord(HuiSendKeyWordList);
    if (kwType != HuiKW_Equal) {
	eMsgType = HuiEMsg_NotKeyWordEqual;
	goto Error_Rtn;
    }

    /* get <Msg> field and check command end.
     */
    if (huiGetMsgField(&msgManageInfo) != HuiTrue) {
	eMsgType = HuiEMsg_ErrorInMsgField;
	goto Error_Rtn;
    }

    /* set msgManageInfo.msgID
     * $B%f!<%6!&%$%s%?%U%'!<%9#I#D(B + ".0_" + $BDL$7HV9f(B
     */
    sprintf(msgID, "%s.0_%d", hAccessInfo->userInfo->agentId, ++(hAccessInfo->currMsgId));
    if ((msgManageInfo.msgID = HuiMallocString(msgID)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocStringError;
	goto Error_Rtn;
    }

    if ((*hMsgManageInfo = (HuiMsgManageInfo *)HuiMalloc(sizeof(HuiMsgManageInfo)))
	== NULL) {
	eMsgType = HuiEMsg_HuiMallocError;
	goto Error_Rtn;
    }

    memcpy(*hMsgManageInfo, &msgManageInfo, sizeof(HuiMsgManageInfo));

    return HuiTrue;

 Error_Rtn:
    HuiFreeString(&(msgManageInfo.funcName));
    HuiFreeString(&(msgManageInfo.processName));
    HuiFreeString(&(msgManageInfo.method));
    HuiFreeString(&(msgManageInfo.methodArg));
    HuiFreeString(&(msgManageInfo.msgID));

    huiPutsErrorMsg(eMsgType);
    /*
    huiShowCmdUsage(hAccessInfo->currCmd);
    */
    return HuiFalse;
}

/*
 *	get <To> field and comma from command line
 *
 *	<To> ::= <function name>
 *	       | { <function name>, <process name> } |
 *	       | <function name> : <method name>     |
 */
HuiBoolean huiGetToField(hMsgManageInfo)
    HHuiMsgManageInfo	hMsgManageInfo;
{
    HuiWord		wordBuf;
    int			ch;
    int			charNum, nameNum;
    HuiSwitchState	braceFlag, commaFlag, colonFlag;
    HuiSwitchState	processNameFlag;
    char		*processName;
    HuiErrorMsgType	eMsgType;

    
    braceFlag = commaFlag = colonFlag = processNameFlag = HuiOff;

    huiSkipCrSpace();

    if ((ch = huiGetChar()) == HuiChar_LeftBrace) {
	braceFlag = HuiOn;
	ch = huiGetChar();
    }

    for (charNum = nameNum = 0;;) {
	switch(ch) {
	case EOF:
	    clearerr(stdin);
	    eMsgType = HuiEMsg_GetEndOfFile;
	    goto Error_Rtn;

	case HuiChar_Comma:
	    if (braceFlag == HuiOn) {
		if (commaFlag == HuiOn) {
		    eMsgType = HuiEMsg_TwoCommasInToField;
		    goto Error_Rtn;
		}
		if (nameNum == 0) {
		    eMsgType = HuiEMsg_NoFunctionName;
		    goto Error_Rtn;
		}
		commaFlag = HuiOn;
		processNameFlag = HuiOn;
		wordBuf[charNum++] = '\0';
		processName = &wordBuf[charNum];
		huiSkipCrSpace();
		nameNum = 0;
	    } else {
		if (nameNum == 0) {
		    eMsgType = (colonFlag == HuiOn)
		      ? HuiEMsg_NoMethodNameInTo : HuiEMsg_NoFunctionName;
		    goto Error_Rtn;
		}
		goto Set2MsgManageInfo;
	    }
	    break;

	case HuiChar_Colon:
	    if (braceFlag == HuiOn) {
		eMsgType = HuiEMsg_ColonInBraces;
		goto Error_Rtn;
	    }

	    if (colonFlag == HuiOn) {
		eMsgType = HuiEMsg_TwoColonsInToField;
		goto Error_Rtn;
	    }

	    if (nameNum == 0) {
		eMsgType = HuiEMsg_NoFunctionName;
		goto Error_Rtn;
	    }
	    colonFlag = HuiOn;
	    wordBuf[charNum++] = ch;
	    huiSkipCrSpace();
	    nameNum = 0;

	    break;

	case HuiChar_RightBrace:
	    if (braceFlag != HuiOn) {
		eMsgType = HuiEMsg_NoLeftBraceInToField;
		goto Error_Rtn;
	    }
	    if (commaFlag != HuiOn) {
		eMsgType = HuiEMsg_NoProcessName;
		goto Error_Rtn;
	    }
	    if (nameNum == 0) {
		eMsgType = HuiEMsg_NoProcessName;
		goto Error_Rtn;
	    }
	    /* right brace $B$O!"=hM}L>$K4^$a$J$$(B
	    wordBuf[charNum++] = ch;
	    */
	    goto CommaCheck;

	case HuiChar_Space:
	    if (colonFlag == HuiOn) {
		if (nameNum > 0) {
		    goto CommaCheck;
		} else {
		    eMsgType = HuiEMsg_StrangeState;
		    goto Error_Rtn;
		}
	    }
	    if (commaFlag == HuiOn || braceFlag == HuiOn) {
		break;
	    }
	    if (nameNum == 0) {
		eMsgType = HuiEMsg_StrangeState;
		goto Error_Rtn;
	    }

	    goto CommaCheck;

	default:
	    if (huiDelimitCheck(ch) == HuiFalse) {
		wordBuf[charNum++] = ch;
		nameNum++;
	    } else {
		eMsgType = HuiEMsg_StrangeState;
		goto Error_Rtn;
	    }
	}
	ch = huiGetChar();
    }

 CommaCheck:

    if (huiCommaCheck(NULL) == HuiFalse) {
	eMsgType = HuiEMsg_NotExistComma;
	goto Error_Rtn;
    }

 Set2MsgManageInfo:

    wordBuf[charNum] = '\0';

    if ((hMsgManageInfo->funcName = HuiMallocString(wordBuf)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocStringError;
	goto Error_Rtn;
    }

    if (processNameFlag == HuiOn) {
	if ((hMsgManageInfo->processName = HuiMallocString(processName)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    HuiFreeString(&(hMsgManageInfo->funcName));
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *	get <Msg> field from command line
 *
 *	<message> ::= <method name>(<argument>-list(,))
 */
HuiBoolean huiGetMsgField(msgManageInfo)
    HHuiMsgManageInfo	msgManageInfo;
{
    HuiText		textBuf;
    int			ch;
    int			charNum, nameNum;
    int			parenLevel;
    HuiSwitchState	argFlag;
    char		*arg;
    HuiErrorMsgType	eMsgType;

    
    huiSkipCrSpace();

    for (charNum = nameNum = parenLevel = 0;;) {
	ch = huiGetChar();
	switch(ch) {
	case EOF:
	    clearerr(stdin);
	    eMsgType = HuiEMsg_GetEndOfFile;
	    goto Error_Rtn;

	case HuiChar_LeftParen:
	    if (parenLevel == 0) {
		if (nameNum == 0) {
		    eMsgType = HuiEMsg_NoMethodNameInMsg;
		    goto Error_Rtn;
		}
		argFlag = HuiOn;
		textBuf[charNum++] = '\0';
		arg = &textBuf[charNum];
	    }
	    parenLevel++;
	    textBuf[charNum++] = ch;
	    nameNum = 1;
	    break;

	case HuiChar_RightParen:
	    if (parenLevel == 0) {
		eMsgType = HuiEMsg_NoLeftParenInMsg;
		goto Error_Rtn;
	    }
	    textBuf[charNum++] = ch;

	    parenLevel--;
	    if (parenLevel == 0) {
		goto CmdEndCheck;
	    }
	    break;

	default:
	    textBuf[charNum++] = ch;
	    if (++nameNum >= HuiTextBufLen_Lim) {
		eMsgType = HuiEMsg_TextLenLimitOver;
		goto Error_Rtn;
	    }
	}
    }

 CmdEndCheck:

    if (huiCmdEndCheck(NULL) == HuiFalse) {
	eMsgType = eMsgType = HuiEMsg_NotCmdTerminated;
	goto Error_Rtn;
    }

 Set2MsgManageInfo:

    textBuf[charNum] = '\0';

    if ((msgManageInfo->method = HuiMallocString(textBuf)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocStringError;
	goto Error_Rtn;
    }

    if (argFlag == HuiOn) {
	if ((msgManageInfo->methodArg = HuiMallocString(arg)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    HuiFreeString(&(msgManageInfo->method));
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* ================================================================
 * Get reply Helios message from command line 
 *
 *  syntax:
 *	<Helios reply message> ::=
 *		[mid = <message ID>,] [status = <message status>,] msg = <message>
 *
 *	<message ID> ::= <userId>.<agent_id>_<integer>
 *	<userId> ::= <machine name>_<integer>
 *	<agentId> ::= <integer>[{.<interger>}]
 *
 *	<message status> ::= <string>	## (ex. "normal", "error")
 *	<message> ::= <text> | "<text>"
 * ================================================================ */
HuiBoolean huiGetReplyHMsg(hAccessInfo, hMsgManageInfo)
    HHuiAccessInfo	hAccessInfo;
    HHuiMsgManageInfo	*hMsgManageInfo;
{
    HuiMsgManageInfo	*askMsgInfo = NULL;
    HuiWord		msgID;
    HuiWord		status;
    HuiText		replyMsg;
    HuiKeyWordType	kwType;
    HuiErrorMsgType	eMsgType;


    /* << Get message Id >>
     */
    if ((kwType = huiGetKeyWord(HuiReplyKeyWordList)) == HuiKW_MsgId) {
	if ((kwType = huiGetKeyWord(HuiReplyKeyWordList)) != HuiKW_Equal) {
	    eMsgType = HuiEMsg_NotKeyWordEqual;
	    goto Error_Rtn;
	}

	/* Get message Id from command line
	 */
	if (huiGetMsgId(hAccessInfo, msgID) != HuiTrue) {
	    eMsgType = HuiEMsg_GetMsgIdError;
	    goto Error_Rtn;
	}

	/* Get MsgManageInfo for msgId
	 */
	if ((askMsgInfo =
	     huiSearchMsgInfoForMsgId(hAccessInfo->msgManageInfo, msgID))
	    == NULL) {
	    eMsgType = HuiEMsg_SearchMsgInfoForMsgIdError;
	    goto Error_Rtn;
	}

	if (askMsgInfo->status != HuiMsgStatus_Asked) {
	    eMsgType = HuiEMsg_NotExistAskedMessageForMsgId;
	    goto Error_Rtn;
	}

	if (huiCommaCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotExistComma;
	    goto Error_Rtn;
	}

	kwType = huiGetKeyWord(HuiReplyKeyWordList);

    } else {
	/* Set current msgId
	 */
	if ((askMsgInfo = hAccessInfo->currAskMsgInfo) == NULL) {
	    eMsgType = HuiEMsg_NotExistCurrentAskedMessage;
	    goto Error_Rtn;
	}
    }

    /*	<< Get message status >>
     */
    if (kwType == HuiKW_MsgStatus) {
	if ((kwType = huiGetKeyWord(HuiReplyKeyWordList)) != HuiKW_Equal) {
	    eMsgType = HuiEMsg_NotKeyWordEqual;
	    goto Error_Rtn;
	}

	/* Get <Status> field from command line
	 */
	if (huiGetMsgStatus(hAccessInfo, status) != HuiTrue) {
	    eMsgType = HuiEMsg_GetMsgStatusError;
	    goto Error_Rtn;
	}

	if ((askMsgInfo->msgStatus = HuiMallocString(status)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}

	if (huiCommaCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotExistComma;
	    goto Error_Rtn;
	}

	kwType = huiGetKeyWord(HuiReplyKeyWordList);

    } else {
	if ((askMsgInfo->msgStatus = HuiMallocString("normal")) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}
    }

    /*	<< Get message >>
     */
    if (kwType == HuiKW_Msg) {
	if ((kwType = huiGetKeyWord(HuiReplyKeyWordList)) != HuiKW_Equal) {
	    eMsgType = HuiEMsg_NotKeyWordEqual;
	    goto Error_Rtn;
	}

	/* get <Msg> field and check command end.
	 */
	if (huiGetText(replyMsg) == 0) {
	    eMsgType = HuiEMsg_NoReplyMsg;
	    goto Error_Rtn;
	}
	if (huiCmdEndCheck(NULL) == HuiFalse) {
	    eMsgType = HuiEMsg_NotCmdTerminated;
	    goto Error_Rtn;
	}

	if ((askMsgInfo->replyMsg = HuiMallocString(replyMsg)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}
    } else {
	eMsgType = HuiEMsg_NotExistMsgKeyWord;
	goto Error_Rtn;
    }

    *hMsgManageInfo = askMsgInfo;

    return HuiTrue;

 Error_Rtn:
    if (askMsgInfo != NULL) {
	HuiFreeString(&(askMsgInfo->msgStatus));
	HuiFreeString(&(askMsgInfo->replyMsg));
    }
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* =========================================================
 *	Append msgManageInfo to hAccessInfo->msgManageInfo
 * ========================================================= */
HuiBoolean huiAppendMsgManageInfo(hAccessInfo, msgManageInfo)
    HHuiAccessInfo	hAccessInfo;
    HHuiMsgManageInfo	msgManageInfo;
{
    HHuiMsgManageInfo	*currInfo;
    HuiErrorMsgType	eMsgType;

    for (currInfo = &(hAccessInfo->msgManageInfo)
	 ; *currInfo != NULL
	 ; currInfo = &((*currInfo)->next))
      ;

    *currInfo = msgManageInfo;

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* ==============================================
 * $BAw$C$?%a%C%;!<%8$N%a%C%;!<%8#I#D$r2hLL$KI=<((B
 * ============================================== */
HuiBoolean huiShowMsgId(hAccessInfo, msgManageInfo)
    HuiAccessInfo	*hAccessInfo;
    HHuiMsgManageInfo	msgManageInfo;
{
    huiPrintf("send message ID : %s\n", msgManageInfo->msgID);

    return HuiTrue;
}

/* ================================================
 * $B%(!<%8%'%s%H$+$i<u$1<h$C$?%a%C%;!<%8$rI=<($9$k(B
 * ================================================ */
HuiBoolean huiShowReceivedMsg(hAccessInfo, msgID)
    HHuiAccessInfo	hAccessInfo;
    char		*msgID;
{
    int			i;
    HuiMsgManageInfo	*currInfo, *latestInfo;
    HuiErrorMsgType	eMsgType;

    /*
     * $B%(!<%8%'%s%H$+$i$N%a%C%;!<%8$r<u$1<h$k!#(B
     */
    if (huiMsgReceiveFromAgent(hAccessInfo) == HuiFalse) {
	eMsgType = HuiEMsg_HuiMsgReceiveFromAgentError;
	goto Error_Rtn;
    }
    
    /*  $B0z?t$N(B msgID $B$H0lCW$7$?%a%C%;!<%8$,$"$l$P!"(B
     *  $B$=$N%a%C%;!<%8$rI=<($9$k!#(B
     *  msgID $B$,(B NULL $B$J$i!"(BHuiMsgStatus_Replied $B$N(B
     *  $B%a%C%;!<%8$r$9$Y$F=PNO$7$F!"(BHuiMsgStatus_Shown $B$r%;%C%H$9$k!#(B
     */
    
    huiPutsStr("msgID\t\t msgStatus\t ReplyMsg\n");
    for (i = 0; i < 70; i++) huiPutsStr("-"); huiPutsStr("\n");
    
    if (msgID[0] == '\0') {
	for (currInfo = hAccessInfo->msgManageInfo, latestInfo = NULL
	     ; currInfo != NULL
	     ; currInfo = currInfo->next) {
	    if (currInfo->status == HuiMsgStatus_Replied) {
		latestInfo = currInfo;
	    }
	}
	if (latestInfo != NULL) {
	    huiPutsMsgManageInfo(latestInfo);
	}
    } else if (huiJudgeKeyWord(HuiAllKeyWordList, msgID) == HuiTrue) {
	for (currInfo = hAccessInfo->msgManageInfo
	     ; currInfo != NULL
	     ; currInfo = currInfo->next) {
	    if (currInfo->status == HuiMsgStatus_Replied) {
		huiPutsMsgManageInfo(currInfo);
	    }
	}
    } else {
	if ((currInfo = huiSearchMsgInfoForMsgId(hAccessInfo->msgManageInfo, msgID))
	    != NULL) {
	    huiPutsMsgManageInfo(currInfo);
	} else {
	    eMsgType = HuiEMsg_SearchMsgInfoForMsgIdError;
	    goto Error_Rtn;
	}
    }
    
    return HuiTrue;
    
 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* ================================================
 * msgId $B$KBP1~$9$k(B HuiMsgManageInfo $B$r8!:w$7!"(B
 * $B$=$N%]%$%s%?!<$rJV$9(B
 * ================================================ */
HuiMsgManageInfo *huiSearchMsgInfoForMsgId(msgManageInfo, msgID)
    HuiMsgManageInfo	*msgManageInfo;
    char		*msgID;
{
    for (; msgManageInfo != NULL
	 ; msgManageInfo = msgManageInfo->next) {
	if (strcmp(msgManageInfo->msgID, msgID) == 0) {
	    return msgManageInfo;
	}
    }

    return NULL;
}

void huiPutsMsgManageInfo(msgManageInfo)
    HuiMsgManageInfo	*msgManageInfo;
{
    huiPrintf("%s\t %s\t %s\n",
	      msgManageInfo->msgID,
	      msgManageInfo->msgStatus,
	      msgManageInfo->replyMsg);
}
