# huiMonitor.tcl
#
#	modification history:	
#	(1) add scale widget '.waku.speed'
#		on November 2nd in '94.
#	(2) add button widget '.waku.modelSelect'
#	    and add one canvas for process model	
#		on November 7th in '94.
#	(3) add two procedures; huiMkAgentPArea, huiMkAgentNameArea
#		on November 24th in '94.
#	(4) add one procedure; huiMkMachArea
#		on November 28th in '94.
#	(5) modified mkAgentBranch and mkAgentLeaf
#	    and add one procedure; huiDialogCheck
#		on December 13th in '94.
#
# $Id: huiMonitor.tcl,v 1.14 1995/03/07 12:15:42 k3sato Exp $

proc addc {{num 0}} {
    format "%fc" $num
}

proc addm {{num 0}} {
    format "%fm" $num
}

proc dpos w {
    wm geometry $w +200+10
}

#
#  model selection command
#
proc huiModelSelect {w} {
    global canvasFr
    global lCanvas pCanvas

    set label [lindex [$w configure -text] 4]

    if { $label == "Process" } {
	$w configure -text "Logical"
	${canvasFr}.vscroll configure -command "$pCanvas yview"
	${canvasFr}.hscroll configure -command "$pCanvas xview"

	pack forget $lCanvas
	pack $pCanvas -expand yes -fill both -padx 4 -pady 4

    } else {
	$w configure -text "Process"
	${canvasFr}.vscroll configure -command "$lCanvas yview"
	${canvasFr}.hscroll configure -command "$lCanvas xview"

	pack forget $pCanvas
	pack $lCanvas -expand yes -fill both -padx 4 -pady 4
    }
}

# make the dialog of Check to modify the attribute of line
#
proc mkDialogCheck {{edge 0} {okCmd mkResetBranch} {x 0} {y 0}} {
    global font1 font2 font3 fontTimes24

    # Set up warning dialog

    frame .warningInfo -relief raised -bd 2

    set w .warningInfo 

    catch {destroy $w}
    toplevel $w -class Dialog

    wm geometry $w +$x+$y
    wm title $w "Warning Dialog"
    wm iconname $w "Warning"
    wm minsize $w 1 1

    frame $w.top -relief ridge -border 6
    frame $w.bot -relief sunken -border 4

    # Create the Warning label and two buttons of 'OK' and 'Cancel'
    #

    label $w.top.label -bitmap warning
    message $w.top.msg -width 5c -font $fontTimes24 \
	    -text " Reset the line ? "

    button $w.bot.ok -text Ok -command "$okCmd $w $edge" \
	-width 7 -bd 4 -font $fontTimes24
    button $w.bot.cancel -text Cancel -command "destroy $w" \
	-width 7 -bd 4 -font $fontTimes24

    pack $w.top -side top -fill x -expand yes
    pack $w.bot -side bottom -fill x -expand yes

    pack $w.top.label $w.top.msg -side left  -padx 3 -pady 3 -expand yes -fill x
    pack $w.bot.ok $w.bot.cancel -side left -expand yes

    tkwait visibility $w
    grab $w
    tkwait window $w
}

proc mkResetBranch {{w .dialog} {edge 0}} {
    global lCanvas
    global WaitMsgColor

    $lCanvas itemconfig $edge -fill $WaitMsgColor -arrow none
    $lCanvas lower $edge

    destroy $w
}

proc mkResetLeaf {{w .dialog} {fd 0}} {
    global lCanvas
    global WaitMsgColor

    $lCanvas itemconfig $fd -outline $WaitMsgColor

    destroy $w
}

# make the dialog of agent information
#
proc mkAgentInfo {{w .info} {name dummy}} {
    global font1 font2 font3 fontTimes34

    global agentDgInfo

    catch {destroy $w}
    toplevel $w -class Dialog
    dpos $w
    wm title $w $name
    wm iconname $w $name
    wm minsize $w 1 1

    # Create two frames in the main window. The top frame will hold the
    # message and the bottom one will hold the buttons.  Arrange them
    # one above the other, with any extra vertical space split between
    # them.

    frame $w.top -relief raised -border 1
    frame $w.bot -relief raised -border 1
    pack $w.top -side top -fill both -expand yes
    pack $w.bot -side bottom -fill y -expand yes

    # Create the message widget and arrange for it to be centered in the
    # top frame.

    message $w.top.msg -width 400 -font $fontTimes34 \
	    -text "\ \ \ \ << Agent Info >>"

    pack $w.top.msg -side top -expand yes -padx 3 -pady 3

    button $w.bot.ok -text OK -command "destroy $w" -font $font3
    pack $w.bot.ok -side bottom -fill x -expand yes

    scrollbar $w.bot.yscroll -relief sunken -command "$w.bot.list yview"
    scrollbar $w.bot.xscroll -relief sunken -orient horizontal \
	    -command "$w.bot.list xview"
    listbox $w.bot.list -geometry 55x14 -yscroll "$w.bot.yscroll set" \
		-xscroll "$w.bot.xscroll set" -relief sunken -setgrid 1 -font $fontTimes34

    pack $w.bot.yscroll -side right -fill y -expand yes

    pack $w.bot.xscroll -side bottom -fill x -expand yes

    pack $w.bot.list -expand yes -fill y

    $w.bot.list delete 0 end

    eval $w.bot.list insert 0 $agentDgInfo

    tkwait visibility $w
    grab $w
    tkwait window $w
}

# make the dialog of message trace information 
#
proc mkMsgTraceInfo {{w .info}} {
    global font1 font2 font3 fontTimes24 fontTimes34

    global msgTraceDgInfo

    catch {destroy $w}
    toplevel $w -class Dialog
    dpos $w
    wm title $w "Message Trace Info"
    wm iconname $w "MTraceInfo"
    wm minsize $w 1 1

    # Create two frames in the main window. The top frame will hold the
    # message and the bottom one will hold the buttons.  Arrange them
    # one above the other, with any extra vertical space split between
    # them.

    frame $w.top -relief raised -border 1
    frame $w.bot -relief raised -border 1
    pack $w.top -side top -fill both -expand yes
    pack $w.bot -side bottom -fill y -expand yes

    # Create the message widget and arrange for it to be centered in the
    # top frame.

    message $w.top.msg -width 400 -font $font3 \
	    -text "\ \ \ \ << Msg Trace Info >>\n"

    pack $w.top.msg -side top -expand yes -padx 3 -pady 3

    button $w.bot.ok -text OK -command "destroy $w" -font $font3
    pack $w.bot.ok -side bottom -fill x  -expand yes

    scrollbar $w.bot.yscroll -relief sunken -command "$w.bot.list yview"
    scrollbar $w.bot.xscroll -relief sunken -orient horizontal \
	    -command "$w.bot.list xview"
    listbox $w.bot.list -geometry 55x14 -yscroll "$w.bot.yscroll set" \
		-xscroll "$w.bot.xscroll set" -relief sunken -setgrid 1 -font $fontTimes34

    pack $w.bot.yscroll -side right -fill y -expand yes

    pack $w.bot.xscroll -side bottom -fill x -expand yes

    pack $w.bot.list -expand yes -fill y

    $w.bot.list delete 0 end

    eval $w.bot.list insert 0 $msgTraceDgInfo

    tkwait visibility $w
    grab $w
    tkwait window $w
}

#
#
proc mkAgentLeaf {{type single} {name {}} {group 0} {x 0} {y 0}} \
{
    global font1 font2 font3 fontTimes24
    global lCanvas leafWidth leafHeight
    global ColAgentName ColAgentAreaOutline ColAgentLevel ColStatus
    global WaitMsgColor AskMsgColor ReplyMsgColor

    if { $name == {} } return

   if { $type == "single" } {
       set shape oval
   } else {
       set shape rectangle
   }

   set fd1 [$lCanvas create $shape [addm $x] [addm $y] \
		[addm [expr $x + $leafWidth]] [addm [expr $y + $leafHeight]] \
		-fill $ColStatus(notActive) -outline $WaitMsgColor \
		-width 1m -tags agentInfo]

   set fd2 [$lCanvas create text [addm [expr $x + $leafWidth / 2]] \
		[addm [expr $y + $leafHeight / 2]] \
		-text $name -fill $ColAgentName($group) -font $font3 -anchor c -tags agentInfo]

    $lCanvas bind $fd1 <1> "popupAgentDg .agentInfo $name"
    $lCanvas bind $fd2 <1> "popupAgentDg .agentInfo $name"

    $lCanvas bind $fd1 <3> "mkDialogCheck $fd1 mkResetLeaf %x %y"

    return $fd1
}

# Procedure to draw line between two agent leaves
#
proc mkAgentBranch {{x1 0} {y1 0} {x2 10} {y2 10}} {
   global lCanvas
   global WaitMsgColor AskMsgColor ReplyMsgColor

   set edge [$lCanvas create line [addm $x1] [addm $y1] [addm $x2]  [addm $y2] \
		-width 1m -fill $WaitMsgColor -tags huiMsgTraceInfo]

   $lCanvas lower $edge

   $lCanvas bind $edge <1> "huiShowMsgTraceInfo .huiMsgTraceInfo $edge"

   $lCanvas bind $edge <3> "mkDialogCheck $edge mkResetBranch %x %y"

   return $edge
}

# ====================================
# define procedures for process model
# ====================================

# procedur to draw message flow line on pCanvas in advance.
#
proc huiMkMsgFlowLine {} {
    global WaitMsgColor AskMsgColor ReplyMsgColor
    global ColFrom ColTo ColMsgFlow

    global pCanvas

    set fd1 [$pCanvas create oval 1c 1c 2c 2c -outline $WaitMsgColor \
		 -width 2m]

    set fd2 [$pCanvas create line 2c 1.5c 3c 1.5c -fill $WaitMsgColor \
		-arrow last -width 2m]

    set fd3 [$pCanvas create oval 3c 1c 4c 2c -outline $WaitMsgColor \
		-width 2m]

    return [format "%i %i %i" $fd1 $fd2 $fd3]
}

# procedure to make machine area
# 
proc huiMkMachArea {{x1 0} {y1 0} {x2 10} {y2 10} name} {
    global font1 font2 font3 fontTimes24
    global ColMachArea ColMachName ColAgentAreaOutline ColAgentLevel ColProcessName ColStatus

    global pCanvas

    set fd1 [$pCanvas create rectangle [addm $x1] [addm $y1] [addm $x2] [addm $y2] \
		-fill $ColMachArea -width 0 -tags machAreaInfo]

    set fd2 [$pCanvas create text [addm [expr $x1 + 3]] [addm [expr $y1 + 2]] \
	      -text $name -fill $ColMachName -font $font2 -anchor nw -tags machAreaInfo]

#    $pCanvas bind $fd1 <1> "popupMachInfoDg .machAreaInfo $name"
#    $pCanvas bind $fd2 <1> "popupMachInfoDg .machAreaInfo $name"

    return $fd1
}


# procedure to make agent process area
# 
proc huiMkAgentPArea {{x 0} {y 0} {width 10} {height 10} {rep N} name} {
    global font1 font2 font3 fontTimes24
    global ColMachArea ColMachName ColAgentNameArea ColAgentAreaOutline
    global ColAgentLevel ColProcessName ColStatus

    global pCanvas

    set fill_color	$ColStatus(notActive)
    set line_color	$ColAgentAreaOutline

    if { $rep == "Y" } {
	set line_width 2m
    } else {
	set line_width 0.5m
    }

    set fd1 [$pCanvas create rectangle [addm $x] [addm $y] \
	             [addm [expr $x + $width]] [addm [expr $y + $height]] \
		-fill $fill_color -outline $line_color -width $line_width \
		-tags agentProcInfo]

    set fd2 [$pCanvas create text [addm [expr $x + 2]] [addm [expr $y + 2]] \
	      -text $name -fill $ColProcessName -font $font2 -anchor nw -tags agentProcInfo]

    set fd3 [$pCanvas create rectangle [addm [expr $x + 60]] \
		[addm [expr $y + 1]] \
		[addm [expr $x + $width - 2]] [addm [expr $y + $height - 1]] \
		-fill $ColAgentNameArea  -width 0 \
		-tags agentProcInfo]

#    $pCanvas bind $fd1 <1> "popupAgentProcDg .agentProcInfo $name"
#    $pCanvas bind $fd2 <1> "popupAgentProcDg .agentProcInfo $name"

    return $fd1
}

# procedure to draw agen name area
#
proc huiMkAgentNameArea {{x 0} {y 0} {width 10} {height 10} {level 0} name} {
    global font1 font2 font3 fontTimes24
    global ColMachArea ColMachName ColAgentAreaOutline ColAgentName ColProcessName ColStatus

    global pCanvas

    set fd1 [$pCanvas create text [addm $x] [addm [expr $y + 2]] \
		-text $name -fill $ColAgentName($level) -font $font2 \
		-anchor nw -tags agentProcInfo]

    return $fd1
}

#
# procedure to make a monitor window
#
proc huiDispMonitor {{CanvasWidth 100} {CanvasHeight 100}} {
    global font1 font2 font3 fontTimes24

    global Blue Yellow Red Green
    global WaitMsgColor AskMsgColor ReplyMsgColor
    global ColMachArea ColMachName ColProcessName ColAgentName ColAgentNameArea
    global ColAgentAreaOutline ColAgentLevel ColStatus
    global ColFrom ColTo ColMsgFlow

    global canvasFr
    global lCanvas pCanvas
    global msgFrame msgArea
    global globalY globalLevel

    wm geometry . -20+20

    frame .waku
    pack .waku -side top -fill both -expand yes

    # color set

    if {[tk colormodel .waku] == "color"} {

	set AntiqueWhite	AntiqueWhite
	set AntiqueWhite1	AntiqueWhite1
	set LavenderBlush	LavenderBlush1

	set Blue		blue
	set Cyan		cyan
	set CadetBlue		CadetBlue
	set DodgerBlue		DodgerBlue4
	set MidNightBlue	MidNightBlue

	set Green		green
	set Green1		green1
	set Green3		green3
	set Green4		green4
	set SeaGreen		SeaGreen
	set PaleGreen		PaleGreen
	set SpringGreen		SpringGreen
	set SpringGreen1	SpringGreen1
	set YellowGreen		YellowGreen
	set DarkSeaGreen	DarkSeaGreen1
	set DarkSeaGreen4	DarkSeaGreen4
	set ForestGreen		ForestGreen
	set DarkGreen		DarkGreen

	set Yellow		yellow
	set Yellow1		yellow1
	set Khaki		khaki
	set LightGoldenrod	LightGoldenrod
	set LightYellow		LightYellow
	set LightYellow1	LightYellow1
	set Goldenrod		Goldenrod
	set PaleGoldenrod	PaleGoldenrod
	set Gold1		gold1

	set Red			red
	set Red3		red3
	set Red4		red4
	set OrangeRed		OrangeRed
	set OrangeRed1		OrangeRed1
	set Firebrick		firebrick
	set Firebrick2		firebrick2
	set Chocolate		Chocolate
	set Brown		brown
	set Brown4		brown4

	set Magenta		magenta

	set Gray		gray
	set DarkSlateGray	DarkSlateGray

    } else {

	set AntiqueWhite	white
	set LavenderBlush	white

	set Blue		black
	set CadetBlue		black
	set DodgerBlue		black
	set MidNightBlue	black

	set Green		black
	set SeaGreen		black
	set PaleGreen		black
	set SpringGreen		black
	set DarkSeaGreen	white
	set DarkSeaGreen2	white
	set ForestGreen		black
	set DarkGreen		black

	set Yellow		white
	set Khaki		white
	set LightGoldenrod	white
	set LightYellow		white
	set Goldenrod		white
	set PaleGoldenrod	white

	set Red			black
	set OrangeRed		black
	set Firebrick		black
	set Chocolate		black
	set Brown		black

	set Gray		black
	set DarkSlateGray	black
    }

    set lCanvasBG		$ForestGreen
    set pCanvasBG		$Green3

    set WaitMsgColor		$Green
    set ReplyMsgColor		$Yellow
    set AskMsgColor		$Red

    set ColMachArea		$ForestGreen
    set ColMachName		$Yellow1
    set ColProcessName		$Yellow

    set ColAgentNameArea	$Green4
    set ColAgentName(0)		$Yellow1
    set ColAgentName(1)		$Cyan
    set ColAgentName(2)		$Gold1
    set ColAgentName(3)		$LightYellow1
    set ColAgentName(4)		$OrangeRed1
    set ColAgentName(5)		$SpringGreen1
    set ColAgentName(6)		$AntiqueWhite1

    set ColAgentAreaOutline	$Gold1
    set ColAgentLevel(1)	$Cyan
    set ColAgentLevel(2)	$LightYellow1
    set ColAgentLevel(3)	$OrangeRed1
    set ColAgentLevel(4)	$SpringGreen1
    set ColAgentLevel(5)	$AntiqueWhite1
    set ColAgentLevel(6)	$Cyan
    set ColAgentLevel(7)	$SpringGreen1
    set ColAgentLevel(8)	$LightYellow1
    set ColAgentLevel(9)	$OrangeRed1

    set ColStatus(notActive)	$Red4
    set ColStatus(Active)	$Red3
    set ColStatus(Asked)	$Firebrick2

    set ColFrom			$WaitMsgColor
    set ColTo			$WaitMsgColor
    set ColMsgFlow		$WaitMsgColor


   #  set global variables
   #
    set w .waku
    set canvasFr  $w.frame2
    set lCanvas ${canvasFr}.lCanvas
    set pCanvas ${canvasFr}.pCanvas
    set contArea $w.control
    set msgFrame $w.msgFrame
    set msgArea $w.msgFrame.msgArea

    set CanvasScrollReg [list 0m 0m [addm $CanvasWidth] [addm $CanvasHeight]]

    frame ${canvasFr} -relief raised -bd 2
    frame ${contArea} -relief raised -bd 2

    button ${contArea}.modelSelect -text "Process" \
	-height 2 -width 8 -bd 4 -font $fontTimes24 \
	-command "huiModelSelect ${contArea}.modelSelect"

    scale ${contArea}.speed -label "Trace Speed" -from 0 -to 10 -orient horizontal \
	 -bd 4 -font $fontTimes24  -command "huiSetTraceSpeed"

    pack ${canvasFr} -side top -fill both -expand yes
    pack ${contArea} -side bottom -fill x
    pack ${contArea}.modelSelect -side right -pady 2 -padx 2
    pack ${contArea}.speed -side bottom -pady 2 -fill x

    ${contArea}.speed set 9

    # canvas for logical model # chartreuse \PaleTurquoise \
    #
    canvas $lCanvas -scrollregion $CanvasScrollReg -width 17c -height 18c \
	-bg $lCanvasBG \
	-xscroll "${canvasFr}.hscroll set" -yscroll "${canvasFr}.vscroll set"
    scrollbar ${canvasFr}.vscroll -relief sunken -command "$lCanvas yview"
    scrollbar ${canvasFr}.hscroll -orient horiz -relief sunken -command "$lCanvas xview"
    pack ${canvasFr}.hscroll -side bottom -fill x
    pack ${canvasFr}.vscroll -side right -fill y
    pack $lCanvas -in ${canvasFr} -expand yes -fill both -padx 4 -pady 4


    # canvas for process model
    #
    canvas $pCanvas -scrollregion $CanvasScrollReg -width 17c -height 18c \
	-bg $pCanvasBG \
	-xscroll "${canvasFr}.hscroll set" -yscroll "${canvasFr}.vscroll set"

    # message box

#    frame $w.title -relief sunken -border 2
#    pack $w.title -after $w.frame2 -fill both ; # -expand yes

#    message $w.title.msg -width 400 -font $fontTimes24 \
#	    -text "Message Trace Information"

#    pack $w.title.msg -in $w.title -anchor nw -padx 2 -pady 1

#    frame $msgFrame -relief raised -bd 2
#    pack $msgFrame -after $w.title -fill x ; # -expand yes

#    listbox $msgArea -geometry 40x5  -relief raised -bd 2 \
#		-xscroll "${msgFrame}.hscroll set" -yscroll "${msgFrame}.vscroll set"
#    scrollbar ${msgFrame}.vscroll -command "$msgArea yview"
#    scrollbar ${msgFrame}.hscroll -orient horizontal -command "$msgArea xview"

#    pack ${msgFrame}.hscroll -side bottom -fill x
#    pack ${msgFrame}.vscroll -side right -fill y
#    pack $msgArea -in $msgFrame -fill x ; # -expand yes

    # Set up Agent Info dialog

    frame .agentInfo -relief raised -bd 2

    # Set up message trace Info dialog

    frame .huiMsgTraceInfo -relief raised -bd 2

    # Set up event bindings for canvas:

    $lCanvas bind agentInfo <2> {

	set fill [lindex [$lCanvas itemconfig current -fill] 4]

	if { $fill == $ColStatus(notActive)} {
		set fill_color $ColStatus(Active)
	} else if { $fill == $ColStatus(Active) } {
		set fill_color $ColStatus(Asked)
	} else {
		set fill_color $ColStatus(notActive)
	}

	$lCanvas itemconfigure current -fill $fill_color
    }

    bind $w <Any-Enter> "focus $lCanvas"
}

set font1 -Adobe-Helvetica-Medium-R-Normal--*-120-*
set font2 -Adobe-Helvetica-Bold-R-Normal--*-240-*
set font3 -Adobe-Helvetica-Bold-R-Normal--*-180-*
set font4 kanji24
set font5 12x24

set fontTimes24 -Adobe-times-medium-r-normal--24-*-*
set fontTimes34 -Adobe-times-medium-r-normal--34-*-*

set leafWidth	40
set leafHeight	20
