/* huiMessage.h;
 *	header for Helios User Interface print message
 *
 *	created by k3sato on June 23rd in '94.
 *
 * $Id: huiMessage.h,v 2.1 1995/03/07 12:14:40 k3sato Exp $
 */

#ifndef _huiMessage_h

#define _huiMessage_h

#include "helios.h"

/* =============================
 *	type definitions
 * ============================= */
/*
 * type define of Error Message Type
 *	for Helios User Interface
 */
typedef enum {
    HuiEMsg_NoError,

    HuiEMsg_CmdAnalysisError = 1,	/* from 1 to 999 for Command analysis Errors */
    HuiEMsg_TooLongWord,		/* one word is too long for word buffer */
    HuiEMsg_NotCmdTerminated,		/* Command line is not correctly terminated */
    HuiEMsg_NotAgentName,		/* not agent name in command line */
    HuiEMsg_NotAgentId,			/* not agent ID in command line */
    HuiEMsg_IllegalAgentId,		/* Illegal agent ID in command line */
    HuiEMsg_NoDelimit,			/* There is no delimiter at a appropriate position */
    HuiEMsg_SingleQuot,			/* place \\ before \' in a text data */
    HuiEMsg_DoubleQuot,			/* place \\ before \" in a text data */
    HuiEMsg_NotExistKeyWord,		/* not exist a key word in command line */
    HuiEMsg_NotAppropriateKeyWord,	/* not exist a appropriate key word in command line */
    HuiEMsg_NotKeyWordEqual,		/* not exist '=' key word */
    HuiEMsg_ErrorInToField,		/* error in <To> field in command line */
    HuiEMsg_ErrorInMsgField,		/* error in <Msg> field in command line */
    HuiEMsg_NotExistMsgKeyWord,		/* not exist 'msg' key word in send command*/
    HuiEMsg_NotExistComma,		/* not exist comma at a appropriate position */
    HuiEMsg_GetEndOfFile,		/* Get End of File Mark */
    HuiEMsg_TwoCommasInToField,		/* There are two commas in <To> field */
    HuiEMsg_NoFunctionName,		/* No Function Name in <To> field */
    HuiEMsg_NoMethodNameInTo,		/* No Method Name in <To> field */
    HuiEMsg_NoMethodNameInMsg,		/* No Method Name in <Msg> field */
    HuiEMsg_ColonInBraces,		/* There is a colon in braces of <To> field */
    HuiEMsg_TwoColonsInToField,		/* There are two colons in <To> field */
    HuiEMsg_NoLeftBraceInToField,	/* There is right brace, but No left brace in <To> field */
    HuiEMsg_NoProcessName,		/* There is no process name in braces of <To> field */
    HuiEMsg_StrangeState,		/* Strange State occurres */
    HuiEMsg_NoLeftParenInMsg,		/* There is a right paren, but No Left paren in <Msg> field */
    HuiEMsg_HuiGetHMessageError,	/* error in huiGetHMessage() */
    HuiEMsg_HuiAlReceiveSetupError,	/* error in huiAlReceiveSetup() */
    HuiEMsg_NotOnOffSwitch,		/* not exist On/Off switch in command line */
    HuiEMsg_AlreadySetMTraceSwitch,	/* Already set the message trace switch to the agent */
    HuiEMsg_AlreadySetATraceSwitch,	/* Already set the agent trace switch to the agent */
    HuiEMsg_AppendTraceSwitchError,	/* Error in huiAppendTraceSwitch() */
    HuiEMsg_GetMsgIdError,		/* Error in huiGetMsgId() */
    HuiEMsg_GetMsgStatusError,		/* Error in huiGetMsgStatus() */
    HuiEMsg_GetTextError,		/* Error in huiGetText() */
    HuiEMsg_NotMsgId,			/* not exist message ID in command line */
    HuiEMsg_IllegalMsgId,		/* illeagel message ID */
    HuiEMsg_GetAgentIdError,		/* Error in huiGetAgentId() */
    HuiEMsg_NotMsgStatus,		/* not exist message status in command line */
    HuiEMsg_NoReplyMsg,			/* No reply message in command line */
    HuiEMsg_NotAgentNameInDecl,		/* Not exist agent name in agent declaration */
    HuiEMsg_TlParaAgentSetupError,	/* Error in huiTlParaAgentSetup() */
    HuiEMsg_NotTupleInDecl,		/* Not exist any tuples in agent declaration */
    HuiEMsg_NotLeftParanOfTuple,	/* Not exist left paren of tuple */
    HuiEMsg_NotRightParanOfTuple,	/* Not exist right paren of tuple */
    HuiEMsg_NotLogFileName,		/* Not exist log file name in command line */

    HuiEMsg_MessageTypeError = 1000,	/* from 1000 to 1999 for Helios Message Type Errors */
    HuiEMsg_NotImplementedMsgType,	/* Not implemented to handle this Message Type */
    HuiEMsg_IllegalMsgType,		/* illegal message type */
    HuiEMsg_NoMonMsgTypeInMsg,		/* No MonMsgType in message from monitor */
    HuiEMsg_NotTraceSpeedValueMsgType,	/* Not Monitor MsgType of Trace speed value */
    HuiEMsg_GetMonMsgTypeError,		/* Error in huiGetMonMsgType() */
    HuiEMsg_FailToGetAskForNextMsgFromMonitor,	/* Fail to get HuiMonMsg_AskForNextMsg from Monitor */
    HuiEMsg_NotHuiAgentInfo,		/* MonMsgType of message from UI is not HuiAgentInfo */

    HuiEMsg_MessageHandleError = 2000,	/* from 2000 to 2999 for Helios Message Handle Errors */
    HuiEMsg_HuiAppendMsgManageInfoError,	/* error in huiAppendMsgManageInfo */
    HuiEMsg_HuiMsgSend2AgentError,	/* error in huiMsgSend2Agent() */
    HuiEMsg_HuiMsgReply2AgentError,	/* error in huiMsgReply2Agent() */
    HuiEMsg_EnvInternalError,		/* Internal process error in environment */
    HuiEMsg_HuiMsgReceiveFromAgentError,/* error in huiMsgReceiveFromAgent */
    HuiEMsg_NotReceivedMsgFromAgent,	/* Not received message from agent */
    HuiEMsg_ShowReceivedMsgError,	/* error in huiShowReceivedMsg() */
    HuiEMsg_HuiSetup2MsgManageInfoError,/* Error in huiSetup2MsgManageInfo */
    HuiEMsg_HuiShowMsgIdError,		/* Error in huiShowMsgId() */
    HuiEMsg_StartAppGuiError,		/* Error in huiStartAppGui() */
    HuiEMsg_CSMGetTypeError,		/* Error in CSMGetType() */
    HuiEMsg_MonGetKeyWordValueError,	/* Error in huiMonGetKeyWordValue() */
    HuiEMsg_GetMsgTraceInfoError,	/* Error in huiGetMsgTraceInfo() */
    HuiEMsg_SearchMsgInfoForMsgIdError,	/* Error in huiSearchMsgInfoForMsgId() */
    HuiEMsg_NotExistAskedMessageForMsgId,/* Not exist any asked message for msg Id */
    HuiEMsg_NotExistCurrentAskedMessage,/* Not exist any current asked message */
    HuiEMsg_NotExistUserId,		/* There is no User ID in message */
    HuiEMsg_NotExistFromAgentId,	/* There is no from-Agent ID in message */
    HuiEMsg_NotExistMsgStatus,		/* There is no message status in message */
    HuiEMsg_HandleDbgInfoFromAgentError,/* Error in huiHandleDbgInfoFromAgent() */
    HuiEMsg_TestHandleDbgInfoFromAgentError,/* Error in huiTestHandleDbgInfoFromAgent() */

    HuiEMsg_AgentInfoError = 3000,	/* from 3000 to 3999 for Agent Infomation Errors */
    HuiEMsg_NotDefinedAgentName,	/* Not defined agent name */
    HuiEMsg_ConvertAgentName2IdError,	/* error in huiConvertAgent2Id() */
    HuiEMsg_SetupUsrInfoError,		/* error in huiSetupUserInfo() */
    HuiEMsg_GetUserInfoError,		/* error in huiGetUserInfo() */
    HuiEMsg_NotGetLoginNameOfUser,	/* Cannot get login name of user */
    HuiEMsg_SetupAgentID2UserInfo,	/* error in huiSetupAgentID2UserInfo() */
    HuiEMsg_SetupAgentName2UserInfo,	/* error in huiSetupAgentName2UserInfo() */
    HuiEMsg_SetupSockInfo2UserInfo,	/* error in huiSetupSockInfo2UserInfo() */
    HuiEMsg_SetupUserInfoMsg2Daemon,	/* error in huiSetupUserInfoMsg2Daemon() */
    HuiEMsg_GetAgentTreeInfoError,	/* Error in huiGetAgentTreeInfo() */
    HuiEMsg_DispAgentTreeInfoError,	/* Error in huiDispAgentTreeInfo() */
    HuiEMsg_SetupPosOfAgentLeafError,	/* Error in huiSetupPosOfAgentLeaf() */
    HuiEMsg_NotExistAgentTreeInfo,	/* Not exist the agentTreeInfo for a given agent name */
    HuiEMsg_NotExistAgentTreeInfoForId,	/* Not exist the agentTreeInfo for a given agent ID */
    HuiEMsg_NotExistAgentTreeInfoForFunc,/* Not exist the agentTreeInfo for a given func name */
    HuiEMsg_SearchTreeInfoForNameError,	/* Error in huiSearchTreeInfoForName() */
    HuiEMsg_SearchTreeInfoForIdError,	/* Error in huiSearchTreeInfoForId() */
    HuiEMsg_SearchTreeInfoForFuncError,	/* Error in huiSearchTreeInfoForFunc() */
    HuiEMsg_SearchTreeInfoError,	/* Error in huiSearchTreeInfo() */
    HuiEMsg_NotMTraceLineError,		/* Not the line of current Message Trace */
    HuiEMsg_GetCommonAgentInfoError,	/* Error in huiGetCommonAgentInfo() */
    HuiEMsg_DestroyedDataInAgentInfo,	/* Destroyed data in AgentInfo */
    HuiEMsg_SetupAgentInfo2BufferError,	/* Error in huiSetupAgentInfo2Buffer() */
    HuiEMsg_SetupFuncDirInfo2BufferError,/* Error in huiSetupFuncDirInfo2Buffer() */
    HuiEMsg_SetupMethodDirInfo2BufferError,/* Error in huiSetupMethodDirInfo2Buffer() */
    HuiEMsg_GetOneAgentTreeInfoError,	/* Error in huiGetOneAgentTreeInfo() */
    HuiEMsg_NotHuiUserInfo,		/* Not exist the data of the type HuiUserInfo */
    HuiEMsg_GetAgentTreeInfo_aError,	/* Error in huiGetAgentTreeInfo_a() */
    HuiEMsg_GetAgentTreeInfoFromUIError,/* Error in huiGetAgentTreeInfoFromUI() */
    HuiEMsg_SetupFuncDirInfoFromMsgError,/* Error in huiSetupFuncDirInfoFromMsg() */
    HuiEMsg_SetupMethodDirInfoFromMsgError,/* Error in huiSetupMethodDirInfoFromMsg() */
    HuiEMsg_SetupAgentInfoInPModelError,/* Error in huiSetupAgentInfoInPModel() */
    HuiEMsg_SetupAgentInfoInPModel_sError,/* Error in huiSetupAgentInfoInPModel_s() */
    HuiEMsg_GetMonMachInfoError,	/* Error in huiGetMonMachInfo() */
    HuiEMsg_CountAgentLevelError,	/* Error in huiCountAgentLevel() */
    HuiEMsg_AdjustMonMachInfoError,	/* Error in huiAdjustMonMachInfo() */
    HuiEMsg_AdjustAgentInfoInPModelError,/* Error in huiAdjustAdjustAgentInfoInPModel() */
    HuiEMsg_GetSingleAgentTreeInfoError,/* Error in huiGetSingleAgentTreeInfo() */
    HuiEMsg_DataErrorInAgentTreeInfo,	/* Data error in HuiAgentTreeInfo */

    HuiEMsg_AgentHandleError = 5000,	/* from 5000 to 5799 for Agent Handle Errors */
    HuiEMsg_GetAgentError,		/* error in get_agent() */
    HuiEMsg_NotFindAgentProcess,	/* Not find agent process */
    HuiEMsg_DeleteAgentError,		/* Error in delete_agent() */
    HuiEMsg_ParaAgentNotNormal,		/* Parametric agent processes are not in normal condition */

    HuiEMsg_ErrorInMonitor = 5800,	/* from 5800 to 5999 for Error in Monitor process */
    HuiEMsg_NotMonitorStandby,		/* Monitor is not Standby */
    HuiEMsg_NotAgentTreeDispStandby,	/* Monitor is not Standby for agent tree display */
    HuiEMsg_NotRunningMonitorProcess,	/* Monitor process is not running */

    HuiEMsg_TclTkError = 6000,		/* from 6000 to 6999 for Tcl/Tk errors */
    HuiEMsg_DrawCanvasError,		/* Error in huiDrawCanvas() */
    HuiEMsg_DrawAgentTreeError,		/* Error in huiDrawAgentTree() */
    HuiEMsg_DrawAgentLeafError,		/* Error in huiDrawAgentLeaf() */
    HuiEMsg_DrawAgentBranchError,	/* Error in huiDrawAgentBranch() */
    HuiEMsg_mkAgentInfoError,		/* Error in mkAgentInfo of tcl script on Tcl_Eval */
    HuiEMsg_mkAgentLeafError,		/* Error in mkAgentLeaf of tcl script on Tcl_Eval */
    HuiEMsg_mkAgentBranchError,		/* Error in mkAgentBranch of tcl script on Tcl_Eval */
    HuiEMsg_TclSetVarError,		/* Error in Tcl_SetVar() */
    HuiEMsg_TclSetGlobalVarFloatError,	/* Error in huiTclSetGlobalVarFloat() */
    HuiEMsg_TclSetAgentLeafSizeError,	/* Error in huiTclSetAgentLeafSize() */
    HuiEMsg_ShowMsgTraceError,		/* Error in huiShowMsgTrace() */
    HuiEMsg_ShowAgentTraceError,	/* Error in huiShowAgentTrace() */
    HuiEMsg_DrawMTraceArrowError,	/* Error in drawing arrow for message trace on tk-canvas */
    HuiEMsg_DrawMTraceLeafError,	/* Error in changing color of Agent leaf for message trace on tk-canvas */
    HuiEMsg_ResetMTracePathError,	/* Error in resetting the current trace path */
    HuiEMsg_mkMsgTraceInfoError,	/* Error in mkMsgTraceInfo of tcl script on Tcl_Eval */
    HuiEMsg_DrawTracePathError,		/* Error in huiDrawTracePath() */
    HuiEMsg_ResetOnePathError,		/* Error in huiResetOnePath() */
    HuiEMsg_ChgColorOfLeafOutlineError,	/* Error in huiChgColorOfLeafOutline() */
    HuiEMsg_DrawOnePathError,		/* Error in huiDrawOnePath() */
    HuiEMsg_ChgColorOfLeafOutlineTclError,/* Error in changing outline of itemconfig in Tcl_Eval */
    HuiEMsg_DrawAgentInPModelError,	/* Error in huiDrawAgentInPModel() */
    HuiEMsg_DrawAgentInPModel_sError,	/* Error in huiDrawAgentInPModel_s() */
    HuiEMsg_DispMonitorError,		/* Error in huiDispMonitor of tcl script on Tcl_Eval */
    HuiEMsg_DrawOneAgentInPModelError,	/* Error in huiDrawOneAgentInPModel()" */
    HuiEMsg_DrawAgentPAreaError,	/* Error in huiDrawAgentPArea() */
    HuiEMsg_DrawAgentNameAreaError,	/* Error in huiDrawAgentNameArea() */
    HuiEMsg_MkAgentNameAreaError,	/* Error in huiMkAgentNameArea of tcl script on Tcl_Eval */
    HuiEMsg_DrawMachAreaInPModelError,	/* Error in huiDrawMachAreaInPModel() */
    HuiEMsg_MkMachAreaError,		/* Error in huiMkMachArea of tcl script on Tcl_Eval */
    HuiEMsg_MkMsgFlowLineError,		/* Error in huiMkMsgFlowLine of tcl script on Tcl_Eval */
    HuiEMsg_ErrorInPCanvasOfTk,		/* Error in canvas of Tk for process model */
    HuiEMsg_DrawMsgFlowLineInPModelError, /* Error in huiDrawMsgFlowLineInPModel() */
    HuiEMsg_DrawTracePathInPModelError,	/* Error in huiDrawTracePathInPModel() */
    HuiEMsg_MoveItemInPModelError,	/* Error in huiMoveItemInPModel() */
    HuiEMsg_ChgColorOfMsgFlowLineInPModelError,/* Error in ChgColorOfMsgFlowLineInPModel of tcl script on Tcl_Eval */
    HuiEMsg_ChgCoordsOfItemError,	/* Error in huiChgCoordsOfItem() */
    HuiEMsg_ChgFillColorOfItemError,	/* Error in changing fill color of item on Tcl_Eval */
    HuiEMsg_ChgColorOfAgentPAreaError,	/* Error in huiChgColorOfAgentPArea() */

    HuiEMsg_CommunicationError = 7000,	/* from 7000 to 7999 for communication errors */
    HuiEMsg_HeliosdInitError,		/* error in heliosdInit() */
    HuiEMsg_NotFindHostName,		/* error in gethostname() */
    HuiEMsg_SetupHostName2UserInfo,	/* error in huiSetupHostName2UserInfo() */
    HuiEMsg_GetAgentInfoError,		/* error in get_agentInfo() */
    HuiEMsg_SendUserInfo2Daemon,	/* error in huiSendUserInfo2Daemon() */
    HuiEMsg_Socket2AgentFailed,
    HuiEMsg_CouldNotBind,
    HuiEMsg_CouldNotConnect,
    HuiEMsg_SocketWriteError,		/* error in write to socket */
    HuiEMsg_SocketReadError,		/* error in read from socket */
    HuiEMsg_InitCommError,		/* error in init_comm() */
    HuiEMsg_SendAMessageError,		/* error in send_a_message() */
    HuiEMsg_NotSendForFullQueue,	/* Could not send for queue is full */
    HuiEMsg_ConnectionTimedOut,		/* CONNECTION TIMED OUT */
    HuiEMsg_ConnectionRefused,		/* CONNECTION REFUSED */
    HuiEMsg_HdCreateSocketError,	/* error in hdCreateSocket() */
    HuiEMsg_HdSendMessageError,		/* error in hdSendMessage() */
    HuiEMsg_HdReceiveMessageError,	/* error in hdReceiveMessage() */
    HuiEMsg_HdReceivedDataError,	/* error in received data from heliosd */
    HuiEMsg_GetMsgFromPipeError,	/* error in HuiGetMsgFromPipe() */
    HuiEMsg_PipeReadError,		/* error in read from pipe */
    HuiEMsg_PipeWriteError,		/* error in write to pipe */
    HuiEMsg_NoPipeData,			/* Get no data through Pipe */
    HuiEMsg_CreateMonitorProcessError,	/* Error in creating Monitor process */
    HuiEMsg_AlreadyRunMonitorProcess,	/* Already running Monitor process */
    HuiEMsg_NotRunMonitorProcess,	/* Not running Monitor process */
    HuiEMsg_ReceiveMsgFromMonitorError,	/* Error in huiReceiveMsgFromMonitor() */
    HuiEMsg_SendMsg2MonitorError,	/* Error in huiSendMsg2Monitor() */
    HuiEMsg_SendSMsg2MonitorError,	/* Error in huiSendSMsg2Monitor() */
    HuiEMsg_OverMaxNumOfRetryToReadPipe,	/* Over the max number of retry to read pipe */
    HuiEMsg_OverMaxNumOfRetryToWritePipe,	/* Over the max number of retry to write pipe */
    HuiEMsg_QuitMonitorError,		/* Error in huiQuitMonitor() */
    HuiEMsg_PutMsg2PipeError,		/* Error in huiPutMsg2Pipe() */
    HuiEMsg_ReceivedDataFromPipeError,	/* Error in received data from pipe */
    HuiEMsg_SendUserInfo2MonitorFail,	/* Failed to send UserInfo to Monitor */
    HuiEMsg_SendAgentInfo2MonitorFail,	/* Failed to send AgentInfo to Monitor */
    HuiEMsg_SendAgentInfo2MonitorError,	/* Error in huiSendAgentInfo2Monitor() */
    HuiEMsg_FailToPutMonMsgType2UI,	/* Failed to send HuiMonMsgType to UI through pipe */
    HuiEMsg_SetupAgentTreeInfoFromMsgError,/* Error in huiSetupAgentTreeInfoFromMsg() */
    HuiEMsg_SendMonMsgType2MonitorError,	/* Error in huiSendMonMsgType2Monitor() */
    HuiEMsg_ReceiveMonMsgTypeFromMonitorError,	/* Error in huiReceiveMonMsgTypeFromMonitor() */
    HuiEMsg_Send2NewParaAgentError,	/* Error in huiSend2NewParaAgent() */
    HuiEMsg_SendDbgInfo2MonitorError,	/* Error in huiSendDbgInfo2Monitor() */
    HuiEMsg_NotSeparatorInFuncDirInfo,	/* Not exist a separator in received data of FuncDirInfo */
    HuiEMsg_PutMonSpeed2UIError,	/* Error in huiPutMonSpeed2UI() */

    HuiEMsg_IllegalError = 8000,	/* from 8000 for illegal value */
    HuiEMsg_NullPointer,		/* pointer value is Null */
    HuiEMsg_CharPointerIsNull,		/* Charcter pointer is NULL */
    HuiEMsg_StringLenLimitOver,		/* Over the limit of string length */
    HuiEMsg_TextLenLimitOver,		/* Over the limit of Text length */


    HuiEMsg_FileHandleError = 9000,	/* from 9000 for file handle Errors */
    HuiEMsg_Fail2OpenFile2Write,	/* Failed to open a file to write */

    HuiEMsg_MemoryHandleError = 9900,	/* from 9900 for memory handle Errors */
    HuiEMsg_SizeZeroMalloc,		/* for error to malloc for size of zero */
    HuiEMsg_MallocError,		/* for error in malloc */
    HuiEMsg_HuiMallocError,		/* for error in HuiMalloc */
    HuiEMsg_HuiMallocStringError,	/* for error in HuiMallocString */
    HuiEMsg_NotEnoughMemory,		/* Not enough memory in system */
    HuiEMsg_SprintfError,		/* Error in sprintf() */

    /* For Implementation */
    HuiEMsg_NotYetImplemented = 9990,	/* Not yet implemented */

} HuiErrorMsgType;

/*
 * type define of Warning Message Type
 *	for Helios User Interface
 */
typedef enum {
    HuiWMsg_Confirm2QuitAgnet = 1,	/* Confirmation to quite agent level */
    HuiWMsg_Confirm2ChangeLog,		/* Confirmation to change log file name */
    HuiWMsg_WaitForAckMsgFromParaAgent,	/* Waiting for a acknowledge from parametric agent */
} HuiWarningMsgType;

/*
 * type define of Good Message Type
 *	for Helios User Interface
 */
typedef enum {
    HuiGMsg_WakeedUpAgent,	/* The agent process for a given agent ID is waked up */
    HuiGMsg_SleepAgent,		/* The agent process for a given agent ID is slept */
} HuiGoodMsgType;

/* =============================
 *	structure definitions
 * ============================= */
/*
 * define structure of Error Message Information
 *	for Helios User Interface
 */
typedef struct _HuiErrorMsgInfo {
    HuiErrorMsgType	type;
    char		*msg;
} HuiErrorMsgInfo;

/*
 * define structure of table for
 *	errno vs. HuiErrorMsgInfo
 */
typedef struct _HuiErrno2EMsgTypeTbl {
    int			errno;
    HuiErrorMsgType	type;
} HuiErrno2EMsgTypeTbl;

/*
 * define structure of Warning Message Information
 *	for Helios User Interface
 */
typedef struct _HuiWarningMsgInfo {
    HuiWarningMsgType	type;
    char		*msg;
} HuiWarningMsgInfo;

/*
 * define structure of Yes/No Message Information
 *	for Helios User Interface
 */
typedef struct _HuiYesNoStrList {
    char	*msg;
    long	len;
    HuiBoolean	retValue;
} HuiYesNoStrList;

/*
 * define structure of Error Message Information
 *	for Helios User Interface
 */
typedef struct _HuiGoodMsgInfo {
    HuiGoodMsgType	type;
    char		*msg;
} HuiGoodMsgInfo;


/* ======================================
 *	functions defined in huiMessage.c
 * ====================================== */
extern HuiBoolean huiAskYesNo();

extern HuiErrorMsgType huiCnvErrno2EMsgType();

extern void huiPutsErrorMsg();
extern char *huiGetErrorMsg();
extern HuiBoolean huiPutsWarningMsg();
extern void huiPutsGoodMsg();
extern void huiPutsStr();
extern void huiPrintf();

extern void HuiPerror();
#endif
