/* huiMessage.c;
 *	Helios User Interface messages
 *
 *		created by k3sato on June 23rd in '94.
 *
 * $Id: huiMessage.c,v 2.2 1995/03/07 12:14:40 k3sato Exp $
 */
#include <stdio.h>
#include <varargs.h>

#include <helios/hExternStdFunc.h>

#include "huiMessage.h"

/* for errno */
extern char *sys_errlist[];

/* defined in helios.c
 */
extern FILE	*HuiLogFd;

/*
 * Error Message for Helios User Interface
 */
HuiErrorMsgInfo huiErrorMsgInfo[] = {
    {HuiEMsg_NoError,		"No Error"},

    /* for Command analysis Errors */
    {HuiEMsg_NotCmdTerminated,	"Command line is not correctly terminated"},
    {HuiEMsg_TooLongWord,	"One word is too long for word buffer"},
    {HuiEMsg_NotAgentName,	"Not agent name in command line"},
    {HuiEMsg_NotAgentId,	"Not agent ID in command line"},
    {HuiEMsg_IllegalAgentId,	"Illegal agent ID in command line"},
    {HuiEMsg_NoDelimit,		"There is no delimiter at a appropriate position"},
    {HuiEMsg_SingleQuot,	"place \\ before \' in a text data"},
    {HuiEMsg_DoubleQuot,	"place \\ before \" in a text data"},
    {HuiEMsg_NotExistKeyWord,	"Not exist a key word in command line"},
    {HuiEMsg_NotAppropriateKeyWord,"Not exist a appropriate key word in command line"},
    {HuiEMsg_NotKeyWordEqual,	"Not exist \'=\' key word"},
    {HuiEMsg_ErrorInToField,	"Error in <To> field in command line"},
    {HuiEMsg_NotExistMsgKeyWord,"Not exist \'msg\' key word in send command"},
    {HuiEMsg_NotExistComma,	"Not exist comma at a appropriate position"},
    {HuiEMsg_GetEndOfFile,	"Get End of File Mark"},
    {HuiEMsg_TwoCommasInToField,"There are two commas in <To> field"},
    {HuiEMsg_NoFunctionName,	"No Function Name in <To> field"},
    {HuiEMsg_NoMethodNameInTo,	"No Method Name in <To> field"},
    {HuiEMsg_ColonInBraces,	"There is a colon in braces of <To> field"},
    {HuiEMsg_TwoColonsInToField,"There are two colons in <To> field"},
    {HuiEMsg_NoLeftBraceInToField,"There is a right brace, but no left brace in <To> field"},
    {HuiEMsg_NoProcessName,	"There is no process name in braces of <To> field"},
    {HuiEMsg_StrangeState,	"Strange State occurres"},
    {HuiEMsg_NoLeftParenInMsg,	"There is a right paren, but No Left paren in <Msg> field"},
    {HuiEMsg_HuiGetHMessageError,	"Error in huiGetHMessage()"},
    {HuiEMsg_HuiAlReceiveSetupError,	"Error in huiAlReceiveSetup()"},
    {HuiEMsg_NotGetLoginNameOfUser,	"Cannot get login name of user"},
    {HuiEMsg_SetupAgentID2UserInfo,	"Error in huiSetupAgentID2UserInfo()"},
    {HuiEMsg_SetupAgentName2UserInfo,	"Error in huiSetupAgentName2UserInfo()"},
    {HuiEMsg_SetupSockInfo2UserInfo,	"Error in huiSetupSockInfo2UserInfo()"},
    {HuiEMsg_NotOnOffSwitch,		"Not exist On/Off switch in command line"},
    {HuiEMsg_AlreadySetMTraceSwitch,	"Already set the message trace switch to the agent"},
    {HuiEMsg_AlreadySetATraceSwitch,	"Already set the agent trace switch to the agent"},
    {HuiEMsg_AppendTraceSwitchError,	"Error in huiAppendTraceSwitch()"},
    {HuiEMsg_GetMsgIdError,		"Error in huiGetMsgId()"},
    {HuiEMsg_GetMsgStatusError,		"Error in huiGetMsgStatus()"},
    {HuiEMsg_GetTextError,		"Error in huiGetText()"},
    {HuiEMsg_NotMsgId,			"Not exist message ID in command line"},
    {HuiEMsg_IllegalMsgId,		"Illeagel message ID"},
    {HuiEMsg_GetAgentIdError,		"Error in huiGetAgentId()"},
    {HuiEMsg_NotMsgStatus,		"Not exist message status in command line"},
    {HuiEMsg_NoReplyMsg,		"No reply message in command line"},
    {HuiEMsg_NotAgentNameInDecl,	"Not exist agent name in agent declaration"},
    {HuiEMsg_TlParaAgentSetupError,	"Error in huiTlParaAgentSetup()"},
    {HuiEMsg_NotTupleInDecl,		"Not exist any tuples in agent declaration"},
    {HuiEMsg_NotLeftParanOfTuple,	"Not exist left paren of tuple"},
    {HuiEMsg_NotRightParanOfTuple,	"Not exist right paren of tuple"},
    {HuiEMsg_NotLogFileName,		"Not exist log file name in command line"},

    /* for Helios Message Type Errors */
    {HuiEMsg_NotImplementedMsgType,	"Not implemented to handle this Message Type"},
    {HuiEMsg_IllegalMsgType,		"Illegal message type"},
    {HuiEMsg_NoMonMsgTypeInMsg,		"No MonMsgType in message from monitor"},
    {HuiEMsg_NotTraceSpeedValueMsgType,	"Not Monitor MsgType of Trace speed value"},
    {HuiEMsg_GetMonMsgTypeError,	"Error in huiGetMonMsgType()"},
    {HuiEMsg_FailToGetAskForNextMsgFromMonitor,	"Fail to get HuiMonMsg_AskForNextMsg from Monitor"},
    {HuiEMsg_NotHuiAgentInfo,		"MonMsgType of message from UI is not HuiAgentInfo"},

    /* for Helios Message Handle Errors */
    {HuiEMsg_HuiAppendMsgManageInfoError,	"Error in huiAppendMsgManageInfo"},
    {HuiEMsg_HuiMsgSend2AgentError,	"Error in huiMsgSend2Agent()"},
    {HuiEMsg_HuiMsgReply2AgentError,	"Error in huiMsgReply2Agent()"},
    {HuiEMsg_EnvInternalError,		"Internal process error in environment"},
    {HuiEMsg_HuiMsgReceiveFromAgentError,	"Error in huiMsgReceiveFromAgent"},
    {HuiEMsg_NotReceivedMsgFromAgent,	"Not received message from agent"},
    {HuiEMsg_ShowReceivedMsgError,	"Error in huiShowReceivedMsg()"},
    {HuiEMsg_HuiSetup2MsgManageInfoError,	"Error in huiSetup2MsgManageInfo"},
    {HuiEMsg_HuiShowMsgIdError,		"Error in huiShowMsgId()"},
    {HuiEMsg_StartAppGuiError,		"Error in huiStartAppGui()"},
    {HuiEMsg_CSMGetTypeError,		"Error in CSMGetType()"},
    {HuiEMsg_MonGetKeyWordValueError,	"Error in huiMonGetKeyWordValue()"},
    {HuiEMsg_GetMsgTraceInfoError,	"Error in huiGetMsgTraceInfo()"},
    {HuiEMsg_SearchMsgInfoForMsgIdError,"Error in huiSearchMsgInfoForMsgId()"},
    {HuiEMsg_NotExistAskedMessageForMsgId,	"Not exist any asked message for msg Id"},
    {HuiEMsg_NotExistCurrentAskedMessage,"Not exist any current asked message"},
    {HuiEMsg_NotExistUserId,		"There is no User ID in message"},
    {HuiEMsg_NotExistFromAgentId,	"There is no from-Agent ID in message"},
    {HuiEMsg_NotExistMsgStatus,		"There is no message status in message"},
    {HuiEMsg_HandleDbgInfoFromAgentError,"Error in huiHandleDbgInfoFromAgent()"},
    {HuiEMsg_TestHandleDbgInfoFromAgentError,"Error in huiTestHandleDbgInfoFromAgent()"},

    /* for Agent Infomation Errors */
    {HuiEMsg_NotDefinedAgentName,	"Agent name is not defined"},
    {HuiEMsg_ConvertAgentName2IdError,	"Error in huiConvertAgent2Id()"},
    {HuiEMsg_SetupUsrInfoError,		"Error in huiSetupUserInfo()"},
    {HuiEMsg_GetUserInfoError,		"Error in huiGetUserInfo()"},
    {HuiEMsg_NotGetLoginNameOfUser,	"Cannot get login name of user"},
    {HuiEMsg_GetAgentTreeInfoError,	"Error in huiGetAgentTreeInfo()"},
    {HuiEMsg_DispAgentTreeInfoError,	"Error in huiDispAgentTreeInfo()"},
    {HuiEMsg_SetupPosOfAgentLeafError,	"Error in huiSetupPosOfAgentLeaf()"},
    {HuiEMsg_NotExistAgentTreeInfo,	"Not exist the agentTreeInfo for a given agent name"},
    {HuiEMsg_NotExistAgentTreeInfoForId,"Not exist the agentTreeInfo for a given agent ID"},
    {HuiEMsg_NotExistAgentTreeInfoForFunc,"Not exist the agentTreeInfo for a given func name"},
    {HuiEMsg_SearchTreeInfoForNameError,"Error in huiSearchTreeInfoForName()"},
    {HuiEMsg_SearchTreeInfoForIdError,	"Error in huiSearchTreeInfoForId()"},
    {HuiEMsg_SearchTreeInfoForFuncError,"Error in huiSearchTreeInfoForFunc()"},
    {HuiEMsg_SearchTreeInfoError,	"Error in huiSearchTreeInfo()"},
    {HuiEMsg_NotMTraceLineError,	"Not the line of current Message Trace"},
    {HuiEMsg_GetCommonAgentInfoError,	"Error in huiGetCommonAgentInfo()"},
    {HuiEMsg_DestroyedDataInAgentInfo,	"Destroyed data in AgentInfo"},
    {HuiEMsg_SetupAgentInfo2BufferError,"Error in huiSetupAgentInfo2Buffer()"},
    {HuiEMsg_SetupFuncDirInfo2BufferError,"Error in huiSetupFuncDirInfo2Buffer()"},
    {HuiEMsg_SetupMethodDirInfo2BufferError,"Error in huiSetupMethodDirInfo2Buffer()"},
    {HuiEMsg_GetOneAgentTreeInfoError,	"Error in huiGetOneAgentTreeInfo()"},
    {HuiEMsg_NotHuiUserInfo,		"Not exist the data of the type HuiUserInfo"},
    {HuiEMsg_GetAgentTreeInfo_aError,	"Error in huiGetAgentTreeInfo_a()"},
    {HuiEMsg_GetAgentTreeInfoFromUIError,"Error in huiGetAgentTreeInfoFromUI()"},
    {HuiEMsg_SetupFuncDirInfoFromMsgError,"Error in huiSetupFuncDirInfoFromMsg()"},
    {HuiEMsg_SetupMethodDirInfoFromMsgError,"Error in huiSetupMethodDirInfoFromMsg()"},
    {HuiEMsg_SetupAgentInfoInPModelError,"Error in huiSetupAgentInfoInPModel()"},
    {HuiEMsg_SetupAgentInfoInPModel_sError,"Error in huiSetupAgentInfoInPModel_s()"},
    {HuiEMsg_GetMonMachInfoError,	"Error in huiGetMonMachInfo()"},
    {HuiEMsg_CountAgentLevelError,	"Error in huiCountAgentLevel()"},
    {HuiEMsg_AdjustMonMachInfoError,	"Error in huiAdjustMonMachInfo()"},
    {HuiEMsg_AdjustAgentInfoInPModelError,"Error in huiAdjustAdjustAgentInfoInPModel()"},
    {HuiEMsg_GetSingleAgentTreeInfoError,"Error in huiGetSingleAgentTreeInfo()"},
    {HuiEMsg_DataErrorInAgentTreeInfo,	"Data error in HuiAgentTreeInfo"},

    /* for Agent Handle Errors */
    {HuiEMsg_GetAgentError,		"Error in get_agent()"},
    {HuiEMsg_NotFindAgentProcess,	"Not find agent process"},
    {HuiEMsg_DeleteAgentError,		"Error in delete_agent()"},

    /* from 5800 to 5999 for Error in Monitor process */
    {HuiEMsg_ErrorInMonitor,		"Error in Monitor process"},
    {HuiEMsg_NotMonitorStandby,		"Monitor is not Standby"},
    {HuiEMsg_NotAgentTreeDispStandby,	"Monitor is not Standby for agent tree display"},
    {HuiEMsg_NotRunningMonitorProcess,	"Monitor process is not running"},

    /* for Tcl/Tk errors */
    {HuiEMsg_DrawCanvasError,		"Error in huiDrawCanvas()"},
    {HuiEMsg_DrawAgentTreeError,	"Error in huiDrawAgentTree()"},
    {HuiEMsg_DrawAgentLeafError,	"Error in huiDrawAgentLeaf()"},
    {HuiEMsg_DrawAgentBranchError,	"Error in huiDrawAgentBranch()"},
    {HuiEMsg_mkAgentInfoError,		"Error in mkAgentInfo of tcl script on Tcl_Eval"},
    {HuiEMsg_mkAgentLeafError,		"Error in mkAgentLeaf of tcl script on Tcl_Eval"},
    {HuiEMsg_mkAgentBranchError,	"Error in mkAgentBranch of tcl script on Tcl_Eval"},
    {HuiEMsg_TclSetVarError,		"Error in Tcl_SetVar()"},
    {HuiEMsg_TclSetGlobalVarFloatError,	"Error in huiTclSetGlobalVarFloat()"},
    {HuiEMsg_TclSetAgentLeafSizeError,	"Error in huiTclSetAgentLeafSize()"},
    {HuiEMsg_ShowMsgTraceError,		"Error in huiShowMsgTrace()"},
    {HuiEMsg_ShowAgentTraceError,	"Error in huiShowAgentTrace()"},
    {HuiEMsg_DrawMTraceArrowError,	"Error in drawing arrow for message trace on tk-canvas"},
    {HuiEMsg_DrawMTraceLeafError,	"Error in changing color of Agent leaf for message trace on tk-canvas"},
    {HuiEMsg_ResetMTracePathError,	"Error in resetting the current trace path"},
    {HuiEMsg_mkMsgTraceInfoError,	"Error in mkMsgTraceInfo of tcl script on Tcl_Eval"},
    {HuiEMsg_DrawTracePathError,	"Error in huiDrawTracePath()"},
    {HuiEMsg_ResetOnePathError,		"Error in huiResetOnePath()"},
    {HuiEMsg_ChgColorOfLeafOutlineError,"Error in huiChgColorOfLeafOutline()"},
    {HuiEMsg_DrawOnePathError,		"Error in huiDrawOnePath()"},
    {HuiEMsg_ChgColorOfLeafOutlineTclError,"Error in changing outline of itemconfig in Tcl_Eval"},
    {HuiEMsg_DrawAgentInPModelError,	"Error in huiDrawAgentInPModel()"},
    {HuiEMsg_DrawAgentInPModel_sError,	"Error in huiDrawAgentInPModel_s()"},
    {HuiEMsg_DispMonitorError,		"Error in huiDispMonitor of tcl script on Tcl_Eval"},
    {HuiEMsg_DrawOneAgentInPModelError,	"Error in huiDrawOneAgentInPModel()"},
    {HuiEMsg_DrawAgentPAreaError,	"Error in huiDrawAgentPArea()"},
    {HuiEMsg_DrawAgentNameAreaError,	"Error in huiDrawAgentNameArea()"},
    {HuiEMsg_MkAgentNameAreaError,	"Error in huiMkAgentNameArea of tcl script on Tcl_Eval"},
    {HuiEMsg_DrawMachAreaInPModelError,	"Error in huiDrawMachAreaInPModel()"},
    {HuiEMsg_MkMachAreaError,		"Error in huiMkMachArea of tcl script on Tcl_Eval"},
    {HuiEMsg_MkMsgFlowLineError,	"Error in huiMkMsgFlowLine of tcl script on Tcl_Eval"},
    {HuiEMsg_ErrorInPCanvasOfTk,	"Error in canvas of Tk for process model"},
    {HuiEMsg_DrawMsgFlowLineInPModelError,"Error in huiDrawMsgFlowLineInPModel()"},
    {HuiEMsg_DrawTracePathInPModelError,"Error in huiDrawTracePathInPModel()"},
    {HuiEMsg_MoveItemInPModelError,	"Error in huiMoveItemInPModel()"},
    {HuiEMsg_ChgColorOfMsgFlowLineInPModelError,
       "Error in ChgColorOfMsgFlowLineInPModel of tcl script on Tcl_Eval"},
    {HuiEMsg_ChgCoordsOfItemError,	"Error in huiChgCoordsOfItem()"},
    {HuiEMsg_ChgFillColorOfItemError,	"Error in changing fill color of item on Tcl_Eval"},
    {HuiEMsg_ChgColorOfAgentPAreaError,	"Error in huiChgColorOfAgentPArea()"},

    /* for communication errors */
    {HuiEMsg_HeliosdInitError,		"Error in heliosdInit()"},
    {HuiEMsg_NotFindHostName,		"Error in gethostname()"},
    {HuiEMsg_SetupHostName2UserInfo,	"Error in huiSetupHostName2UserInfo()"},
    {HuiEMsg_GetAgentInfoError,		"Error in get_agentInfo()"},
    {HuiEMsg_SendUserInfo2Daemon,	"Error in huiSendUserInfo2Daemon()"},
    {HuiEMsg_Socket2AgentFailed,	"Failed to create socket to Agent"},
    {HuiEMsg_CouldNotBind,		"Failed to bind to Agent"},
    {HuiEMsg_CouldNotConnect,		"Failed to connect to Agent"},
    {HuiEMsg_SocketWriteError,		"Failed to write to socket"},
    {HuiEMsg_SocketReadError,		"Failed to read from socket"},
    {HuiEMsg_InitCommError,		"Error in init_comm()"},
    {HuiEMsg_SendAMessageError,		"Error in send_a_message()"},
    {HuiEMsg_NotSendForFullQueue,	"Could not send for queue is full.\n\
Or could not receive for lack of memory area"},
    {HuiEMsg_ConnectionTimedOut,	"CONNECTION TIMED OUT"},
    {HuiEMsg_ConnectionRefused,		"CONNECTION REFUSED"},
    {HuiEMsg_HdCreateSocketError,	"Error in hdCreateSocket()"},
    {HuiEMsg_HdSendMessageError,	"Error in hdSendMessage()"},
    {HuiEMsg_HdReceiveMessageError,	"Error in hdReceiveMessage()"},
    {HuiEMsg_HdReceivedDataError,	"Error in received data from heliosd"},
    {HuiEMsg_GetMsgFromPipeError,	"Error in HuiGetMsgFromPipe()"},
    {HuiEMsg_PipeReadError,		"Error in read from pipe"},
    {HuiEMsg_PipeWriteError,		"Error in write to pipe"},
    {HuiEMsg_NoPipeData,		"Get no data through Pipe"},
    {HuiEMsg_CreateMonitorProcessError,	"Error in creating Monitor process"},
    {HuiEMsg_AlreadyRunMonitorProcess,	"Already running Monitor process"},
    {HuiEMsg_NotRunMonitorProcess,	"Not running Monitor process"},
    {HuiEMsg_ReceiveMsgFromMonitorError,"Error in huiReceiveMsgFromMonitor()"},
    {HuiEMsg_SendMsg2MonitorError,	"Error in huiSendMsg2Monitor()"},
    {HuiEMsg_SendSMsg2MonitorError,	"Error in huiSendSMsg2Monitor()"},
    {HuiEMsg_OverMaxNumOfRetryToReadPipe,	"Over the max number of retry to read pipe"},
    {HuiEMsg_OverMaxNumOfRetryToWritePipe,	"Over the max number of retry to write pipe"},
    {HuiEMsg_QuitMonitorError,		"Error in huiQuitMonitor()"},
    {HuiEMsg_PutMsg2PipeError,		"Error in huiPutMsg2Pipe()"},
    {HuiEMsg_ReceivedDataFromPipeError,	"Error in received data from pipe"},
    {HuiEMsg_SendUserInfo2MonitorFail,	"Failed to send UserInfo to Monitor"},
    {HuiEMsg_SendAgentInfo2MonitorFail,	"Failed to send AgentInfo to Monitor"},
    {HuiEMsg_SendAgentInfo2MonitorError,"Error in huiSendAgentInfo2Monitor()"},
    {HuiEMsg_FailToPutMonMsgType2UI,	"Failed to send HuiMonMsgType to UI through pipe"},
    {HuiEMsg_SetupAgentTreeInfoFromMsgError,"Error in huiSetupAgentTreeInfoFromMsg()"},
    {HuiEMsg_SendMonMsgType2MonitorError,	"Error in huiSendMonMsgType2Monitor()"},
    {HuiEMsg_ReceiveMonMsgTypeFromMonitorError,	"Error in huiReceiveMonMsgTypeFromMonitor()"},
    {HuiEMsg_Send2NewParaAgentError,	"Error in huiSend2NewParaAgent()"},
    {HuiEMsg_SendDbgInfo2MonitorError,	"Error in huiSendDbgInfo2Monitor()"},
    {HuiEMsg_NotSeparatorInFuncDirInfo,	"Not exist a separator in received data of FuncDirInfo"},
    {HuiEMsg_PutMonSpeed2UIError,	"Error in huiPutMonSpeed2UI()"},

    /* for illegal value */
    {HuiEMsg_NullPointer,		"Pointer is NULL"},
    {HuiEMsg_CharPointerIsNull,		"Charcter pointer is NULL"},
    {HuiEMsg_StringLenLimitOver,	"Over the limit of string length"},
    {HuiEMsg_TextLenLimitOver,		"Over the limit of Text length"},

    /* for file handle Errors */
    {HuiEMsg_Fail2OpenFile2Write,	"Failed to open a file to write"},

    /* for memory handle Errors */
    {HuiEMsg_SizeZeroMalloc,		"Cannot malloc for size of zero"},
    {HuiEMsg_MallocError,		"Error in malloc"},
    {HuiEMsg_HuiMallocError,		"Error in HuiMalloc"},
    {HuiEMsg_HuiMallocStringError,	"Error in HuiMallocString"},
    {HuiEMsg_NotEnoughMemory,		"Not enough memory in system"},
    {HuiEMsg_SprintfError,		"Error in sprintf()"},

    /* For Implementation */
    {HuiEMsg_NotYetImplemented,		"Not yet implemented"},

    {NULL,			NULL},
};

/*
 * Warning Message for Helios User Interface
 */
HuiWarningMsgInfo huiWarningMsgInfo[] = {
    {HuiWMsg_Confirm2QuitAgnet,		"Are you sure to quit Agent Level"},
    {HuiWMsg_Confirm2ChangeLog,		"Confirmation to change log file name"},
    {HuiWMsg_WaitForAckMsgFromParaAgent,"Waiting for a acknowledge from parametric agent"},
};

/*
 * Good Message for Helios User Interface
 */
HuiGoodMsgInfo huiGoodMsgInfo[] = {
    {HuiGMsg_WakeedUpAgent,	"The agent process for a given agent ID is waked up"},
    {HuiGMsg_SleepAgent,	"The agent process for a given agent ID is slept"},
    {NULL,		NULL},
};

/*
 * Table for errno vs. HuiErrorMsgInfo
 */
HuiErrno2EMsgTypeTbl err2eMsgTbl[] = {
	{EPERM,		NULL},	/* Not owner */
	{ENOENT,	HuiEMsg_NotFindAgentProcess},
	{ESRCH,		NULL},	/* No such process */
	{EINTR,		NULL},	/* Interrupted system call */
	{EIO,		NULL},	/* I/O error */
	{ENXIO,		NULL},	/* No such device or address */
	{E2BIG,		NULL},	/* Arg list too long */
	{ENOEXEC,	NULL},	/* Exec format error */
	{EBADF,		NULL},	/* Bad file number */
	{ECHILD,	NULL},	/* No children */
	{EAGAIN,	HuiEMsg_NotSendForFullQueue},
	{ENOMEM,	HuiEMsg_NotEnoughMemory},
	{EACCES,	NULL},	/* Permission denied */
	{EFAULT,	NULL},	/* Bad address */
	{ENOTBLK,	NULL},	/* Block device required */
	{EBUSY,		NULL},	/* Mount device busy */
	{EEXIST,	NULL},	/* File exists */
	{EXDEV,		NULL},	/* Cross-device link */
	{ENODEV,	NULL},	/* No such device */
	{ENOTDIR,	NULL},	/* Not a directory*/
	{EISDIR,	NULL},	/* Is a directory */
	{EINVAL,	NULL},	/* Invalid argument */
	{ENFILE,	NULL},	/* File table overflow */
	{EMFILE,	NULL},	/* Too many open files */
	{ENOTTY,	NULL},	/* Not a typewriter */
	{ETXTBSY,	NULL},	/* Text file busy */
	{EFBIG,		NULL},	/* File too large */
	{ENOSPC,	NULL},	/* No space left on device */
	{ESPIPE,	NULL},	/* Illegal seek */
	{EROFS,		NULL},	/* Read-only file system */
	{EMLINK,	NULL},	/* Too many links */
	{EPIPE,		NULL},	/* Broken pipe */

	   /* math softwRE */
	{EDOM,		NULL},	/* ARGUMENT TOO LARGE */
	{ERANGE,	NULL},	/* RESULT TOO LARGE */

	   /* NON-BLOCKING AND INTERRUPT I/O */
	{EWOULDBLOCK,	NULL},	/* OPERATION WOULD BLOCK */
	{EINPROGRESS,	NULL},/* OPERATION NOW IN PROGRESS */
	{EALREADY,	NULL},	/* OPERATION ALREADY IN PROGRESS */
	   /* IPC/NETWORK SOFTWARE */

	   /* ARGUMENT ERRORS */
	{ENOTSOCK,	NULL},	/* SOCKET OPERATION ON NON-SOCKET */
	{EDESTADDRREQ,	NULL},	/* DESTINATION ADDRESS REQUIRED */
	{EMSGSIZE,	NULL},	/* MESSAGE TOO LONG */
	{EPROTOTYPE,	NULL},	/* PROTOCOL WRONG TYPE FOR SOCKET */
	{ENOPROTOOPT,	NULL},	/* PROTOCOL NOT AVAILABLE */
	{EPROTONOSUPPORT,	NULL},	/* PROTOCOL NOT SUPPORTED */
	{ESOCKTNOSUPPORT,	NULL},	/* SOCKET TYPE NOT SUPPORTED */
	{EOPNOTSUPP,	NULL},	/* OPERATION NOT SUPPORTED ON SOCKET */
	{EPFNOSUPPORT,	NULL},	/* PROTOCOL FAMILY NOT SUPPORTED */
	{EAFNOSUPPORT,	NULL},	/* ADDRESS FAMILY NOT SUPPORTED BY PROTOCOL FAMILY */
	{EADDRINUSE,	NULL},	/* ADDRESS ALREADY IN USE */
	{EADDRNOTAVAIL,	NULL},	/* CAN'T ASSIGN REQUESTED ADDRESS */

	   /* OPERATIONAL ERRORS */
	{ENETDOWN,	NULL},	/* NETWORK IS DOWN */
	{ENETUNREACH,	NULL},	/* NETWORK IS UNREACHABLE */
	{ENETRESET,	NULL},	/* NETWORK DROPPED CONNECTION ON RESET */
	{ECONNABORTED,	NULL},	/* SOFTWARE CAUSED CONNECTION ABORT */
	{ECONNRESET,	NULL},	/* CONNECTION RESET BY PEER */
	{ENOBUFS,	NULL},	/* NO BUFFER SPACE AVAILABLE */
	{EISCONN,	NULL},	/* SOCKET IS ALREADY CONNECTED */
	{ENOTCONN,	NULL},	/* SOCKET IS NOT CONNECTED */
	{ESHUTDOWN,	NULL},	/* CAN'T SEND AFTER SOCKET SHUTDOWN */
	{ETOOMANYREFS,	NULL},	/* TOO MANY REFERENCES: CAN'T SPLICE */
	{ETIMEDOUT,	HuiEMsg_ConnectionTimedOut},
	{ECONNREFUSED,	HuiEMsg_ConnectionRefused},

	   /* */
	{ELOOP,	NULL},	/* TOO MANY LEVELS OF SYMBOLIC LINKS */
	{ENAMETOOLONG,	NULL},	/* FILE NAME TOO LONG */

	   /* SHOULD BE REARRANGED */
	{EHOSTDOWN,	NULL},	/* HOST IS DOWN */
	{EHOSTUNREACH,	NULL},	/* NO ROUTE TO HOST */
	{ENOTEMPTY,	NULL},	/* DIRECTORY NOT EMPTY */

	   /* QUOTAS & MUSH */
	{EPROCLIM,	NULL},	/* TOO MANY PROCESSES */
	{EUSERS,	NULL},	/* TOO MANY USERS */
	{EDQUOT,	NULL},	/* DISC QUOTA EXCEEDED */

	   /* NETWORK FILE SYSTEM */
	{ESTALE,	NULL},	/* STALE NFS FILE HANDLE */
	{EREMOTE,	NULL},	/* TOO MANY LEVELS OF REMOTE IN PATH */

	   /* STREAMS */
	{ENOSTR,	NULL},	/* DEVICE IS NOT A STREAM */
	{ETIME,		NULL},	/* TIMER EXPIRED */
	{ENOSR,		NULL},	/* OUT OF STREAMS RESOURCES */
	{ENOMSG,	NULL},	/* NO MESSAGE OF DESIRED TYPE */
	{EBADMSG,	NULL},	/* Trying to read unreadable message */

	   /* SystemV IPC */
	{EIDRM,		NULL},	/* Identifier removed */

	   /* SystemV Record Locking */
	{EDEADLK,	NULL},	/* Deadlock condition. */
	{ENOLCK,	NULL},	/* No record locks available. */

	   /* RFS */
	{ENONET,	NULL},	/* Machine is not on the network */
	{ERREMOTE,	NULL},	/* Object is remote */
	{ENOLINK,	NULL},	/* the link has been severed */
	{EADV,		NULL},	/* advertise error */
	{ESRMNT,	NULL},	/* srmount error */
	{ECOMM,		NULL},	/* Communication error on send */
	{EPROTO,	NULL},	/* Protocol error */
	{EMULTIHOP,	NULL},	/* multihop attempted */
	{EDOTDOT,	NULL},	/* Cross mount point (not an error) */
	{EREMCHG,	NULL},	/* Remote address changed */

	   /* POSIX */
	{ENOSYS,	NULL},	/* function not implemented */

	   /* Multi-byte character library problems */
	{EILSEQ,	NULL},	/* Illegal byte sequence. */

	{NULL,		NULL},	/* end of HuiErrno2EMsgTypeTbl */
       };

/*
 *  errno.h $B$GDj5A$5$l$F$$$k(B error code $B$r(B
 *  HuiErrorMsgType $B$XJQ49$9$k!#(B
 */
HuiErrorMsgType huiCnvErrno2EMsgType(errnoCode)
    int	errnoCode;
{
    HuiErrno2EMsgTypeTbl *currTbl;

    if (errnoCode < 0) errnoCode *= -1;

    for (currTbl = err2eMsgTbl; currTbl->errno != NULL; currTbl++) {
	if (currTbl->errno == errnoCode) {
	    return currTbl->type;
	}
    }
    return NULL;
}

/*
 *	$B%(%i!<!&%a%C%;!<%8I=<(4X?t(B
 */
void huiPutsErrorMsg(msgType)
    HuiErrorMsgType	msgType;
{
    char	*msg;

    if ((msg = huiGetErrorMsg(msgType)) != NULL) {
	huiPrintf("%s.\n", msg);
    }
}

/*
 *  $B%(%i!<!&%a%C%;!<%8!&%3!<%I$+$i%(%i!<!&%a%C%;!<%8$r(B
 *  $B3MF@$9$k4X?t(B
 */
char *huiGetErrorMsg(msgType)
    HuiErrorMsgType	msgType;
{
    HuiErrorMsgInfo	*hhuiErrorMsgInfo;

    if (msgType != NULL) {
	for (hhuiErrorMsgInfo = &huiErrorMsgInfo[0]
	     ; hhuiErrorMsgInfo->msg != NULL
	     ; ++hhuiErrorMsgInfo) {

	    if (hhuiErrorMsgInfo->type == msgType) {
		return hhuiErrorMsgInfo->msg;
	    }
	}
    }

    return NULL;
}

/*
 *	$B%o!<%K%s%0!&%a%C%;!<%8I=<(4X?t(B
 */
HuiBoolean huiPutsWarningMsg(msgType)
    HuiWarningMsgType	msgType;
{
    HuiWarningMsgInfo	*hhuiWarningMsgInfo;

    if (msgType == NULL)
      return HuiFuzzy;

    for (hhuiWarningMsgInfo = &huiWarningMsgInfo[0]
	 ; hhuiWarningMsgInfo->msg != NULL
	 ; ++hhuiWarningMsgInfo) {
	if (hhuiWarningMsgInfo->type == msgType) {
	    return huiAskYesNo(hhuiWarningMsgInfo->msg);
	}
    }

    return HuiFuzzy;
}

HuiYesNoStrList huiYesNoStrList[] = {
    {"yes",	3,	HuiTrue},
    {"YES",	3,	HuiTrue},
    {"Yes",	3,	HuiTrue},
    {"y",	1,	HuiTrue},
    {"Y",	1,	HuiTrue},
    {"no",	2,	HuiFalse},
    {"NO",	2,	HuiFalse},
    {"No",	2,	HuiFalse},
    {"n",	1,	HuiFalse},
    {"N",	1,	HuiFalse},
    {NULL,	0,	NULL},
};

/*
 *	Yes/No $BF~NO5Z$S3NG'4X?t(B
 */
HuiBoolean huiAskYesNo(msg)
    char		*msg;
{
    HuiYesNoStrList	*currList;
    int			len;
    HuiText		inputBuf;

    for (;;) {
	huiPrintf("%s <yes/no> ? ", msg);

	len = 0;

	while (len == 0) {
	    gets(inputBuf);
	    len = strlen(inputBuf);
	}

	if (HuiLogFd)
	  fputs(inputBuf, HuiLogFd);

	for (currList = huiYesNoStrList; currList->msg != NULL; currList++) {
	    if (len == currList->len && strcmp(inputBuf, currList->msg) == 0) {
		return currList->retValue;
	    }
	}
    }
    return HuiFuzzy;
}

/*
 *	puts good message
 */
void huiPutsGoodMsg(msgType)
    HuiGoodMsgType	msgType;
{
    HuiGoodMsgInfo	*hhuiGoodMsgInfo;

    for (hhuiGoodMsgInfo = &huiGoodMsgInfo[0]; hhuiGoodMsgInfo->msg != NULL; ++hhuiGoodMsgInfo) {
	if (hhuiGoodMsgInfo->type == msgType) {
	    huiPrintf("%s.\n", hhuiGoodMsgInfo->msg);
	    break;
	}
    }
}


static char *huiPerrorFrmt = "system error (%d) : %s\n";

/* =======================================
 *	system error handle function
 * ======================================= */
void HuiPerror()
{
    huiPrintf(huiPerrorFrmt, errno, sys_errlist[errno]);
}

/* =================================
 *   common output functions
 * ================================= */
void huiPutsStr(msg)
    char	*msg;
{
    if (msg != NULL) {
	fputs(msg, stderr);

	if (HuiLogFd)
	  fputs(msg, HuiLogFd);
    }
}

void huiPrintf(va_alist)
    va_dcl
{
    va_list args;
    char *fmt;
    
    va_start(args);

    fmt = va_arg(args, char *);

    vfprintf(stderr, fmt, args);

    if (HuiLogFd)
      vfprintf(HuiLogFd, fmt, args);

    va_end(args);
}
