/* huiMemory.c;
 *	Helios User Interface; 
 *		memory hadle module for helios user interface commands
 *		created on July 1st, 1994.
 *
 *	modification history:
 *	(1) add HuiFreeMsgManageInfo(),
 *		on October 25th, 1994.
 *
 * $Id: huiMemory.c,v 1.6 1994/11/25 06:35:21 k3sato Exp $
 */

#include <stdio.h>
#include <malloc.h>
#include <memory.h>

#include "helios.h"
#include "huiMessage.h"
#include "huiMemory.h"


/* =======================================
 *	Memory manipulation functions
 * ======================================= */
void *HuiMalloc(size)
    int			size;
{
    void		*ptr;
    HuiErrorMsgType	eMsgType;

    if (size > 0) {
	if ((ptr = malloc(size)) == NULL) {
	    eMsgType = HuiEMsg_MallocError;
	    goto Error_Rtn;
	}
    } else {
	eMsgType = HuiEMsg_SizeZeroMalloc;
	goto Error_Rtn;
    }

    memset(ptr, 0, size);

    return ptr;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return NULL;
}

char *HuiMallocString(string)
    char		*string;
{
    int			size;
    void		*ptr;
    HuiErrorMsgType	eMsgType;

    if (string == NULL) {
	eMsgType = HuiEMsg_NullPointer;
	goto Error_Rtn;
    }

    size = strlen(string) + 1;

    if (size > HuiStringLength_Lim) {
	eMsgType = HuiEMsg_StringLenLimitOver;
	goto Error_Rtn;
    }

    if ((ptr = HuiMalloc(size)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocError;
	goto Error_Rtn;
    }

    strcpy(ptr, string);

    return ptr;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return NULL;
}

/* =============================
 *  functions to free memory
 * ============================= */
void HuiFreeMsgManageInfo(hMsgManageInfoP)
    HHuiMsgManageInfo	*hMsgManageInfoP;
{
    HHuiMsgManageInfo	msgManageInfo;

    if (hMsgManageInfoP == NULL || (msgManageInfo = *hMsgManageInfoP) == NULL) return;

    HuiFreeString(&(msgManageInfo->msgID));
    HuiFreeString(&(msgManageInfo->fromAid));
    HuiFreeString(&(msgManageInfo->toAid));
    HuiFreeString(&(msgManageInfo->funcName));
    HuiFreeString(&(msgManageInfo->processName));
    HuiFreeString(&(msgManageInfo->method));
    HuiFreeString(&(msgManageInfo->methodArg));
    HuiFreeString(&(msgManageInfo->msgStatus));
    HuiFreeString(&(msgManageInfo->replyMsg));

    HuiFree(msgManageInfo);
    *hMsgManageInfoP = NULL;
}

void HuiFreeUserInfo(hUserInfoP)
    HAgentInfo		*hUserInfoP;
{
    HAgentInfo		userInfo;

    if (hUserInfoP == NULL || (userInfo = *hUserInfoP) == NULL) return;

    HuiFreeString(&(userInfo->agentId));
    HuiFreeString(&(userInfo->agentName));
    HuiFreeString(&(userInfo->sockInfo.hostName));

    HuiFree(userInfo);
    *hUserInfoP = NULL;
}

void HuiFreeAgentInfo(hAgentInfoP)
    HAgentInfo	*hAgentInfoP;
{
    HAgentInfo	agentInfo;

    if (hAgentInfoP == NULL || (agentInfo = *hAgentInfoP) == NULL) return;

    HuiFreeString(&(agentInfo->agentId));
    HuiFreeString(&(agentInfo->agentPath));
    HuiFreeString(&(agentInfo->agentName));
    HuiFreeString(&(agentInfo->sockInfo.hostName));

    HuiFree(agentInfo);
    *hAgentInfoP = NULL;
}

void HuiFreeString(strP)
    char	**strP;
{
    if (strP != NULL) {
	HuiFree(*strP);
	*strP = NULL;
    }
}

void HuiFree(ptr)
    void	*ptr;
{
    if (ptr != NULL) {
	free(ptr);
    }
}
