/* huiKeyWord.h;
 *	a Header for huiKeyWord.c; key word handle module for Helios User Interface
 *		created on July 1st, 1994.
 *
 *	modification history:	
 *	(1) add HuiKW_MsgId, HuiKW_MsgStatus in HuiKeyWordType,
 *		on October 28th in '94.
 *
 * $Id: huiKeyWord.h,v 1.4 1995/03/02 09:25:11 k3sato Exp $
 */

typedef enum {
    HuiKW_NotUsed,
    HuiKW_To,
    HuiKW_Msg,
    HuiKW_Equal,

    HuiKW_MsgId,
    HuiKW_MsgStatus,

    HuiKW_Off = 10,
    HuiKW_On,

    HuiKW_All = 20,

} HuiKeyWordType;

typedef struct _HuiKeyWordList	*HHuiKeyWordList;

typedef struct _HuiKeyWordList {
    char		*keyWord;
    int			len;
    HuiKeyWordType	type;
} HuiKeyWordList;


HuiKeyWordType huiGetKeyWord();
HuiKeyWordType huiCheckKeyWord();

HuiBoolean huiJudgeKeyWord();

extern HuiKeyWordList HuiSendKeyWordList[];
extern HuiKeyWordList HuiReplyKeyWordList[];
extern HuiKeyWordList HuiOnOffKeyWordList[];
extern HuiKeyWordList HuiAllKeyWordList[];
