/* huiKeyWord.c;
 *	Key word handle module for Helios User Interface
 *		created on July 1st, 1994.
 *
 *	modification history:	
 *	(1) add HuiKeyWordList HuiReplyKeyWordList[]
 *		on October 28th in '94.
 *
 * $Id: huiKeyWord.c,v 1.6 1995/03/02 09:25:11 k3sato Exp $
 */

#include <stdio.h>

#include "helios.h"
#include "huiMessage.h"
#include "huiCommon.h"
#include "huiKeyWord.h"

HuiKeyWordList HuiSendKeyWordList[] = {
    {"TO",	2,	HuiKW_To},
    {"To",	2,	HuiKW_To},
    {"to",	2,	HuiKW_To},
    {"MSG",	3,	HuiKW_Msg},
    {"Msg",	3,	HuiKW_Msg},
    {"msg",	3,	HuiKW_Msg},
    {"=",	1,	HuiKW_Equal},	
    {NULL,	0,	NULL},
};

HuiKeyWordList HuiReplyKeyWordList[] = {
    {"mid",	3,	HuiKW_MsgId},
    {"mId",	3,	HuiKW_MsgId},
    {"mID",	3,	HuiKW_MsgId},
    {"MID",	3,	HuiKW_MsgId},
    {"status",	6,	HuiKW_MsgStatus},
    {"Status",	6,	HuiKW_MsgStatus},
    {"STATUS",	6,	HuiKW_MsgStatus},
    {"msg",	3,	HuiKW_Msg},
    {"Msg",	3,	HuiKW_Msg},
    {"MSG",	3,	HuiKW_Msg},
    {"=",	1,	HuiKW_Equal},	
    {NULL,	0,	NULL},
};

HuiKeyWordList HuiOnOffKeyWordList[] = {
    {"ON",	2,	HuiKW_On},
    {"On",	2,	HuiKW_On},
    {"on",	2,	HuiKW_On},
    {"OFF",	3,	HuiKW_Off},
    {"Off",	3,	HuiKW_Off},
    {"off",	3,	HuiKW_Off},
    {NULL,	0,	NULL},
};

HuiKeyWordList HuiAllKeyWordList[] = {
    {"all",	3,	HuiKW_All},
    {"All",	3,	HuiKW_All},
    {"ALL",	3,	HuiKW_All},
    {NULL,	0,	NULL},
};

HuiKeyWordType huiGetKeyWord(kwList)
    HuiKeyWordList	kwList[];
{
    HuiWordType		wtype;
    HuiWord		wordBuf;

    wtype = huiGetWord(wordBuf);
    if (wtype != HuiWT_String
	&& wtype != HuiWT_OneChar
	&& wtype != HuiWT_Delimit) {
	goto Error_Rtn;
    }

    return huiCheckKeyWord(kwList, wordBuf);

 Error_Rtn:
    huiPutsErrorMsg(HuiEMsg_NotExistKeyWord);
    return HuiKW_NotUsed;
}

HuiKeyWordType huiCheckKeyWord(kwList, str)
    HuiKeyWordList	kwList[];
    char		*str;
{
    int			len;

    len = strlen(str);

    for (; kwList->len > 0 ; kwList++) {
	if (len == kwList->len
	    && strcmp(str, kwList->keyWord) == 0) {
	    return kwList->type;
	}
    }

    huiPutsErrorMsg(HuiEMsg_NotAppropriateKeyWord);
    return HuiKW_NotUsed;
}

HuiBoolean huiJudgeKeyWord(kwList, str)
    HuiKeyWordList	kwList[];
    char		*str;
{
    int			len;

    len = strlen(str);

    for (; kwList->len > 0 ; kwList++) {
	if (len == kwList->len
	    && strcmp(str, kwList->keyWord) == 0) {
	    return HuiTrue;
	}
    }

    return HuiFalse;
}
