/* huiDebugInfo.c
 *	program to handle the debug Info from agent
 *		created on November 22th in 94.
 *
 * $Id: huiDebugInfo.c,v 1.2 1994/12/01 10:15:01 k3sato Exp $
 */

#include <stdio.h>

#include "helios.h"
#include "huiMessage.h"
#include "huiMemory.h"

/* defined in huiMAccess.c
 */
extern HuiBoolean huiSendMsg2Monitor();
extern HuiBoolean huiReceiveMsgFromMonitor();
extern HuiBoolean huiSetupTraceSpeedFromMsg();

#ifdef _DEBUG_DbgInfo

char *dreceive() {
    return NULL;
}

#else

/* not defined
 */
extern char *dreceive();

#endif  /* _DEBUG_DbgInfo */

HuiBoolean huiSendDbgInfo2Monitor();


HuiBoolean huiHandleDbgInfoFromAgent(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    char		*dbgInfo;
    HuiText		msgBuf;
    HuiErrorMsgType	eMsgType;

    if ((dbgInfo = dreceive()) != NULL) {

	if (hAccessInfo->monitor.state == HuiOn) {
	    while (hAccessInfo->monitor.traceSpeed == 0) {
		if (huiReceiveMsgFromMonitor(hAccessInfo, msgBuf) == HuiFalse) {
		    huiPutsErrorMsg(HuiEMsg_ReceiveMsgFromMonitorError);
		    /*	clear buffer between UI and Monitor
		     */
		    break;
		}
		if (huiSetupTraceSpeedFromMsg(hAccessInfo, msgBuf) == HuiFalse) {
		    /*	clear buffer between UI and Monitor
		     */
		}
	    }

	    if (huiSendDbgInfo2Monitor(hAccessInfo, dbgInfo) == HuiFalse) {
		huiPutsErrorMsg(HuiEMsg_SendDbgInfo2MonitorError);
	    }
	} else {
	    huiPrintf("<< debug info from agent >>\n%s\n", dbgInfo);
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * $B%G%P%C%0!&%a%C%;!<%8$r(B monitor $B$KAw$k(B
 */
HuiBoolean huiSendDbgInfo2Monitor(hAccessInfo, dbgInfo)
    HHuiAccessInfo	hAccessInfo;
    char		*dbgInfo;
{
    HuiMonMsgType	monMsgType;
    HuiRecvBuf		msgBuf;
    int			traceSpeed;
    HuiErrorMsgType	eMsgType;
    char		*ret;

    ret = sprintf(msgBuf, "%d\n%s\n", HuiMonMsg_DebugInfo, dbgInfo);
    if (ret == NULL) {
	eMsgType = HuiEMsg_SprintfError;
	goto Error_Rtn;
    }

    if (huiSendMsg2Monitor(hAccessInfo, msgBuf) == HuiFalse) {
	eMsgType = HuiEMsg_SendMsg2MonitorError;
	goto Error_Rtn;
    }

    if (huiReceiveMsgFromMonitor(hAccessInfo, msgBuf) == HuiFalse) {
	eMsgType = HuiEMsg_ReceiveMsgFromMonitorError;
	goto Error_Rtn;
    }

    huiPrintf("received data from monitor:\n\t%s\n", msgBuf);

    if (huiSetupTraceSpeedFromMsg(hAccessInfo, msgBuf) == HuiFalse) {
	if (huiGetMonMsgType(hAccessInfo, msgBuf, &monMsgType) == HuiFalse) {
	    eMsgType = HuiEMsg_GetMonMsgTypeError;
	    goto Error_Rtn;
	}

	if (monMsgType != HuiMonMsg_WaitForMsgFromUI) {
	    eMsgType = HuiEMsg_ErrorInMonitor;
	    goto Error_Rtn;
	}
    }

    traceSpeed = hAccessInfo->monitor.traceSpeed;

    if (traceSpeed > 0) {
	if (traceSpeed < 10) {
	    traceSpeed = 10 - traceSpeed;
	    sleep(traceSpeed);
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}
