/* huiCmdAnalysis.c;
 *	Helios User Interface;
 *		command List and command analysis module
 *
 *		created on June 9th in '94.
 *
 *	modification history:	
 *	(1) add "gui" command
 *		on September 1st in '94.
 *	(2) add "wake" command
 *		on September 16th in '94.
 *	(3) add event handler of comm
 *		and handle the event of receive_a_message
 *		on September 26th, 1994.
 *	(4) add "sleep" and "reset" command
 *		on October 11th in '94.
 *	(5) add "para_agent" command
 *		on November 11th in '94.
 *
 * $Id: huiCmdAnalysis.c,v 2.0 1995/03/02 09:24:49 k3sato Exp $
 */
#include <stdio.h>

#include <helios/event.h>
#include "helios.h"
#include "huiMessage.h"
#include "huiTLevel.h"
#include "huiALevel.h"
#include "huiCommon.h"
#include "huiMemory.h"

/* defined in helios.c
 */
extern FILE	*HuiLogFd;

/* defined in huiDebugInfo.c
 */
extern HuiBoolean huiHandleDbgInfoFromAgent();

/* defined in huiAAccess.c
 */
extern HuiBoolean huiMsgReceiveFromAgent();


int	HuiCmdLine = 0;

static char	*HuiTopLevelPrompt = "helios" ;
char	*HuiUnknownCmdFrmt = "'%s' is a unknown command.";

HuiCmdList tlCmdList[] = {
    {"show_all_agents",	15,	HuiTL_SHOW_AllAgents,	huiTlShowAllAgents,
       "show_all_agents",
       "show all available agents"},
/*
    {"show_active_agents",18,	HuiTL_SHOW_ActiveAgents,	huiTlShowActiveAgents,
       "show_active_agents",
       "show all active agents"},
*/
    {"show_functions",	14,	HuiTL_SHOW_Functions,	huiTlShowFunctions,
       "show_functions <agent>",
       "show the functions of <agent>"},
    {"show_methods",	12,	HuiTL_SHOW_Methods,	huiTlShowMethods,
       "show_methods <agent>",
       "show all methods of <agent>"},
/*
    {"show_structure",	14,	HuiTL_SHOW_Structure,	huiTlShowStructure,
       "show_structure <agent>",
       "show the structure of <agent>"},
    {"show_location",	13,	HuiTL_SHOW_Location,	huiTlShowLocation,
       "show_location <agent>",
       "show the physical map of <agent>"},
    {"show_status",	11,	HuiTL_SHOW_Status,	huiTlShowStatus,
       "show_status <agent>",
       "show the current status of <agent>"},
*/
    {"para_agent",	10,	HuiTL_ParaAgent,	huiTlParaAgent,
       "para_agent <template agnet name> <agent name>( [ <argument list> ] )\n\
\t[{ <agent name>( [ <argument list> ] ) }]",
	 "\t<argument list> := <argument> [{ , <argument> }]\n\
\t\t<argument> := <alpha-numeric> | \"<string>\"\n\
\tcreate parametric instance agents"},
    {"connect",		7,	HuiTL_CONNECT,		huiTlConnect,
       "connect <agent>",
       "connect to an agent named <agent>"},
    {"mtrace",		6,	HuiTL_MTRACE,		huiTlMTrace,
       "mtrace {ON | OFF}",
       "message trace flag ON or OFF"},
    {"atrace",		6,	HuiTL_ATRACE,		huiTlATrace,
       "atrace <agent>, {ON | OFF}",
       "agent trace flag ON or OF to an agent named <agent>"},
/*
    {"kill",		4,	HuiTL_KILL,		huiTlKill,
       "kill <agent>",
       "kill the process of <agent>"},
*/
    {"bye",		3,	HuiTL_BYE,		huiTlBye,
       "bye",
       "exit Helios"},
    {"help",		4,	HuiTL_HELP,		huiTlHelp,
       "help [<command name>]",
       "Help messages of all commands in the top session are shown.\n\
If a <command name> is given, help message of the command is shown."},
/*
    {"gui",	3,	HuiTL_GUI,	huiTlGui,
       "gui <agent>",
       "start the gui program for an agent named <agent>"},
    {"send",	4,	HuiTL_SEND,	huiTlSend,
       "send",
       "send to nQueen"},
    {"receive",	4,	HuiTL_RECEIVE,	huiTlReceive,
       "receive",
       "receive from nQueen"},
*/
    {NULL,	0,	NULL,	NULL,	NULL,	NULL},
};

HuiCmdList alCmdList[] = {
    {"show_functions",	14,	HuiAL_SHOW_Functions,	huiAlShowFunctions,
       "show_functions",
       "show the functions of the current agent"},
    {"show_methods",	12,	HuiAL_SHOW_Methods,	huiAlShowMethods,
       "show_methods",
       "show all methods of the current agent"},
/*
    {"show_structure",	14,	HuiAL_SHOW_Structure,	huiAlShowStructure,
       "show_structure",
       "show the structure of the current agent"},
    {"show_location",	13,	HuiAL_SHOW_Location,	huiAlShowLocation,
       "show_location",
       "show the physical map of the current agent"},
    {"show_status",	11,	HuiAL_SHOW_Status,	huiAlShowStatus,
       "show_status [<agent>]",
       "show the current status of the current agent"},
*/
    {"top",		3,	HuiAL_TOP,		huiAlTop,
       "top",
       "quit current agent and connect to the daemon"},
    {"bye",		3,	HuiAL_BYE,		huiAlBye,
       "bye",
       "exit Helios"},
    {"wake",		4,	HuiAL_WAKE,		huiAlWake,
       "wake <Agent ID>",
       "start the agent process for a given <Agent ID>"},
    {"sleep",		5,	HuiAL_SLEEP,		huiAlSleep,
       "sleep <Agent ID>",
       "kill the agent process for a given <Agent ID>"},
    {"send",		4,	HuiAL_SEND,		huiAlSend,
       "send [to = <To> ,] msg = <message>",
       "<To> ::= | <function name> |\n\t\t | { <function name>, <process name> } |\n\
\t\t | <function name> : <method name> |\n\
\t<message> ::= <method name>(<argument>-list(,))\n\n\
\tsend <message> to the current agent"},
    {"receive",		7,	HuiAL_RECEIVE,		huiAlReceive,
       "receive [<message ID> | all]",
       "receive a return message of <message ID> and show the message.\n\
\tif no <message ID>, show the current received message"},
    {"reply",		5,	HuiAL_REPLY,		huiAlReply,
       "reply [mid = <message ID>,] [status = <message status>,] msg = <reply message>",
       "send a <reply message> with <message status> for ASK message of <message ID> from agent"},
    {"show_msg",	8,	HuiAL_SHOW_Msg,		huiAlShowMsg,
       "show_msg",
       "show message ID sended to the current agent"},
/*
    {"cancel",		6,	HuiAL_CANCEL,		huiAlCancel,
       "cancel [<message ID>]",
       "cancel the message of <message ID>"},
*/
    {"mtrace",		6,	HuiAL_MTRACE,		huiAlMTrace,
       "mtrace {ON | OFF}",
       "message trace flag ON or OFF"},
    {"atrace",		6,	HuiAL_ATRACE,		huiAlATrace,
       "atrace [<agent>,] {ON | OFF}",
       "agent trace flag ON or OF to an agent named <agent>"},
    {"log",		3,	HuiAL_LOG,		huiAlLog,
       "log <file_name>",
       "switch the message-log-mode\n(output all messages into <file_name>)"},
    {"monitor",		7,	HuiAL_MONITOR,		huiAlMonitor,
       "monitor",
       "display the status of activities visually"},
/*
    {"reset",		5,	HuiAL_RESET,		huiAlReset,
       "reset",
       "reset the connected agent"},
*/
    {"test_trace",	10,	HuiAL_TEST_Trace,	huiAlTestTrace,
       "test_trace [ <file name> ]",
       "test command of message trace.\n\
get message trace string data from a file named <file name>,\n\
and send the data to monitor"},

    {"help",		4,	HuiAL_HELP,		huiAlHelp,
       "help [<command name>]",
       "Help messages of all commands in this session are shown.\n\
If a <command name> is given, help message of the command is shown"},

    {NULL,	0,	NULL,	NULL,	NULL,	NULL},
};

HuiCmdList *huiGetCmd(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    int		eventType;
    int		eventFd;
    HHuiCmdList	cmdList;
    HHuiCmdList	currCmdList;
    HuiWord	cmd;
    int		cmd_len;
    HuiWordType	wtype;
    char	*prompt;

    if (hAccessInfo->level == HuiAccess2TopLevel) {
	prompt = HuiTopLevelPrompt;
	cmdList = tlCmdList;
    } else {
	prompt = hAccessInfo->agentName;
	cmdList = alCmdList;
    }

    for (;;) {
	HuiCmdLine = 1;
	eventType = NULL;

	while(eventType != EVENT_IO_READY || eventFd != 0){
	    huiPrintf("\n%s> ", prompt);
	    fflush(stdout);

	    eventType = select_event(&eventFd);
	    switch(eventType){
	    case EVENT_IO_READY:    /* stdin $B$+$i$N%G!<%?<u?.%$%Y%s%H$NH/@8(B */
		if (eventFd != 0) {
		    huiPrintf("\na event has happend, but not stdin.\n");
		}
		continue;

	    case EVENT_MESSAGE_RECEIVE_READY: /* $BDL?.It$K$h$k<u?.%$%Y%s%H$NH/@8(B */
		if (huiMsgReceiveFromAgent(hAccessInfo) == HuiFalse) {
		    huiPutsErrorMsg(HuiEMsg_HuiMsgReceiveFromAgentError);
		}
		continue;

	    case EVENT_DEBUG:
		if (huiHandleDbgInfoFromAgent(hAccessInfo) == HuiFalse) {
		    huiPutsErrorMsg(HuiEMsg_HandleDbgInfoFromAgentError);
		}
		continue;

	    default:	/* EVENT_MESSAGE_SEND_READY, EVENT_EXIT, etc */
		break;
	    }
	}

	wtype = huiGetWord(cmd);

	switch(wtype) {
	case HuiWT_OneChar:
	case HuiWT_String:
	    cmd_len = strlen(cmd);
	    for (currCmdList = cmdList; currCmdList->len > 0; currCmdList++) {
		if ((cmd_len == currCmdList->len)
		    && huiStrCmp(cmd, currCmdList->cmd) == HuiTrue) {
		    return currCmdList;
		}
	    }
	    huiPrintf(HuiUnknownCmdFrmt, cmd);
	    huiSkipToNextStmt();
	    continue;

	case HuiWT_Delimit:
	    if (cmd[0] != HuiChar_CR) {
		huiPrintf(HuiUnknownCmdFrmt, cmd);
		huiSkipToNextStmt();
	    }
	    continue;

	case HuiWT_TooLongWordError:
	    huiPrintf("%s is a too long command.", cmd);
	    huiSkipToNextStmt();
	    continue;

	case HuiWT_NullString:
	case HuiWT_EOF:
	    clearerr(stdin);
	case HuiWT_SystemError:
	    goto Error_Rtn;
	}
    }
    
 Error_Rtn:

    return NULL;
}
