/* huiAgentInfo.c
 *	program to handle the struct _AgentInfo for helios
 *		created on November 4th in 94.
 *
 * $Id: huiAgentInfo.c,v 2.1 1995/03/02 09:25:11 k3sato Exp $
 */

#include <stdio.h>

#include "helios.h"
#include "huiAgentInfo.h"
#include "huiMAccess.h"
#include "huiMessage.h"
#include "huiMemory.h"
#include "huiCommon.h"

static void huiPutsOneFuncDir();

/*
 *	Search AgentInfo for agentName
 *	from allAgentInfo
 */
HAgentInfo huiSearchAgentInfo(allAgents, agentName)
    HAgentInfo		allAgents;
    char		*agentName;
{
    for (; allAgents != NULL
	 ; allAgents = allAgents->next) {
	if (strcmp(allAgents->agentName, agentName) == 0) {
	    return allAgents;
	}
    }

    return NULL;
}

/*
 *	Search AgentInfo for agentName
 *	of parametric agent
 */
HAgentInfo huiSearchParaAgentInfo(allAgents, agentName)
    HAgentInfo		allAgents;
    char		*agentName;
{
    HAgentInfo		paraAgent;

    for (; allAgents != NULL
	 ; allAgents = allAgents->next) {
	if ((paraAgent = huiSearchAgentInfo(allAgents->child, agentName))
	    != NULL) {
	    return paraAgent;
	}
    }

    return NULL;
}

/*
 *	Search AgentInfo for agentId
 *	from allAgentInfo
 */
HAgentInfo huiSearchAgentInfoForId(allAgents, agentId)
    HAgentInfo		allAgents;
    char		*agentId;
{
    for (; allAgents != NULL
	 ; allAgents = allAgents->next) {
	if (strcmp(allAgents->agentId, agentId) == 0) {
	    return allAgents;
	}
    }

    return NULL;
}

/*
 *	convert agentName to agentId
 */
char *huiConvertAgentName2Id(hAccessInfo, agentName)
    HHuiAccessInfo	hAccessInfo;
    char		*agentName;
{
    HAgentInfo		hAgentInfo;
    char		*agentId;
    HuiErrorMsgType	eMsgType;

    if (agentName == NULL || *agentName == NULL) {
	eMsgType = HuiEMsg_NullPointer;
	goto Error_Rtn;
    }

    if ((hAgentInfo = huiSearchAgentInfo(hAccessInfo->allAgentInfo, agentName))
	!= NULL) {
	if ((agentId = HuiMallocString(hAgentInfo->agentId)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}

	return agentId;
    }

    eMsgType = HuiEMsg_NotDefinedAgentName;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return NULL;
}

/*
 *  Send UserInfo and AgentInfo to Monitor
 */
HuiBoolean huiSendAgentInfo2Monitor(hAccessInfo, agentInfo)
    HHuiAccessInfo	hAccessInfo;
    HAgentInfo		agentInfo;
{
    AgentInfo		tempInfo;
    HuiErrorMsgType	eMsgType;

    if (agentInfo != NULL) {

	memcpy(&tempInfo, agentInfo, sizeof(AgentInfo));
	tempInfo.next = NULL;

	if (huiSendAgentInfo2Mon_sub(hAccessInfo, &tempInfo) == HuiFalse) {
	    eMsgType = NULL;
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Send and AgentInfo's children to Monitor
 */
HuiBoolean huiSendAgentInfo2Mon_sub(hAccessInfo, agentInfo)
    HHuiAccessInfo	hAccessInfo;
    HAgentInfo		agentInfo;
{
    HuiErrorMsgType	eMsgType;

    for (; agentInfo != NULL; agentInfo = agentInfo->next) {

	if (huiWaitForAskForNextMsgFromMonitor(hAccessInfo) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToGetAskForNextMsgFromMonitor;
	    goto Error_Rtn;
	}

	if (huiSendOneAgentInfo2Monitor(hAccessInfo, HuiMonMsg_AgentInfo, agentInfo)
	    == HuiFalse) {
	    eMsgType = HuiEMsg_SendAgentInfo2MonitorFail;
	    goto Error_Rtn;
	}

	if (huiSendAgentInfo2Mon_sub(hAccessInfo, agentInfo->child) == HuiFalse) {
	    eMsgType = NULL;
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Send one HuiAgentInfo to Monitor
 */
HuiBoolean huiSendOneAgentInfo2Monitor(hAccessInfo, monMsgType, agentInfo)
    HHuiAccessInfo	hAccessInfo;
    HuiMonMsgType	monMsgType;
    HAgentInfo		agentInfo;
{
    HuiText		msgBuf;
    HuiErrorMsgType	eMsgType;

    if (huiSetupAgentInfo2Buffer(msgBuf, monMsgType, agentInfo)	== HuiFalse) {
	eMsgType = HuiEMsg_SetupAgentInfo2BufferError;
	goto Error_Rtn;
    }

    if (huiSendMsg2Monitor(hAccessInfo, msgBuf) == HuiFalse) {
	eMsgType = HuiEMsg_SendMsg2MonitorError;
	goto Error_Rtn;
    }

    if (agentInfo->procArgs != NULL) {
	if (huiWaitForAskForNextMsgFromMonitor(hAccessInfo) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToGetAskForNextMsgFromMonitor;
	    goto Error_Rtn;
	}

	if (huiSendMsg2Monitor(hAccessInfo, agentInfo->procArgs) == HuiFalse) {
	    eMsgType = HuiEMsg_SendMsg2MonitorError;
	    goto Error_Rtn;
	}
    }

    if (agentInfo->funcDir != NULL) {
	if (huiSetupFuncDirInfo2Buffer(msgBuf, HuiMonMsg_FuncDirInfo, agentInfo->funcDir)
	    == HuiFalse) {
	    eMsgType = HuiEMsg_SetupFuncDirInfo2BufferError;
	    goto Error_Rtn;
	}

	if (huiWaitForAskForNextMsgFromMonitor(hAccessInfo) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToGetAskForNextMsgFromMonitor;
	    goto Error_Rtn;
	}

	if (huiSendMsg2Monitor(hAccessInfo, msgBuf) == HuiFalse) {
	    eMsgType = HuiEMsg_SendMsg2MonitorError;
	    goto Error_Rtn;
	}
    }

    if (agentInfo->methodDir != NULL) {
	if (huiSetupMethodDirInfo2Buffer(msgBuf, HuiMonMsg_MethodDirInfo, agentInfo->methodDir)
	    == HuiFalse) {
	    eMsgType = HuiEMsg_SetupMethodDirInfo2BufferError;
	    goto Error_Rtn;
	}

	if (huiWaitForAskForNextMsgFromMonitor(hAccessInfo) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToGetAskForNextMsgFromMonitor;
	    goto Error_Rtn;
	}

	if (huiSendMsg2Monitor(hAccessInfo, msgBuf) == HuiFalse) {
	    eMsgType = HuiEMsg_SendMsg2MonitorError;
	    goto Error_Rtn;
	}
    }

    if (agentInfo->comment != NULL) {
	if (huiWaitForAskForNextMsgFromMonitor(hAccessInfo) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToGetAskForNextMsgFromMonitor;
	    goto Error_Rtn;
	}

	if (huiSendMsg2Monitor(hAccessInfo, agentInfo->comment) == HuiFalse) {
	    eMsgType = HuiEMsg_SendMsg2MonitorError;
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Setup a AgentInfo to message buffer 
 */
HuiBoolean huiSetupAgentInfo2Buffer(msgBuf, monMsgType, agentInfo)
    char		*msgBuf;
    HuiMonMsgType	monMsgType;
    HAgentInfo		agentInfo;
{
    char		*ret;
    HuiErrorMsgType	eMsgType;

    ret = sprintf(msgBuf, "%d %d %s %s %s %x %x %x %s %d %d %d %d %x %x %x %x \n",
		  monMsgType,
		  agentInfo->type,		/* HdAgentType (int) */
		  agentInfo->agentId,		/* char* */
		  agentInfo->agentPath,		/* char* */
		  agentInfo->agentName,		/* char* */
		  agentInfo->procArgs,		/* char* */
		  agentInfo->funcDir,		/* HFuncDirInfo */
		  agentInfo->methodDir,		/* HMethodDirInfo */
		  agentInfo->sockInfo.hostName,	/* char* */
		  agentInfo->sockInfo.sin_port,	/* u_short */
		  agentInfo->pid,		/* int */
		  agentInfo->status,		/* AgentStatusType (int) */
		  agentInfo->groupNum,		/* int */
		  agentInfo->comment,		/* char* */
		  agentInfo->parent,		/* pointer */
		  agentInfo->child,		/* pointer */
		  agentInfo->next		/* pointer */
		  );

    if (ret == NULL) {
	eMsgType = HuiEMsg_DestroyedDataInAgentInfo;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *	setup FuncDirInfo of AgentInfo to message buffer
 */
HuiBoolean huiSetupFuncDirInfo2Buffer(msgBuf, msgType, funcDirInfo)
    char		*msgBuf;
    HuiMonMsgType	msgType;
    HFuncDirInfo	funcDirInfo;
{
    int			length;
    int			totalLen;
    char		*currBufPtr;
    HuiErrorMsgType	eMsgType;

    sprintf(msgBuf, "%d ", msgType);

    totalLen = strlen(msgBuf);
    for (currBufPtr = msgBuf + totalLen
	 ; funcDirInfo != NULL
	 ; funcDirInfo = funcDirInfo->next, currBufPtr += length) {

	sprintf(currBufPtr, "%s %s\n",
		funcDirInfo->funcName, funcDirInfo->agentNames);

	length = strlen(currBufPtr);

	if ((totalLen += length) >= HuiTextBufLen_Lim) {
	    eMsgType = HuiEMsg_TextLenLimitOver;
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *	setup methodDirInfo of AgentInfo to message buffer
 */
HuiBoolean huiSetupMethodDirInfo2Buffer(msgBuf, msgType, methodDirInfo)
    char		*msgBuf;
    HuiMonMsgType	msgType;
    char		*methodDirInfo;	/* HMethodDirInfo	methodDirInfo; */
{
    /*
    int			length;
    int			totalLen;
    char		*currBufPtr;
    HuiErrorMsgType	eMsgType;

    sprintf(msgBuf, "%d ", msgType);

    totalLen = strlen(msgBuf);
    for (currBufPtr = msgBuf + totalLen
	 ; methodDirInfo != NULL
	 ; methodDirInfo = methodDirInfo->next, currBufPtr += length) {

	sprintf(currBufPtr, "%s ", methodDirInfo->methodName);

	length = strlen(currBufPtr);

	if ((totalLen += length) >= HuiTextBufLen_Lim) {
	    eMsgType = HuiEMsg_TextLenLimitOver;
	    goto Error_Rtn;
	}
    }
    */

    sprintf(msgBuf, "%d %s", msgType, methodDirInfo);

    return HuiTrue;

 /*
 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
 */
}

/*
 *  Wait for message HuiMonMsg_AskForNextMsg from Monitor.
 */
HuiBoolean huiWaitForAskForNextMsgFromMonitor(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    HuiMonMsgType	monMsgType;
    HuiText		msgBuf;
    HuiErrorMsgType	eMsgType;

    if (huiReceiveMsgFromMonitor(hAccessInfo, msgBuf) == HuiFalse) {
	eMsgType = HuiEMsg_ReceiveMsgFromMonitorError;
	goto Error_Rtn;
    }

    if (huiGetMonMsgType(hAccessInfo, msgBuf, &monMsgType) == HuiFalse) {
	eMsgType = HuiEMsg_GetMonMsgTypeError;
	goto Error_Rtn;
    }

    if (monMsgType != HuiMonMsg_AskForNextMsg) {
	eMsgType = HuiEMsg_IllegalMsgType;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}


static char *HeaderOfShowFunctions = "\n Function Name       Agent Names\n";

/* ===========================================
 *  Print function name of agentInfo
 * =========================================== */
void huiPutsFuncDir(funcDir)
    HFuncDirInfo	funcDir;
{
    huiPrintf(HeaderOfShowFunctions);
    huiPutsLine(60, HuiChar_EqualCode);

    for (; funcDir != NULL; funcDir = funcDir->next) {
	huiPutsOneFuncDir(funcDir);
	huiPutsLine(60, HuiChar_NULL);
    }
}

static void huiPutsOneFuncDir(funcDir)
    HFuncDirInfo	funcDir;
{
    char		*funcPtr;
    char		*agentPtr;

    funcPtr = funcDir->funcName;
    agentPtr = funcDir->agentNames;

    for (; *funcPtr != HuiChar_NULL || *agentPtr != HuiChar_NULL;) {

	huiPrintf(" %-18.18s  %-40.40s\n", funcPtr, agentPtr);

	funcPtr = huiNextBufPtr(funcPtr, 18);
	agentPtr = huiNextBufPtr(agentPtr, 40);
    }
}

static char *HeaderOfShowMethod = "\n Method Name\n";

void huiPutsMethodDir(methodDir)
    char	*methodDir;
{

    huiPrintf(HeaderOfShowMethod);
    huiPutsLine(60, HuiChar_EqualCode);

    huiPrintf(methodDir);

    huiPutsLine(60, HuiChar_NULL);
}
