/* huiAAccess.c;
 *	Agent access module for Helios User Interface,
 *		created on June 9th, 1994.
 *
 *	modification history:	
 *	(1) inplement to handle ask messages from agent,
 *		on October 25th, 1994.
 *	(2) add huiSend2NewParaAgent()
 *		on November 14th, 1994.
 *
 * $Id: huiAAccess.c,v 2.1 1995/03/02 09:25:11 k3sato Exp $
 */

#include <stdio.h>
#include <sys/time.h>
#include <string.h>

#include <helios/SMessage.h>
#include <helios/envdef.h>
#include <helios/hExternStdFunc.h>

#include "helios.h"
#include "huiAgentInfo.h"
#include "huiMAccess.h"
#include "huiMsgManage.h"
#include "huiMessage.h"
#include "huiMemory.h"

#include <sys/socket.h>


#ifndef _Helios_TEST

/* defined in env	
 */
extern int send_a_message();
extern int receive_a_message();

#else

static struct timeval huiTimeout = {
    (long)25, (long)0
  };

#endif

/* defined in envdef.c
*/
extern char *eAmesGetAFrom();
extern char *eAmesGetACntl();
extern char *eAmesGetAInfo();

/* defined in eSAConv.c of env/adm
 */
extern int eSAConvStoA();
extern SMessage eSAConvAtoS();


HuiBoolean huiSetup2MsgManageInfo();

/*
 * S-Message $B$r9=@.$7$F!"%(!<%8%'%s%H$XAw$k4X?t(B
 *
 * $B$3$3$G$O!"0J2<$N%G!<%?$rIU2C$9$k!#(B
 *
 *	From:	"<machine>_<num>.0"	for User Interface
 *	AgentId:"0.1" etc.
 *	env:	"0"	for User Interface
 */
HuiBoolean huiMsgSend2Agent(hAccessInfo, msgManageInfo)
    HHuiAccessInfo	hAccessInfo;
    HHuiMsgManageInfo	msgManageInfo;

#ifdef _Helios_TEST

{
    fd_set		mask;
    fd_set		writeOk;
    int			width;
    int			sock;
    HHuiMsgManageInfo	msgManageInfo;
    char		*method;
    char		*arg;
    HuiText		sendBuf;
    HuiErrorMsgType	eMsgType;

    for (msgManageInfo = hAccessInfo->msgManageInfo
	 ; msgManageInfo->next != NULL
	 ; msgManageInfo = msgManageInfo->next)
      ;

    if ((method = msgManageInfo->method) == NULL) {
	method = "test_method_of_helios_user_interface";
    }

    if ((arg = hAccessInfo->msgManageInfo->methodArg) == NULL) {
	arg = "(eight)";
    }

    sprintf(sendBuf, "%s%s", method, arg);

    sock = hAccessInfo->sock;

    FD_ZERO(&mask);
    FD_SET(sock, &mask);
    width = sock + 1;

    /* select $B$NA0$KKh2s(B writeOk $B$r=i4|2=$9$k!#(B */
    writeOk = mask;
    select(width, NULL, (fd_set *)&writeOk, NULL, &huiTimeout);

    /* $B%=%1%C%H$K=q$-9~$_2D$+!)(B */
    if (FD_ISSET(sock, &writeOk)) {
	if (write(sock, sendBuf, strlen(sendBuf)) == ERROR_FLAG) {
	    HuiPerror();
	    eMsgType = HuiEMsg_SocketWriteError;
	    goto Error_Close;
	}
    }

    return HuiTrue;

 Error_Close:
    close(sock);

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

#else

{
    char		*userID;
    char		*toAgentID;
    char		*processName;
    SMessage		message;
    char		*aMsg;
    int			aMsgLen;
    HuiErrorMsgType	eMsgType;
    int			ret;

    userID = hAccessInfo->userInfo->agentId;
    toAgentID = hAccessInfo->agentId;

    /* S Message Object $B$r:n@.(B
     */
    message = CSMInit();

    /* Type $B$r(BASK$B$K$7$^$9!#(B
     */
    CSMTypeAsk(message);

    if (hAccessInfo->traceInfo.allMsgTrace == HuiOn) {
	CSMPutDebuginfoStr(message, userID);
    }

    /* message id $B$r%;%C%H$7$^$9!#(B
     *	msgManageInfo->msgID
     */
    CSMPutMidStr(message, msgManageInfo->msgID);

    /* From $B$K(B USER ID $B$r%;%C%H!#(B
     */
    CSMPutFromAidStr(message, userID);

    /* $B5!G=L>$r%;%C%H$7$^$9!#(B
     */
    CSMPutToAFStr(message, msgManageInfo->funcName);

    /*$B=hM}L>$r%;%C%H$7$^$9!#(B
     */
    if ((processName = msgManageInfo->processName) == NULL)
      processName = "first";

    CSMPutToManagementStr(message, processName);

    /*TID$B$O;H$o$J$$!#(B
     */
    CSMPutTidStr(message,"");

    /* Method $B$r%;%C%H!#(B
     */
    CSMPutMethodStr(message, msgManageInfo->method);

    /* $B%G!<%?(B $B$r%;%C%H$7$^$9!#(B
     */
    CSMPutDataStr(message, msgManageInfo->methodArg);

    ret = eSAConvStoA(userID, toAgentID, "normal", "0", "", message, &aMsg, &aMsgLen);
    if (ret < 0) {
	eMsgType = (ret == -1)
	  ? HuiEMsg_EnvInternalError : HuiEMsg_MallocError;
	goto Error_Rtn;
    }

    if ((ret = send_a_message(toAgentID, aMsg, aMsgLen)) < 0) {
	eMsgType = huiCnvErrno2EMsgType(ret);
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}
#endif /* _Helios_TEST */

/*
 * S-Message $B$r9=@.$7$F!"%j%W%i%$!&%a%C%;!<%8$r(B
 * $B%(!<%8%'%s%H$XAw$k4X?t(B
 *
 * $B$3$3$G$O!"0J2<$N%G!<%?$rIU2C$9$k!#(B
 *
 *	From:	"<machine>_<num>.0"	for User Interface
 *	AgentId:"0.1" etc.
 *	env:	"0"	for User Interface
 */
HuiBoolean huiMsgReply2Agent(hAccessInfo, msgManageInfo)
    HHuiAccessInfo	hAccessInfo;
    HHuiMsgManageInfo	msgManageInfo;
{
    SMessage		message;
    char		*userID;
    char		*toAgentID;
    char		*status;
    char		*aMsg;
    int			aMsgLen;
    HuiErrorMsgType	eMsgType;
    int			ret;

    if (hAccessInfo->userInfo == NULL ||
	(userID = hAccessInfo->userInfo->agentId) == NULL) {
	eMsgType = HuiEMsg_NotExistUserId;
	goto Error_Rtn;
    }

    if ((toAgentID = msgManageInfo->fromAid) == NULL) {
	eMsgType = HuiEMsg_NotExistFromAgentId;
	goto Error_Rtn;
    }

    if ((status = msgManageInfo->msgStatus) == NULL) {
	eMsgType = HuiEMsg_NotExistMsgStatus;
	goto Error_Rtn;
    }

    /* S Message Object $B$r:n@.(B
     */
    message = CSMInit();

    /* Type $B$r(B Reply $B$K$7$^$9!#(B
     */
    CSMTypeReply(message);

    if (hAccessInfo->traceInfo.allMsgTrace == HuiOn) {
	CSMPutDebuginfoStr(message, userID);
    }

    /* message Id $B$r%;%C%H(B
     */
    CSMPutMidStr(message, msgManageInfo->msgID);

    /* From $B$K(B USER ID $B$r%;%C%H(B
     */
    CSMPutFromAidStr(message, userID);

    /* To $B$K(B agent Id $B$r%;%C%H(B
     */
    CSMPutToAFStr(message, toAgentID);

    /* message status $B$N%;%C%H(B
     */
    CSMPutStatusStr(message, status);

    /* $B%j%W%i%$!&%a%C%;!<%8$r%G!<%?NN0h$K%;%C%H(B
     */
    CSMPutDataStr(message, msgManageInfo->replyMsg);

    ret = eSAConvStoA(userID, toAgentID, "normal", "0", "", message, &aMsg, &aMsgLen);
    if (ret < 0) {
	eMsgType = (ret == -1)
	  ? HuiEMsg_EnvInternalError : HuiEMsg_MallocError;
	goto Error_Rtn;
    }

    if ((ret = send_a_message(toAgentID, aMsg, aMsgLen)) < 0) {
	eMsgType = huiCnvErrno2EMsgType(ret);
	goto Error_Rtn;
    }

    msgManageInfo->status = HuiMsgStatus_AskedReplied;

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * $B%(!<%8%'%s%H$+$i%a%C%;!<%8$r<u$1<h$k(B
 */
HuiBoolean huiMsgReceiveFromAgent(hAccessInfo)
    HHuiAccessInfo	hAccessInfo;
{
    int			rpc_id;
    HuiRecvBuf		aMsg;
    int			aMsgLen;
    char		*aMsgCntl;
    char		*aMsgInfo;
    SMessage		sMsg;
    HAgentInfo		paraAgent;
    char		*fromAid;
    char		*ackMsg;
    HuiErrorMsgType	eMsgType;
    int			ret;

    paraAgent = hAccessInfo->connectedAgent;
    if (paraAgent != NULL && paraAgent->type != HdAT_Parametric) {
	paraAgent = NULL;
    }

    for (ret = 0; ret == 0;) {
	memset(aMsg, 0, HuiReceiveBufLen_Lim);
	aMsgLen = HuiReceiveBufLen_Lim;

	ret = receive_a_message(&rpc_id, &aMsg, &aMsgLen);
	if (ret < 0) {
	    if (ret == -EAGAIN) {
		break;
	    } else {
		eMsgType = huiCnvErrno2EMsgType(ret);
		goto Error_Rtn;
	    }
	}

	if (((aMsgCntl = eAmesGetACntl(aMsg)) != NULL) &&
	    (strcmp(aMsgCntl, ACK_STR) == 0)) {

	    fromAid = eAmesGetAFrom(aMsg);

	    if ((aMsgInfo = eAmesGetAInfo(aMsg)) != NULL) {
		
		if (strcmp(aMsgInfo, OK_STR) == 0) {

		    if (paraAgent != NULL &&
			strncmp(fromAid, paraAgent->agentId
				, strlen(paraAgent->agentId)) == 0) {
			paraAgent->status = AS_Active;
			hAccessInfo->connectedAgent = NULL;
		    }
		    ackMsg = "Ok";
		} else {
		    ackMsg = "No";
		}
	    } else {
		ackMsg = "";
	    }

	    huiPrintf("%s acknowledge from agent(%s)\n", ackMsg, fromAid);
	    continue;
	}

	if ((sMsg = (SMessage)eSAConvAtoS(aMsg)) == NULL) {
	    eMsgType = HuiEMsg_MallocError;
	    goto Error_Rtn;
	}

	/* in huiSetup2MsgManageInfo(),
	 * Handle control message from agent
	 */
	if (huiSetup2MsgManageInfo(hAccessInfo, sMsg) == HuiFalse) {
	    eMsgType = HuiEMsg_HuiSetup2MsgManageInfoError;
	    goto Error_Rtn;
	}
    }
    
    return HuiTrue;
    
 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * SMessage $B$N%G!<%?$r(B HuiMsgManageInfo $B9=B$BN$X%;%C%H$9$k(B
 */
HuiBoolean huiSetup2MsgManageInfo(hAccessInfo, sMsg)
    HHuiAccessInfo	hAccessInfo;
    SMessage		sMsg;
{
    HuiMsgManageInfo	*currInfo;
    int			msgType;
    char		*msgID;
    char		*fromAid, *toAid;
    char		*msgStatus, *replyMsg;
    HuiText		msgBuf;
    HuiErrorMsgType	eMsgType;
    
    msgType = CSMWhatType(sMsg);	/* Message Type$B$N3MF@(B */
    msgID = CSMGetMidStr(sMsg);		/* message ID $B$N3MF@(B (ex. "0_1") */
    fromAid = CSMGetFromAidStr(sMsg);	/* Agent ID of sender. (ex. "0.1.9") */
    toAid = CSMGetToAFStr(sMsg);	/* receiver of message (ex. "0") */ 
    msgStatus = CSMGetStatusStr(sMsg);	/* msgStatus $B$N3MF@(B */
    replyMsg = CSMGetDataStr(sMsg);	/* replyMsg $B$N3MF@(B */

    switch (msgType) {
    case REPLY:
	for (currInfo = hAccessInfo->msgManageInfo
	     ; currInfo != NULL
	     ; currInfo = currInfo->next) {
	    if (strcmp(currInfo->msgID, msgID) == 0) {
		currInfo->status = HuiMsgStatus_Replied;
		currInfo->msgStatus = msgStatus;
		currInfo->replyMsg = replyMsg;
	    }
	}
	huiPrintf("\na reply message received.\n");
	break;

    case CONTROL:
	if (hAccessInfo->monitor.state == HuiOn) {
	    while (hAccessInfo->monitor.traceSpeed == 0) {
		if (huiReceiveMsgFromMonitor(hAccessInfo, msgBuf) == HuiFalse) {
		    huiPutsErrorMsg(HuiEMsg_ReceiveMsgFromMonitorError);
		    /*	clear buffer between UI and Monitor
		     */
		    break;
		}
		if (huiSetupTraceSpeedFromMsg(hAccessInfo, msgBuf) == HuiFalse) {
		    /*	clear buffer between UI and Monitor
		     */
		}
	    }

	    if (huiSendSMsg2Monitor(hAccessInfo, sMsg) == HuiFalse) {
		huiPutsErrorMsg(HuiEMsg_SendSMsg2MonitorError);
	    }
	}
	break;
	
    case ASK:
	/* $B%(!<%8%'%s%H$+$i<u$1<h$C$?(B ASK $B%a%C%;!<%8$r(B
	 * HuiMsgManageInfo $B$K%;%C%H$9$k!#(B
	 */
	if ((currInfo = (HuiMsgManageInfo *)HuiMalloc(sizeof(HuiMsgManageInfo)))
	    == NULL) {
	    eMsgType = HuiEMsg_HuiMallocError;
	    goto Error_Rtn;
	}

	currInfo->status = HuiMsgStatus_Asked;
	currInfo->msgID = msgID;
	currInfo->fromAid = fromAid;
	currInfo->toAid = toAid;
	currInfo->method = CSMGetMethod(sMsg);
	currInfo->methodArg = replyMsg;
	currInfo->msgStatus = msgStatus;

	if (huiAppendMsgManageInfo(hAccessInfo, currInfo) == HuiFalse) {
	    HuiFreeMsgManageInfo(&currInfo);
	    eMsgType = HuiEMsg_HuiAppendMsgManageInfoError;
	    goto Error_Rtn;
	}

	hAccessInfo->currAskMsgInfo = currInfo;

	huiPrintf("\na ask message received.\n\tmsgId : %s\n", msgID);
	break;
	
    default:
	eMsgType = HuiEMsg_IllegalMsgType;
	goto Error_Rtn;
    }
    
    return HuiTrue;
    
 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * Send a message of agent trace switch to a agent
 */
HuiBoolean huiSendAgentTraceSwitch(hAccessInfo, traceSwitch)
    HHuiAccessInfo	hAccessInfo;
    HHuiTraceSwitch	traceSwitch;
{
    char		*userID;
    char		*toAgentID;
    SMessage		message;
    char		*aMsg;
    int			aMsgLen;
    HuiErrorMsgType	eMsgType;
    int			ret;

    userID = hAccessInfo->userInfo->agentId;
    toAgentID = traceSwitch->agent->agentId;

    /* S Message Object $B$r:n@.(B
     */
    message = CSMInit();

    /* Message Type $B$r(B CONTROL $B$K%;%C%H!#(B
     */
    CSMTypeControl(message);

    if (hAccessInfo->traceInfo.allMsgTrace == HuiOn) {
	CSMPutDebuginfoStr(message, userID);
    }

    /* message id $B$O!"8=>u$G$O;HMQ$7$J$$$N$G!"(B
     * $B%;%C%H$7$J$$!#(B
     * CSMPutMidStr(message, NULL);
     */

    /* From $B$K(B USERID $B$r%;%C%H!#(B
     */
    CSMPutFromAidStr(message, userID);

    /* $B5!G=L>$O!"(BNULL
     */
    CSMPutToAFStr(message, toAgentID);

    /* $B=hM}L>$O!"(BNULL
     * CSMPutToManagementStr(message, NULL);
     */

    /* TID$B$O;H$o$J$$!#(B
     * CSMPutTidStr(message, NULL);
     */

    /* Method $B$r%;%C%H!#(B
     */
    CSMPutMethodStr(message,
		    (traceSwitch->aTrace == HuiOn) ? "trace_on" : "trace_off");

    /* $B%G!<%?(B $B$r%;%C%H$7$^$9!#(B
     */
    CSMPutDataStr(message, "()");

    ret = eSAConvStoA(userID, toAgentID, "normal",
		      userID, "", message, &aMsg, &aMsgLen);
    if (ret < 0) {
	eMsgType = (ret == -1)
	  ? HuiEMsg_EnvInternalError : HuiEMsg_MallocError;
	goto Error_Rtn;
    }

    if ((ret = send_a_message(toAgentID, aMsg, aMsgLen)) < 0) {
	eMsgType = huiCnvErrno2EMsgType(ret);
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * send a message to a new parametric agent
 */
HuiBoolean huiSend2NewParaAgent(hAccessInfo, instanceList)
    HHuiAccessInfo	hAccessInfo;
    char		*instanceList;
{
    HAgentInfo		parentInfo;
    char		*toAgentId;
    char		*aMsg;
    int			aMsgLen;
    HuiText		msgBuf;
    HuiErrorMsgType	eMsgType;
    int			ret;

    parentInfo = hAccessInfo->connectedAgent;
    toAgentId = parentInfo->parent->agentId;

    sprintf(msgBuf, "%s %s", parentInfo->agentName, instanceList);

    ret = eSAConvStoA(hAccessInfo->userInfo->agentId,
		      toAgentId,
		      CREATE_INSTANCE_FROM_USER,
		      "0", msgBuf, NULL, &aMsg, &aMsgLen);
    if (ret < 0) {
	eMsgType = (ret == -1)
	  ? HuiEMsg_EnvInternalError : HuiEMsg_MallocError;
	goto Error_Rtn;
    }

    if ((ret = send_a_message(toAgentId, aMsg, aMsgLen)) < 0) {
	eMsgType = huiCnvErrno2EMsgType(ret);
	goto Error_Rtn;
    }

    /*  waiting a acknowledge message from parametric agent.
     */
    huiPutsWarningMsg(HuiWMsg_WaitForAckMsgFromParaAgent);

    parentInfo->status = AS_WaitAck;

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}
