/* helios.h;
 *
 *	a Header for Helios User Interface main program
 *		created on May 25th, 1994.
 *
 *	modification history:	
 *	(1) add HuiTl_Gui
 *		on September 1st in '94.
 *	(2) add typedef struct _HuiMonitorInfo
 *		on September 22th in '94
 *	(3) add Message Type between UI and GUI Monitor,
 *	    and add HuiAL_SLEEP, HuiAL_RESET in HuiCmdType
 *		on October 7th in '94
 *	(4) add typedef struct _AgentInfo_a
 *	    and add a member 'connectedAgent' in HuiAccessInfo,
 *		on November 4th in '94.
 *	(5) add HuiTL_ParaAgent
 *		on November 11th in '94.
 *	(6) modified type HuiUserInfo of userInfo in struct HuiAccessInfo to HAgentInfo
 *		on November 16th in '94.
 *
 * $Id: helios.h,v 2.1 1995/03/02 09:25:11 k3sato Exp $
 */

#ifndef HuiWordBufLen_Lim

#include <sys/types.h>
#include <memory.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>

#include <helios/heliosd.h>
#include <helios/hExternStdFunc.h>


/* ==========================
 *	define constants
 * ========================== */

#define ERROR_FLAG	-1

#define HUIMONITOR_SLEEP_SPAN	1
#define HuiMaxNumOfRetry	10
#define HuiMonitorMaxSpeed	10

/*
 *	limit constants
 */
#define HuiWordBufLen_Lim	256
#define HuiTextBufLen_Lim	4096
#define HuiReceiveBufLen_Lim	8192

#define HuiStringLength_Lim	0x0000FFFF

/* #define HuiSelfPortNum		2999 */

/*
 *  delimiter of a word
 */
#define HuiChar_NULL		'\0'
#define HuiChar_CR		'\n'
#define HuiChar_LF		'\012'
#define HuiChar_Space		' '
#define HuiChar_Tab		'\t'
#define HuiChar_Colon		':'
#define HuiChar_Semicolon	';'
#define HuiChar_Ampersand	'&'
#define HuiChar_LeftParen	'('
#define HuiChar_RightParen	')'
#define HuiChar_Comma		','
#define HuiChar_Minus		'-'
#define HuiChar_Period		'.'
#define HuiChar_EscCode		'\\'
#define HuiChar_EqualCode	'='

#define HuiChar_DoubleQuot	'\"'
#define HuiChar_SingleQuot	'\''
#define HuiChar_SlantCode	'/'

#define HuiChar_Underscore	'_'
#define HuiChar_LeftBrace	'{'
#define HuiChar_RightBrace	'}'

/* ==================================
 *	type definitions
 * ================================== */
typedef char	HuiWord[HuiWordBufLen_Lim];
typedef char	HuiText[HuiTextBufLen_Lim];
typedef char	HuiRecvBuf[HuiReceiveBufLen_Lim];

/* ==================================
 *	define enumeration types
 * ================================== */
/*	Boolean for Helios User Interface
 */
typedef enum {
    HuiFalse,
    HuiTrue,
    HuiFuzzy,
} HuiBoolean;

/*	Switch state ON/OFF/ for Helios User Interface
 */
typedef enum {
    HuiOff,
    HuiOn,
    HuiSuspense,
} HuiSwitchState;

/*
 * define Word types:
 */
typedef enum {
    HuiWT_NullString,
    HuiWT_OneChar,
    HuiWT_String,
    HuiWT_Delimit,
    HuiWT_EOF,
    HuiWT_TooLongWordError,
    HuiWT_SystemError,
} HuiWordType;

/*	command type of user interface
 */
typedef enum {
    HuiAccess2TopLevel,
    HuiAccess2AgentLevel,
} HuiAccessLevel;

/*	command type of user interface
 */
typedef enum {
    HuiTL_SHOW_AllAgents = 1,	/* Top Level(= TL) command */
    HuiTL_SHOW_ActiveAgents,
    HuiTL_SHOW_Functions,
    HuiTL_SHOW_Methods,
    HuiTL_SHOW_Structure,
    HuiTL_SHOW_Location,
    HuiTL_SHOW_Status,
    HuiTL_ParaAgent,
    HuiTL_CONNECT,
    HuiTL_MTRACE,
    HuiTL_ATRACE,
    HuiTL_KILL,
    HuiTL_BYE,
    HuiTL_HELP,
    HuiTL_GUI,
    /*
    HuiTL_SEND,
    HuiTL_RECEIVE,
    */
    _end_of_HuiTLCmdtype_,

    HuiAL_SHOW_Functions = 100,	/* Agent Level(= AL) command */
    HuiAL_SHOW_Methods,
    HuiAL_SHOW_Structure,
    HuiAL_SHOW_Location,
    HuiAL_SHOW_Status,
    HuiAL_TOP,
    HuiAL_BYE,
    HuiAL_WAKE,
    HuiAL_SLEEP,
    HuiAL_SEND,
    HuiAL_RECEIVE,
    HuiAL_REPLY,
    HuiAL_SHOW_Msg,
    HuiAL_CANCEL,
    HuiAL_MTRACE,
    HuiAL_ATRACE,
    HuiAL_LOG,
    HuiAL_MONITOR,
    HuiAL_RESET,
    HuiAL_TEST_Trace,
    HuiAL_HELP,
    _end_of_HuiALtype_,
} HuiCmdType;

/*
 *	S-Message $B$N(B
 *	$B%a%C%;!<%8!&%?%$%W(B
 */
typedef enum {
    HuiSMsgType_Ask,
    HuiSMsgType_Reply,
    HuiSMsgType_Control,
} HuiSMsgType;

/*
 *	$B%a%C%;!<%8>uBV(B
 */
typedef enum {
    HuiMsgStatus_Empty,
    HuiMsgStatus_Hold,		/* $B%(!<%8%'%s%H$XAw$k>uBV$N%a%C%;!<%8(B */
    HuiMsgStatus_Sent,
    HuiMsgStatus_Waiting,
    HuiMsgStatus_Replied,
    HuiMsgStatus_Shown,		/* $B<u$1<h$C$?%a%C%;!<%8$r2hLL$KI=<($7$?%a%C%;!<%8(B */
    HuiMsgStatus_Filed,
    HuiMsgStatus_Asked,		/* $B%(!<%8%'%s%H$+$i$NLd$$9g$o$;%a%C%;!<%8(B */
    HuiMsgStatus_AskedReplied,	/* $B%(!<%8%'%s%H$+$i$NLd$$9g$o$;$KBP$7$F$N2sEz40N;(B */

    HuiMsgStatus_ControlMsg,	/* control message; message trace or agent trace */
    HuiMsgStatus_Sent2Monitor,	/* send message to monitor */
} HuiMsgManageStatus;

/*
 *	$B%b%K%?!<$N>uBV(B
 */
typedef enum {
    HuiMonStatus_None,
    HuiMonStatus_Standby,	/* monitor is standby */
    HuiMonStatus_DispStandby,	/* monitor is standby to display trace of agent */
    HuiMonStatus_WaitForMessage,/* monitor waits for messages */
    HuiMonStatus_AskForNextMsg,	/* monitor asks for next message */

    HuiMonStatus_StepwiseTrace,
    HuiMonStatus_ContinuosTrace,
} HuiMonitorStatus;

/*
 *  UI $B$H(B Monitor $B4V$N%a%C%;!<%8!&%?%$%W(B
 */
typedef enum {
    HuiMonMsg_NotUsed,

    HuiMonMsg_UI2MonitorMsg = 1,	/* Message type from UI to Monitor */
    HuiMonMsg_UserInfo,			/* HuiUserInfo */
    HuiMonMsg_AgentInfo,		/* AgentInfo */
    HuiMonMsg_AgentInfoEnd,		/* End of AgentInfo */
    HuiMonMsg_FuncDirInfo,		/* function directory information */
    HuiMonMsg_MethodDirInfo,		/* method directory information */

    HuiMonMsg_DebugInfo = 200,		/* Debug information from UI to Monitor */
    HuiMonMsg_TraceInfo,		/* Trace information from UI to Monitor */
    HuiMonMsg_SMessageInfo,		/* S-Message information */
    HuiMonMsg_MTraceInfo,		/* Message trace information */
    HuiMonMsg_ATraceInfo,		/* Agent trace information */
    HuiMonMsg_AgentStatusInfo,		/* Agent status information */


    HuiMonMsg_AskMonitorStatus = 300,	/* Ask monitor Status from UI */
    HuiMonMsg_AskTraceSpeed,		/* Ask Trace speed of monitor */


    HuiMonMsg_Monitor2UIMsg = 500,	/* Message type from Monitor to UI */
    HuiMonMsg_MonitorStandby,		/* Inform that Monitor process stands by */
    HuiMonMsg_AgentTreeDispStandby,	/* Inform that Agent tree display stands by */
    HuiMonMsg_WaitForMsgFromUI,		/* Wait for message from UI */
    HuiMonMsg_AskForNextMsg,		/* Ask for next message */

    HuiMonMsg_MonitorStatus = 800,	/* Monitor Status */
    HuiMonMsg_TraceSpeedValue,		/* Trace speed of monitor */

    HuiMonMsg_MonitorErrorMsg = 900,	/* Monitor Error Message */
    HuiMonMsg_ErrorInMsgFromUI,		/* Error in message received from UI */
    HuiMonMsg_ErrorInMonitor,		/* Error in Monitor */

    HuiMonMsg_TestMsgUI2Monitor = 990,	/* Test Message from UI to monitor*/
    HuiMonMsg_TestMsgMonitor2UI,	/* Test Message from monitor to UI */

} HuiMonMsgType;

/* ==============================
 *	structure definitions
 * ============================== */
/*
 * structure for hui Command List
 */
typedef struct _HuiCmdList	*HHuiCmdList;

typedef struct _HuiCmdList {
    char	*cmd;
    long	len;
    HuiCmdType	type;
    HuiBoolean	(*func)();
    char	*usage;
    char	*helpMsg;
} HuiCmdList;

/*
 *	Information for message management
 */
typedef struct _HuiMsgManageInfo	*HHuiMsgManageInfo;

typedef struct _HuiMsgManageInfo {
    HuiMsgManageStatus	status;
    char		*msgID;		/* message ID managed in user interface */
    char		*fromAid;	/* ask $B$N>l9g(B from_agentId */
    char		*toAid;		/* send $B$N>l9g(B to_agentId */
    char		*funcName;	/* <To> $B$,5!G=L>$N>l9g$K%;%C%H$5$l$k!#(B */
    char		*processName;	/* <To> $B$,(B{ $B5!G=L>(B, $B=hM}L>(B }$B$N;~!"=hM}L>$,%;%C%H$5$l$k!#(B */
    char		*method;	/* <method name>:<signature> */
    char		*methodArg;	/* <method name> $B$N0z?t(B */
    char		*msgStatus;	/* status of msg */
    char		*replyMsg;	/* result message */
    HHuiMsgManageInfo	next;
} HuiMsgManageInfo;

/*
 *	Information for user interface
 */
typedef struct _HuiUserInfo	*HHuiUserInfo;

typedef struct _HuiUserInfo {
    char		*agentID;	/* agentID for user interface */
    /* char		*machName;	machine name */
    char		*agentName;	/* login name of user */
    SocketInfo		sockInfo;	/* socket information of user interface */
    int			pid;		/* process ID of user interface */
} HuiUserInfo;

/*	trace flag for agent trace and message trace
 */
typedef struct _HuiTraceSwitch	*HHuiTraceSwitch;

typedef struct _HuiTraceSwitch {
    HAgentInfo		agent;	/* reference to allAgentInfo */
    HuiSwitchState	mTrace;
    HuiSwitchState	aTrace;
    HHuiTraceSwitch	next;
} HuiTraceSwitch;

/*
 *	Information for trace;
 *		agent trace and message trace
 */
typedef struct _HuiTraceInfo	*HHuiTraceInfo;

typedef struct _HuiTraceInfo {
    HuiSwitchState	allMsgTrace;	/* message trace flag for all messages */
    HHuiTraceSwitch	traceSwitch;
} HuiTraceInfo;

/*
 *	Information for monitor
 */
typedef struct _HuiMonitorInfo	*HHuiMonitorInfo;

typedef struct _HuiMonitorInfo {
    HuiSwitchState	state;
    HuiMonitorStatus	status;
    int			pipeIn;		/* pipe file descriptor to read data from monitor */
    int			pipeOut;	/* pipe file descriptor to write data to monitor */
    int			pid;		/* process ID of monitor */
    int			traceSpeed;	/* from 0 to 100 */
} HuiMonitorInfo;

/*
 * structure for hui access information
 */
typedef struct _HuiAccessInfo *HHuiAccessInfo;

typedef struct _HuiAccessInfo {
    HuiAccessLevel	level;
    HAgentInfo		userInfo;
    HHuiCmdList		currCmd;
    HAgentInfo		allAgentInfo;
    HAgentInfo		connectedAgent;	/* connected agent or parametric agent */
    char		*agentName;
    char		*agentId;
    int			currMsgId;
    HHuiMsgManageInfo	msgManageInfo;
    HHuiMsgManageInfo	currAskMsgInfo;	/* for current message asked from agent */
    char		*logFileName;
    FILE		*logFd;
    struct sockaddr_in	*sockAddr;
    int			sock;
    HuiTraceInfo	traceInfo;
    HuiMonitorInfo	monitor;
} HuiAccessInfo;

#endif
