/* huiTclMessage.c;
 *	Helios User Interface messages for Tcl
 *
 *		created by k3sato on October 6th in '94.
 *
 * $Id: huiTclMessage.c,v 1.2 1994/10/20 08:52:20 k3sato Exp $
 */
#include <stdio.h>

#include "huiMonitor.h"
#include "huiTclMessage.h"

/*
 * Tcl Message for Helios User Interface
 */
HuiTclMsgInfo huiTclMsgInfo[] = {
    {HuiTcl_NoError,		"No Error"},

    {HuiTcl_WrogArgsToProc,	"wrong # args: to %s"},
};


/*
 *	TCL $B$N%a%C%;!<%8I=<(4X?t(B
 */
void huiPutsTclMsg(msgType, argc, argv)
    HuiTclMsgType	msgType;
    int			argc;
    char		*argv[];
{
    HuiTclMsgInfo	*tclMsgInfo;
    HuiText		frmt;

    if (msgType == HuiTcl_NoError)
      return;

    for (tclMsgInfo = &huiTclMsgInfo[0]; tclMsgInfo->msg != NULL; ++tclMsgInfo) {
	if (tclMsgInfo->type == msgType) {
	    sprintf(frmt, "%s.\n", tclMsgInfo->msg);

	    fprintf(stderr, frmt, argv[0]);
	    break;
	}
    }
}

/*
 *	TCL $B$N(B result $BI=<(4X?t(B
 */
void huiPutsTclResult(interp)
    Tcl_Interp		*interp;
{
    fprintf(stderr, "Tcl error msg: %s\n", interp->result);
}
