/* huiTclLib.c
 * 	library to handle Tcl functions for huiMonitor
 *		created on September 29th in 94.
 *
 *	modification history:	
 *	(1) add huiTclCreateCmds()
 *		on November 2nd in '94.
 *
 * $Id: huiTclLib.c,v 2.0 1995/03/03 03:17:19 k3sato Exp $
 */

#include "huiMonitor.h"
#include "huiPAccess.h"
#include "huiMessage.h"
#include "huiTclLib.h"
#include "huiTclMessage.h"

/*  defined in huiDialog.c
 */
extern int huiPopupAgentDialogCmd();
extern int huiPopupMsgTraceDialogCmd();

/*  defined in huiMonitor.c
 */
extern void huiSetReadFileHandler();
extern void huiResetReadFileHandler();


int huiSetTraceSpeedCmd();

/*
 * Create New commands for Tcl
 */
HuiBoolean huiTclCreateCmds(monCtlInfo)
    HuiMonitorCtlInfo	*monCtlInfo;
{
    Tcl_Interp		*interp;

    interp = monCtlInfo->interp;

    Tcl_CreateCommand(interp, HuiPopupAgentDialog, huiPopupAgentDialogCmd,
		      monCtlInfo, NULL);

    Tcl_CreateCommand(interp, HuiPopupMsgTraceDialog, huiPopupMsgTraceDialogCmd,
		      monCtlInfo, NULL);

    Tcl_CreateCommand(interp, HuiSetTraceSpeed, huiSetTraceSpeedCmd,
		      monCtlInfo, NULL);

    return HuiTrue;
}

/* =============================================================
 * Tcl New Command procedure for tcl command "huiSetTraceSpeed"
 * called by scale widget(.waku.speed defined in huiMonitor.tcl)
 *
 *	argv[1] : a value from scale widget
 * ============================================================= */
int huiSetTraceSpeedCmd(monCtlInfo, interp, argc, argv)
    HuiMonitorCtlInfo	*monCtlInfo;
    Tcl_Interp		*interp;
    int			argc;
    char		*argv[];
{
    int			speed;
    HuiErrorMsgType	eMsgType;

    if (argc != 2) {
	eMsgType = HuiTcl_WrogArgsToProc;
	goto TclError_Rtn;
    }

    huiResetReadFileHandler(monCtlInfo);

    sscanf(argv[1], "%d", &speed);

    if (monCtlInfo->traceSpeed == 0) {
	if (huiPutMonSpeed2UI(monCtlInfo, speed) == HuiFalse) {
	    eMsgType = HuiEMsg_PutMonSpeed2UIError;
	    goto Error_Rtn;
	}
    }

    monCtlInfo->traceSpeed = speed;

    huiSetReadFileHandler(monCtlInfo);

    return TCL_OK;

 TclError_Rtn:
    huiPutsTclResult(interp);

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    huiSetReadFileHandler(monCtlInfo);
    return TCL_OK;
}

/* ============================
 *  common routines
 * ============================ */
HuiBoolean huiTclCreateCommand(interp, cmdName, cmdProc, clientData, deleteProc)
    Tcl_Interp		*interp;
    char		*cmdName;
    Tcl_CmdProc		*cmdProc;
    ClientData		clientData;
    Tcl_CmdDeleteProc	*deleteProc;
{
/*    HuiErrorMsgType	eMsgType;
*/

    Tcl_CreateCommand(interp, cmdName, cmdProc, clientData, deleteProc);

    return HuiTrue;

    /*
      TclError_Rtn:
      huiPutsTclResult(interp);

      huiPutsErrorMsg(eMsgType);
      return HuiFalse;
      */
}

/*
 *
 */
HuiBoolean huiTclSetGlobalVarFloat(interp, name, var)
    Tcl_Interp		*interp;
    char		*name;
    float		var;
{
    HuiWord		script;
    HuiErrorMsgType	eMsgType;

    sprintf(script, "%.1f", var);
    if (Tcl_SetVar(interp, name, script,
		   TCL_GLOBAL_ONLY | TCL_LEAVE_ERR_MSG) == NULL) {
	eMsgType = HuiEMsg_TclSetVarError;
	goto TclError_Rtn;
    }

    return HuiTrue;

 TclError_Rtn:
    huiPutsTclResult(interp);

    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}
