/* huiPAccess.c;
 *	Parent Access module with pipe for Monitor of Helios User Interface;
 *		created on October 7th in 1994.
 *
 * $Id: huiPAccess.c,v 2.0 1995/03/03 03:17:19 k3sato Exp $
 */

#include <stdio.h>

#include "huiMonitor.h"
#include "huiMessage.h"

#include "huiPAccess.h"

/*
 *	Get a message from UI through pipe(stdin)
 */
HuiBoolean huiGetMsgFromPipe(recvBuf)
    char		*recvBuf;
{
    fd_set		readOk;
    int			pipeFd;
    int			width;
    int			length;
    HuiErrorMsgType	eMsgType;

    pipeFd = 0;

    /* select $B$NA0$K(B readOk $B$r=i4|2=$9$k!#(B
     */
    FD_ZERO(&readOk);
    FD_SET(pipeFd, &readOk);
    width = pipeFd + 1;

    /* $B%Q%$%W$+$iFI$_9~$_2D$+!)(B
     */
    select(width, (fd_set *)&readOk, NULL, NULL, 0);

    if (FD_ISSET(pipeFd, &readOk)) {
	if ((length = read(pipeFd, recvBuf, HuiTextBufLen_Lim)) == ERROR_FLAG) {
	    HuiPerror();
	    eMsgType = HuiEMsg_PipeReadError;
	    goto Error_Rtn;
	}
	if (length >= HuiTextBufLen_Lim) {
	    eMsgType = HuiEMsg_TextLenLimitOver;
	    goto Error_Rtn;
	}
	
	recvBuf[length] = '\0';
	return HuiTrue;
    }

    eMsgType = HuiEMsg_NoPipeData;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Put Monitor Message Type into pipe
 */
HuiBoolean huiPutMonMsgType2UI(monCtlInfo, monMsgType)
    HuiMonitorCtlInfo	*monCtlInfo;
    HuiMonMsgType	monMsgType;
{
    HuiWord		msgBuf;
    char		*ret;
    HuiErrorMsgType	eMsgType;

    ret = sprintf(msgBuf, "%d \n", monMsgType);
    if (ret == NULL) {
	eMsgType = HuiEMsg_SprintfError;
	goto Error_Rtn;
    }

    if (huiPutMsg2Pipe(msgBuf) == HuiFalse) {
	eMsgType = HuiEMsg_PutMsg2PipeError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Put monitor speed value into pipe
 */
HuiBoolean huiPutMonSpeed2UI(monCtlInfo, speed)
    HuiMonitorCtlInfo	*monCtlInfo;
    int			speed;
{
    HuiWord		msgBuf;
    char		*ret;
    HuiErrorMsgType	eMsgType;

    ret = sprintf(msgBuf, "%d %d", HuiMonMsg_TraceSpeedValue, speed);
    if (ret == NULL) {
	eMsgType = HuiEMsg_SprintfError;
	goto Error_Rtn;
    }

    if (huiPutMsg2Pipe(msgBuf) == HuiFalse) {
	eMsgType = HuiEMsg_PutMsg2PipeError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Put Error message into pipe
 */
HuiBoolean huiPutErrorMsg2Pipe(eMsgType)
    HuiErrorMsgType	eMsgType;
{
    char		*errorMsg;
    HuiWord		msgBuf;

    if ((errorMsg = huiGetErrorMsg(eMsgType)) == NULL) {
	errorMsg = "Error in Monitor";
    }
    if (sprintf(msgBuf, "%d %s\n",
		HuiMonMsg_ErrorInMonitor, errorMsg) == NULL) {
	eMsgType = HuiEMsg_SprintfError;
	goto Error_Rtn;
    }

    if (huiPutMsg2Pipe(msgBuf) == HuiFalse) {
	eMsgType = HuiEMsg_PutMsg2PipeError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *	Put a message to UI through pipe(stdout)
 */
HuiBoolean huiPutMsg2Pipe(msg)
    char		*msg;
{
    fd_set		mask;
    fd_set		writeOk;
    int			pipeFd;
    int			width;
    int			length;
    int			retry;
    HuiErrorMsgType	eMsgType;

    if ((length = strlen(msg) + 1) >= HuiTextBufLen_Lim) {
	eMsgType = HuiEMsg_TextLenLimitOver;
	goto Error_Rtn;
    }

    pipeFd = 1;

    FD_ZERO(&mask);
    FD_SET(pipeFd, &mask);
    width = pipeFd + 1;

    for (retry = HuiMaxNumOfRetry; retry > 0; retry--) {
	/* select $B$NA0$K(B writeOk $B$r=i4|2=$9$k!#(B
	 */
	writeOk = mask;
	/* $B%Q%$%W$+$iFI$_9~$_2D$+!)(B
	 */
	select(width, NULL, (fd_set *)&writeOk, NULL, 0);

	if (FD_ISSET(pipeFd, &writeOk)) {
	    if ((length = write(pipeFd, msg, length)) == ERROR_FLAG) {
		HuiPerror();
		eMsgType = HuiEMsg_PipeWriteError;
		goto Error_Rtn;
	    }

	    return HuiTrue;
	}
    }

    eMsgType = HuiEMsg_OverMaxNumOfRetryToWritePipe;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Get Monitor Message Type from Message
 */
HuiBoolean huiGetMonMsgType(monCtlInfo, msg, monMsgType)
    HuiMonitorCtlInfo	*monCtlInfo;
    char		*msg;
    int			*monMsgType;
{
    int			ret;
    HuiErrorMsgType	eMsgType;

    ret = sscanf(msg, "%d", monMsgType);
    if (ret == 0 || ret == EOF) {
	eMsgType = HuiEMsg_NoMonMsgTypeInMsg;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}
