/* huiMonitor.h;
 *	a Header for Helios User Interface Monitor program
 *		created on September 27th in 94.
 *	modification history:	
 *	(1) add typedef struct _AgentTreeInfo_a
 *		on November 4th in '94.
 *	(2) modified HuiAgentTreeInfo to add four members;
 *		pModelX, pModelY, processConfig, numAsk
 *		on November 23rd in '94.
 *	(3) add typedef struct _HuiMonMachInfo
 *	    and modified two structs; _HuiMonitorCtlInfo and _HuiAgentTreeInfo
 *		on November 25th in '94.
 *	(4) modified HuiAgentTreeInfo to add one member(char *procArgs)
 *		and modified (HMethodDirInfo methodDir;) to (char *methodDir)
 *		on February 22nd in '95.
 *
 * $Id: huiMonitor.h,v 1.8 1995/03/02 09:27:32 k3sato Exp $
 */

#ifndef _huiMonitor_h_
#define _huiMonitor_h_

/* #include <tcl.h> */
#include <tk.h>

#include "helios.h"

/*
 * information for drawing agent tree
 */
#define HuiAgentLeafHeight	10	/* 20 */
#define HuiAgentLeafWidth	35	/* 40 */

#define HuiAgentLeafStart_X	5
#define HuiAgentLeafSpanHeight	(HuiAgentLeafHeight + 4)
#define HuiAgentLeafSpanWidth	(HuiAgentLeafWidth + 15)

/*
 * New Tcl command names
 */
#define HuiPopupAgentDialog	"popupAgentDg"
#define HuiPopupMsgTraceDialog	"huiShowMsgTraceInfo"
#define HuiSetTraceSpeed	"huiSetTraceSpeed"

/*
 * Hold the display data in process model
 *	for each machine.
 */
typedef struct _HuiMonMachInfo	*HHuiMonMachInfo;

typedef struct _HuiMonMachInfo {
    char		*machName;	/* machine name */
    float		maxX;		/* maximum position of X */
    float		startY;		/* for drawing the machine region */
    float		pModelY;	/* next value for Y in pModel */
    HHuiMonMachInfo	next;
} HuiMonMachInfo;

/*
 *	Information for Agent tree
 */
typedef struct _HuiAgentTreeInfo *HHuiAgentTreeInfo;

typedef struct _HuiAgentTreeInfo {
    HdAgentType		type;		/* agent type */
    char		*agentId;	/* agent ID */
    char		*agentPath;	/* full path of agent */
    char		*agentName;	/* agent name */
    char		*procArgs;	/* arguments to pass through agent process */
    HFuncDirInfo	funcDir;	/* function directory information */
    char		*methodDir;	/* HMethodDirInfo: method directory information */
    HuiMonMachInfo	*machInfo;	/* machine information */
    u_short		sin_port;	/* port number of socket */
    int			pid;		/* process ID of agent process */
    AgentStatusType	status;		/* agent status; active or not */
    int			groupNum;	/* number to group agents for monitor */
    char		*comment;	/* comment for a agent */
    int			acceptedAsk;	/* number of ask message accepted */
    float		posX;		/* x of upper left pos in lModel */
    float		posY;		/* y of upper left pos in lModel */
    float		pModelX;	/* x of agent name pos in pModel */
    float		pModelY;	/* y of agent name pos in pModel */
    int			leafConfig;	/* itemconfig of agent leaf of lModel */
    int			lineConfig;	/* itemconfig of msg line of lModel */
    int			processConfig;	/* itemconfig of area of pModel */
    HHuiAgentTreeInfo	parent;		/* parent agent tree info */
    HHuiAgentTreeInfo	child;		/* child agent tree info */
    HHuiAgentTreeInfo	next;		/* brothers agent tree info */
} HuiAgentTreeInfo;

/*
 *	Information for Message Trace
 */
typedef struct _HuiMsgTraceInfo	*HHuiMsgTraceInfo;

typedef struct _HuiMsgTraceInfo {
    HuiAgentTreeInfo	*rcvAidInfo;	/* agent tree info for received agentId */
    HuiAgentTreeInfo	*fromInfo;	/* agent tree info for sender */
    HuiAgentTreeInfo	*toInfo;	/* agent tree info for receiver */
    HuiAgentTreeInfo	*parentInfo;	/* parent tree info in common with from and to */
    HuiSMsgType		msgType;	/* message Type */
    char		*msgId;		/* message ID */
    char		*from;		/* from agent id */
    char		*to;		/* to agent id */
    char		*status;	/* message status */
    char		*method;	/* message method */
    char		*msgData;	/* message Data */
    int			arrowConfig;	/* itemconfig of msg arrow of pModel */
    int			fromConfig;	/* itemconfig of from-circle of pModel */
    int			toConfig;	/* itemconfig of to-circle of pModel */
} HuiMsgTraceInfo;

/*
 *	Information for Monitor control
 */
typedef struct _HuiMonitorCtlInfo {
    int			pipeIn;
    Tcl_Interp		*interp;
    float		canvasWidth;
    float		canvasHeight;
    HuiMonMachInfo	*machInfo;
    HuiAgentTreeInfo	*treeInfo;
    HuiMsgTraceInfo	mTraceInfo;
    int			traceSpeed;	/* window redraw speed; 0: stop, 10: continue */
} HuiMonitorCtlInfo;

/*	structure to receive structured AgentInfo from UI
 */
typedef struct _HuiAgentTreeInfo_a *HHuiAgentTreeInfo_a;

typedef struct _HuiAgentTreeInfo_a {
    int			address;	/* pointer address of AgentInfo */
    HHuiAgentTreeInfo	treeInfo;
    HHuiAgentTreeInfo_a	next;
} HuiAgentTreeInfo_a;

#endif /*_huiMonitor_h_ */
