/* huiMonMemory.c;
 *	memory hadle module for helios user interface Monitor.
 *		created on November 8th, 1994.
 *
 *	modification history:
 *	(1) add huiFreeMonMachInfo()
 *		on November 24th, '94.
 *
 * $Id: huiMonMemory.c,v 1.1 1994/12/01 10:14:21 k3sato Exp $
 */

#include <stdio.h>

#include "huiMonitor.h"
#include "huiAgentProcess.h"
#include "huiMessage.h"
#include "huiMemory.h"
#include "huiMonMemory.h"


/* =======================================
 *	Memory manipulation functions
 * ======================================= */


/* =============================
 *  functions to free memory
 * ============================= */
/*
 *
 */
void huiFreeMonMachInfo(machInfoP)
    HHuiMonMachInfo	*machInfoP;
{
    HuiMonMachInfo	*currInfo, *nextInfo;

    for (currInfo = *machInfoP; currInfo != NULL; currInfo = nextInfo) {
	nextInfo = currInfo->next;

	HuiFreeString(&(currInfo->machName));
	HuiFree(currInfo);
    }

    *machInfoP = NULL;
}

/* ================================
 *  Free of HuiAgentTreeInfo_a
 * ================================ */
void HuiFreeAgentTreeInfo_a(treeInfo_aP)
    HHuiAgentTreeInfo_a	*treeInfo_aP;
{
    HHuiAgentTreeInfo_a	currInfo_a;
    HHuiAgentTreeInfo_a	nextInfo_a;

    if (treeInfo_aP == NULL || (currInfo_a = *treeInfo_aP) == NULL) return;

    for (; currInfo_a != NULL; currInfo_a = nextInfo_a) {
	nextInfo_a = currInfo_a->next;
	HuiFreeOneAgentTreeInfo_a(&currInfo_a);
    }

    *treeInfo_aP = NULL;
}

void HuiFreeOnlyAgentTreeInfo_a(treeInfo_aP)
    HHuiAgentTreeInfo_a	*treeInfo_aP;
{
    HHuiAgentTreeInfo_a	currInfo_a;
    HHuiAgentTreeInfo_a	nextInfo_a;

    if (treeInfo_aP == NULL || (currInfo_a = *treeInfo_aP) == NULL) return;

    for (; currInfo_a != NULL; currInfo_a = nextInfo_a) {
	nextInfo_a = currInfo_a->next;
	HuiFree(currInfo_a);
    }

    *treeInfo_aP = NULL;
}

void HuiFreeOneAgentTreeInfo_a(treeInfo_aP)
    HHuiAgentTreeInfo_a	*treeInfo_aP;
{
    HHuiAgentTreeInfo_a	treeInfo_a;

    if (treeInfo_aP == NULL || (treeInfo_a = *treeInfo_aP) == NULL) return;

    huiFreeOneAgentTreeInfo(&(treeInfo_a->treeInfo));

    HuiFree(treeInfo_a);

    *treeInfo_aP = NULL;
}

/* ================================
 *  Free of HuiAgentTreeInfo
 * ================================ */
void huiFreeAgentTreeInfo(treeInfoP)
    HHuiAgentTreeInfo	*treeInfoP;
{
    HHuiAgentTreeInfo	currInfo;
    HHuiAgentTreeInfo	nextInfo;

    if (treeInfoP == NULL || (currInfo = *treeInfoP) == NULL) return;

    for (; currInfo != NULL; currInfo = nextInfo) {
	nextInfo = currInfo->next;
	huiFreeOneAgentTreeInfo(&currInfo);
    }

    *treeInfoP = NULL;
}

void huiFreeOneAgentTreeInfo(treeInfoP)
    HHuiAgentTreeInfo	*treeInfoP;
{
    HHuiAgentTreeInfo	treeInfo;

    if (treeInfoP == NULL || (treeInfo = *treeInfoP) == NULL) return;

    HuiFreeString(&(treeInfo->agentId));
    HuiFreeString(&(treeInfo->agentPath));
    HuiFreeString(&(treeInfo->agentName));

    huiFreeFuncDirInfo(&(treeInfo->funcDir));
    huiFreeMethodDirInfo(&(treeInfo->methodDir));

    HuiFree(treeInfo);
    *treeInfoP = NULL;
}

void huiFreeFuncDirInfo(funcDirInfoP)
    HFuncDirInfo	*funcDirInfoP;
{
    HFuncDirInfo	funcDirInfo, nextFuncDirInfo;

    if (funcDirInfoP == NULL) return;

    for (funcDirInfo = *funcDirInfoP
	 ; funcDirInfo != NULL
	 ; funcDirInfo = nextFuncDirInfo) {
	nextFuncDirInfo = funcDirInfo->next;
	HuiFreeString(&(funcDirInfo->funcName));
	HuiFree(funcDirInfo);
    }
    *funcDirInfoP = NULL;
}

void huiFreeMethodDirInfo(methodDirInfoP)
    HMethodDirInfo	*methodDirInfoP;
{
    HMethodDirInfo	methodDirInfo, nextMethodDirInfo;

    if (methodDirInfoP == NULL) return;

    for (methodDirInfo = *methodDirInfoP
	 ; methodDirInfo != NULL
	 ; methodDirInfo = nextMethodDirInfo) {
	nextMethodDirInfo = methodDirInfo->next;
	HuiFreeString(&(methodDirInfo->methodName));
	HuiFree(methodDirInfo);
    }
    *methodDirInfoP = NULL;
}
