/* huiDialog.c
 *	program to popup dailogs for huiMonitor
 *		created on September 29th in 94.
 *
 * $Id: huiDialog.c,v 1.7 1994/12/20 02:52:05 k3sato Exp $
 */

#include "huiMonitor.h"
#include "huiMessage.h"
#include "huiTclMessage.h"

/*  defined in huiMonitor.c
 */
extern void huiSetReadFileHandler();
extern void huiResetReadFileHandler();

/*  defined in huiAgentTree.c
 */
extern HHuiAgentTreeInfo huiSearchTreeInfoForName();

HuiBoolean huiCheckCurrentTracePath();

/*
 * popup a dialog to show the agent information
 *
 *	argv[1] : widget of top level
 *	argv[2] : agent name(char *)
 */
int huiPopupAgentDialogCmd(monCtlInfo, interp, argc, argv)
    HuiMonitorCtlInfo	*monCtlInfo;
    Tcl_Interp		*interp;
    int			argc;
    char		*argv[];
{
    HuiAgentTreeInfo	*treeInfo;
    char		*machName;
    HuiText		script;
    HuiErrorMsgType	eMsgType;

    if (argc != 3) {
	eMsgType = HuiTcl_WrogArgsToProc;
	goto TclError_Rtn;
    }

    huiResetReadFileHandler(monCtlInfo);

    if ((treeInfo = huiSearchTreeInfoForName(monCtlInfo->treeInfo, argv[2])) == NULL) {
	eMsgType = HuiEMsg_SearchTreeInfoForNameError;
	goto TclError_Rtn;
    }

    machName = (treeInfo->machInfo == NULL)
      ? "(null)" : treeInfo->machInfo->machName;

    sprintf(script, "\"Agent ID : %s\"\
                     \"Agent Name : %s\"\
                     \" \"\
                     \"Machine Name : %s\"\
                     \"Process Path : %s\"\
                     \" \"\
                     \"Comment:\" %s",
	    treeInfo->agentId,
	    argv[2],
	    machName,
	    treeInfo->agentPath,
	    treeInfo->comment
	    );

    if (Tcl_SetVar(interp, "agentDgInfo", script,
		   TCL_GLOBAL_ONLY | TCL_LEAVE_ERR_MSG) == NULL) {
	eMsgType = HuiEMsg_TclSetVarError; /* TCL_LIST_ELEMENT | */
	goto TclError_Rtn;
    }

    sprintf(script, "mkAgentInfo %s %s", argv[1], argv[2]);

    if (Tcl_Eval(monCtlInfo->interp, script) != TCL_OK) {
	eMsgType = HuiEMsg_mkAgentInfoError;
	goto TclError_Rtn;
    }

    huiSetReadFileHandler(monCtlInfo);

    return TCL_OK;

 TclError_Rtn:
    huiPutsTclResult(interp);

    huiPutsErrorMsg(eMsgType);
    huiSetReadFileHandler(monCtlInfo);
    return TCL_OK;
}

/*
 * popup a dialog to show the message trace information
 *
 *	argv[1] : widget of top level	(char *)
 *	argv[2] : lineConfig		(int)
 */
int huiPopupMsgTraceDialogCmd(monCtlInfo, interp, argc, argv)
    HuiMonitorCtlInfo	*monCtlInfo;
    Tcl_Interp		*interp;
    int			argc;
    char		*argv[];
{
    HHuiMsgTraceInfo	traceInfo;
    int			lineConfig;
    HuiText		script;
    HuiErrorMsgType	eMsgType;

    if (argc != 3) {
	eMsgType = HuiTcl_WrogArgsToProc;
	goto TclError_Rtn;
    }

    huiResetReadFileHandler(monCtlInfo);

    lineConfig = 0;
    sscanf(argv[2], "%d", &lineConfig);

    if (huiCheckCurrentTracePath(monCtlInfo, lineConfig) == HuiFalse) {
	eMsgType = HuiEMsg_NotMTraceLineError;
	goto Error_Rtn;
    }

    traceInfo = &(monCtlInfo->mTraceInfo);

    sprintf(script, "\"Message ID : %s\"\
                     \"Message Type : %s\"\
                     \"From : %s\"\
                     \"To : %s\"\
                     \"Status : %s\"\
                     \"Method : %s\"\
                     {Message Data : %s}",
	    traceInfo->msgId,
	    (traceInfo->msgType == HuiSMsgType_Ask) ? "ASK" :
	    (traceInfo->msgType == HuiSMsgType_Reply) ? "REPLY" : "CONTROL",
	    traceInfo->from,
	    traceInfo->to,
	    traceInfo->status,
	    traceInfo->method,
	    traceInfo->msgData);

    if (Tcl_SetVar(interp, "msgTraceDgInfo", script,
		   TCL_GLOBAL_ONLY | TCL_LEAVE_ERR_MSG) == NULL) {
	eMsgType = HuiEMsg_TclSetVarError;
	goto TclError_Rtn;
    }

    sprintf(script, "mkMsgTraceInfo %s", argv[1]);

    if (Tcl_Eval(monCtlInfo->interp, script) != TCL_OK) {
	eMsgType = HuiEMsg_mkMsgTraceInfoError;
	goto TclError_Rtn;
    }

    huiSetReadFileHandler(monCtlInfo);

    return TCL_OK;

 TclError_Rtn:
    huiPutsTclResult(interp);

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    huiSetReadFileHandler(monCtlInfo);
    return TCL_OK;
}

/*
 * Check if the clicked line is on the current trace path.
 */
HuiBoolean huiCheckCurrentTracePath(monCtlInfo, lineConfig)
    HuiMonitorCtlInfo	*monCtlInfo;
    int			lineConfig;
{
    HHuiAgentTreeInfo	parentInfo;
    HHuiAgentTreeInfo	tempInfo;

    if ((parentInfo = monCtlInfo->mTraceInfo.parentInfo) == NULL) {
	return HuiFalse;
    }

    for (tempInfo = monCtlInfo->mTraceInfo.fromInfo
	 ; tempInfo != parentInfo
	 ; tempInfo = tempInfo->parent) {

	if (tempInfo->lineConfig == lineConfig) {
	    goto True_Rtn;
	}
    }

    for (tempInfo = monCtlInfo->mTraceInfo.toInfo
	 ; tempInfo != parentInfo
	 ; tempInfo = tempInfo->parent) {

	if (tempInfo->lineConfig == lineConfig) {
	    goto True_Rtn;
	}
    }

    return HuiFalse;

 True_Rtn:
    return HuiTrue;
}
