/* huiAgentTreeInfo.c
 * *	program to handle the struct _HuiAgentTreeInfo for huiMonitor
 *		created on November 7th in 94.
 *
 * $Id: huiAgentTreeInfo.c,v 1.3 1995/03/02 09:27:32 k3sato Exp $
 */

#include <memory.h>

#include "huiMonitor.h"
#include "huiMemory.h"
#include "huiMessage.h"
#include "huiMonMemory.h"

/* defined in huiMonitor.c
 */
extern HdBoolean huiGetMsgFromPipe();
extern HdBoolean huiPutMsg2Pipe();

/* defined in huiPAccess.c
 */
extern HuiBoolean huiPutMonMsgType2UI();

/* defined in huiAgentProcess.c
 */
extern HHuiMonMachInfo huiGetMonMachInfo();

#ifdef _DEBUG_MONITOR_Only

/* defined in huiTestAgentTree.c
 */
extern HuiAgentTreeInfo testAgentTreeInfo[];

#endif

HuiBoolean huiGetAgentTreeInfoFromUI();
HuiBoolean huiGetAgentTreeInfo();

HuiBoolean huiGetOneAgentTreeInfo();
HuiBoolean huiGetAgentTreeInfo_a();

HuiBoolean huiSetupAgentTreeInfoFromMsg();
HuiBoolean huiSetupFuncDirInfoFromMsg();
static char *huiGetNextTermPtr();
HuiBoolean huiSetupMethodDirInfoFromMsg();

HHuiAgentTreeInfo huiGetSingleAgentTreeInfo();

/*
 * Get AgentTreeInfo from UI.
 */
HuiBoolean huiGetAgentTreeInfo(monCtlInfo)
    HuiMonitorCtlInfo	*monCtlInfo;

#ifdef _DEBUG_MONITOR_Only

{
    monCtlInfo->treeInfo = testAgentTreeInfo;

    return HuiTrue;
}

#else

{
    HuiMonMsgType	monMsgType;
    HuiErrorMsgType	eMsgType;

    /* Get HuiUserInfo from UI
     */
    if (huiGetOneAgentTreeInfo(monCtlInfo, &monMsgType, &(monCtlInfo->treeInfo))
	== HuiFalse) {
	eMsgType = HuiEMsg_GetOneAgentTreeInfoError;
	goto Error_Rtn;
    }

    if (monMsgType != HuiMonMsg_UserInfo) {
	eMsgType = HuiEMsg_NotHuiUserInfo;
	goto Error_Rtn;
    }

    /* Get HuiAgentInfo from UI
     * and translate into HuiAgentTreeInfo structure
     */
    if (huiGetAgentTreeInfoFromUI(monCtlInfo, &(monCtlInfo->treeInfo->child))
	== HuiFalse) {
	eMsgType = HuiEMsg_GetAgentTreeInfoFromUIError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiFreeAgentTreeInfo(&monCtlInfo->treeInfo);

    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

#endif

/*
 *  Get AgentInfo from UI
 */
HuiBoolean huiGetAgentTreeInfoFromUI(monCtlInfo, treeInfo)
    HuiMonitorCtlInfo	*monCtlInfo;
    HHuiAgentTreeInfo	*treeInfo;
{
    HuiErrorMsgType	eMsgType;

    *treeInfo = (HHuiAgentTreeInfo) !NULL;

    if (huiGetAgentTreeInfo_a(monCtlInfo, treeInfo, monCtlInfo->treeInfo)
	== HuiFalse) {
	eMsgType = HuiEMsg_GetAgentTreeInfo_aError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiFreeAgentTreeInfo(treeInfo);

    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Get the structure data of HuiAgentTreeInfo 
 *  from UI
 */
HuiBoolean huiGetAgentTreeInfo_a(monCtlInfo, treeInfo, parentInfo)
    HuiMonitorCtlInfo	*monCtlInfo;
    HHuiAgentTreeInfo	*treeInfo;
    HHuiAgentTreeInfo	parentInfo;
{
    HHuiAgentTreeInfo	currInfo;
    HuiMonMsgType	msgType = HuiMonMsg_AgentInfo;

    for (; *treeInfo != NULL; treeInfo = &(currInfo->next)) {

	if (msgType == HuiMonMsg_AgentInfoEnd) {
	    goto Error_Rtn;
	}

	if (huiPutMonMsgType2UI(monCtlInfo, HuiMonMsg_AskForNextMsg) == HuiFalse) {
	    goto Error_Rtn;
	}

	if (huiGetOneAgentTreeInfo(monCtlInfo, &msgType, treeInfo) == HdFalse) {
	    goto Error_Rtn;
	}

	currInfo = *treeInfo;
	currInfo->parent = parentInfo;

	if (msgType != HuiMonMsg_AgentInfoEnd) {

	    if (currInfo->child != NULL) {
		if (huiGetAgentTreeInfo_a(monCtlInfo, &(currInfo->child), currInfo) == HuiFalse) {
		    goto Error_Rtn;
		}
	    }
	} else {
	    if (currInfo->child != NULL) {
		goto Error_Rtn;
	    }
	}
    }

    return HuiTrue;

 Error_Rtn:
    return HuiFalse;
}

/*
 *  Get one HHuiAgentTreeInfo from UI
 */
HuiBoolean huiGetOneAgentTreeInfo(monCtlInfo, monMsgType, treeInfo)
    HuiMonitorCtlInfo	*monCtlInfo;
    HuiMonMsgType	*monMsgType;
    HHuiAgentTreeInfo	*treeInfo;
{
    HuiText		msgBuf;
    HuiErrorMsgType	eMsgType;

    if (huiGetMsgFromPipe(msgBuf) == HuiFalse) {
	eMsgType = HuiEMsg_GetMsgFromPipeError;
	goto Error_Rtn;
    }

    if (huiSetupAgentTreeInfoFromMsg(monCtlInfo, treeInfo, monMsgType, msgBuf)
	== HuiFalse) {
	eMsgType = HuiEMsg_SetupAgentTreeInfoFromMsgError;
	goto Error_Rtn;
    }

    if ((*treeInfo)->procArgs != NULL) {

	if (huiPutMonMsgType2UI(monCtlInfo, HuiMonMsg_AskForNextMsg) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToPutMonMsgType2UI;
	    goto Error_Rtn;
	}

	if (huiGetMsgFromPipe(msgBuf) == HuiFalse) {
	    eMsgType = HuiEMsg_GetMsgFromPipeError;
	    goto Error_Rtn;
	}

	if (((*treeInfo)->procArgs = HuiMallocString(msgBuf)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocError;
	    goto Error_Rtn;
	}
    }

    if ((*treeInfo)->funcDir != NULL) {

	if (huiPutMonMsgType2UI(monCtlInfo, HuiMonMsg_AskForNextMsg) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToPutMonMsgType2UI;
	    goto Error_Rtn;
	}

	if (huiGetMsgFromPipe(msgBuf) == HuiFalse) {
	    eMsgType = HuiEMsg_GetMsgFromPipeError;
	    goto Error_Rtn;
	}

	if (huiSetupFuncDirInfoFromMsg(&((*treeInfo)->funcDir), msgBuf) == HuiFalse) {
	    eMsgType = HuiEMsg_SetupFuncDirInfoFromMsgError;
	    goto Error_Rtn;
	}
    }

    if ((*treeInfo)->methodDir != NULL) {

	if (huiPutMonMsgType2UI(monCtlInfo, HuiMonMsg_AskForNextMsg) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToPutMonMsgType2UI;
	    goto Error_Rtn;
	}

	if (huiGetMsgFromPipe(msgBuf) == HuiFalse) {
	    eMsgType = HuiEMsg_GetMsgFromPipeError;
	    goto Error_Rtn;
	}

	if (huiSetupMethodDirInfoFromMsg(&((*treeInfo)->methodDir), msgBuf) == HuiFalse) {
	    eMsgType = HuiEMsg_SetupMethodDirInfoFromMsgError;
	    goto Error_Rtn;
	}
    }

    if ((*treeInfo)->comment != NULL) {

	if (huiPutMonMsgType2UI(monCtlInfo, HuiMonMsg_AskForNextMsg) == HuiFalse) {
	    eMsgType = HuiEMsg_FailToPutMonMsgType2UI;
	    goto Error_Rtn;
	}

	if (huiGetMsgFromPipe(msgBuf) == HuiFalse) {
	    eMsgType = HuiEMsg_GetMsgFromPipeError;
	    goto Error_Rtn;
	}

	if (((*treeInfo)->comment = HuiMallocString(msgBuf)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocError;
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Setup a AgentTreeInfo from messages received from UI
 */
HuiBoolean huiSetupAgentTreeInfoFromMsg(monCtlInfo, treeInfoP, monMsgType, msgBuf)
    HuiMonitorCtlInfo	*monCtlInfo;
    HHuiAgentTreeInfo	*treeInfoP;
    HuiMonMsgType	*monMsgType;
    char		*msgBuf;
{
    HuiAgentTreeInfo	treeInfo;
    HuiWord		agentId;
    HuiWord		agentPath;
    HuiWord		agentName;
    HuiWord		hostName;
    int			sin_port;
    int			ret;
    HuiErrorMsgType	eMsgType;

    memset(&treeInfo, 0, sizeof(HuiAgentTreeInfo));

    ret = sscanf(msgBuf, "%i %i %s %s %s %x %x %x %s %i %i %i %i %x %x %x %x",
		 monMsgType,
		 &(treeInfo.type),	/* HdAgentType (int) */
		 agentId,		/* char* */
		 agentPath,		/* char* */
		 agentName,		/* char* */
		 &(treeInfo.procArgs),	/* char* */
		 &(treeInfo.funcDir),	/* HFuncDirInfo */
		 &(treeInfo.methodDir),	/* HMethodDirInfo */
		 hostName,		/* char* */
		 &sin_port,		/* u_short */
		 &(treeInfo.pid),	/* int */
		 &(treeInfo.status),	/* AgentStatusType (int) */
		 &(treeInfo.groupNum),	/* int */
		 &(treeInfo.comment),	/* char* */
		 &(treeInfo.parent),	/* pointer */
		 &(treeInfo.child),	/* pointer */
		 &(treeInfo.next)	/* pointer */
		 );

    if (ret < 17) {
	if (*monMsgType == HuiMonMsg_AgentInfoEnd) {
	    goto Good_Rtn;
	} else {
	    eMsgType = HuiEMsg_DestroyedDataInAgentInfo;
	    goto Error_Rtn;
	}
    }

    treeInfo.sin_port = sin_port;

    if ((treeInfo.agentId = HuiMallocString(agentId)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocError;
	goto Error_Rtn;
    }
	
    if ((treeInfo.agentPath = HuiMallocString(agentPath)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocError;
	goto Error_Rtn;
    }
	
    if ((treeInfo.agentName = HuiMallocString(agentName)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocError;
	goto Error_Rtn;
    }

    if (hostName[0] != HuiChar_LeftParen) {
	if ((treeInfo.machInfo = huiGetMonMachInfo(&(monCtlInfo->machInfo), hostName))
	    == NULL) {
	    eMsgType = HuiEMsg_GetMonMachInfoError;
	    goto Error_Rtn;
	}
    }

    if ((*treeInfoP = (HHuiAgentTreeInfo)HuiMalloc(sizeof(HuiAgentTreeInfo))) == NULL) {
	eMsgType = HuiEMsg_HuiMallocError;
	goto Error_Rtn;
    }

    memcpy(*treeInfoP, &treeInfo, sizeof(HuiAgentTreeInfo));

 Good_Rtn:
    return HuiTrue;

 Error_Rtn:
    HuiFreeString(&(treeInfo.agentId));
    HuiFreeString(&(treeInfo.agentPath));
    HuiFreeString(&(treeInfo.agentName));

    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

HuiBoolean huiSetupFuncDirInfoFromMsg(funcDirInfo, msgBuf)
    HFuncDirInfo	*funcDirInfo;
    char		*msgBuf;
{
    HuiMonMsgType	msgType;
    char		*bufPtr;
    char		funcName[AgentNameLen_Lim];
    char		*agentNames;
    HFuncDirInfo	*currInfoP;
    HFuncDirInfo	currInfo;
    HuiErrorMsgType	eMsgType;
    int			ret;

    ret = sscanf(msgBuf, "%i", &msgType);

    if (ret < 1 || ret == EOF) {
	eMsgType = HuiEMsg_DestroyedDataInAgentInfo;
	goto Error_Rtn;
    }

    if (msgType != HuiMonMsg_FuncDirInfo) {
	eMsgType = HuiEMsg_IllegalMsgType;
	goto Error_Rtn;
    }

    if (*(bufPtr = huiGetNextTermPtr(msgBuf)) == HuiChar_NULL) {
	eMsgType = HuiEMsg_DestroyedDataInAgentInfo;
	goto Error_Rtn;
    }

    for (currInfoP = funcDirInfo
	 ; bufPtr != NULL && *bufPtr != HuiChar_NULL
	 ; currInfoP = &(currInfo->next)) {

	ret = sscanf(bufPtr, "%s", funcName);
	if (ret < 1 || ret == EOF) {
	    eMsgType = HuiEMsg_DestroyedDataInAgentInfo;
	    goto Error_Rtn;
	}

	if ((*currInfoP =
	     currInfo = (HFuncDirInfo)HuiMalloc(sizeof(FuncDirInfo))) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocError;
	    goto Error_Rtn;
	}

	if ((currInfo->funcName = HuiMallocString(funcName)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}

	if (*(agentNames = huiGetNextTermPtr(bufPtr)) == HdChar_NULL) {
	    eMsgType = HuiEMsg_NotSeparatorInFuncDirInfo;
	    goto Error_Rtn;
	}

	if ((bufPtr = strchr(agentNames, '\n')) == NULL) {
	    eMsgType = HuiEMsg_DestroyedDataInAgentInfo;
	    goto Error_Rtn;
	}

	*bufPtr++ = HdChar_NULL;

	if ((currInfo->agentNames = HuiMallocString(agentNames)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiFreeFuncDirInfo(funcDirInfo);

    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

static char *huiGetNextTermPtr(bufPtr)
    char	*bufPtr;
{
    char	ch;

    while ((ch = *bufPtr) != HdChar_NULL
	   && (ch == HdChar_Space
	       || ch == HdChar_Tab)) {
	bufPtr++;
    }

    while ((ch = *bufPtr) != HdChar_NULL
	   && ch != HdChar_Space
	   && ch != HdChar_Tab) {
	bufPtr++;
    }

    while ((ch = *bufPtr) != HdChar_NULL
	   && (ch == HdChar_Space
	       || ch == HdChar_Tab)) {
	bufPtr++;
    }

    return bufPtr;
}

HuiBoolean huiSetupMethodDirInfoFromMsg(methodDirInfo, msgBuf)
    char		**methodDirInfo;	/* HMethodDirInfo */
    char		*msgBuf;
{
    HuiMonMsgType	msgType;
    /*
    char		methodName[AgentNameLen_Lim];
    HMethodDirInfo	*currInfoP;
    HMethodDirInfo	currInfo;
    */
    HuiErrorMsgType	eMsgType;
    int			ret;

    ret = sscanf(msgBuf, "%i", &msgType);

    if (ret < 1 || ret == EOF) {
	eMsgType = HuiEMsg_DestroyedDataInAgentInfo;
	goto Error_Rtn;
    }

    if (msgType != HuiMonMsg_MethodDirInfo) {
	eMsgType = HuiEMsg_IllegalMsgType;
	goto Error_Rtn;
    }

    if ((msgBuf = strchr(msgBuf, ' ')) != NULL) {
	while (*++msgBuf == ' ' && *msgBuf != '\0')
	  ;
    }

    if ((*methodDirInfo = HuiMallocString(msgBuf)) == NULL) {
	eMsgType = HuiEMsg_HuiMallocStringError;
	goto Error_Rtn;
    }

    /*
    for (currInfoP = methodDirInfo
	 ; msgBuf != NULL && *msgBuf != '\0'
	 ; currInfoP = &(currInfo->next)) {

	ret = sscanf(msgBuf, "%s", methodName);
	if (ret < 1 || ret == EOF) {
	    eMsgType = HuiEMsg_DestroyedDataInAgentInfo;
	    goto Error_Rtn;
	}

	if ((*currInfoP =
	     currInfo = (HMethodDirInfo)HuiMalloc(sizeof(MethodDirInfo))) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocError;
	    goto Error_Rtn;
	}

	if ((currInfo->methodName = HuiMallocString(methodName)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}

	if ((msgBuf = strchr(msgBuf, ' ')) != NULL) {
	    while (*++msgBuf == ' ' && *msgBuf != '\0')
	      ;
	}
    }
    */

    return HuiTrue;

 Error_Rtn:
    huiFreeMethodDirInfo(methodDirInfo);

    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * get Single agent tree info from complex agent tree info
 */
HHuiAgentTreeInfo huiGetSingleAgentTreeInfo(treeInfo)
    HHuiAgentTreeInfo	treeInfo;
{
    while (treeInfo->child != NULL) {
	treeInfo = treeInfo->child;
    }

    return treeInfo;
}
