/* huiAgentProcess.c
 *	program to diplay the Agent throught process model of Agent
 *		created on November 23rd in 94.
 *
 * $Id: huiAgentProcess.c,v 1.3 1995/03/02 09:27:32 k3sato Exp $
 */

#include "huiMonitor.h"
#include "huiAgentProcess.h"
#include "huiMessage.h"
#include "huiTclLib.h"
#include "huiTclMessage.h"
#include "huiMemory.h"
#include "huiMonMemory.h"


HuiBoolean huiSetupAgentInfoInPModel_s();

HuiBoolean huiAdjustMonMachInfo();
HuiBoolean huiAdjustAgentInfoInPModel();

HuiBoolean huiDrawMsgFlowLineInPModel();
HuiBoolean huiDrawMachAreaInPModel();
HuiBoolean huiDrawAgentInPModel_s();
HuiBoolean huiDrawOneAgentInPModel();
HuiBoolean huiDrawAgentPArea();
HuiBoolean huiDrawAgentNameArea();

int huiCountAgentLevel();

/*
 * Setup information to draw agent in Process model
 */
HuiBoolean huiSetupAgentInfoInPModel(monCtlInfo, treeInfo)
    HuiMonitorCtlInfo	*monCtlInfo;
    HuiAgentTreeInfo	*treeInfo;
{
    HHuiMonMachInfo	currMachInfo;
    HuiErrorMsgType	eMsgType;

    /* userInfo is on the top of treeInfo;
     */
    currMachInfo = treeInfo->machInfo;

    treeInfo->pModelX = HuiAgentNameArea_X;
    currMachInfo->maxX = HuiAgentNameArea_X
      + HuiMonOneCharWidth * (strlen(treeInfo->agentName) + 2);

    treeInfo->pModelY = currMachInfo->pModelY;
    currMachInfo->pModelY += HuiAgentProcSpanHeight;

    if (huiSetupAgentInfoInPModel_s(HuiAgentNameArea_X, treeInfo->child)
	== HuiFalse) {
	eMsgType = HuiEMsg_SetupAgentInfoInPModel_sError;
	goto Error_Rtn;
    }

    if (huiAdjustMonMachInfo(monCtlInfo, monCtlInfo->machInfo) == HuiFalse) {
	eMsgType = HuiEMsg_AdjustMonMachInfoError;
	goto Error_Rtn;
    }

    if (huiAdjustAgentInfoInPModel(monCtlInfo->treeInfo) == HuiFalse) {
	eMsgType = HuiEMsg_AdjustAgentInfoInPModelError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiFreeMonMachInfo(&(monCtlInfo->machInfo));
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* Sub-function of
 * Setup information to draw agent in Process model
 */
HuiBoolean huiSetupAgentInfoInPModel_s(posX, treeInfo)
    float		posX;
    HuiAgentTreeInfo	*treeInfo;
{
    HHuiMonMachInfo	currMachInfo;
    float		tempPosX;
    HuiErrorMsgType	eMsgType;

    for (; treeInfo != NULL; treeInfo = treeInfo->next) {

	currMachInfo = treeInfo->machInfo;
	
	treeInfo->pModelX = posX;

	tempPosX = posX + HuiMonOneCharWidth * (strlen(treeInfo->agentName) + 2);

	if (currMachInfo != NULL && currMachInfo->maxX < tempPosX) {
	    currMachInfo->maxX = tempPosX;
	}

	if (treeInfo->child != NULL) {
	    if (huiSetupAgentInfoInPModel_s(tempPosX, treeInfo->child)
		== HuiFalse) {
		eMsgType = 0;
		goto Error_Rtn;
	    }
	} else {
	    if (currMachInfo != NULL) {
		treeInfo->pModelY = currMachInfo->pModelY;
		currMachInfo->pModelY += HuiAgentProcSpanHeight;
	    }
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * Draw agent in canvas of Process model
 */
HuiBoolean huiDrawAgentInPModel(monCtlInfo, treeInfo)
    HuiMonitorCtlInfo	*monCtlInfo;
    HHuiAgentTreeInfo	treeInfo;
{
    Tcl_Interp		*interp;
    HHuiAgentTreeInfo	currInfo;
    HHuiAgentTreeInfo	childInfo;
    HuiErrorMsgType	eMsgType;

    interp = monCtlInfo->interp;

    /* Draw message flow line on pCanvas in advance
     */
    if (huiDrawMsgFlowLineInPModel(interp, &(monCtlInfo->mTraceInfo))
	== HuiFalse) {
	eMsgType = HuiEMsg_DrawMsgFlowLineInPModelError;
	goto Error_Rtn;
    }

    /* Draw machine area and machine name
     */
    if (huiDrawMachAreaInPModel(interp, monCtlInfo->machInfo) == HuiFalse) {
	eMsgType = HuiEMsg_DrawMachAreaInPModelError;
	goto Error_Rtn;
    }

    /* Draw user interface process
     */
    if (huiDrawOneAgentInPModel(interp, treeInfo, treeInfo) == HuiFalse) {
	eMsgType = HuiEMsg_DrawOneAgentInPModelError;
	goto Error_Rtn;
    }

    /* draw Agent process
     */
    for (currInfo = treeInfo->child; currInfo != NULL; currInfo = currInfo->next) {
	if ((childInfo = currInfo->child) != NULL) {
	    if (huiDrawAgentInPModel_s(interp, currInfo, childInfo) == HuiFalse) {
		eMsgType = HuiEMsg_DrawAgentInPModel_sError;
		goto Error_Rtn;
	    }
	} else {
	    if (huiDrawOneAgentInPModel(interp, currInfo, currInfo) == HuiFalse) {
		eMsgType = HuiEMsg_DrawOneAgentInPModelError;
		goto Error_Rtn;
	    }
	}
    }	    

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * Draw Message flow line on pCanvas in advance
 */
HuiBoolean huiDrawMsgFlowLineInPModel(interp, mTraceInfo)
    Tcl_Interp		*interp;
    HHuiMsgTraceInfo	mTraceInfo;
{
    HuiText		script;
    int			ret;
    HuiErrorMsgType	eMsgType;

    sprintf(script, "huiMkMsgFlowLine");

    if (Tcl_Eval(interp, script) != TCL_OK) {
	eMsgType = HuiEMsg_MkMsgFlowLineError;
	goto TclError_Rtn;
    }

    ret = sscanf(interp->result, "%i %i %i",
		 &(mTraceInfo->fromConfig),
		 &(mTraceInfo->arrowConfig),
		 &(mTraceInfo->toConfig)
		 );

    if (ret < 3) {
	eMsgType = HuiEMsg_ErrorInPCanvasOfTk;
	goto Error_Rtn;
    }

    return HuiTrue;

 TclError_Rtn:
    huiPutsTclResult(interp);

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * Draw machine areas in process model
 */
HuiBoolean huiDrawMachAreaInPModel(interp, machInfo)
    Tcl_Interp		*interp;
    HHuiMonMachInfo	machInfo;
{
    HuiText		script;
    HuiErrorMsgType	eMsgType;

    for (; machInfo != NULL; machInfo = machInfo->next) {

	sprintf(script, "huiMkMachArea %.1f %.1f %.1f %.1f %s",
		(float)HuiMachAreaStart_X, machInfo->startY,
		machInfo->maxX, machInfo->pModelY,
		machInfo->machName);

	if (Tcl_Eval(interp, script) != TCL_OK) {
	    eMsgType = HuiEMsg_MkMachAreaError;
	    goto TclError_Rtn;
	}
    }

    return HuiTrue;

 TclError_Rtn:
    huiPutsTclResult(interp);
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* Sub-function of
 * Draw agent in canvas of Process model
 */
HuiBoolean huiDrawAgentInPModel_s(interp, parentInfo, treeInfo)
    Tcl_Interp		*interp;
    HHuiAgentTreeInfo	parentInfo;
    HHuiAgentTreeInfo	treeInfo;
{
    HHuiAgentTreeInfo	childInfo;
    HuiErrorMsgType	eMsgType;

    for (; treeInfo != NULL; treeInfo = treeInfo->next) {
	if ((childInfo = treeInfo->child) != NULL) {
	    if (huiDrawAgentInPModel_s(interp, parentInfo, childInfo) == HuiFalse) {
		eMsgType = HuiEMsg_DrawAgentInPModel_sError;
		goto Error_Rtn;
	    }
	} else {
	    if (huiDrawOneAgentInPModel(interp, parentInfo, treeInfo) == HuiFalse) {
		eMsgType = HuiEMsg_DrawOneAgentInPModelError;
		goto Error_Rtn;
	    }
	}
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * Draw one Agent Process Area on Tk-canvas
 */
HuiBoolean huiDrawOneAgentInPModel(interp, parentInfo, treeInfo)
    Tcl_Interp		*interp;
    HHuiAgentTreeInfo	parentInfo;
    HHuiAgentTreeInfo	treeInfo;
{
    HuiErrorMsgType	eMsgType;

    if (huiDrawAgentPArea(interp, treeInfo) == HuiFalse) {
	eMsgType = HuiEMsg_DrawAgentPAreaError;
	goto Error_Rtn;
    }

    if (huiDrawAgentNameArea(interp, parentInfo, treeInfo) == HuiFalse) {
	eMsgType = HuiEMsg_DrawAgentNameAreaError;
	goto Error_Rtn;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Draw the Agent Process Area on Tk-canvas
 */
HuiBoolean huiDrawAgentPArea(interp, treeInfo)
    Tcl_Interp		*interp;
    HHuiAgentTreeInfo	treeInfo;
{
    HHuiAgentTreeInfo	parentInfo;
    float		procWidth;
    char		*processName;
    char		*represent = "N";
    HuiText		script;
    HuiErrorMsgType	eMsgType;

    if ((processName = strrchr(treeInfo->agentPath, '/')) == NULL) {
	processName = treeInfo->agentPath;
    } else {
	processName++;
    }

    if ((parentInfo = treeInfo->parent) != NULL) {
	if (treeInfo == parentInfo->child) {
	    represent = "Y";
	}
    }

    procWidth = treeInfo->pModelX +
      HuiMonOneCharWidth *(strlen(treeInfo->agentName) + 2);

    sprintf(script, "huiMkAgentPArea %.1f %.1f %.1f %.1f %s %s",
	    (float)HuiAgentProcStart_X, treeInfo->pModelY,
	    procWidth, (float)HuiAgentProcHeight,
	    represent, processName);

    if (Tcl_Eval(interp, script) != TCL_OK) {
	eMsgType = HuiEMsg_mkAgentLeafError;
	goto TclError_Rtn;
    }

    sscanf(interp->result, "%d", &treeInfo->processConfig);

    return HuiTrue;

 TclError_Rtn:
    huiPutsTclResult(interp);
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 *  Draw the Agent Name Area in Agent process area
 */
HuiBoolean huiDrawAgentNameArea(interp, parentInfo, treeInfo)
    Tcl_Interp		*interp;
    HHuiAgentTreeInfo	parentInfo;
    HHuiAgentTreeInfo	treeInfo;
{
    int			level;
    float		pModelY;
    float		width;
    float		height;
    HuiText		script;
    HuiErrorMsgType	eMsgType;

    if ((level = huiCountAgentLevel(parentInfo, treeInfo)) == 0) {
	eMsgType = HuiEMsg_CountAgentLevelError;
	goto Error_Rtn;
    }

    pModelY = treeInfo->pModelY;

    height = (float)HuiMonOneCharHeight;

    for (; level > 0; level--, treeInfo = treeInfo->parent) {

	width = (float)HuiMonOneCharWidth * strlen(treeInfo->agentName);

	sprintf(script, "huiMkAgentNameArea %.1f %.1f %.1f %.1f %i %s",
		treeInfo->pModelX, pModelY,
		width, height,
		level + treeInfo->groupNum, treeInfo->agentName);

	if (Tcl_Eval(interp, script) != TCL_OK) {
	    eMsgType = HuiEMsg_MkAgentNameAreaError;
	    goto TclError_Rtn;
	}
    }

    return HuiTrue;

 TclError_Rtn:
    huiPutsTclResult(interp);

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/* 
 * Count the Agent level
 */
int huiCountAgentLevel(parentInfo, childInfo)
    HHuiAgentTreeInfo	parentInfo;
    HHuiAgentTreeInfo	childInfo;
{
    int			level;

    for (level = 0; childInfo != NULL; childInfo = childInfo->parent, level++) {
	if (parentInfo == childInfo) {
	    return ++level;
	}
    }

    return 0;
}

/*
 * Search HuiMonMachInfo for a machine name
 */
HHuiMonMachInfo huiGetMonMachInfo(machInfoP, machName)
    HHuiMonMachInfo	*machInfoP;
    char		*machName;
{
    HHuiMonMachInfo	currInfo;
    HuiErrorMsgType	eMsgType;

    if (machName == NULL) goto Error_Rtn;

    for (; *machInfoP != NULL; machInfoP = &(currInfo->next)) {
	currInfo = *machInfoP;

	if (strcmp(currInfo->machName, machName) == 0) {
	    break;
	}
    }

    if (*machInfoP == NULL) {
	if ((currInfo =
	     *machInfoP = (HHuiMonMachInfo)HuiMalloc(sizeof(HuiMonMachInfo)))
	    == NULL) {
	    eMsgType = HuiEMsg_HuiMallocError;
	    goto Error_Rtn;
	}

	if ((currInfo->machName = HuiMallocString(machName)) == NULL) {
	    eMsgType = HuiEMsg_HuiMallocStringError;
	    goto Error_Rtn;
	}

	currInfo->maxX = HuiAgentNameArea_X;
	currInfo->pModelY = HuiAgentProcStart_Y;
    }

    return currInfo;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return NULL;
}

/*
 * Adjust the information to draw the machine area
 *	of process model in tk-canvas
 * and the size of tk-canvas for monitor.
 */
HuiBoolean huiAdjustMonMachInfo(monCtlInfo, machInfo)
    HuiMonitorCtlInfo	*monCtlInfo;
    HHuiMonMachInfo	machInfo;
{
    float		maxX;
    float		maxY;
    HuiErrorMsgType	eMsgType;

    maxY = maxX = 1;	/* unit of value ; mm */

    for (; machInfo != NULL; machInfo = machInfo->next) {
	machInfo->startY = maxY;

	maxY += machInfo->pModelY;
	machInfo->pModelY = maxY - HuiAgentProcHeightGap/2;

	machInfo->maxX += HuiMachAreaAdjustWidth;

	if (maxX < machInfo->maxX) {
	    maxX = machInfo->maxX;
	}
    }

    /* determin the size of canvas of lModel and pModel.
     */
    monCtlInfo->canvasWidth = monCtlInfo->canvasWidth * HuiAgentLeafSpanWidth
      + HuiAgentLeafWidth;

    if (monCtlInfo->canvasWidth < maxX) {
	monCtlInfo->canvasWidth = maxX;
    }

    if (monCtlInfo->canvasHeight < maxY) {
	monCtlInfo->canvasHeight = maxY;
    }

    return HuiTrue;

 Error_Rtn:
    huiPutsErrorMsg(eMsgType);
    return HuiFalse;
}

/*
 * Adjust the information to draw the agent area
 *	of process model in tk-canvas
 */
HuiBoolean huiAdjustAgentInfoInPModel(treeInfo)
    HuiAgentTreeInfo	*treeInfo;
{
    for (; treeInfo != NULL; treeInfo = treeInfo->next) {

	if (treeInfo->type == HdAT_Single || treeInfo->type == HdAT_ParaInstance) {
	    treeInfo->pModelY += treeInfo->machInfo->startY;
	}

	if (huiAdjustAgentInfoInPModel(treeInfo->child) == HuiFalse) {
	    goto Error_Rtn;
	}
    }

    return HuiTrue;

 Error_Rtn:
    return HuiFalse;
}
