/* hExternStdFunc.h
 *	extern decralation of standard functions
 *	created on November 11th, '94.
 *
 * $Id: hExternStdFunc.h,v 2.5 1995/03/02 09:27:05 k3sato Exp $
 */

#ifndef _hExternStdFunc_h_

#define _hExternStdFunc_h_

#ifndef uid_t
#include <sys/types.h>
#endif

extern int gethostname();
extern int getsockname();

extern int socket();
extern int bind();
extern int listen();
extern int accept();
extern int connect();

extern int select();
extern int read();
extern int write();
extern int close();

extern int atoi();

extern int printf();
extern char *sprintf();
extern int fprintf();
extern int vfprintf();

extern int _filbuf();
extern int ungetc();
extern char *fputs();

extern int sscanf();
extern int fscanf();

extern int fflush();
extern int fclose();

extern void bzero();
extern void bcopy();

extern char *strchr();
extern char *strrchr();
extern char *strcat();

/* extern int getuid(); */
extern uid_t getuid();

extern int getpid();
extern char *getenv();
extern char *realpath();
extern int unlink();

extern void free();

extern int sigblock();
extern int sigsetmask();

extern int dup();

extern int fork();
extern int pipe();
extern int execv();

/* extern int sleep(); */
extern unsigned sleep();

extern int wait();

extern int getrusage();

#endif /* _hExternStdFunc_h_ */
