/* hDaemonLib.h;
 *
 *	a Header for Helios Daemon Library
 *		created by k3sato on May 25th in 1994.
 *
 *	modification history:	
 *	(1) add HdAgentSockInfo structure for Socket information
 *		on August 5th in '94.
 *	(2) add delete_agent()
 *		on October 11th in '94.
 *	(3) add the define of HdLibMaxNumOfRetry
 *		on December 10th in '94.
 *
 * $Id: hDaemonLib.h,v 2.0 1994/12/10 10:03:17 k3sato Exp $
 */

#include <helios/heliosd.h>

#define HdLibMaxNumOfRetry	16

/*
 *	define struct types
 */
/*	structure for socket information for AgentId
 */
typedef struct _HdAgentSockInfo	*HHdAgentSockInfo;

typedef struct _HdAgentSockInfo {
    char		*agentId;
    struct sockaddr_in	*sockInfo;
    HHdAgentSockInfo	next;
} HdAgentSockInfo;

/*
 *	type definition of functions
 */
int heliosdInit();
struct sockaddr_in *get_agent();
struct sockaddr_in *wake_agent();
HdBoolean delete_agent();
HAgentInfo get_agentInfo();
HdBoolean register_paraAgent();

HdBoolean hdGetSockaddrFromDaemon();

HdBoolean hdCreateSocket();
HdBoolean hdCloseSocket();
HdBoolean hdSendMessage();
HdBoolean hdReceiveMessage();
