#include <netinet/in.h>

extern struct sockaddr_in my_addr;

#define TX_QUEUE_SIZE 16
#define TX_QUEUE_MASK 15
#define RX_QUEUE_SIZE 16
#define RX_QUEUE_MASK 15

struct agent {
  int status;
  struct sockaddr_in addr;
  int sock;
  int cur_tx, cur_rx;
  int dirty_tx, dirty_rx;
  struct q rx_queue[RX_QUEUE_SIZE];
  struct q tx_queue[TX_QUEUE_SIZE];
};

#define MAX_AGENT 64

#define AGENT_FREE              0
#define AGENT_NO_CONNECTION     1
#define AGENT_CONNECTING        2
#define AGENT_ACTIVE            3
#define AGENT_CLOSING           4
#define AGENT_PEER_DIED         5

extern struct agent agents[];
extern struct agent *fd_to_agent[];

extern struct agent *comm_get_agent (char *name);
extern int accept_agent (int s, struct sockaddr_in *peer);
extern int connect_agent (struct agent *a);
extern void init_agent (void);
extern void invalidate_agent_internal (struct agent *a);
extern void invalidate_agent (char *agent_name);
