#include <helios/comm_q.h>
#include <helios/comm_agent.h>

/* PORT specifies port number to listen */
/* Returns 0 on success.                */
extern int init_comm (int port, int user_p);

/* 
  rpc_idP 
  m
  lenP
 */
extern int receive_a_message (int *rpc_idP, void *m, int *lenP);

/* AG: agent
   M: message
   LEN: length of message
   returns RPC_ID
 */
extern int send_a_message (char *ag, void *m, unsigned int len);

extern void accept_socket (void);
extern int write_to_socket (struct agent *a);
extern int read_from_socket (struct agent *a);

extern fd_set io_r_fds, io_w_fds, io_e_fds;
extern int listen_sock;
extern int udp_sock;

/**/
#define RUDP_SYNC 0
#define RUDP_DATA 1
#define RUDP_ACK  2

struct rudp {
  unsigned short seq;
  struct sockaddr_in sock_addr;
};
