/* capldata.h
 *        $B%3!<%I$r@8@.$9$k$?$a$N>pJs$N@k8@(B
 *        $B3FJQ?t$O(B main.c $B$GDj5A$9$k(B
 */

#include "define.h"

#ifdef __main__
#define global
#else
#define global extern
#endif

#ifndef __capldata__
#define __capldata__

#define ON  1
#define OFF 0

#define SIMPLE     0
#define COMPLEX    1
#define PARAMETRIC 2

#define SAME_PROC 0
#define PIPE      1
#define SOCKET    2

struct _para_data {
  char *para_name;
  char *para_type;
  char *para_init;
};
typedef struct _para_data para_data;

struct _type_data {
  char *type_name;
  cap_type type_type;
};
typedef struct _type_data type_data;

struct _import_data {
  char *common_method;
  char *inner_method;  /* $B8r>D!&<jB3$-$N8F$S=P$7$N>l9g!"(B
			* $B8r>DL>!&<jB3$-L>$,F~$k(B
			*/
  char *np_name;
  char *to;
  char *manage;
  char *common_signature;
  char *inner_signature;
  int  dist;   /* SUB_CALL, NEGO, PROC */
};
typedef struct _import_data import_data;

struct _export_data {
  char *common_method;
  char *inner_method;
  char *common_signature;
  char *inner_signature;
  char *to;
  char *manage;
};
typedef struct _export_data export_data;

struct _call_data {
  char *method;    /* $B<B$N=hM}$KBP1~$9$kCf4V%a%=%C%I(B */
  char *sub_proc;  /* $B<B$N=hM}L>(B */
  char *method_signature;
  char *sub_proc_signature;
};
typedef struct _call_data call_data;

struct _query_data {
  char *method; /* $B<B$+$i$N8F$S=P$7$KBP1~$9$kCf4V%a%=%C%I(B */
  char *sub_proc;
  char *np_name; /* $B8r>DL>!&<jB3$-L>(B */
  char *method_signature;
  char *sub_proc_signature;
  int  dist; /* EX_ASK, NEGO, PROC */
};
typedef struct _query_data query_data;

struct _np_event_data {
  char *np_name;
  char *state;
  int  queue;
  int  mtype;
  char *method;
  char *func_name;
};
typedef struct _np_event_data np_event_data;

global int agent_type;           /* $B%(!<%8%'%s%H$N%?%$%W(B */
global int lock_swt;             /* $BGSB>@)8f$N(BON/OFF */
global int trans_swt;            /* $B%H%i%s%6%/%7%g%s=hM}$N(B ON/OFF */
global int connect_type;         /* $B<B$HHi$N@\B3J}K!(B */
global char *agent_name;         /* $B%(!<%8%'%s%H$NO@M}M}L>(B */
global char *env_name;           /* $B%(!<%8%'%s%H$,B0$9$k4D6-(B */
global char *agent_id;           /* $B%(!<%8%'%s%H$N<1JL;R(B */
global char *sub_type;           /* $B<B$N8GM-7?(B */
global char *ap_name[AP_MAX+1];  /* $B%(!<%8%'%s%H%W%m%;%9$NL>A0(B */
global char *path;               /* $B<B$N%7%9%F%`$N%Q%9(B */
global char *insides[ARG_MAX+1]; /* $B%(!<%8%'%s%H$NCf?H(B 
				  *  or $B%(!<%8%'%s%HFbIt$N4D6-(B 
				  */
global char *lib[LIB_MAX];       /* $B%W%m%;%9$H%j%s%/$9$k%i%$%V%i%j(B */
global char *inside_sub;         /* $B%(!<%8%'%s%H$NCf?H$N%W%m%0%i%`(B */
global char *comment;            /* $B<+8J%b%G%kFb$N%3%a%s%H(B         */

global int num_of_import;                  /* $BM"F~%a%=%C%I$NAm?t(B */
global import_data import_list[TABLE_MAX];

global int num_of_export;                  /* $BM"=P%a%=%C%I$NAm?t(B */
global export_data export_list[TABLE_MAX];

global int num_of_call;                    /* $B<B$N=hM}$NAm?t(B */
global call_data call_list[TABLE_MAX];     /* $B<B$N=hM}(B */

global int num_of_query;                   /* $B<B$+$i$NLd$$9g$o$;$NAm?t(B */
global query_data query_list[TABLE_MAX];   /* $B<B$+$i$NLd$$9g$o$;(B */

global int num_of_para;
global para_data para_list[PARA_MAX];      /* $B%Q%i%a!<%?!<(B */

global int num_of_type;
global type_data type_list[TYPE_MAX];      /* $B6&DL7?$N>pJs(B */

global int num_of_np_state;
global char *np_state[TABLE_MAX];
global int  np_state_np[TABLE_MAX];

global int num_of_proc_event;                   /* $B<jB3$-$N%$%Y%s%H?t(B */
global int num_of_nego_event;                   /* $B8r>D$N%$%Y%s%H?t(B   */
global np_event_data proc_event_list[NEGO_MAX]; /* $B8r>D$N=hM}(B   */
global np_event_data nego_event_list[PROC_MAX]; /* $B<jB3$-$N=hM}(B */
#endif __capldata__

/* end of capldata.h */
