/* Variable */


#ifndef __SMessage__
#define __SMessage__


/*
SMessage     S Message $BK\BN(B  Black Box

SMType       Message Type    Black Box
SMMid        Message ID      Black Box
SMFrom       From            Black Box
SMTo         To              Black Box
SMTS         TID or Status   Black Box
SMMethod     Method Name     Black Box
SMData       Method $B0z?t(B     Black Box */
/* Simple Message Format */

typedef struct _SMType {
 enum {ASK , REPLY ,CONTROL} type;  /* 0 for ASK , 1 for REPLY , 2 for CONTROL*/
 char* debug;

} SMType_m;

typedef SMType_m *SMType; /* Message Type */

typedef char* SMMid; /* Message ID */


typedef	char*  SMFrom;   /* From */

typedef struct {        /* To */
	char* AF;      /* $BAw?.@h(BAid $B$^$?$O!"5!G=L>(B */
	int method;    /* $B%a%=%C%I%G%#%l%/%H%j%U%i%0(B */
	char* management;     /* $B=hM}L>(B | NULL */
} SMTo_m;

typedef SMTo_m *SMTo;

typedef char* SMTS;      /* TID or Status */
                        /* Status ::= normal etc,. */
                        /* TID $B$b(Bstring$B$G3JG<$9$k!#(B*/
                        /* TID ::= AgnetID - LocalTransactionID | NULL*/

typedef char* SMMethod;   /* $B%a%=%C%IL>(B */

typedef char* SMData;     /* $B0z?tItJ,(B */


 /* $B%a%C%;!<%8K\BN(B  $B$3$N%a%C%;!<%87A<0(B($B<BAu(B)$B$r(BS Message $B$H8F$V!#(B */

typedef struct {
	SMType mtype;
	SMMid mid;     
	SMFrom from;
	SMTo  to;
	SMTS ts;               
	SMMethod method;
	SMData data;
} SMessage_m;

typedef SMessage_m *SMessage;


/* S Message */

extern     SMessage CSMInit();
/*  SMessage$B$r=i4|2=$9$k!#(BSMessage$BJQ?t(B(SMessage)$B@k8@8e!":G=i$K0lEY$@$1(B
  $B9T$J$o$l$k!#A4$F$NMWAG$N=i4|2=$,9T$J$o$l$k!#(B*/

extern     SMessage CSMDelete();
/*  SMessage$B$r>C5n$9$k!#$=$NFbMF$OA4$F>CLG$9$k!#;2>H$r;}$C$F$$$k>l9g$K(B
  $BCm0U$9$k$3$H!#(B
*/
extern     SMessage CSMNewData(SMType,SMMid,SMFrom,SMTo,SMTS,SMMethod,SMData);
/*  $B3F0z?t$rMWAG$K;}$D(B SMessage$B$r?7$?$K:n@.$9$k!#(BNULL$B$r0z?t$H$9$k$H!"(BSMessage
  $B$N$=$l$KBP1~$9$kMWAG$O6u$K$J$k!#(B
*/
extern     SMessage CSMDuplicateMessage(SMessage); 
/*  SMessage $B$rJ#@=$9$k!#(B
*/
extern     SMessage CSMPut(SMessage,SMType,SMMid,SMFrom,SMTo,SMTS,SMMethod,SMData);
/*  SMessage $B$N3FMWAG$K0z?t$G;XDj$5$l$?>pJs$rF~$l$k!#?7$?$J>pJs$rF~$l$k:]!"(B
  $B0JA0$NMWAG$NFbMF$O>C5n$5$l$k!#0z?t$,(BNULL$B$N>l9g$K$O!"0JA0$N>pJs$,;D$k!#(B
*/  

/*
extern     int CSMGet(SMessage,*SMType,*SMMid,*SMFrom,*SMTo,*SMTS,*SMMethod,*SMData); */
/*  SMessage $B$N3FMWAG$r;2>H$9$k!#0z?t$N(BSMessage$B$O=q$-49$($i$l$J$$!#(B
  $BLa$jCM$O!"3FMWAG$,<h$j=P$;$J$+$C$?>l9g(B(SMessage$B$K0[>o$,$"$k>l9g(B)$B$O(B1 
  $B@5>o$J$i(B0 $B$G$"$k!#(B
*/

/* Message Type */

extern     SMessage CSMPutType(SMessage,SMType);
/*$B!C(BSMessage$B$K%a%C%;!<%8%?%$%V>pJs$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/

extern     SMType   CSMGetType(SMessage);
/*  SMessage$B$N%a%C%;!<%8%?%$%V>pJs$r;2>H$9$k!#(B*/

extern     int     CSMIsTypeAsk(SMessage);
/*  $B$=$N(BSMessage$B$,Ld$$9g$o$;$J$i(B1$B!"$=$&$G$J$1$l$P(B0$B!#(B*/

extern     int     CSMIsTypeReply(SMessage);
/*  $B$=$N(BSMessage$B$,JV?.$J$i??!"$=$&$G$J$1$l$P56!#(B*/

extern     int     CSMIsTypeControl(SMessage);
/*  $B$=$N(BSMessage$B$,%3%s%H%m!<%k$J$i??!"$=$&$G$J$1$l$P56!#(B*/

extern     int     CSMWhatType(SMessage);
/*  $B$=$N(BSMessage$B$,Aw?.$J$i(B0,$BJV?.$J$i(B1,$B%3%s%H%m!<%k$J$i(B2$B!#(B*/

extern     SMessage CSMTypeAsk(SMessage);
/*  SMessage$B$N(BType$B$KLd$$9g$o$;$r0UL#$9$k>pJs$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/

extern     SMessage CSMTypeReply(SMessage);
/*  SMessage$B$N(BType$B$KJV?.$r0UL#$9$k>pJs$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/

extern     SMessage CSMTypeControl(SMessage);
/*  SMessage$B$N(BType$B$K%3%s%H%m!<%k$r0UL#$9$k>pJs$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/

extern     SMessage CSMPutDebuginfoStr(SMessage,char*);
/*  SMessage$B$K%G%P%C%0>pJs(B($B%f!<%6L>(B)$B$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/

extern     char*    CSMGetDebuginfoStr(SMessage);
/*  SMessage$B$N%G%P%C%0>pJs(B($B%f!<%6L>(B)$B$r;2>H$9$k!#(B
  $B%G%P%C%0>pJs$,$J$$>l9g$O!"(BNULL$B$,JV$5$l$k!#(B*/

extern    SMessage CSMTypeFree(SMessage);
/* Type $B$N%a%b%jNN0h$r2rJ|$9$k!#(B */

extern     int     CSIsTypeAsk(SMType);
/*  $B$=$N(BSMType$B$,Ld$$9g$o$;$J$i??!"$=$&$G$J$1$l$P56!#(B*/

extern     int     CSIsTypeReply(SMType);
/*  $B$=$N(BSMType$B$,JV?.$J$i??!"$=$&$G$J$1$l$P56!#(B*/

extern     int     CSIsTypeControl(SMType);
/*  $B$=$N(BSMessage$B$,%3%s%H%m!<%k$J$i??!"$=$&$G$J$1$l$P56!#(B*/

extern     int     CSWhatType(SMType);
/*  $B$=$N(BSMType$B$,Aw?.$J$i(B0,$BJV?.$J$i(B1,$B%3%s%H%m!<%k$J$i(B2$B!#(B*/

extern     SMType     CSPutType(SMType,int);
/*  SMType$B$K>pJs$rF~$l$k!#Aw?.$J$i(B0,$BJV?.$J$i(B1,$B%3%s%H%m!<%k$J$i(B2$B!#(B*/

extern     SMType CSPutDebuginfoStr(SMType,char*);
/*  SMType$B$K%G%P%C%0>pJs(B($B%f!<%6L>(B)$B$rF~$l$k!#0JA0$NFbMF$O>C5n$5$l$k!#(B*/

extern     char*    CSGetDebuginfoStr(SMType);
/*  SMType$B$N%G%P%C%0>pJs(B($B%f!<%6L>(B)$B$r;2>H$9$k!#(B
  $B%G%P%C%0>pJs$,$J$$>l9g$O!"(BNULL$B$,JV$5$l$k!#(B*/

/* Message ID */

extern     SMessage CSMPutMid(SMessage,SMMid);
/* SMessage$B$K(BMid$B$rF~$l$k!#(B 
   $B0z?t$N(BSMMid$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     SMMid    CSMGetMid(SMessage);
/*  SMessage$B$N(BMid$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(BMid$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BMid$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMessage CSMPutMidStr(SMessage,char *);
/*  SMessage$B$N(BMid$B$N>pJs$r(BString$B$GF~$l$k!#(B
  $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/


extern     char*    CSMGetMidStr(SMessage);
/*  SMessage$B$N(BMid$B>pJs$r(BString$B$H$7$F;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(Bstring$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMessage CSMPutMidStrInt(SMessage,char * Aid ,int num);
/*  SMessage$B$N(BMid$B$N(BAid$BItJ,$HDL$7HV9f>pJs$rF~$l$k!#(BAid$B$O(BC $B8@8l$N(Bstring$B$G$"$k!#(B
  $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     SMessage CSMMidFree(SMessage);
/* message $B$N(Bmid $BItJ,$N%a%b%j$r2rJ|$9$k!#(B */

/* From */

extern     SMessage CSMPutFrom(SMessage,SMFrom);
/*$B!C(BSMessage$B$K(BSMFrom$B$rF~$l$k!#(B 
$B!C0z?t$N(BSMFrom$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     SMFrom   CSMGetFrom(SMessage);
/*  SMessage$B$N(BFrom$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(BSMFrom$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMessage CSMPutFromAidStr(SMessage,char *);
/*  SMessage$B$N(BFrom$B$N(BAid$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char *   CSMGetFromAidStr(SMessage);
/*  SMessage$B$N(BFrom$B$N(BAid$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(BAid$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern    SMessage CSMFromFree(SMessage message);
/* From $B$N%a%b%jNN0h$r2rJ|$9$k!#(B*/

extern     SMFrom   CSPutFromAidStr(SMFrom,char *);
/*  SMFrom$B$N(BAid$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char *   CSGetFromAidStr(SMFrom);
/*  SMFrom$B$N(BFrom$B$N(BAid$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$N(BAid$B$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

/* To */

extern     SMessage CSMPutTo(SMessage,SMTo);
/*$B!C(BSMessage$B$K(BTo$B$rF~$l$k!#(B 
$B!C0z?t$N(BSMTo$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     SMTo    CSMGetTo(SMessage);
/*  SMessage$B$N(BTo$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMessage CSMPutToAFStr(SMessage,char *);
/*  SMessage$B$N(BTo$B$N(BAid$B$^$?$O5!G=L>$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSMGetToAFStr(SMessage);
/*  SMessage$B$N(BTo$B$N(BAid$B$^$?$O5!G=L>$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMessage CSMSetToMethod(SMessage);
/*  SMessage$B$N(BTo$B$K%a%=%C%I%U%#!<%k%I$HF1$8J8;zNs>pJs$,<h$j=P$;$kMM$K(B
  $B@_Dj$9$k!#$3$l$O!"%a%=%C%I%G%#%l%/%H%j$r;H$&$h$&$K$9$k@_Dj$G$"$k!#(B*/

extern     SMessage CSMResetToMethod(SMessage);
/*  SMessage$B$N(BTo$B$+$i%a%=%C%IL>$,<h$j=P$;$J$$MM$K@_Dj$9$k!#(B
    $B$3$l$O!"%a%=%C%I%G%#%l%/%H%j$r;H$&$h$&$K$9$k@_Dj$G$"$k!#(B*/

extern     char*    CSMGetToMethodStr(SMessage);
/*  SMessage$B$N(BTo$B$N%a%=%C%IL>$r;2>H$9$k!#(B
  $BLa$jCM$O!"%a%C%;!<%8Cf$N%a%=%C%IL>$G$"$k!#(B
  $BLa$jCM$,(BNULL$B$N;~$O!"%a%=%C%I%G%#%l%/%H%j$r;HMQ$7$J$$!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/


extern     SMessage CSMPutToManagementStr(SMessage,char* );
/*  SMessage$B$N(BTo$B$N=hM}L>$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSMGetToManagementStr(SMessage);
/*  SMessage$B$N(BTo$B$N=hM}L>$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern    SMessage CSMToFree(SMessage message);
/* To $B$N%a%b%jNN0h$r2rJ|$9$k!#(B */

extern     SMTo CSPutToAFStr(SMTo,char *);
/*  SMTo$B$N(BAid$B$^$?$O5!G=L>$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSGetToAFStr(SMTo);
/*  SMTo$B$N(BAid$B$^$?$O5!G=L>$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMTo CSPutToManagementStr(SMTo,char* );
/*  SMTo$B$N=hM}L>$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(Bstring$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSGetToManagementStr(SMTo);
/*  SMTo$B$N=hM}L>$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/


/* Status or Transaction ID */

extern     SMessage CSMPutSMTS(SMessage,SMTS);
/*$B!C(BSMessage$B$N(BSMTS$B$K>pJs$rF~$l$k!#(B 
$B!C0z?t$N(BSTS$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     SMTS     CSMGetSMTS(SMessage);
/*  SMessage$B$N(BSMTS$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMessage CSMPutTidStr(SMessage,char*);
/*  SMessage$B$N(BTid$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B
  SMessage$B$,Aw?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/

   SMessage CSMPutTidStrInt(SMessage message,char* mtid, int n);
/*  SMessage$B$N(BTid$B$K(BAid$B$H(BLocal Tid$B>pJs$rF~$l$k!#(B 
  $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B
  SMessage$B$,Aw?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/

extern     char*    CSMGetTidStr(SMessage);
/*  SMessage$B$N(BTid$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B
  SMessage$B$,Aw?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/

extern     SMessage CSMPutStatusStr(SMessage,char*);
/*  SMessage$B$N(BStatus$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(BSMTS$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B
  SMessage$B$,JV?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/

extern     char*    CSMGetStatusStr(SMessage);
/*  SMessage$B$N(BSMTS$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B
  SMessage$B$,JV?.$G$J$$$H$-$K$O(BNull$B$rJV$9!#(B*/

extern    SMessage CSMSMTSFree(SMessage message);
/* SMTS$B$N%a%b%jNN0h$r2rJ|$9$k!#(B */

extern     SMTS CSPutTidStr(SMTS,char*);
/*  SMTS$B$r(BTid$B$H$7$F>pJs$rF~$l$k!#(B 
  $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSGetTidStr(SMTS);
/*  SMTS$B$r(BTid$B$H$_$F>pJs$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMTS CSPutStatusStr(SMTS,char*);
/*  SMTS$B$N(BStatus$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSGetStatusStr(SMTS);
/*  SMTS$B$r(BStatus$B$H$7$F>pJs$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/


/* Method Name*/
extern     SMessage CSMPutMethod(SMessage,SMMethod );
/*$B!C(BSMessage$B$N(BMethod Name$B$K>pJs$rF~$l$k!#(B 
$B!C0z?t$N(BSMMethod$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     SMMethod CSMGetMethod(SMessage);
/*  SMessage$B$N(BMethod Name$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMessage CSMPutMethodStr(SMessage,char* );
/*  SMessage$B$N(BMethod Name$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSMGetMethodStr(SMessage);
/*  SMessage$B$N(BMethod Name$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern    SMessage CSMMethodFree(SMessage message);
/* Method $B$N%a%b%jNN0h$r%/%j%"$9$k!#(B */

extern     SMMethod CSPutMethodStr(SMMethod,char* );
/*  SMMethod$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSGetMethodStr(SMMethod);
/*  SMessage$B$N(BMethod Name$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/


/*   Data  */

extern     SMessage CSMPutData(SMessage,SMData);
/*$B!C(BSMessage$B$N(BData$B$K>pJs$rF~$l$k!#(B 
$B!C0z?t$N(BSMMethod$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     SMData   CSMGetData(SMessage);
/*  SMessage$B$N(BData$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern     SMessage CSMPutDataStr(SMessage,char*);
/*  SMessage$B$N(BData$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*    CSMGetDataStr(SMessage);
/*  SMessage$B$N(BData$B$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/

extern    SMessage CSMDataFree(SMessage);
/* Data $B$N%a%b%jNN0h$r2rJ|$9$k!#(B */

extern     SMData   CSPutDataStr(SMData,char*);
/*  SMData$B$K>pJs$rF~$l$k!#(B 
  $B0z?t$N(BString$B$O;2>H$5$l$k$@$1$G!"JQ99$d>C5n$O$5$l$J$$!#(B*/

extern     char*     CSGetDataStr(SMData);
/*  SMData$B$N>pJs$r;2>H$9$k!#(B
  $B85$N(BSMessage$B$,>C5n$5$l$k$H$3$NLa$jCM$b>C5n$5$l$k$N$GCm0U!#$^$?!"FbMF(B
  $B$r=q$-49$($k$H85$N(BSMessage$B$NFbMF$bJQ2=$7$F$7$^$&$N$GCm0U!#(B*/


#endif __SMessage__
