/* hiagMkInit.c
 *	module to make helios.init
 *		created by k3sato on March15th in '95.
 *
 * $Id: hiagMkInit.c,v 1.0 1995/03/31 11:29:57 k3sato Exp k3sato $
 */

#include <stdio.h>
#include <dirent.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <string.h>
#include <fcntl.h>
#include <memory.h>
#include <errno.h>

#include <helios/hdMessage.h>
#include <helios/hExternStdFunc.h>

#include "hiag.h"
#include "hiagData.h"
#include "hiagCommon.h"
#include "hdcommon.h"

extern int rename();

HdBoolean hdMakeInitFile();
HdBoolean hdRenameInitFile();

static HdBoolean hdSetupInitFile();
static HdBoolean hdPutsInitInfo();

/*
 * Make the file - helios.init
 */
HdBoolean hdMakeInitFile(hdCtlInfo)
    HeliosdCtlInfo	*hdCtlInfo;
{

    if (hdRenameInitFile(hdCtlInfo) == HdTrue) {

	return hdSetupInitFile(hdCtlInfo);
    }

    hdPrintf("Error in renaming helios.init to helios.init~\n");
    return HdFalse;
}

/*
 * Rename init file if helios.init already exists.
 */
HdBoolean hdRenameInitFile(hdCtlInfo)
    HeliosdCtlInfo	*hdCtlInfo;
{
    DIR		*initDirP;
    int		initFd;
    char	*bufPtr;
    char	initFile[HeliosdFilePathLen_Lim];
    char	initFileTilde[HeliosdFilePathLen_Lim];

    sprintf(initFile, "%s", hdCtlInfo->fullPath);

    if ((bufPtr = strrchr(initFile, '/')) == NULL) {
	hdPrintf("Data error in fullPath(%s)\n", hdCtlInfo->fullPath);
	return HdFalse;
    }

    *bufPtr = HdChar_NULL;

    if ((initDirP = opendir(initFile)) == NULL) {
	hdPrintf("Can't opendir %s\n", initFile);
	return HdFalse;
    }

    sprintf(initFile, "%s%s", hdCtlInfo->fullPath, HeliosInitFileName);
    sprintf(initFileTilde, "%s%s~", hdCtlInfo->fullPath, HeliosInitFileName);

    if ((initFd = open(initFile, O_CREAT|O_RDWR|O_EXCL, 00664)) < 0) {
	if (errno == EEXIST) {
	    if (rename(initFile, initFileTilde) < 0) {
		hdPerror();
		goto Close_Error_Rtn;
	    }
	}
    } else {
	close(initFd);
    }
    closedir(initDirP);

    return HdTrue;

 Close_Error_Rtn:
    closedir(initDirP);
    return HdFalse;
}

/*
 *	Setup the init file
 */
static HdBoolean hdSetupInitFile(hdCtlInfo)
    HeliosdCtlInfo	*hdCtlInfo;
{
    char		initFile[HeliosdFilePathLen_Lim];
    FILE		*fp;
    HeliosdErrorMsgType	eMsgType;

    sprintf(initFile, "%s/%s", hdCtlInfo->fullPath, HeliosInitFileName);

    if ((fp = fopen(initFile, "w")) == (FILE *)NULL) {
	eMsgType = HdEMsg_InitFileOpenError;
	goto Error_Rtn;
    }

    fprintf(fp, hiagHeaderOfInitFile);
    prnCurrTime(fp);

    if (hdPutsInitInfo(hdCtlInfo, fp, hdCtlInfo->allAgents) == HdFalse) {
	eMsgType = NULL;
	hdPrintf("Error in hdPutsInitInfo.\n");
	goto Close_Error_Rtn;
    }

    fclose(fp);

    return HdTrue;

 Close_Error_Rtn:
    fclose(fp);

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/*
 *	Write the init data to the init file - helios.init
 */
static HdBoolean hdPutsInitInfo(hdCtlInfo, fp, agentInfo)
    HeliosdCtlInfo	*hdCtlInfo;
    FILE		*fp;
    HAgentInfo		agentInfo;
{
    HAgentInfo		info;

    for (info = agentInfo; info != NULL; info = info->next) {

	if (info->type == HdAT_Complex) {
	    if (fprintf(fp, "#\n# %s\tComplex Agent : %s\n#\n",
			info->agentId, info->agentName) == EOF) {
		goto Error_Rtn;
	    }
	    if (hdPutsInitInfo(hdCtlInfo, fp, info->child) == HdFalse) {
		goto Error_Rtn;
	    }
	} else {
	    if (fprintf(fp, "%s\t%s\t%d",
			info->agentId,
			info->sockInfo.hostName,
			info->groupNum)
		== EOF) {
		goto Error_Rtn;
	    }
	    if (fprintf(fp, (info->procArgs != NULL) ? "\t%s\n" : "\n",
			info->procArgs)
		== HdFalse) {
		goto Error_Rtn;
	    }
	}
    }

    return HdTrue;

 Error_Rtn:
    return HdFalse;
}
