/* hiagMakefile.c
 *	module to make Makefile in agent process directory.
 *		created by k3sato on March15th in '95.
 *
 * $Id: hiagMakefile.c,v 1.0 1995/03/31 11:29:57 k3sato Exp k3sato $
 */

#include <stdio.h>
#include <pwd.h>

#include <helios/hdMessage.h>
#include <helios/hExternStdFunc.h>

#include "hiag.h"
#include "hiagData.h"
#include "hiagCommon.h"
#include "hdcommon.h"

static HdBoolean hdGetLoginName();

/*
 *
 */
HdBoolean hdSetupMakefileInCmdDir(hiagCtlInfo, agentName)
    HiagCtlInfo		*hiagCtlInfo;
    char		*agentName;
{
    FILE		*fp;
    char		loginName[AgentNameLen_Lim];
    char		filePath[HeliosdFilePathLen_Lim];
    HeliosdErrorMsgType	eMsgType;

    sprintf(filePath, "%s/cmd_%s/Makefile", hiagCtlInfo->currDir, agentName);

    if (hdGetLoginName(loginName) == HdFalse) {
	eMsgType = HdEMsg_GetLoginNameError;
	goto Error_Rtn;
    }

    if ((fp = fopen(filePath, "w")) == NULL) {
	eMsgType = HdEMsg_MakefileFileOpenError;
	goto Error_Rtn;
    }

    if (fprintf(fp, hiagAgentMakefileHead, agentName, loginName) == EOF) {
	eMsgType = HdEMsg_Fail2FprintfAgentMakefileHead;
	goto Close_Error_Rtn;
    }

    prnCurrTime(fp);

    if (fprintf(fp, hiagAgentMakefileTail, agentName) == EOF) {
	eMsgType = HdEMsg_Fail2FprintfAgentMakefileTail;
	goto Close_Error_Rtn;
    }

    fclose(fp);

    return HdTrue;

 Close_Error_Rtn:
    fclose(fp);

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/* $B%f!<%6!&%$%s%?%U%'!<%9$N(B agent $BL>(B $B$H$7$F!"(B
 * $B%f!<%6$N(B login name $B$r@_Dj$9$k!#(B
 */
static HdBoolean hdGetLoginName(name)
    char		*name;
{
    struct passwd	*userpwd;
    HeliosdErrorMsgType	eMsgType;

    /* hiag $B$r5/F0$7$?%f!<%6$N(B login $BL>$N3MF@(B */
    if ((userpwd = getpwuid(getuid())) == NULL) {
	eMsgType = HdEMsg_NotGetLoginNameOfUser;
	goto Error_Rtn;
    }

    sprintf(name, "%s", userpwd->pw_name);

    return HdTrue;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}
