/* hiagMain.c:
 *	main program to make two files - helios.hia and helios.init
 *		created by k3sato on March15th in '95.
 *
 *	modification history:	
 *	(1) 
 *
 * $Id: hiagMain.c,v 1.0 1995/03/31 11:29:57 k3sato Exp k3sato $
 */

#include <stdio.h>
#include <sys/param.h>
#include <string.h>
#include <fcntl.h>
#include <memory.h>
#include <sys/socket.h>

#include <helios/hdMessage.h>
#include <helios/hExternStdFunc.h>

#include "hiag.h"
#include "hiagAgentInfo.h"
#include "hiagDirInfo.h"
#include "hiagCommon.h"
#include "hdcommon.h"

/* defined in daemon/hdHiaInfo.c
 */
extern HdBoolean hdGetHiaInfo();

/* defined in mkInit.c
 */
extern HdBoolean hdMakeInitFile();

/* defined in hiagAgentInfo.c
 */
char *hdGetHeliosdFullPath();

static HdBoolean hdGetMachInfo();
static HMachInfo hdMakeDataOfMachInfo();

void hdErrorExit();

void main(argc, argv)
    int		argc;
    char	*argv[];
{
    HiagCtlInfo		hiagCtlInfo;
    HeliosdCtlInfo	hdCtlInfo;	/* Heliosd Control information */
    HeliosdErrorMsgType	eMsgType;

    memset(&hiagCtlInfo, 0, sizeof(HiagCtlInfo));
    memset(&hdCtlInfo, 0, sizeof(HeliosdCtlInfo));

    hiagCtlInfo.hdCtlInfo = &hdCtlInfo;

    /*
     *  setup directories in HELIOSDIR/app
     */
    if (hdSetupDirInfo(&hiagCtlInfo, argc, argv) == HdFalse) {
	eMsgType = HdEMsg_SetupDirInfoError;
	goto Error_Exit;
    }

    /*
     *	$B%^%7%s>pJs$N3MF@(B
     */
    if (hdGetMachInfo(&hdCtlInfo, &(hdCtlInfo.machInfo)) == HdFalse) {
	eMsgType = HdEMsg_GetMachInfoError;
	goto Error_Exit;
    }

    /*
     *	$B%X%j%*%9!&%G!<%b%s$,N)$A>e$2$i$l$?%^%7%s$G(B
     *	$B07$&$3$H$N=PMh$kA4%(!<%8%'%s%H>pJs$N3MF@(B
     */
    if (hdGetHiaInfo(&hdCtlInfo, &hdCtlInfo.allAgents) == HdFalse) {
	hdPutsErrorMsg(HdEMsg_HiaFileError);
    }

    /*
     * $B%U%!%$%k(B *.cpl, *.evl $B$+$iF@$?>pJs$r85$K!"(Bhia $B%U%!%$%k$N99?7(B
     */
    if (hdUpdateHiaInfo(&hiagCtlInfo) == HdFalse) {
	eMsgType = HdEMsg_UpdateHiaInfoError;
	goto Error_Exit;
    }

    /*
     * write the initial data of agent to the file; helios.init
     */
    if (hdMakeInitFile(&hdCtlInfo) == HdFalse) {
	hdPrintf("Error in making helios.init\n");
	exit(2);
    }

    exit(0);

 Error_Exit:
    hdErrorExit(eMsgType);
}

/*
 *	$B%^%7%s>pJs$N3MF@(B
 */
static HdBoolean hdGetMachInfo(hdCtlInfo, hMachInfo)
    HeliosdCtlInfo	*hdCtlInfo;
    HMachInfo		*hMachInfo;
{
    char		hostname[HostNameLen_Lim];
    HeliosdErrorMsgType	eMsgType;

    /* $B%5!<%P$r5/F0$7$?%^%7%s$N%[%9%HL>(B */
    if (gethostname(hostname, HostNameLen_Lim) == ERROR_FLAG) {
	hdPerror();
	eMsgType = HdEMsg_NotFindHostName;
	goto Error_Rtn;
    }

#ifdef _DEBUG_HELIOSD_HOSTNAME
    fprintf(stderr, "host name : %s\n", hostname);
#endif /* _DEBUG_HELIOSD */

    if ((*hMachInfo = hdMakeDataOfMachInfo(hostname)) == NULL) {
	eMsgType = HdEMsg_MakeDataOfMachInfoError;
	goto Error_Rtn;
    }

    return HdTrue;

 Error_Rtn:
    hdPutsErrorMsg(eMsgType);
    return HdFalse;
}

/*
 *	Make data of MachInfo structure
 */
static HMachInfo hdMakeDataOfMachInfo(hostname)
    char		*hostname;
{
    HMachInfo		machInfo;
    struct hostent	*myhost;
    struct sockaddr_in	*sockAddr;
    HeliosdErrorMsgType	eMsgType;


    if ((myhost = gethostbyname(hostname)) == NULL) {
	eMsgType = HdEMsg_BadHostName;
	goto Error_Rtn;
    }

    if ((machInfo = (HMachInfo)HdMalloc(sizeof(MachInfo))) == NULL) {
	eMsgType = HdEMsg_HdMallocError;
	goto Error_Rtn;
    }

    if ((machInfo->hostName = HdMallocString(hostname)) == NULL) {
	eMsgType = HdEMsg_HdMallocStringError;
	goto Error_Rtn;
    }

    machInfo->addressSize = sizeof(machInfo->sockAddress);
    sockAddr = &(machInfo->sockAddress);

    bzero((char *)sockAddr, machInfo->addressSize);
    sockAddr->sin_family = AF_INET;

    bcopy(myhost->h_addr, (char *)&(sockAddr->sin_addr), myhost->h_length);

#ifdef _Heliosd_Static_Port_Num

    sockAddr->sin_port = HeliosdPortNum;

#else

    sockAddr->sin_port = 0;
    sockAddr->sin_addr.s_addr = INADDR_ANY;

#endif

    return machInfo;

 Error_Rtn:
    hdFreeMachInfo(&machInfo);

    hdPutsErrorMsg(eMsgType);
    return NULL;
}

/*
 *
 */
void hdErrorExit(eMsgType)
    HeliosdErrorMsgType	eMsgType;
{
    hdPutsErrorMsg(eMsgType);
    exit(eMsgType);
}
