/* hiagKeyWord.c;
 *	Key word handle module for hiag
 *		created on March 20th in 1994.
 *
 * $Id: hiagKeyWord.c,v 1.0 1995/03/31 11:29:57 k3sato Exp k3sato $
 */

#include <stdio.h>

#include "hiag.h"
#include "hiagKeyWord.h"

HdKeyWordList HdCplKeyList[] = {
    {"type",	4,	HdCplKW_Type},
    {"Type",	4,	HdCplKW_Type},
    {"TYPE",	4,	HdCplKW_Type},
    {"agent",	5,	HdCplKW_Agent},
    {"Agent",	5,	HdCplKW_Agent},
    {"AGENT",	5,	HdCplKW_Agent},
    {"env",	3,	HdCplKW_Env},
    {"Env",	3,	HdCplKW_Env},
    {"ENV",	3,	HdCplKW_Env},
    {"inside",	6,	HdCplKW_Inside},
    {"Inside",	6,	HdCplKW_Inside},
    {"INSIDE",	6,	HdCplKW_Inside},
    {"import_method",	13,	HdCplKW_ImpMethod},
    {"import_Method",	13,	HdCplKW_ImpMethod},
    {"Import_Method",	13,	HdCplKW_ImpMethod},
    {"IMPORT_METHOD",	13,	HdCplKW_ImpMethod},
    {"export_method",	13,	HdCplKW_ExpMethod},
    {"export_Method",	13,	HdCplKW_ExpMethod},
    {"Export_Method",	13,	HdCplKW_ExpMethod},
    {"EXPORT_METHOD",	13,	HdCplKW_ExpMethod},
    {"comment",	7,	HdCplKW_Comment},
    {"Comment",	7,	HdCplKW_Comment},
    {"COMMENT",	7,	HdCplKW_Comment},
    {NULL,	0,	NULL},
};

HdKeyWordList HdEvlKeyList[] = {
    {"environment",	11,	HdEvlKW_Environment},
    {"Environment",	11,	HdEvlKW_Environment},
    {"ENVIRONMENT",	11,	HdEvlKW_Environment},
    {"agent_dir",	9,	HdEvlKW_AgentDir},
    {"agent_Dir",	9,	HdEvlKW_AgentDir},
    {"Agent_Dir",	9,	HdEvlKW_AgentDir},
    {"AGENT_DIR",	9,	HdEvlKW_AgentDir},
    {"function_dir",	12,	HdEvlKW_FuncDir},
    {"function_Dir",	12,	HdEvlKW_FuncDir},
    {"Function_Dir",	12,	HdEvlKW_FuncDir},
    {"FUNCTION_DIR",	12,	HdEvlKW_FuncDir},
    {"method_dir",	10,	HdEvlKW_MethodDir},
    {"method_Dir",	10,	HdEvlKW_MethodDir},
    {"Method_Dir",	10,	HdEvlKW_MethodDir},
    {"METHOD_DIR",	10,	HdEvlKW_MethodDir},
    {NULL,	0,	NULL},
};

HdKeyWordList HdAgentTypeNameList[] = {
    {"complex",		7,	HdAgentTypeKW_Complex},
    {"Complex",		7,	HdAgentTypeKW_Complex},
    {"COMPLEX",		7,	HdAgentTypeKW_Complex},

    {"single",		6,	HdAgentTypeKW_Single},
    {"Single",		6,	HdAgentTypeKW_Single},
    {"SINGLE",		6,	HdAgentTypeKW_Single},
    {"parametric",	10,	HdAgentTypeKW_Parametric},
    {"Parametric",	10,	HdAgentTypeKW_Parametric},
    {"PARAMETRIC",	10,	HdAgentTypeKW_Parametric},
    {"single parametric",	17,	HdAgentTypeKW_SinglePara},
    {"Single Parametric",	17,	HdAgentTypeKW_SinglePara},
    {"SINGLE PARAMETRIC",	17,	HdAgentTypeKW_SinglePara},
    {NULL,	0,	NULL},
};

HdKeyWordList HdTopEvlKeyList[] = {
    {"&user",	5,	HdTEvlKW_User},
    {"&User",	5,	HdTEvlKW_User},
    {"&USER",	5,	HdTEvlKW_User},
    {"user",	4,	HdTEvlKW_User},
    {"User",	4,	HdTEvlKW_User},
    {"USER",	4,	HdTEvlKW_User},
    {NULL,	0,	NULL},
};

/*
 *
 */
int hdCheckKeyWord(kwList, str)
    HdKeyWordList	*kwList;
    char		*str;
{
    int			len;

    len = strlen(str);

    for (; kwList->len > 0 ; kwList++) {
	if (len == kwList->len
	    && strcmp(str, kwList->keyWord) == 0) {
	    return kwList->type;
	}
    }

    return -1;
}

HdBoolean hdCompKeyWord(kwList, str)
    HdKeyWordList	kwList[];
    char		*str;
{
    int			len;

    len = strlen(str);

    for (; kwList->len > 0 ; kwList++) {
	if (len == kwList->len
	    && strcmp(str, kwList->keyWord) == 0) {
	    return HdTrue;
	}
    }

    return HdFalse;
}
