/* hiag.h:
 *	Header for hiag command
 *		created by k3sato on March17th in '95.
 *
 * $Id: hiag.h,v 1.0 1995/03/31 11:29:57 k3sato Exp k3sato $
 */

#ifndef _hiag_h_

#define _hiag_h_

#include <helios/heliosd.h>

#define HiagDirFileMode		0755

#define HiagAgentId_TopLevel	0
#define HiagAgentId_StartNum	1

#define HiagAppTopDirName	"app"
#define HiagEvlDirName		"evl"
#define HiagCplDirName		"cpl"

#define HiagCplFileDescriptor	"cpl"
#define HiagEvlFileDescriptor	"evl"

#define HiagTopEvlName		"&user"

#define HEvlInfo_Environ	1
#define HEvlInfo_AgentDir	(1<<1)
#define HEvlInfo_FuncDir	(1<<2)
#define HEvlInfo_MethodDir	(1<<3)
#define HEvlInfo_All		(1 | 2 | 4 | 8)

#define HCplInfo_Type		1
#define HCplInfo_Agent		(1<<1)
#define HCplInfo_Env		(1<<2)
#define HCplInfo_Inside		(1<<3)
#define HCplInfo_ImpMethod	(1<<4)
#define HCplInfo_ExpMethod	(1<<5)
#define HCplInfo_Comment	(1<<6)
#define HCplInfo_All		(1 | 2 | 4 | 8 | 16 | 32 | 64)

/* ===============================
 *   define enumeration types
 * =============================== */
/* 
 */
typedef enum {
    HiagPT_NotUsed,
    HiagPT_Single,	/* get one agent info of appName */
    HiagPT_All,		/* get all agent info in directory HELIOSDIR/app */
} HiagProcessType;

/* ===============================
 *   define structure types
 * =============================== */
/*  Name info
 */
typedef struct _HiagNameInfo	*HHiagNameInfo;

typedef struct _HiagNameInfo {
    char		*name;
    HHiagNameInfo	next;
} HiagNameInfo;

/*  agent Id info
 */
typedef struct _HiagAgentIdInfo	*HHiagAgentIdInfo;

typedef struct _HiagAgentIdInfo {
    int			level;
    int			id;
    HHiagAgentIdInfo	parent;
    HHiagAgentIdInfo	child;
} HiagAgentIdInfo;

/*  Information of *.evl and *.cpl
 */
typedef struct _HiagEvlInfo	*HHiagEvlInfo;
typedef struct _HiagCplInfo	*HHiagCplInfo;

typedef struct _HiagEvlInfo {
    char		*fileName;
    char		*environment;
    HiagNameInfo	*agentDir;
    char		*funcDir;
    char		*methodDir;
    HHiagCplInfo	outerCpl;
    HHiagCplInfo	innerCpl;
    HHiagEvlInfo	next;
} HiagEvlInfo;

typedef struct _HiagCplInfo {
    HdAgentType		type;
    char		*agentId;
    char		*agentName;
    HiagNameInfo	*importMethod;
    HiagNameInfo	*exportMethod;
    char		*env;
    char		*inside;
    char		*comment;
    HHiagEvlInfo	outerEvl;
    HHiagEvlInfo	innerEvl;
    HHiagCplInfo	parent;
    HHiagCplInfo	child;
    HHiagCplInfo	brother;
    HHiagCplInfo	next;
} HiagCplInfo;

/* structure for hiag control information
 */
typedef struct _HiagCtlInfo	*HHiagCtlInfo;

typedef struct _HiagCtlInfo {
    HiagProcessType	type;
    char		*heliosDir;
    HiagNameInfo	*appDirName;
    char		*currDir;	/* current directory */
    int			maxAgentId;	/* HiagAgentIdInfo	*idInfo; */
    HiagEvlInfo		*evlInfo;
    HiagCplInfo		*cplInfo;
    HiagCplInfo		*topCplInfo;
    FILE		*hiaFp;
    HeliosdCtlInfo	*hdCtlInfo;
} HiagCtlInfo;

#endif /* _hiag_h_ */
