/* hdMessage.c;
 *	created by k3sato on May 18th in 1994.
 *
 *	Helios Daemon message
 *
 */
#include <stdio.h>
#include <varargs.h>

#include <helios/hdMessage.h>
#include <helios/hExternStdFunc.h>


HdErrorMsgInfo hdErrorMsgInfo[] = {
    {HdEMsg_NoError,			"No Error"},

    /* for Socket Errors */
    {HdEMsg_NotFindHostName,		"Cannot find hostname"},
    {HdEMsg_BadHostName,		"Bad hostname!"},
    {HdEMsg_GetMachInfoError,		"Error in hdGetMachInfo()"},
    {HdEMsg_SocketForServerFailed,	"Socket for server failed"},
    {HdEMsg_SocketCreateFailed,		"Failed to create socket"},
    {HdEMsg_CouldNotBind,		"Failed to bind socket"},
    {HdEMsg_CouldNotConnect,		"Failed to connect socket"},
    {HdEMsg_GetSockName,		"Cannot get socket name"},
    {HdEMsg_CanNotListen,		"Cannot listen"},
    {HdEMsg_SelectError,		"Error in select()"},
    {HdEMsg_IllegalPortNumber,		"Illegal Port number"},
    {HdEMsg_SocketReadError,		"Cannot read from socket"},
    {HdEMsg_SocketWriteError,		"Cannot write to socket"},
    {HdEMsg_GetSockaddrFromDaemonError,	"Cannot get sockaddr_in from heliosd"},
    {HdEMsg_GetAgentFromDaemonError,	"Cannot get agentInfo from heliosd"},
    {HdEMsg_SendSocketInfoError,	"Cannot send SocketInfo to agent"},
    {HdEMsg_SendOneAgentInfoError,	"Error in hdSendOneAgentInfo()"},
    {HdEMsg_CloseError,			"Error in close()"},
    {HdEMsg_CreateSocket2OtherDaemon,	"Error in hdCreateSocket2OtherDaemon()"},
    {HdEMsg_CloseSocket2OtherDaemon,	"Error in hdCloseSocket2OtherDaemon()"},
    {HdEMsg_Send2Daemon,		"Error in hdSend2Daemon()"},
    {HdEMsg_OverMaxNumOfRetryToReadSoc,	"Over the max number of retry to read socket"},
    {HdEMsg_OverMaxNumOfHeliosdPortNum,	"Over the max number of sin_port in heliosd"},
    {HdEMsg_SetPortNum2AgentInfoError,	"Error in hdSetPortNum2AgentInfo()"},
    {HdEMsg_ErrorInHeliosd,		"Error in Helios Daemon"},
    {HdEMsg_TimeoutOnSelect2WriteSock,	"Timeout on select to write to socket"},
    {HdEMsg_NotSelect2Write2Sock,	"Not select to write to socket"},
    {HdEMsg_Retry2GetAgentError,	"Error in hdRetry2GetAgent()"},

    /* for Message Type Errors */
    {HdEMsg_NotExistMsgType,		"Not Exit in message types that heliosd handles"},
    {HdEMsg_MsgTypeMismatch,		"Message Type mismatch"},
    {HdEMsg_NotAskForNextInfo,		"Message Type is not AskForNextInfo"},
    {HdEMsg_NotMsgTypeOfAgentInfo,	"Message type is not of AgentInfo"},

    /* for Agent Infomation Errors */
    {HdEMsg_HiaFileError,		"Cannot Read Hia file"},
    {HdEMsg_AppGuiFileError,		"Cannot Read the Application Gui info file"},
    {HdEMsg_GetAgentPathError,		"Cannot Get the path of agent process"},
    {HdEMsg_AgentStatusTypeError,	"Illegal Agent Status Type"},
    {HdEMsg_NotDefinedHdCtlInfo,	"Not defined HdCtlInfo"},
    {HdEMsg_NotDefinedAgentName,	"Not defined AgentName"},
    {HdEMsg_NotDefinedAgentId,		"Not defined AgentId"},
    {HdEMsg_NotDefinedAgentInfo,	"Not defined AgentInfo in heliosd"},
    {HdEMsg_NotDefinedAgentInfoOnOthers,"Not defined agent info on other daemons"},
    {HdEMsg_SetupHostName2HiaInfoError,	"Error in hdSetupHostName2HiaInfo()"},
    {HdEMsg_CreateUserInfoError,	"Error in hdCreateUserInfo()"},
    {HdEMsg_AppendUserInfoError,	"Error in hdAppendUserInfo()"},
    {HdEMsg_GetNextComponentError,	"Error in hdGetNextComponent()"},
    {HdEMsg_NoExistRepAgent,		"Not exist the representative agent"},
    {HdEMsg_NoExistRepAgentForParametric,"Not exist the representative for the parametric agent"},
    {HdEMsg_NotGetRepAgentInfo,		"Cannot Get the information of representative agent"},
    {HdEMsg_SetupStatus2ParentAgentError,"Error in hdSetupStatus2ParentAgent()"},
    {HdEMsg_AppendAgentSockInfoError,	"Error in hdAppendAgentSockInfo()"},
    {HdEMsg_AppendOtherDaemonsInfoError,"Error in hdAppendOtherDaemonsInfo()"},
    {HdEMsg_MakeDataOfMachInfoError,	"Error in hdMakeDataOfMachInfo()"},
    {HdEMsg_NotDefinedAppGuiInfo,	"Not defined Application Gui info"},
    {HdEMsg_GetAppGuiInfoError,		"Error in hdGetAppGuiInfo()"},
    {HdEMsg_SetupHostName2AppGuiInfo,	"Error in hdSetupHostName2AppGuiInfo()"},
    {HdEMsg_SearchAppGuiInfoError,	"Error in hdSearchAppGuiInfo()"},
    {HdEMsg_SetupAgentIdForUserError,	"Error in hdSetupAgentIdForUser()"},
    {HdEMsg_SendAgentInfoError,		"Error in hdSendAgentInfo()"},
    {HdEMsg_NotParametricAgent,		"The Agent is not a parametric agent"},
    {HdEMsg_NotParaInstanceAgent,	"The Agent is not a parametric instance agent"},
    {HdEMsg_IllegalAgentId,		"Illegal Agent ID"},
    {HdEMsg_NotProperAgentId,		"Not proper agent ID"},
    {HdEMsg_NotDefinedAsParametricAgent,"Not defined as parametric agent"},
    {HdEMsg_NotDefinedAgentPath,	"Not defined agent path"},
    {HdEMsg_NotExistParametricTemplateAgent, "Not exist the parametric template agent"},
    {HdEMsg_NotExistParametricInstanceAgent, "Not exist the parametric instance agent"},
    {HdEMsg_SetupAgentInfo2Msg,		"Error in hdSetupAgentInfo2Msg()"},
    {HdEMsg_SetupFuncDirInfoError,	"Error in hdSetupFuncDirInfo()"},
    {HdEMsg_SetupMethodDirInfoError,	"Error in hdSetupMethodDirInfo()"},
    {HdEMsg_GetFuncDirInfoError,	"Error in hdGetFuncDirInfo()"},
    {HdEMsg_GetMethodDirInfoError,	"Error in hdGetMethodDirInfo()"},
    {HdEMsg_AppendParaInstanceError,	"Error in hdAppendParaInstance()"},

    /* for Agent Handle Errors */
    {HdEMsg_CreateAgentProcessError,	"Cannot create agent process"},
    {HdEMsg_NotAgentProcessFile,	"Not exist the file of the agent process of your request"},
    {HdEMsg_CreateAppGuiProcessError,	"Error in hdCreateAppGuiProcess()"},
    {HdEMsg_NotAppGuiProcessFile,	"Not exist the file of the application Gui process"},
    {HdEMsg_NotActiveAgent,		"Not active agent"},
    {HdEMsg_AlreadySleepAgent,		"Already sleeped agent"},
    {HdEMsg_DeleteAgentProcessError,	"Error in hdDeleteAgentProcess()"},
    {HdEMsg_NoWakedProccessForAgentId,	"There is no waked process for agent Id"},
    {HdEMsg_AlreadyParametricInstance,	"Parametric instance agent Already exists"},
    {HdEMsg_AskForCreating2OtherDaemonError,"Error in hdAskForCreating2OtherDaemon()"},

    /* for communication Errors */
    {HdEMsg_SendMsg2Daemon,		"Cannot send messege to heliosd"},
    {HdEMsg_RecvMsgFromDaemon,		"Cannot receive messege from heliosd"},
    {HdEMsg_ReceivedDataError,		"Error in received data"},
    {HdEMsg_SendMsg2Agent,		"Cannot send messege to agent"},
    {HdEMsg_SendMsgTypeError,		"Error in hdSendMsgType()"},
    {HdEMsg_GetResultFromDaemonError,	"Error in hdGetResultFromDaemon()"},
    {HdEMsg_GetOneAgentInfo_aError,	"Error in hdGetOneAgentInfo_a()"},
    {HdEMsg_GetAgentInfo_aError,	"Error in hdGetAgentInfo_a()"},
    {HdEMsg_SetupAgentInfoFromMsgError,	"Error in hdSetupAgentInfoFromMsg()"},
    {HdEMsg_GetAskForNextInfoError,	"Error in hdGetAskForNextInfo()"},
    {HdEMsg_SetupParaInfo2AgentInfoError,"Error in hdSetupParaInfo2AgentInfo()"},
    {HdEMsg_ReceiveSockInfoFromDaemonError,"Error in hdReceiveSockInfoFromDaemon()"},

    /* for illegal value */
    {HdEMsg_NullPointer,		"Pointer is NULL"},
    {HdEMsg_StringLenLimitOver,		"Over the limit of string length"},
    {HdEMsg_SocketBufferLenLimitOver,	"Over the limit of the socket buffer length"},

    /* from 8500 for illegal value in Hia */
    {HdEMsg_IllegalValueInHia,		"There is a illegal value in Hia information"},
    {HdEMsg_EncounterEndOfLineInHia,	"Encounter the End of Line in data of hia"},

    /* from 9000 for file handle Errors */
    {HdEMsg_CreateTmpFile,		"Cannot Create the heliosd lock file in /tmp"},
    {HdEMsg_SetupTmpFile,		"Cannot Setup the heliosd lock file in /tmp"},
    {HdEMsg_LockFileOpenError,		"Cannot Open the heliosd lock file"},
    {HdEMsg_LockFileReadError,		"Cannot read the heliosd lock file"},
    {HdEMsg_LockFileWriteError,		"Cannot write the heliosd lock file"},
    {HdEMsg_LockFileRemoveError,	"Failed to remove the heliosd lock file"},
    {HdEMsg_GetDaemonPortNum,		"Cannot get Port Number of heliosd from the lock file"},
    {HdEMsg_DalFileOpenError,		"Cannot Open the helios dal file"},
    {HdEMsg_DalFileReadError,		"Cannot read the helios dal file"},
    {HdEMsg_GetOtherMachInfo,		"Error in hdGetOthrMachInfo()"},
    {HdEMsg_GetHiaInfoFromFilesError,	"Error in hdGetHiaInfoFromFiles()"},
    {HdEMsg_GetDataFromHiaFileError,	"Error in hdGetDataFromHiaFile()"},
    {HdEMsg_GetDataFromInitFileError,	"Error in hdGetDataFromInitFile()"},
    {HdEMsg_HiaFileOpenError,		"Cannot Open the file; helios.hia"},
    {HdEMsg_GetOneHiaInfoFromFileError,	"Error in hdGetOneHiaInfoFromFile()"},
    {HdEMsg_SetHiaInfo2AgentInfoError,	"Error in hdSetHiaInfo2AgentInfo()"},
    {HdEMsg_hdGetAgentInfoFromHiaError,	"Error in hdGetAgentInfoFromHia()"},
    {HdEMsg_ConflictAgentIdInHiaFile,	"Conflict Agent Id in the file - helios.hia"},
    {HdEMsg_AgentTypeErrorInHiaInfo,	"Agent Type error in the file - helios.hia"},
    {HdEMsg_GetAgentTblDataError,	"Error in hdGetAgentTblData()"},
    {HdEMsg_TblFileOpenError,		"Cannot Open the table file; <agent name>.tbl"},
    {HdEMsg_Fail2CheckAgentNameID,	"Fail to check Agent Name and ID of <agent name>.tbl file"},
    {HdEMsg_CommentFromFileError,	"Error in hdCommentFromFile()"},
    {HdEMsg_GetMethodDirFromFileError,	"Error in hdGetMethodDirFromFile()"},
    {HdEMsg_GetAgentDirFromFileError,	"Error in hdGetAgentDirFromFile()"},
    {HdEMsg_GetFuncDirFromFileError,	"Error in hdGetFuncDirFromFile()"},
    {HdEMsg_NotAgentNameInTblFile,	"Not exist the Agent Name in <agent name>.tbl file"},
    {HdEMsg_AgentNameUnmatchToHiaInfo,	"Unmatch the agent name in helios.hia file"},
    {HdEMsg_NotAgentIDInTblFile,	"Not exist the Agent ID in <agent name>.tbl file"},
    {HdEMsg_NotAgentTypeInTblFile,	"Not exist the Agent type in <agent name>.tbl file"},
    {HdEMsg_NotAgentCommentInTblFile,	"Not exist the Agent comment in <agent name>.tbl file"},
    {HdEMsg_NotMethodDirInTblFile,	"Not exist the Method Dir data in <agent name>.tbl file"},
    {HdEMsg_SetupMethodDir2AgentInfoError,"Error in hdSetupMethodDir2AgentInfo()"},
    {HdEMsg_NotAgentDirInTblFile,	"Not exist the Agent Dir data in <agent name>.tbl file"},
    {HdEMsg_AgentDirForNotComplexAgent, "Exist the Agent Dir data for not Complex agen in <agent name>.tbl file"},
    {HdEMsg_NotFunctionDirInTblFile,	"Not exist the Function Dir data in <agent name>.tbl file"},
    {HdEMsg_SetupFuncDir2AgentInfoError,"Error in hdSetupFuncDir2AgentInfo()"},
    {HdEMsg_NotExistLeftBraceInData,	"Not exist left brace in file data"},
    {HdEMsg_NotExistRightBraceInData,	"Not exist right brace in file data"},
    {HdEMsg_NotExistCommaInData,	"Not exist comman in file data"},
    {HdEMsg_InitFileOpenError,		"Cannot Open the init file - helios.init"},
    {HdEMsg_GetAgentInfoFromInitError,	"Error in hdGetAgentInfoFromInit()"},
    {HdEMsg_SetupAgentInfoFromInitError,"Error in hdSetupAgentInfoFromInit()"},
    {HdEMsg_NotDataInInitFile,		"Not exist data in the init file - helios.init"},
    {HdEMsg_NotExistAgentIdInData,	"Not exist Agent ID in the init file - helios.init"},
    {HdEMsg_NotExistHostNameInData,	"Not exist Host Name in the init file - helios.init"},
    {HdEMsg_NotExistGroupNumInData,	"Not exist Group Number in the init file - helios.init"},
    {HdEMsg_NoMoreTermInBuffer,		"No More term in string buffer"},
    {HdEMsg_NotExistAgentInfoForId,	"Not exist AgentInfo for Agent Id (%s) in helios.init"},
    {HdEMsg_NotSeparatorInFuncDirInfo,	"Not exist a separator in received data of FuncDirInfo"},

    {HdEMsg_SetupDirInfoError,		"Error in hdSetupDirInfo()"},
    {HdEMsg_UpdateHiaInfoError,		"Error in hdUpdateHiaInfo()"},
    {HdEMsg_UpdateHiaForOneAppError,	"Error in hdUpdateHiaForOneApp()"},
    {HdEMsg_GetCplEvlInfoError,		"Error in hdGetCplEvlInfo()"},
    {HdEMsg_UpdateHiaWithCplEvlInfoError,"Error in hdUpdateHiaWithCplEvlInfo()"},
    {HdEMsg_GetCplInfoFromFileError,	"Error in hdGetCplInfoFromFile()"},
    {HdEMsg_GetEvlInfoFromFileError,	"Error in hdGetEvlInfoFromFile()"},
    {HdEMsg_DisableOpenCplDir,		"Disable to open a cpl directory"},
    {HdEMsg_DisableOpenEvlDir,		"Disable to open a evl directory"},
    {HdEMsg_GetOneCplInfoError,		"Error in hdGetOneCplInfo()"},
    {HdEMsg_GetOneEvlInfoError,		"Error in hdGetOneEvlInfo()"},
    {HdEMsg_IsNotCplFile,		"File name(%s) is not a cpl file"},
    {HdEMsg_IsNotEvlFile,		"File name(%s) is not a evl file"},
    {HdEMsg_CplFileOpenError,		"Can not open a cpl file(%s)"},
    {HdEMsg_EvlFileOpenError,		"Can not open a evl file(%s)"},
    {HdEMsg_GetOneWordError,		"Error in hdGetOneWord()"},
    {HdEMsg_ChgTypeName2AgentTypeError,	"Error in hdChgTypeName2AgentType()"},
    {HdEMsg_AlreadyGetTypeFromCpl,	"Already get &type value from a cpl file(%s)"},
    {HdEMsg_AlreadyGetAgentFromCpl,	"Already get &agent value from a cpl file(%s)"},
    {HdEMsg_AlreadyGetEnvFromCpl,	"Already get &env value from a cpl file(%s)"},
    {HdEMsg_AlreadyGetInsideFromCpl,	"Already get &inside value from a cpl file(%s)"},
    {HdEMsg_AlreadyGetImpMethodFromCpl,	"Already get &import_method value from a cpl file(%s)"},
    {HdEMsg_AlreadyGetExpMethodFromCpl,	"Already get &export_method value from a cpl file(%s)"},
    {HdEMsg_AlreadyGetEnvironmentFromEvl,"Already get &environment value from a evl file(%s)"},
    {HdEMsg_AlreadyGetAgentDirFromEvl,	"Already get &agent_dir value from a evl file(%s)"},
    {HdEMsg_AlreadyGetFuncDirFromEvl,	"Already get &function_dir value from a evl file(%s)"},
    {HdEMsg_AlreadyGetMethodDirFromEvl,	"Already get &method_dir value from a evl file(%s)"},
    {HdEMsg_GetKeyWordValueError,	"Error in hdGetKeyWordValue()"},
    {HdEMsg_GetEvlKeyTypeValueError,	"Error in hdGetEvlKeyTypeValue()"},
    {HdEMsg_GetCplKeyTypeValueError,	"Error in hdGetCplKeyTypeValue()"},
    {HdEMsg_NotCplKeyWord,		"Not a cpl key word"},
    {HdEMsg_NotEvlKeyWord,		"Not a evl key word"},
    {HdEMsg_SetupAgentDir2EvlInfoError,	"Error in hdSetupAgentDir2EvlInfo()"},
    {HdEMsg_SetupTopCplInfoError,	"Error in hdSetupTopCplInfo()"},
    {HdEMsg_LinkCplWithEvlError,	"Error in hdLinkCplWithEvl()"},
    {HdEMsg_NotExistTopCplInfo,		"Not exist top cpl info"},
    {HdEMsg_LinkCplWithInnerEvlError,	"Error in hdLinkCplWithInnerEvl()"},
    {HdEMsg_GetCplInfoForNameError,	"Error in hdGetCplInfoForName()"},
    {HdEMsg_ConflictCplEnvWithEvlInfo,	"Conflict env of cpl with evl info"},
    {HdEMsg_NotInnerEvlInCplInfo,	"Not exist inner evl in cpl info"},
    {HdEMsg_AppendAgentInfoWithCplEvlInfoError,"Error in hdAppendAgentInfoWithCplEvlInfo()"},
    {HdEMsg_AppendOneAgentInfoError,	"Error in hdAppendOneAgentInfoError()"},
    {HdEMsg_FwriteAgentInfo2HiaError,	"Error in hdFwriteAgentInfo2Hia()"},
    {HdEMsg_SetupCmdDirError,		"Error in hdSetupCmdDir()"},
    {HdEMsg_Fail2FprintfAgentId,	"Fail to fprintf agentId and agent name"},
    {HdEMsg_Fail2FprintfEnvName,	"Fail to fprintf env name"},
    {HdEMsg_Fail2FprintfTblPath,	"Fail to fprintf agent tbl path"},
    {HdEMsg_Fail2FprintfProcPath,	"Fail to fprintf process path"},
    {HdEMsg_Fail2FprintfAgentNameInTbl,	"Fail to fprintf agent name in tbl"},
    {HdEMsg_Fail2FprintfAgentIdInTbl,	"Fail to fprintf agent id in tbl"},
    {HdEMsg_Fail2FprintfAgentTypeInTbl,	"Fail to fprintf agent type in tbl"},
    {HdEMsg_Fail2FprintfCommentInTbl,	"Fail to fprintf comment in tbl"},
    {HdEMsg_Fail2FprintfNullDirsInTbl,	"Fail to fprintf null dirs in tbl"},
    {HdEMsg_Fail2FprintfMethodDirInTbl,	"Fail to fprintf method dir in tbl"},
    {HdEMsg_Fail2FprintfAgentDirInTbl,	"Fail to fprintf agent dir in tbl"},
    {HdEMsg_Fail2FprintfFuncDirInTbl,	"Fail to fprintf function dir in tbl"},
    {HdEMsg_FileGetStringError,		"Error in hdFileGetString()"},
    {HdEMsg_NotKeyWordInStrLineOfFile,	"Not exist key word in a string line of file"},
    {HdEMsg_SkipSpaceError,		"Error in hdSkipSpace()"},
    {HdEMsg_GetConfigFullPathError,	"Error in hdGetConfigFullPath()"},
    {HdEMsg_GetHeliosDirError,		"Error in hdGetHeliosDir()"},
    {HdEMsg_GetCurrentDirError,		"Error in hdGetCurrentDir()"},
    {HdEMsg_GetAllAppDirNameError,	"Error in hdGetAllAppDirName()"},
    {HdEMsg_ErrorInFullPath,		"Error in full path"},
    {HdEMsg_DisableOpenAppDir,		"Disable to open a app directory"},
    {HdEMsg_MakeCmdDirError,		"Error in hdMakeCmdDir()"},
    {HdEMsg_SetupAgentTblInCmdDirError,	"Error in hdSetupAgentTblInCmdDir()"},
    {HdEMsg_MkdirError,			"Error in mkdir()"},
    {HdEMsg_GetLoginNameError,		"Error in hdGetLoginName()"},
    {HdEMsg_MakefileFileOpenError,	"Can not open a Makefile"},
    {HdEMsg_Fail2FprintfAgentMakefileHead,"Fail to fprintf hiagAgentMakefileHead"},
    {HdEMsg_Fail2FprintfAgentMakefileTail,"Fail to fprintf hiagAgentMakefileTail"},
    {HdEMsg_GetMaxAgentIdError,		"Error in hdGetMaxAgentId()"},

    /* for memory handle Errors */
    {HdEMsg_SizeZeroMalloc,		"Cannot malloc for size of zero"},
    {HdEMsg_MallocError,		"Error in malloc"},
    {HdEMsg_HdMallocError,		"Error in HdMalloc"},
    {HdEMsg_HdMallocStringError,	"Error in HdMallocString"},
    {HdEMsg_GetHeliosdFullPathError,	"Error in hdGetHeliosdFullPath()"},
    {HdEMsg_MallocParaInstanceError,	"Error in hdMallocParaInstance()"},
    {HdEMsg_CreateAcceptMsgInfoError,	"Error in hdCreateAcceptMsgInfo()"},
    {HdEMsg_RemoveAcceptMsgInfoError,	"Error in hdRemoveAcceptMsgInfo()"},

    {HdEMsg_NotYetImplemented,		"Not yet implemented"},
    {NULL,				NULL},
};

HdGoodMsgInfo hdGoodMsgInfo[] = {
    {HdGMsg_NowListens,			"successfully bound, now listens"},


    /* from 5000 to 5999 for Agent Handle
     */
    {HdGMsg_DeleteAgent,		"deleted a agent for asking"},

    {NULL,				NULL},
};


void hdPutsErrorMsg(va_alist)
    va_dcl
{
    va_list		args;
    HeliosdErrorMsgType	msgType;
    char		*msg;
    char		fmtBuf[HdMsgBufferLen_Lim];

    va_start(args);

    msgType = va_arg(args, HeliosdErrorMsgType);

    if ((msg = hdGetErrorMsg(msgType)) != NULL) {
	sprintf(fmtBuf, "%s.\n", msg);

	vfprintf(stderr, fmtBuf, args);
    }

    va_end(args);
}

char *hdGetErrorMsg(msgType)
    HeliosdErrorMsgType	msgType;
{
    HdErrorMsgInfo	*hhdErrorMsgInfo;

    if (msgType != NULL) {
	for (hhdErrorMsgInfo = &hdErrorMsgInfo[0]
	     ; hhdErrorMsgInfo->msg != NULL
	     ; ++hhdErrorMsgInfo) {
	    if (hhdErrorMsgInfo->type == msgType) {
		return hhdErrorMsgInfo->msg;
	    }
	}
    }
    return NULL;
}

void hdPutsGoodMsg(va_alist)
    va_dcl
{
    va_list		args;
    HeliosdGoodMsgType	msgType;
    char		*msg;
    char		fmtBuf[HdMsgBufferLen_Lim];

    va_start(args);

    msgType = va_arg(args, HeliosdGoodMsgType);

    if ((msg = hdGetGoodMsg(msgType)) != NULL) {
	sprintf(fmtBuf, "%s.\n", msg);

	vfprintf(stderr, fmtBuf, args);
    }

    va_end(args);
}

char *hdGetGoodMsg(msgType)
    HeliosdGoodMsgType	msgType;
{
    HdGoodMsgInfo	*hhdGoodMsgInfo;

    for (hhdGoodMsgInfo = &hdGoodMsgInfo[0]
	 ; hhdGoodMsgInfo->msg != NULL
	 ; ++hhdGoodMsgInfo) {
	if (hhdGoodMsgInfo->type == msgType) {
	    return hhdGoodMsgInfo->msg;
	}
    }

    return NULL;
}

void hdPrintf(va_alist)
    va_dcl
{
    va_list args;
    char *fmt;
    
    va_start(args);

    fmt = va_arg(args, char *);

    vfprintf(stderr, fmt, args);

    va_end(args);
}
