/* debugInfo.c
 *	Debug information in helios
 *
 * $Id: debugInfo.c,v 2.0 1994/12/08 13:29:44 k3sato Exp $
 */

#include <stdio.h>

#include <helios/SMessage.h>
#include <helios/AgentFlags.h>
#include <helios/dprintf.h>
#include <helios/debugInfo.h>
#include <helios/hExternStdFunc.h>

void debug_write(char *AgentID,SMessage Message)
{
    char	*User;
    int		type;
    
    /*  Agent Trace Debug Write */
    /*  Message Trace Debug Write */  
    
    if((User = CDebugFlagRead(AgentID)) == NULL)
      if((User = CSMGetDebuginfoStr(Message)) == NULL)
	return;
    
    type = CSMWhatType(Message);
    
    dprintf(User,"\
   Received AgentID = %s\n\
   Message ID       = %s\n\
   Message Type     = %s\n\
   From             = %s\n\
   To               = %s\n\
   To:Management    = %s\n\
   To:Method        = %s\n\
   Tid/Status       = %s\n\
   Method           = %s\n\
   Data             = %s\n",
	    AgentID,
	    CSMGetMidStr(Message),
	    (type == ASK) ? "ASK" : (type == REPLY) ? "REPLY" : "CONTROL",
	    CSMGetFromAidStr(Message),
	    CSMGetToAFStr(Message),
	    CSMGetToManagementStr(Message),
	    CSMGetToMethodStr(Message),
	    (char*)CSMGetSMTS(Message),
	    CSMGetMethodStr(Message),
	    CSMGetDataStr(Message));
    
    return;
}
