extern char *malloc(), *realloc();

# line 2 "envl.y"
 /*** definition section ***/
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"envl.h"
#include	"evlHiaParse.h"
#include	"evlHiaStruct.h"
#include	"evlHiaPool.h"
#include	"evlEnvlInfo.h"
#include	"evlPool.h"
#include	"evlErrCheckObj.h"
#include	"envldef.h"

extern	int	current_state;
extern	int	lineno;

Pool	*pool_for_check;

HiaStruct	*current_hop;
char	*current_env_name = NULL;
char	*current_env_id = NULL;

char	*function_name1 = NULL;
char	*function_name2 = NULL;
char	*agent_name2 = NULL;
char	*old_method = NULL;
char	*new_method = NULL;

char	*common_type_name_p = NULL;
char	*constant_name_p = NULL;
char	*expression_p = NULL;
char	*template_name = NULL;

char	*buf[256];

int	lineno_of_name_in_agdir;
int	lineno_of_name_in_funcdir;
int	lineno_of_name_in_methdir;
int	lineno_of_template_name;

# line 43 "envl.y"
typedef union  {
  char	*string;
} YYSTYPE;
# define STRING 257
# define AND_ENVIRONMENT 258
# define AND_COMMON_TYPE 259
# define AND_AGENT_DIR 260
# define AND_FUNCTION_DIR 261
# define AND_METHOD_DIR 262
# define AND_GLOBAL_CONST 263
# define SUBSTITUTION_SYMBOL 264
# define AND_TEMPLATES 265
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 267 "envl.y"


extern	FILE	*yyin;

int
main(int argc, char **argv)
{
  HiaStruct	*hia_top;

  if ( argc != 2 ) {
    fprintf(stderr, "Usage: cmd top_agent_name\n");
    exit(0);
  }

  hia_top = evlHiaParse(argv[1]);
  if ( hia_top == NULL ) exit(0);

#ifdef DEBUG
  fprintf(stderr, "finished HiaParse()\n");
#endif

  /*** for checking directory ***/
  pool_for_check = evlPoolNew(evlErrCheckObjMatch, evlErrCheckObjPrint);
  if ( pool_for_check == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  /******************************/

  while ( current_hop = evlHiaPoolGet() ) {
    if ( evlHiaStructGetAgentType(current_hop) == 0 ) continue;
    current_env_name = evlHiaStructGetMyEnv(current_hop);
    current_env_id = evlHiaStructGetMyAid(current_hop);

#ifdef DEBUG
    fprintf(stderr, "current_env_name = %s\n", current_env_name);
#endif

    lineno = 1;
    LexSetNextFile(current_env_name);
    yyparse();
  }

  while ( current_hop = evlHiaPoolGet() ) {
    if ( evlHiaStructGetAgentType(current_hop) != 0 ) continue;
    
    evlCreateSrcForAgent(current_hop);
  }

  return NORMAL;
}


int
set_agent_dir_cmd(char *agent_name)
{
  Pool		*pool;
  HiaStruct	*op, *upper, *check;
  EnvlInfo	*ep;
  char		*aid, *cmd;
  char		tmpbuf[512];
  ErrCheckObj	*err_op;

  /*** for checking directory ***/
  err_op = evlPoolGet(pool_for_check, agent_name);
  if ( err_op != NULL &&
      !strcmp(current_env_name, evlErrCheckObjGetEnv(err_op)) ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is multiple defined\n",
	    current_env_name, lineno_of_name_in_agdir, agent_name);
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  else if ( err_op != NULL ) {
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  /******************************/

  pool = evlHiaParseGetPoolForName();
  op = evlPoolGet(pool, agent_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not in helios.hia file.\n",
	    current_env_name, lineno_of_name_in_agdir, agent_name);
    return ERROR;
  }

  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  /*** for checking directory ***/
  if ( strcmp(current_env_name, evlHiaStructGetInEnv(op)) ) {
    fprintf(stderr,
	    "Warning! %s.evl:%d: \"%s\" is conflicting between %s.evl and helios.hia file.\n",
	    current_env_name, lineno_of_name_in_agdir, agent_name, current_env_name);
    return ERROR;
  }
  /******************************/

  /*** for checking directory ***/
  err_op = evlErrCheckObjNew(agent_name, current_env_name);
  if ( err_op == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  /******************************/

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

#ifdef DEBUG
  fprintf(stderr, "upper = %s\n", HiaStructGetMyEnv(upper));
#endif

  aid = evlHiaStructGetMyAid(op);
  if ( aid == NULL ) {
    /*  */
  }

  sprintf(tmpbuf, "add_to_agent_directory(\"%s\", \"%s\", \"%s\");",
	  current_env_id, agent_name, aid);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutAgentDir(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}


int
set_function_dir_cmd(char *function, char *agent_name)
{
  Pool		*pool;
  HiaStruct	*op, *upper;
  EnvlInfo	*ep;
  char		*aid, *cmd;
  char		tmpbuf[512];
  ErrCheckObj	*err_op;

  /*** for checking directory ***/
  err_op = evlPoolGet(pool_for_check, agent_name);
  if ( err_op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not defined.\n",
	    current_env_name, lineno_of_name_in_funcdir, agent_name);
    fprintf(stderr, "\tif \"%s\" is template_agent, ignore this warning message.\n",
	    agent_name);
  }
  else if ( strcmp(current_env_name, evlErrCheckObjGetEnv(err_op)) ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not defined.\n",
	    current_env_name, lineno_of_name_in_funcdir, agent_name);
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  else {
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  /******************************/

  pool = evlHiaParseGetPoolForName();
  op = evlPoolGet(pool, agent_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not in helios.hia file.\n",
	    current_env_name, lineno_of_name_in_funcdir, agent_name);
    return ERROR;
  }
  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

  aid = evlHiaStructGetMyAid(op);
  if ( aid == NULL ) {
    /*  */
  }

  sprintf(tmpbuf, "add_to_function_directory(\"%s\", \"%s\", \"%s\");",
	  current_env_id, function, aid);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutFunctionDir(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}


int
set_method_dir_cmd(char *function, char *old_method,
		   char *agent_name, char *new_method)
{
  Pool		*pool;
  HiaStruct	*op, *upper;
  EnvlInfo	*ep;
  char		*aid, *cmd;
  char		tmpbuf[512];
  ErrCheckObj	*err_op;

  /*** for checking directory ***/
  err_op = evlPoolGet(pool_for_check, agent_name);
  if ( err_op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not defined.\n",
	    current_env_name, lineno_of_name_in_methdir, agent_name);
    fprintf(stderr, "\tif \"%s\" is template_agent, ignore this warning message.\n",
	    agent_name);
  }
  else if ( strcmp(current_env_name, evlErrCheckObjGetEnv(err_op)) ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not defined.\n",
	    current_env_name, lineno_of_name_in_methdir, agent_name);
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  else {
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  /********************************/

  pool = evlHiaParseGetPoolForName();
  op = evlPoolGet(pool, agent_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not in helios.hia file.\n",
	    current_env_name, lineno_of_name_in_methdir, agent_name);
    return ERROR;
  }
  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

  aid = evlHiaStructGetMyAid(op);
  if ( aid == NULL ) {
    /*  */
  }

  sprintf(tmpbuf,
	  "add_to_method_directory(\"%s\", \"%s\", \"%s\", \"%s\", \"%s\");",
	  current_env_id, function, old_method, aid, new_method);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutMethodDir(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}


int
set_param(char *template_name)
{
  Pool		*pool;
  HiaStruct	*op, *upper;
  EnvlInfo	*ep;
  char		*aid, *cmd;
  char		tmpbuf[512];
  ErrCheckObj	*err_op;

  /*** for checking directory ***/
  err_op = evlPoolGet(pool_for_check, template_name);
  if ( err_op != NULL && 
       !strcmp(current_env_name, evlErrCheckObjGetEnv(err_op)) ) {
    fprintf(stderr,
	    "Warning! %s.evl:%d: \"%s\" of template is multiple defined.\n",
	    current_env_name, lineno_of_template_name, template_name);
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }
  else if ( err_op != NULL ) {
    if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
      fprintf(stderr, "memory shortage!\n");
      exit(0);
    }
  }

  err_op = evlErrCheckObjNew(template_name, current_env_name);
  if ( err_op == NULL ) {
    fprintf(stderr, "memory shortage!\n");
  }
  if ( evlPoolPut(pool_for_check, err_op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  /********************************/

  pool = evlHiaParseGetPoolForName();
  op = evlPoolGet(pool, template_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warning! %s.evl:%d: \"%s\" is not in helios.hia file.\n",
	    current_env_name, lineno_of_template_name, template_name);
    return ERROR;
  }
  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  evlHiaStructSetParam(op);

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

  aid = evlHiaStructGetMyAid(op);
  if ( aid == NULL ) {
    /*  */
  }

  sprintf(tmpbuf, "add_to_agent_directory(\"%s\", \"%s\", \"%s\");",
	  current_env_id, template_name, aid);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutAgentDir(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  sprintf(tmpbuf, "eInitSetPrmInfo(\"%s\", \"%s\", \"%s\");",
	  current_env_id, aid, template_name);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutTemplate(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}


int
set_gl_const_cmd(common_type_name, constant_name, expression)
{
  Pool		*pool;
  HiaStruct	*op, *upper;
  EnvlInfo	*ep;
  char		*cmd;
  char		tmpbuf[512];

  pool = evlHiaParseGetPoolForEnv();
  op = evlPoolGet(pool, current_env_name);
  if ( op == NULL ) {
    fprintf(stderr, "Warnig! : \"%s\" is not in helios.hia file\n", current_env_name);
    return ERROR;
  }
  if ( evlPoolPut(pool, op) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

  upper = evlHiaStructGetUpper(op);
  ep = evlHiaStructGetInfo(upper);

  sprintf(tmpbuf, "add_to_global_pool(\"%s\", \"%s\", \"%s\", \"%s\");",
	  current_env_id, common_type_name_p,
	  constant_name_p, expression_p);

  cmd = strdup(tmpbuf);
  if ( cmd == NULL ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }
  if ( evlEnvlInfoPutGlobalCstr(ep, cmd) == EALLOC ) {
    fprintf(stderr, "memory shortage!\n");
    exit(0);
  }

#ifdef DEBUG
  fprintf(stderr, "cmd = %s\n", cmd);
#endif

  return NORMAL;
}

/*** END OF FILE ***/

int yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 43
# define YYLAST 104
int yyact[]={

    22,    23,    25,     9,    24,    64,     5,     3,    83,    78,
    76,    71,    16,    40,    36,    61,    55,    45,    11,     7,
    74,    27,    84,    81,    68,    33,    30,    49,    67,    53,
    51,    47,    43,    27,    17,    14,    38,    12,    32,    35,
    80,    69,    59,    57,    52,    50,    46,    42,    26,    15,
    29,    34,    70,    54,    39,    37,    82,    75,    77,    60,
    66,    48,    31,    44,    28,    21,    20,    19,    18,    10,
     6,    13,     8,     4,     2,     1,     0,    41,     0,     0,
     0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
    63,    62,     0,    65,    56,     0,     0,     0,     0,     0,
     0,    73,    72,    79 };
int yypact[]={

  -251, -1000,  -253,  -238,  -257,  -239,   -22, -1000, -1000,  -245,
   -25, -1000, -1000,  -261,   -11, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000,   -97,   -98,  -243,  -244, -1000,  -245,   -12, -1000,
  -240,   -13, -1000,   -96,   -14, -1000, -1000,   -15, -1000,  -241,
 -1000, -1000, -1000,   -97,    -1, -1000, -1000,   -98,    -2,  -242,
 -1000,  -243, -1000,  -244,  -259, -1000, -1000,  -245, -1000,   -99,
    -3, -1000, -1000, -1000,  -246,   -23,   -24, -1000,  -247,  -248,
 -1000, -1000, -1000, -1000,   -99,    -4, -1000,  -102, -1000, -1000,
  -249, -1000,  -103, -1000, -1000 };
int yypgo[]={

     0,    75,    74,    73,    72,    71,    70,    69,    35,    49,
    68,    67,    66,    65,    64,    50,    63,    62,    38,    61,
    60,    59,    58,    28,    57,    56,    55,    36,    54,    53,
    52,    51,    39 };
int yyr1[]={

     0,     1,     2,     6,     3,     7,     4,     8,     8,     9,
     5,     5,     5,     5,     5,    10,    14,    14,    15,    16,
    11,    17,    17,    18,    19,    21,    22,    20,    20,    23,
    24,    25,    13,    26,    26,    27,    28,    29,    30,    12,
    31,    31,    32 };
int yyr2[]={

     0,     8,     6,     3,     6,     3,     6,     2,     6,     3,
     0,     4,     4,     4,     4,     6,     2,     6,    10,     3,
     6,     2,     6,    10,    10,     3,     3,     2,     6,    10,
     3,     3,     6,     2,     6,     8,     3,     3,     3,     6,
     2,     6,     3 };
int yychk[]={

 -1000,    -1,    -2,   258,    -3,   259,    -6,   257,    -4,   260,
    -7,   257,    59,    -5,    -8,    -9,   257,    59,   -10,   -11,
   -12,   -13,   261,   262,   265,   263,    59,    44,   -14,   -15,
   123,   -17,   -18,   123,   -31,   -32,   257,   -26,   -27,   -28,
   257,    -9,    59,    44,   -16,   257,    59,    44,   -19,   123,
    59,    44,    59,    44,   -29,   257,   -15,    44,   -18,    44,
   -21,   257,   -32,   -27,   264,    -8,   -20,   -23,   123,    44,
   -30,   257,   125,   125,    44,   -24,   257,   -22,   257,   -23,
    44,   125,   -25,   257,   125 };
int yydef[]={

     0,    -2,     0,     0,     0,     0,     0,     3,    10,     0,
     0,     5,     2,     1,     0,     7,     9,     4,    11,    12,
    13,    14,     0,     0,     0,     0,     6,     0,     0,    16,
     0,     0,    21,     0,     0,    40,    42,     0,    33,     0,
    36,     8,    15,     0,     0,    19,    20,     0,     0,     0,
    39,     0,    32,     0,     0,    37,    17,     0,    22,     0,
     0,    25,    41,    34,     0,     0,     0,    27,     0,     0,
    35,    38,    18,    23,     0,     0,    30,     0,    26,    28,
     0,    24,     0,    31,    29 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"STRING",	257,
	"AND_ENVIRONMENT",	258,
	"AND_COMMON_TYPE",	259,
	"AND_AGENT_DIR",	260,
	"AND_FUNCTION_DIR",	261,
	"AND_METHOD_DIR",	262,
	"AND_GLOBAL_CONST",	263,
	"SUBSTITUTION_SYMBOL",	264,
	"AND_TEMPLATES",	265,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"envl_statement : environment_definition common_type_file agent_directory other_statements",
	"environment_definition : AND_ENVIRONMENT environment_name ';'",
	"environment_name : STRING",
	"common_type_file : AND_COMMON_TYPE file_name ';'",
	"file_name : STRING",
	"agent_directory : AND_AGENT_DIR agent_name_list ';'",
	"agent_name_list : agent_name",
	"agent_name_list : agent_name_list ',' agent_name",
	"agent_name : STRING",
	"other_statements : /* empty */",
	"other_statements : other_statements function_directory",
	"other_statements : other_statements method_directory",
	"other_statements : other_statements agent_templates",
	"other_statements : other_statements global_constant",
	"function_directory : AND_FUNCTION_DIR function_couple_list ';'",
	"function_couple_list : function_couple",
	"function_couple_list : function_couple_list ',' function_couple",
	"function_couple : '{' function_name1 ',' agent_name_list '}'",
	"function_name1 : STRING",
	"method_directory : AND_METHOD_DIR method_couple_list ';'",
	"method_couple_list : method_couple",
	"method_couple_list : method_couple_list ',' method_couple",
	"method_couple : '{' old_method ',' new_method_list '}'",
	"old_method : '{' function_name2 ',' old_method_name '}'",
	"function_name2 : STRING",
	"old_method_name : STRING",
	"new_method_list : new_method",
	"new_method_list : new_method_list ',' new_method",
	"new_method : '{' agent_name2 ',' new_method_name '}'",
	"agent_name2 : STRING",
	"new_method_name : STRING",
	"global_constant : AND_GLOBAL_CONST constant_definition_list ';'",
	"constant_definition_list : constant_definition",
	"constant_definition_list : constant_definition_list ',' constant_definition",
	"constant_definition : common_type_name constant_name SUBSTITUTION_SYMBOL expression",
	"common_type_name : STRING",
	"constant_name : STRING",
	"expression : STRING",
	"agent_templates : AND_TEMPLATES template_name_list ';'",
	"template_name_list : template_name",
	"template_name_list : template_name_list ',' template_name",
	"template_name : STRING",
};
#endif /* YYDEBUG */
#line 1 "urlbycpr"
#ifndef lint
static	char yaccpar_sccsid[] = "@(#)yaccpar	1.9 91/12/11 Copyr 1989 Sun Micro; JLE";
/* from SunOS4.0.3 @(#)yaccpar 1.6 88/02/08 SMI"; *//* from UCB 4.1 83/02/01 */
#endif

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	{ free(yys); free(yyv); return(0); }
#define YYABORT		{ free(yys); free(yyv); return(1); }
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** static variables used by the parser
*/
static YYSTYPE *yyv;			/* value stack */
static int *yys;			/* state stack */

static YYSTYPE *yypv;			/* top of value stack */
static int *yyps;			/* top of state stack */

static int yystate;			/* current state */
static int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */

int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */


/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */
	unsigned yymaxdepth = YYMAXDEPTH;

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yyv = (YYSTYPE*)malloc(yymaxdepth*sizeof(YYSTYPE));
	yys = (int*)malloc(yymaxdepth*sizeof(int));
	if (!yyv || !yys)
	{
		yyerror( "out of memory" );
		return(1);
	}
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			(void)printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			int yyps_index = (yy_ps - yys);
			int yypv_index = (yy_pv - yyv);
			int yypvt_index = (yypvt - yyv);
			yymaxdepth += YYMAXDEPTH;
			yyv = (YYSTYPE*)realloc((char*)yyv,
				yymaxdepth * sizeof(YYSTYPE));
			yys = (int*)realloc((char*)yys,
				yymaxdepth * sizeof(int));
			if (!yyv || !yys)
			{
				yyerror( "yacc stack overflow" );
				return(1);
			}
			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
# ifdef YYEUCCCOUNT
		if ( ( yychar < 0 ) && ( ( yychar = yyeuclex() ) < 0 ) )
# else
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
# endif
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			(void)printf( "Received token " );
			if ( yychar == 0 )
				(void)printf( "end-of-file\n" );
			else if ( yychar < 0 )
				(void)printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				(void)printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
# ifdef YYEUCCCOUNT
			if ( ( yychar < 0 ) && ( ( yychar = yyeuclex() ) < 0 ) )
# else
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
# endif
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				(void)printf( "Received token " );
				if ( yychar == 0 )
					(void)printf( "end-of-file\n" );
				else if ( yychar < 0 )
					(void)printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					(void)printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						(void)printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					(void)printf( "Error recovery discards " );
					if ( yychar == 0 )
						(void)printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						(void)printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						(void)printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			(void)printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 3:
# line 68 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("environment = %s\n", yypvt[-0].string);
                            printf("current_state = %d\n",
				   current_state);
                           #endif
			    if ( strcmp(yypvt[-0].string, current_env_name) ) {
			      fprintf(stderr,
			      "Warning! %s.evl:%d: %s is different from file name.\n",
				      current_env_name, lineno,
				      current_env_name);
			    }
			   } break;
case 5:
# line 87 "envl.y"
{
                           #ifdef DEBUG
                            printf("file_name = %s\n", yypvt[-0].string);
                            printf("current_state = %d\n", current_state);
                           #endif
			  } break;
case 9:
# line 103 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("agent_name = %s\n", yypvt[-0].string);
                           #endif
                            if ( current_state == AGENT_DIR_STATE ) {
			      lineno_of_name_in_agdir = lineno;
                              set_agent_dir_cmd(yypvt[-0].string);
			    }
			    else if ( current_state ==
  				          FUNCTION_DIR_STATE ) {
			      lineno_of_name_in_funcdir = lineno;
			      set_function_dir_cmd(function_name1, yypvt[-0].string);
			    }
			  } break;
case 19:
# line 139 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("function_name1 = %s\n", yypvt[-0].string);
                           #endif
			    function_name1 = strdup(yypvt[-0].string);
 			  } break;
case 25:
# line 161 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("function_name2 = %s\n", yypvt[-0].string);
                           #endif
			    function_name2 = strdup(yypvt[-0].string);
 			  } break;
case 26:
# line 170 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("old_method_name = %s\n", yypvt[-0].string);
                           #endif
			    old_method = strdup(yypvt[-0].string);
 			  } break;
case 30:
# line 186 "envl.y"
{
                           #ifdef DEBUG
                            printf("agent_name2 = %s\n", yypvt[-0].string);
                           #endif
			    lineno_of_name_in_methdir = lineno;
			    agent_name2 = strdup(yypvt[-0].string);
 			  } break;
case 31:
# line 196 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("new_method_name = %s\n", yypvt[-0].string);
                           #endif
			    new_method = strdup(yypvt[-0].string);
			    set_method_dir_cmd(function_name2,
					       old_method,
					       agent_name2, 
					       new_method);
 			  } break;
case 36:
# line 220 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("common_type_name = %s\n", yypvt[-0].string);
                           #endif
			    common_type_name_p = strdup(yypvt[-0].string);
 			  } break;
case 37:
# line 229 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("constant_name = %s\n", yypvt[-0].string);
                           #endif
			    constant_name_p = strdup(yypvt[-0].string);
 			  } break;
case 38:
# line 238 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("expression = %s\n", yypvt[-0].string);
                           #endif
			    expression_p = strdup(yypvt[-0].string);
			    set_gl_const_cmd(common_type_name_p,
					     constant_name_p,
					     expression_p);
 			  } break;
case 42:
# line 257 "envl.y"
{ 
                           #ifdef DEBUG
                            printf("template_name = %s\n", yypvt[-0].string);
                           #endif
			    lineno_of_template_name = lineno;
			    template_name = strdup(yypvt[-0].string);
			    set_param(yypvt[-0].string);
 			  } break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef YYEUCCCOUNT
yyeuclex()
{
    unsigned short c;
    int i;
 
    c = yylex();
    if( c < 256 ) return(c);
    for(i=0;i<YYEUCCCOUNT;i++)
        if( c == yyeucctable[i].name )
            return( yyeucctable[i].val );
    return(c);
}
# endif
 
