/*
 * file name: evlPool.c
 *
 */

#include	<stdio.h>
#include	"envldef.h"
#include	"evlPool.h"
#include	"evlLL.h"


/*
 * evlPoolNew()
 */
void*
evlPoolNew(int (*match)(), void (*print)() )
{
  return ( evlLLNew(match, print) );
}


/*
 * evlPoolDelete()
 */
void
evlPoolDelete(Pool *target)
{
  evlLLDelete( (LinkedList*)target );
}


/*
 * evlPoolPut()
 */
int
evlPoolPut(Pool *target, void *object)
{
  return ( evlLLAddTail((LinkedList*)target, object) );
}


/*
 * evlPoolGet()
 */
void*
evlPoolGet(Pool *target, void *lookfor)
{
  if ( lookfor == NULL ) {
    return ( evlLLRetrieveHead((LinkedList*)target) );
  }

  if ( evlLLMatch((LinkedList*)target, lookfor) ) {
    return ( evlLLRetrieveCurrent((LinkedList*)target) );
  }
  return (NULL);
}


/*
 * evlPoolPrint()
 */
void
evlPoolPrint(Pool *target)
{
  evlLLPrint(target);
}

/*** END OF FILE ***/

