/*
 * file name: evlLink.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	"envldef.h"
#include	"evlLink.h"



/*
 * evlLinkNew()
 */
void*
evlLinkNew(void *new_content)
{
  Link	*lp;

  lp = (Link*)malloc( sizeof(Link) );
  if ( lp == NULL ) return (NULL);

  evlLinkSetNext(lp, NULL);
  evlLinkSetContents(lp, new_content);

  return (lp);
}


/*
 * evlLinkDelete()
 */
void
evlLinkDelete(Link *target)
{
  if ( target == NULL ) return;
  target->next = NULL;
  target->contents = NULL;
  free(target);
}


/*
 * evlLinkSetNext()
 */
void
evlLinkSetNext(Link *target, Link *next)
{
  target->next = next;
}


/*
 * evlLinkSetContents()
 */
void
evlLinkSetContents(Link *target, void *contents)
{
  target->contents = contents;
}


/*
 * evlLinkGetNext()
 */
Link*
evlLinkGetNext(Link *target)
{
  return ( target->next );
}


/*
 * evlLinkGetContents()
 */
void*
evlLinkGetContents(Link *target)
{
  return ( target->contents );
}

/*** END OF FILE ***/
