/*
 * file name: evlLL.h
 *
 */

#ifndef ELL
#define ELL

#include	"evlLink.h"

typedef	struct _LinkedList {
  Link		*head;
  Link		*tail;
  Link		*current;
  int		(*match)();
  void		(*print)();
} LinkedList;

void*		evlLLNew(int (*match)(), void (*print)() );
void		evlLLDelete(LinkedList *target);

void		evlLLHead(LinkedList *target);
void		evlLLNext(LinkedList *target);
void		evlLLTail(LinkedList *target);
int		evlLLIsTail(LinkedList *target);

int		evlLLAddHead(LinkedList *target, void *obj);
int		evlLLAddTail(LinkedList *target, void *obj);
void*		evlLLRetrieveHead(LinkedList *target);
void*		evlLLRetrieveCurrent(LinkedList *target);
int		evlLLMatch(LinkedList *target, void *look);
void*		evlLLRefCurrent(LinkedList *target);
void		evlLLPrint(LinkedList *target);

#endif

/*** END OF FILE ***/
