/*
 * file name: evlLL.c
 *
 */

#include	<stdio.h>
#include	<stdlib.h>
#include	"envldef.h"
#include	"evlLink.h"
#include	"evlLL.h"


/*
 * evlLLNew()
 */
void*
evlLLNew(int (*match)(), void (*print)() )
{
  LinkedList	*llp;

  llp = (LinkedList*)malloc( sizeof(LinkedList) );
  if ( llp == NULL ) return (NULL);

  llp->head = NULL;
  llp->tail = NULL;
  llp->current = NULL;
  llp->match = match;
  llp->print = print;

  return (llp);
}


/*
 * evlLLDelete()
 */
void
evlLLDelete(LinkedList *target)
{
  if ( target == NULL ) return;
  target->head = NULL;
  target->tail = NULL;
  target->current = NULL;
  target->match = NULL;
  target->print = NULL;
  free( target );
}


/*
 * evlLLHead()
 */
void
evlLLHead(LinkedList *target)
{
  target->current = target->head;
}

/*
 * evlLLNext()
 */
void
evlLLNext(LinkedList *target)
{
  if ( !evlLLIsTail(target) ) {
    target->current = evlLinkGetNext(target->current);
  }
}


/*
 * evlLLTail()
 */
void
evlLLTail(LinkedList *target)
{
  target->current = target->tail;
}


/*
 * evlLLIsTail()
 */
int
evlLLIsTail(LinkedList *target)
{
  if ( target->tail == target->current ) return (1);
  return (0);
}


/*
 * evlLLAddHead()
 */
int
evlLLAddHead(LinkedList *target, void *obj)
{
  Link	*lp;

  lp = evlLinkNew(obj);
  if ( lp == NULL ) return (EALLOC);

  if ( target->head == NULL ) { /* LinkedList is empty */
    target->head = lp;
    target->tail = lp;
    target->current = lp;
    evlLinkSetNext(lp, NULL);
    return (NORMAL);
  }

  evlLinkSetNext(lp, target->head);
  target->head = lp;
  return (NORMAL);
}


/*
 * evlLLAddTail()
 */
int
evlLLAddTail(LinkedList *target, void *obj)
{
  Link	*lp;

  lp = evlLinkNew(obj);
  if ( lp == NULL ) return (EALLOC);

  if ( target->head == NULL ) {	/* LinkedList is empty */
    target->head = lp;
    target->tail = lp;
    target->current = lp;
    evlLinkSetNext(lp, NULL);
    return (NORMAL);
  }

  evlLinkSetNext(target->tail, lp);
  evlLinkSetNext(lp, NULL);
  target->tail = lp;

  return (NORMAL);
}


/*
 * evlLLRetrieveHead()
 */
void*
evlLLRetrieveHead(LinkedList *target)
{
  Link	*lp;
  void	*objp;

  lp = target->head;
  if ( lp == NULL ) return (NULL);
  target->head = evlLinkGetNext(lp);
  if ( target->current == lp ) {
    target->current = evlLinkGetNext(lp);
  }
  if ( target->tail == lp ) {
    target->tail = NULL;
  }
  objp = evlLinkGetContents(lp);
  evlLinkDelete(lp);
  return (objp);
}


/*
 * evlLLRetrieveCurrent()
 */
void*
evlLLRetrieveCurrent(LinkedList *target)
{
  Link	*cp, *lp;
  void	*objp;

  if ( target->head == NULL ) return (NULL);

  if ( target->current == target->head ) {
    return ( evlLLRetrieveHead(target) );
  }

  cp = target->current;
  
  for ( lp = target->head; cp != evlLinkGetNext(lp);
                                lp = evlLinkGetNext(lp) ) {}
  objp = evlLinkGetContents(cp);
  evlLinkSetNext(lp, evlLinkGetNext(cp));

  if ( evlLLIsTail(target) ) {
    target->current = lp;
    target->tail = lp;
  }
  else {
    target->current = evlLinkGetNext(cp);
  }

  evlLinkDelete(cp);
  return (objp);
}


/*
 * evlLLMatch()
 */
int
evlLLMatch(LinkedList *target, void *look)
{
  Link	*lp;
  void	*objp;

  evlLLHead(target);
  while ( 1 ) {
    lp = evlLLRefCurrent(target);
    if ( lp == NULL ) return (0);
    objp = evlLinkGetContents(lp);
    if ( (*(target->match))(objp, look) ) return (1);
    if ( evlLLIsTail(target) ) return (0);
    evlLLNext(target);
  }
}


/*
 * evlLLRefCurrent()
 */
void*
evlLLRefCurrent(LinkedList *target)
{
  return (target->current);
}


/*
 * evlLLPrint()
 */
void
evlLLPrint(LinkedList *target)
{
  Link	*lp;
  void	*objp;

  evlLLHead(target);
  while ( 1 ) {
    lp = evlLLRefCurrent(target);
    if ( lp == NULL ) return;
    objp = evlLinkGetContents(lp);
    (*(target->print))(objp);
    if ( evlLLIsTail(target) ) return;
    evlLLNext(target);
  }
}
/*** END OF FILE ***/
