/*
 * file name : evlHiaStruct.h
 *
 */
#ifndef HIASTRUCT
#define HIASTRUCT

#include	"evlPool.h"
#include	"evlEnvlInfo.h"

typedef	struct	_HiaStruct {
  EnvlInfo	*info;
  struct _HiaStruct	*upper;
  Pool		*lower_agents;
  char		*my_aid;
  char		*my_logical_name;
  int		agent_type;
  char		*in_env;
  char		*my_env;
  union _substance {
    char	*full_path;
    Pool	*agents;
  } substance;
  Pool		*tmp;
  int		lower_agent_num;
  int		is_param;
} HiaStruct;


HiaStruct*	evlHiaStructNew(char *my_aid, char *my_logical_name,
			     int agent_type, char *in_env, char
			     *substance);
void		evlHiaStructSetInfo(HiaStruct *target, EnvlInfo *info);
void		evlHiaStructSetUpper(HiaStruct *target, HiaStruct
				  *upper);
int		evlHiaStructSetMyEnv(HiaStruct *target, char *env);
void		evlHiaStructSetParam(HiaStruct *target);
int		evlHiaStructPutLowerAgent(HiaStruct *target, HiaStruct *obj);
EnvlInfo*	evlHiaStructGetInfo(HiaStruct *target);
HiaStruct*	evlHiaStructGetHiaOfLowerAgent(HiaStruct* target, void *lookfor);
HiaStruct*	evlHiaStructGetUpper(HiaStruct *target);
char*		evlHiaStructGetMyAid(HiaStruct *target);
char*		evlHiaStructGetMyLogicalName(HiaStruct *target);
int		evlHiaStructGetAgentType(HiaStruct *target);
char*		evlHiaStructGetInEnv(HiaStruct *target);
char*		evlHiaStructGetMyEnv(HiaStruct *target);
char*		evlHiaStructGetSubstanceFullPath(HiaStruct *target);
Pool*		evlHiaStructGetSubstanceAgents(HiaStruct *target);
char*		evlHiaStructGetLowerAgent(HiaStruct *target);
int		evlHiaStructIsParam(HiaStruct *target);

int		evlHiaStructMatch(void *target, void *lookfor);
void		evlHiaStructPrint(void *target);
int		evlHiaStructAgentMatch(void *target, void *lookfor);
void		evlHiaStructAgentPrint(void *target);

void		evlHiaStructTreePrint(HiaStruct *target);

int		evlHiaStructMatchForName(void *target, void *lookfor);
int		evlHiaStructMatchForType(void *target, void *lookfor);
int		evlHiaStructMatchForEnv(void *target, void *lookfor);

#endif

/*** END OF FILE ***/
